% $Id: coef.pdDiag.Rd,v 1.5 1998/04/02 18:53:10 pinheiro Exp $
\name{coef.pdDiag}
\title{pdDiag Object Coefficients}
\usage{
coef(object, unconstrained)
}
\alias{coef.pdDiag}
\arguments{
 \item{object}{an object inheriting from class \code{pdDiag},
   representing a positive-definite matrix with diagonal structure.}
 \item{unconstrained}{a logical value. If \code{TRUE} the logarithm of
   the standard deviations corresponding to the variance-covariance
   matrix represented by \code{object} are returned. If \code{FALSE} the
   standard deviations are returned. Defaults to \code{TRUE}.} 
}
\description{
  This method function extracts the coefficients associated with the
  positive-definite matrix represented by \code{object}. 
}
\value{
  a vector with the coefficients corresponding to \code{object}.
}
\author{Jose Pinheiro and Douglas Bates }

\seealso{\code{\link{coef.pdMat}}, \code{\link{pdMat}}}

\examples{
library(lme)
coef(pdDiag(diag(3)))
}
\keyword{models}
