# $Id: WWheat.q,v 1.1 1998/06/30 18:40:24 bates Exp $
# Winter wheat yields versus preplant soil moisture for 10 varieties
# Data set 7.2 from "SAS System for Mixed Models".
"WWheat" <-
  structure(list(
Variety = structure(c(6, 6, 6, 6, 6, 6, 2, 2, 
  2, 2, 2, 2, 7, 7, 7, 7, 7, 7, 3, 3, 3, 3, 3, 3, 9, 9, 9, 9, 9, 
  9, 8, 8, 8, 8, 8, 8, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 5, 5, 
  5, 5, 5, 5, 10, 10, 10, 10, 10, 10),
  .Label = c("7", "2", "4", "8", "9", "1", "3", "6", "5", "10"),
  class = c("ordered", "factor")),
Yield = c(41, 69, 53, 66, 64, 64, 49, 44, 44, 46, 57, 42, 
  69, 62, 50, 76, 48, 55, 48, 60, 45, 47, 62, 43, 65, 63, 71, 68, 
  52, 68, 76, 46, 45, 67, 65, 79, 35, 37, 30, 30, 57, 49, 75, 64, 
  46, 54, 52, 52, 51, 63, 42, 61, 67, 69, 60, 73, 66, 71, 67, 74
  ),
Moisture = c(10, 57, 32, 52, 47, 48, 30, 21, 20, 26, 44, 19, 
  50, 40, 23, 58, 21, 30, 22, 40, 17, 21, 44, 13, 49, 44, 57, 51, 
  27, 52, 55, 11, 11, 43, 38, 60, 17, 20, 11, 10, 48, 36, 57, 41, 
  15, 28, 23, 23, 26, 44, 13, 40, 48, 53, 37, 58, 44, 53, 48, 59
  )),
row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", 
"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", 
"21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", 
"32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", 
"43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", 
"54", "55", "56", "57", "58", "59", "60"),
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
formula = Yield ~ Moisture | Variety,
labels = list(x = "Preplant moisture content of top 36 inches of soil",
y = "Winter Wheat Yield"),
units = list(y = "Bu/Acre"),
FUN = function (x) mean(x, na.rm = FALSE),
order.groups = TRUE)
