"window.mcmc" <-
function (x, start, end, thin) 
{
        x <- as.mcmc(x)
        xtspar <- tspar(x)
        xstart <- xtspar[1]
        xend <- xtspar[2]
        xthin <- xtspar[3]
        if (missing(thin)) 
                thin <- xthin
        else if (thin%%xthin != 0) {
                thin <- xthin
                warning("Thin value not changed")
        }
        xtime <- as.vector(time(x))
        ts.eps <- .Options$ts.eps
        if (missing(start)) 
                start <- xstart
        else if (length(start) != 1) 
                stop("bad value for start")
        else if (start < xstart) {
                start <- xstart
                warning("start value not changed")
        }
        if (missing(end)) 
                end <- xend
        else if (length(end) != 1) 
                stop("bad value for end")
        else if (end > xend) {
                end <- xend
                warning("end value not changed")
        }
        if (start > end) 
                stop("start cannot be after end")
        if (all(abs(xtime - start) > abs(start) * ts.eps)) {
                start <- xtime[(xtime > start) & ((start + xthin) > 
                        xtime)]
        }
        if (all(abs(end - xtime) > abs(end) * ts.eps)) {
                end <- xtime[(xtime < end) & ((end - xthin) < 
                        xtime)]
        }
        use <- 1:nrow(x)
        use <- use[use >= trunc((start - xstart)/xthin + 1.5) & 
                use <= trunc((end - xstart)/xthin + 1.5) & (use - 
                trunc((start - xstart)/xthin + 1.5))%%(thin%/%xthin) == 
                0]
        return(x[use, , ])
}
