"spec.pgram" <-
function (x, spans = 1, taper = 0.1, demean = F, detrend = T, 
        pad = F, plot = F) 
{
        N <- length(x)
        if (detrend) {
                t <- 1:N
                x <- residuals(lm(x ~ t))
        }
        else if (demean) {
                x <- x - mean(x)
        }
        if (taper > 0.5 || taper < 0) 
                stop("taper must be between 0 and 0.5")
        else if (taper > 0) {
                w <- rep(1, N)
                n <- max(round(N * taper), 1)
                w[1:n] <- sin(((1:n - 0.5) * pi)/(2 * n))^2
                w[N:(N - n + 1)] <- w[1:n]
                x <- x * w
        }
        if (pad) 
                x <- c(x, rep(0, nextn(N) - N))
        Nspec <- ceiling(N/2) + 1
        spec <- (Mod(fft(x))^2)[1:Nspec]/N
        for (i in spans) {
                m <- floor(i/2)
                if (m > 0) {
                        filter <- c(0.5, rep(1, 2 * m - 1), 0.5)/(2 * 
                                m)
                        spec0 <- c(spec[(m + 1):2], spec, spec[Nspec - 
                                1:m])
                        for (j in 1:Nspec) spec[j] <- sum(spec0[j:(j + 
                                2 * m)] * filter)
                }
        }
        spec <- 10 * log10(spec)
        freq <- seq(from = 0, to = 0.5, length = Nspec)
        return(spec = spec, freq = freq)
}
