"print.raftery.diag" <-
function (x, ...) 
{
        cat("\nRAFTERY AND LEWIS CONVERGENCE DIAGNOSTIC:")
        cat("\n=========================================\n\n")
        cat("Iterations used = ", x$tspar[1], ":", x$tspar[2], 
                "\n", sep = "")
        cat("Thinning interval =", x$tspar[3], "\n")
        cat("Sample size per chain =", x$Niters, "\n")
        cat("\nQuantile (q) =", x$params["q"])
        cat("\nAccuracy (r) = +/-", x$params["r"])
        cat("\nProbability (s) =", x$params["s"], "\n")
        if (x$resmatrix[1] == "Error") 
                cat("\nYou need a sample size of at least", x$resmatrix[2], 
                        "with these values of q, r and s\n")
        else for (i in 1:(dim(x$resmatrix)[3])) {
                cat("\n", dimnames(x$resmatrix)[[3]][i], "\n", 
                        sep = "")
                out <- x$resmatrix[, , i, drop = T]
                out <- rbind(matrix(c("Burn-in ", "Total", 
                        "Lower bound ", "Dependence", 
                        "(M)", "(N)", "(Nmin)", "factor (I)"), 
                        byrow = T, ncol = 4), out)
                dimnames(out) <- list(dimnames(out)[[1]], rep("", 
                        4))
                for (i in ncol(out)) out[, i] <- format(out[, 
                        i])
                print.default(out, quote = F)
        }
	invisible(x)
}
