"codamenu.options.diag" <-
function () 
{
        next.menu <- this.menu <- "codamenu.options.diag"
        mtitle <- "CODA Diagnostics Options Menu"
        cat("", mtitle, paste(rep("*", nchar(mtitle)), collapse = ""), 
                sep = "\n")
        choices <- c("Display current diagnostic options", "Window sizes for Geweke's diagnostic", 
                "Bin size for plotting Geweke's diagnostic", 
                "Bin size for plotting Gelman & Rubin's diagnostic", 
                "Parameters for Raftery & Lewis' diagnostic", 
                "Halfwidth precision for Heidelberger & Welch's diagnostic", 
                "Combine chains to calculate correlation matrix", 
                "Return to main options menu")
        pick <- menu(choices)
        if (pick == 0) 
                return("quit")
        switch(pick, print.coda.options(diags = T), next.menu <- codamenu.options.geweke.win(this.menu), 
                next.menu <- codamenu.options.geweke.bin(this.menu), 
                next.menu <- codamenu.options.gelman(this.menu), 
                next.menu <- codamenu.options.raftery(this.menu), 
                next.menu <- codamenu.options.heidel(this.menu), 
                {
                        change.tfoption("Do you want to combine all chains to calculate correlation matrix", 
                                "combine.corr")
                }, next.menu <- "codamenu.options")
        return(next.menu)
}
