/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * pm_tcl.c
 */

#include <tcl.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include <pm.h>
#include <constants.h>

int pmCmd(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);
static int pm_tcl_get(Tcl_Interp *interp, int pmtype, int argc, char *argv[]);
static int pm_tcl_put(Tcl_Interp *interp, int pmtype, int argc, char *argv[]);
static int pm_tcl_query(Tcl_Interp *interp, int pmtype, int argc,char *argv[]);


int
pmCmd(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  static int processing_EXEC = FALSE;  /* if TRUE, then only allow GET/QUERY cmds */
  int ok = TRUE, pmtype, kw;
  char *str;

  /* check for correct number of arguments */
  if (argc < 3) ok = FALSE;

  /* get type of object */
  else
    {
      kw = pm_keyword(argv[1]);
      pmtype = pm_type((str=argv[2]), NULL, NULL);
      if ( (kw != QUERY) && (pmtype == 0))
	{
	  fprintf(stderr, "pm object name \"%s\" not recognized\n", str);
	  ok = FALSE;
	}
      else if ( (!processing_EXEC) || (kw==GET) || (kw==GET_LIST) ||
	       (kw==QUERY) )
	{
	  switch(kw)        /* switch on operation */
	    {
	    case EXEC:
	      processing_EXEC = TRUE;
	      pm(EXEC, str, NULL);
	      processing_EXEC = FALSE;
	      break;
	    case GET:
	      ok = pm_tcl_get(interp,pmtype,argc,argv);
	      break;
	    case PUT:
	      ok = pm_tcl_put(interp,pmtype,argc,argv);
	      break;
	    case QUERY:
	      ok = pm_tcl_query(interp,pmtype,argc,argv);
	      break;
	    case INIT:
	    case CLEAR:
	    case CREATE_OBJ:
	    case CREATE_ELEM:
	    case GET_LIST:
	      fprintf(stderr,"pm %s not yet implemented\n",argv[1]);
	      break;
	    default:
	      fprintf(stderr,"pm %s invalid command\n",argv[1]);
	      ok = FALSE;
	    }
	}
    }
  
  if (!ok) /* paw ??? */
    { 
      fprintf(stderr, "usage: pm [PUT | GET | EXEC | QUERY] object.element\n");
    }

  return TCL_OK;
}

static char temp_str[MAX_LONG_STR];

int
pm_tcl_get(Tcl_Interp *interp, int pmtype, int argc, char *argv[])
{
  int ok = TRUE;
  int i_result, format;
  double d_result;

  temp_str[0] = '\0';

  switch(pmtype)
    {
    case INT:
      i_result = *((int *) pm(GET, argv[2], NULL));
      sprintf(temp_str,"%ld",i_result);
      break;
    case INT_LIST:
      i_result = *((int *) pm(GET, argv[2], atoi(argv[3]), NULL));
      sprintf(temp_str,"%ld",i_result);
      break;
    case DBL:
      format = *((int *) pm(GET, "Defaults.Precision", NULL));
      d_result = *((double *) pm(GET, argv[2], NULL));
      sprintf(temp_str,"%.*lg",format,d_result);
      break;
    case DBL_LIST:
      format = *((int *) pm(GET, "Defaults.Precision", NULL));
      d_result = *((double *) pm(GET, argv[2], atoi(argv[3]), NULL));
      sprintf(temp_str,"%.*lg",format,d_result);
      break;
    case STRNG:
      pm(GET, argv[2], temp_str, NULL);
      break;
    case STRNG_LIST:
      pm(GET, argv[2], atoi(argv[3]), temp_str, NULL);
      break;
    default:
      fprintf(stderr,"pm GET not implemented for this type!");
      ok = FALSE;
    }

  if (ok) interp->result = temp_str;
  return ok;
}


pm_tcl_put(Tcl_Interp *interp, int pmtype, int argc, char *argv[])
{
  int ok = TRUE;

  switch(pmtype)
    {
    case INT:
      pm(PUT, argv[2], atoi(argv[3]), NULL);
      break;
    case DBL:
      pm(PUT, argv[2], atof(argv[3]), NULL);
      break;
    case STRNG:
      pm(PUT, argv[2], argv[3], NULL);
      break;
    case INT_LIST:
      pm(PUT, argv[2], atoi(argv[3]), atoi(argv[4]), NULL);
      break;
    case DBL_LIST:
      pm(PUT, argv[2], atoi(argv[3]), atof(argv[4]), NULL);
      break;
    case STRNG_LIST:
      pm(PUT, argv[2], atoi(argv[3]), argv[4], NULL);
      break;
    default:  
      fprintf(stderr,"pm PUT not implemented for this type!");
      ok = FALSE;
    }

  return ok;
}

int
pm_tcl_query(Tcl_Interp *interp, int pmtype, int argc, char *argv[])
{
  int *pi, i, ok = TRUE;
  char *pc;

  if (argc<4) return FALSE;

  i = pm_typekeyword(argv[3]);
  if (i == LIST_SIZE)
    {
      pi = (int *) pm(QUERY, argv[2], i, NULL);
      if (pi == NULL)
	strcpy(interp->result,"-1");
      else
	sprintf(interp->result,"%d",*pi);
    }
  else if (i == STRNG_LENGTH)
    {
      sprintf(interp->result, "%d", (int) pm(QUERY, argv[2], i, NULL));
    }
  else
    {
      if (argc<5) return FALSE;
      pc = (char *) pm(QUERY, argv[2], i,
		       atoi(argv[4]), NULL);
      if (pc != (char *) NULL) interp->result = pc;
    }

  return ok;
}

