/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

#ifndef MODEL_HEADERS_h
#define MODEL_HEADERS_h

/*
 * model_headers.h
 */

#include <stdio.h>
#include <math.h>

#include <constants.h>
#include <manifold.h>
#include <pm.h>
#include <modellib.h>
#include <utilities.h>

extern double sign();  /* paw 3/11/93 */

void varb_setup(int n_varb, char **variable_names,
		double *variables, double *variable_min, double *variable_max,
		char *indep_varb_name,
		double indep_varb_min, double indep_varb_max);
void param_func_setup(int n_param, int n_funct,
		      char **parameter_names, char **funct_names,
		      double *parameters,
		      double *parameter_min, double *parameter_max,
		      double *funct_min, double *funct_max);
void phase_sp_setup(int n_varb, int manifold_type,
		    int *periodic_varb,
		    double *period_start, double *period_end);
void geomview_setup(int gv_n, char *gv_filename);

static char *c_filename = NULL;

#endif
