/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * continue.h
 */

#include <memory.h>
#include <manifold.h>


struct Cont_Cntl_Ds{
	int			Check_Switch;
	int			Cont_Hide_Settings;
	int			*Active_Param;
	int			*i_workspace;
	int			Debug_Level;
	double			*r_workspace;
	double                  **jacobian_wrt_x;
	double                  **jacobian_wrt_p;
	double			*aug_varb_save;
	int			aug_varb_alloc;
	memory			Continue_Mem_Ptr;
	Manifold		*manifold;
                   };


struct	Cont_DataS{
  		char	*Cont_Name;
		int	(*Cont_Init)(int *n_aug_varb, int max_iters, double ***xr, double **fpar, double *state, double *parameters);
		int	(*Cont_Driver)(int nvar, double *fpar, int *ipar, double *x, double *fx);
		int	(*Cont_Deriv)(int nvar, double *fpar, int *ipar, double *x, double **fprime);
		int	(*Cont_Update)(double *x, double *param, int n_aug_varb);
		int	(*Cont_Check)(int *color, int n_varb, double *state, double *param);
		int	Num_Req_Param;
		  };                      


extern  int     N_Cont, Cont_Cur_Choice;
extern  struct Cont_DataS       Cont_Sel[];
extern struct  Cont_Cntl_Ds            cont_ds;


/* cont_install.c */
void cont_install(void);
void cont_reset(void);

/* cont_proc.c */
int cont_proc(void);
int cont_setup(void);
int cont_alloc(int max_iters, int n_varbs, int n_param, int nvar, double ***xr, double **fpar);
int cont_exit(int nvar, int max_iters, double **xr, double *fpar, double *r_pass_varb, int *i_pass_varb);
int update_cont_state(double *state, double *x, double *par, int n_varb, int n_aug_param, int n_param);
int update_ds_state(double *state, double *x, double *par, int n_varb, int n_aug_varb, int n_param);
int cont_dump_input(int nvar, double *r_pass_varb, int *i_pass_varb, double *xstart, int n_varb, double *ph_space_state, int n_param, double *parameters);
void cont_forwards(void);
void cont_backwards(void);
void cont_continue(void); 

/* cont_state.c */
void cont_get_state(void);
void cont_copy_state(void);
void cont_compute_functions(void);
int cont_get_ews(void);

/* coqual.c */
double coqual(double clast, double ctotal, double epstate, int maxcor, int modnew, int nstep);

/* corect.c */
int corect(int (*df)(), double *fpar, int (*fx)(), int ihold, int *ipar, int *iwork, int *maxcor, int *ncor, int nvar, double *rwork, int (*slv)(), double *stepx, double *wk, double *xr);

/* pitcon.c */
int pitcon(int (*df)(), double *fpar, int (*fx)(), int *ipar, int *iwork, int liw, int nvar, double *rwork, int lrw, int (*slv)(), double *xr);
void err_print(int kerror, int *ipoin, int *ierror, int ipoint, double arclxc, double arclxf, double arclxr, int istate, int nmitl, int nmitt, int nmitx, int nmred, int nmstp, int *iwork, double *rwork);

/* root.c */
int root(double *a, double *fa, double *b, double *fb, double *u, double *fu, int *kount, int *iflag, double epmach);
double sdist2(int n, double *sx, double *sy, int job);

/* tangnt.c */
int tangnt(double *detsn, int (*fx)(), int (*df)(), double *fpar, int ip, int *ipar, int *iwork, int nvar, double *rwork, int (*slv)(), double *tan, double *xr);

/* cont_utilities.c */
int get_Dxf(double **matrix, int n_varb, double *state, double *parameters);
int get_Dpf(double **matrix, int n_varb, double *state, double *parameters);
int multAB(double **C, double **A, int a_col, double **B, int b_row);
int multAv(double *w, double **A, int a_row, int a_col, double *v);
int get_eigenval(double **A, int dim, double *wr, double *wi);
int get_eigenvec(double **A, int dim, double *wr, double *wi, double **vectors);
int minvse(double **m, double **m_inverse, int dim);
int frob_matnorm(double **matrix, int n, double *value);
int biprod(double **a_biprod, double **a, int n, double *det);
int bialtprd(double **B, double **A, int n);
int bezout(double **B, double *c, int n);
void balance(double **a, int n);
void hesberg(double **a, int n);
void compan(double **A, int n);

/* dslv.c */
void clear_mat(double **mat, int n, int m);
void copy_m_for(double **a, double *v, int n, int m);
void copy_m_back(double **a, double *v, int n, int m);
int dslv(double *dets, int (*fx)(), int (*df)(), double *fpar, int ipc,
         int *ipar, int *iwork, int liw, int job, int nvar, double *rwork,
         int lrw, double *x, double *y);
int dgefa(double **a, int lda, int n, int *ipvt);
void dgedi(double **a, int lda, int n, int *ipvt, double *det, double *work,
           int job);
void dgesl(double **a, int lda, int n, int *ipvt, double *b, int job);


/* Bif_Modes/<star>.c */
extern	int	static_init(int *n_aug_varb, int max_iters, double ***xr, double **fpar, double *state, double *parameters);
extern  int	static_func(int nvar, double *fpar, int *ipar, double *x, double *fx);
extern  int     static_dfunc(int nvar, double *fpar, int *ipar, double *x, double **fprime);
extern  int 	static_check(int *color, int n_varb, double *state, double *param);
extern  int 	static_update(double *x, double *param, int n_aug_varb);
extern	int	det_init(int *n_aug_varb, int max_iters, double ***xr, double **fpar, double *state, double *parameters);
extern  int 	det_func(int nvar, double *fpar, int *ipar, double *x, double *fx);
extern  int 	det_dfunc(int nvar, double *fpar, int *ipar, double *x, double **fprime);
extern  int	det_check(int *color, int n_varb, double *state, double *param);
extern  int 	det_update(double *x, double *param, int n_aug_varb);
extern	int	sn_init(int *n_aug_varb, int max_iters, double ***xr, double **fpar, double *state, double *parameters);
extern  int 	sn_func(int nvar, double *fpar, int *ipar, double *x, double *fx);
extern  int 	sn_dfunc(int nvar, double *fpar, int *ipar, double *x, double **fprime);
extern  int	sn_check(int *color, int n_varb, double *state, double *param);
extern  int 	sn_update(double *x, double *param, int n_aug_varb);
/* extern	int	hopf_bp_init(int *n_aug_varb, int max_iters, double ***xr, double **fpar, double *state, double *parameters);
extern  int 	hopf_bp_func(int nvar, double *fpar, int *ipar, double *x, double *fx);
extern  int	hopf_bp_dfunc(int nvar, double *fpar, int *ipar, double *x, double **fprime);
extern  int	hopf_bp_check(int *color, int n_varb, double *state, double *param);
extern  int 	hopf_bp_update(double *x, double *param, int n_aug_varb); */
extern	int	bp_init(int *n_aug_varb, int max_iters, double ***xr, double **fpar, double *state, double *parameters);
extern  int	bp_func(int nvar, double *fpar, int *ipar, double *x, double *fx);
extern  int	bp_dfunc(int nvar, double *fpar, int *ipar, double *x, double **fprime);
extern  int	bp_check(int *color, int n_varb, double *state, double *param);
extern  int	bp_update(double *x, double *param, int n_aug_varb);
extern	int	sp_init(int *n_aug_varb, int max_iters, double ***xr, double **fpar, double *state, double *parameters);
extern  int	sp_func(int nvar, double *fpar, int *ipar, double *x, double *fx);
extern  int     sp_dfunc(int nvar, double *fpar, int *ipar, double *x, double **fprime);
extern  int	sp_check(int *color, int n_varb, double *state, double *param);
extern  int	sp_update(double *x, double *param, int n_aug_varb);
extern	int	kub1_init(int *n_aug_varb, int max_iters, double ***xr, double **fpar, double *state, double *parameters);
extern 	int	kub1_func(int nvar, double *fpar, int *ipar, double *x, double *fx);
extern  int	kub1_dfunc(int nvar, double *fpar, int *ipar, double *x, double **fprime);
extern  int     kub1_check(int *color, int n_varb, double *state, double *param);
extern  int	kub1_update(double *x, double *param, int n_aug_varb);
extern	int	jgr_init(int *n_aug_varb, int max_iters, double ***xr, double **fpar, double *state, double *parameters);
extern  int	jgr_func(int nvar, double *fpar, int *ipar, double *x, double *fx);
extern	int	jgr_dfunc(int nvar, double *fpar, int *ipar, double *x, double **fprime);
extern	int	jgr_check(int *color, int n_varb, double *state, double *param);
extern	int	jgr_update(double *x, double *param, int n_aug_varb);

/* Misc. and aug. procedures from Bif_Modes */
extern  int     sn_aug_func(double *g_vector, double *x, double *fpar);
extern  int     lin_barstow(double *b, double *coeffs, int n, double omega);
extern  int     jgr_aug_func(double *g_vector, double *x, double *fpar);

