C  -------------------------------------------------------------------
C
C	Copyright (1990-1995) by Alexander Khibnik, Yuri Kuznetsov, and 
C	Eugene Nikolaev.
C
C The Locbif computation code in DsTool is distributed in the hope that it  
C will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty  
C of FITNESS FOR A PARTICULAR PURPOSE.  The software is provided as is without 
C any obligation on the part of Locbif authors, Cornell faculty, 
C Cornell staff or Cornell students to assist in its use, correction, 
C modification or enhancement. 
C
C  -------------------------------------------------------------------

      SUBROUTINE DECOMP (NDIM,N,A,COND,IPVT,WORK)
C     3.05.90.
C     POPAMMA BCET PAOEHE BEECTBEHHO
C     MATP OCPECTBOM ACCOBA CKEH 
C     OEHBAET OCOBEHHOCT MATP.
C
C     (POPAMMA OCAHA B KHE:
C           .OPCAT, M.MAKOM, K.MOEP
C          "MAHHE METO MATEMATECKX BCEH".
C           M.:MP,1980)
C
C     OHA COETC  BCEH PEEH HEHX
C     CCTEM.
C
C     BXOHA HOPMA...
C
C       NDIM=ABEHHA CTPOHA PAMEPHOCT MACCBA,
C       COEPAEO A.
C
C       N=OPOK MATP.
C
C       A=MATPA, KOTOP HHO PAOT.
C
C     BXOHA HOPMA...
C
C       A COEPT BEPXH TPEOH MATP U
C          TBA EPECTAHOBK BEPC
C         HHE TPEOHO MATP 1-L, TAKE,
C         TO (MATPA EPECTAHOBOK) *A=L*U
C
C     COND=OEHKA OCOBEHHOCT A.
C         HEHO CCTEM A*X=B MEHEH
C        B A  B MOT BBAT MEHEH B X, OE
C        B COND PA. EC COND+1.0 .EQ. COND, TO A
C        B PEEAX MAHHO TOHOCT BETC
C        BPOEHHO MATPE. COND OAAETC
C        PABHM 1.0E+32, EC OHAPEHA TOHA
C        BPOEHHOCT.
C
C     IPVT=BEKTOP BEX EMEHTOB.
C        IPVT(K)=HEKC K-BEE CTPOK
C        IPVT(N)=(-1)**(CO EPECTAHOBOK)
C
C     PAOEE OE..BEKTOP WORK OEH T OCAH
C              BKEH B BB. EO BXOHOE COEP-
C             AHE OHO HE AET BAHO HOP-
C             MA.
C
C     OPEETE MATP A MOET T OEH
C     HA BXOE O OPME
C        DET(A)=IPVT(N)*A(1,1)*A(2,2)*...*A(N,N).
C
C
C
      IMPLICIT REAL*8 (A-H,O-Z)
      IMPLICIT INTEGER*2 (I-N)
      DIMENSION A(NDIM,N), WORK(N), IPVT(N)
C
      IPVT(N) = 1
      IF (N .EQ. 1) GOTO 80
      NM1 = N - 1
C
C     BCT 1-HOPM MATP A.
C
      ANORM = 0.D0
      DO 10 J=1,N
         T = 0.D0
         DO 5 I=1,N
            T = T + DABS(A(I,J))
 5       CONTINUE
         IF (T .GT. ANORM) ANORM = T
 10   CONTINUE
C
C     ACCOBO CKEHE C ACTHM BOPOM BE-
C     EO EMEHTA.
C
      DO 35 K=1,NM1
         KP1 = K + 1
C
C     HAT BE EMEHT.
C
         M = K
         DO 15 I=KP1,N
            IF (DABS(A(I,K)) .GT. DABS(A(M,K))) M = I
 15      CONTINUE
         IPVT(K) = M
         IF (M .NE. K) IPVT(N) = -IPVT(N)
         T = A(M,K)
         A(M,K) = A(K,K)
         A(K,K) = T
C
C     POCTT TOT A, EC BE EMEHT
C     PABEH H.
C
         IF (T .EQ. 0.D0) GOTO 35
C
C     BCT MHOTE.
C
         DO 20 I=KP1,N
            A(I,K) = -A(I,K)/T
 20      CONTINUE
C
C     EPECTABT  CKAT O CTOAM.
C
         DO 30 J=KP1,N
            T = A(M,J)
            A(M,J)=A(K,J)
            A(K,J)=T
            IF (T .EQ. 0.D0) GOTO 30
            DO 25 I=KP1,N
               A(I,J)=A(I,J) + A(I,K)*T
 25         CONTINUE
 30      CONTINUE
 35   CONTINUE
C
C     COND=(1-HOPMA MATP A)*(OEHKA  1-HOPM
C           MATP, OPATHO K A)
C     OEHKA OAETC OCPECTBOM OHOO AA ME-
C     TOA OPATHX TEPA  HAMEHEO CH-
C     PHOO BEKTOPA. TO TPEET PEEH BX
C     CCTEM PABHEH, (TPAHCOHPOBAHHA  A)*Y=E
C     I A*Z=Y, E E-BEKTOP  +1  -1, BPAHH TAK,
C     TO MAKCMPOBAT BEH Y.
C     ESTIMATE=(1-HOPMA Z)/(1-HOPMA Y)
C
C     PET CCTEM (TPAHCOHPOBAHHA  A)*Y=E
C
      DO 50 K=1,N
         T = 0.D0
         IF (K .EQ. 1) GOTO 45
         KM1 = K - 1
         DO 40 I=1,KM1
            T = T + A(I,K)*WORK(I)
 40      CONTINUE
 45      EK = 1.D0
         IF (T .LT. 0.D0) EK = -1.D0
         IF (A(K,K) .EQ. 0.D0) GOTO 90
         WORK(K) = -(EK + T)/A(K,K)
 50   CONTINUE
      DO 60 KB=1,NM1
         K = N - KB
         T = 0.D0
         KP1 = K + 1
         DO 55 I=KP1,N
            T = T + A(I,K)*WORK(K)
 55      CONTINUE
         WORK(K) = T
         M = IPVT(K)
         IF (M .EQ. K) GOTO 60
         T = WORK(M)
         WORK(M) = WORK(K)
         WORK(K) = T
 60   CONTINUE
C
      YNORM = 0.D0
      DO 65 I=1,N
         YNORM = YNORM + DABS(WORK(I))
 65   CONTINUE
C
C     PET CCTEM A*Z=Y
C
      CALL SOLVE (NDIM,N,A,WORK,IPVT)
C
      ZNORM = 0.D0
      DO 70 I=1,N
         ZNORM = ZNORM + DABS(WORK(I))
 70   CONTINUE
C
C     OEHT OCOBEHHOCT
C
      COND = ANORM*ZNORM/YNORM
      IF (COND .LT. 1.D0) COND = 1.D0
      RETURN
C
C     CA MATP 1:1.
C
 80   COND = 1.D0
      IF (A(1,1) .NE. 0.D0) RETURN
C
C     TOHA BPOEHHOCT.
C
 90   COND = 1.0D+64
      RETURN
      END
