C  -------------------------------------------------------------------
C
C	Copyright (1990-1995) by Alexander Khibnik, Yuri Kuznetsov, and 
C	Eugene Nikolaev.
C
C The Locbif computation code in DsTool is distributed in the hope that it  
C will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty  
C of FITNESS FOR A PARTICULAR PURPOSE.  The software is provided as is without 
C any obligation on the part of Locbif authors, Cornell faculty, 
C Cornell staff or Cornell students to assist in its use, correction, 
C modification or enhancement. 
C
C  -------------------------------------------------------------------

      SUBROUTINE ZERO (ISTEP,NX,NDIMM,NG,NCAN,NUF,IFUNS,IPRZ,STX2,EPS,
     A                 FUN,DFDX,OUT,DFUN,ISTOP)
C     3.05.90.
C     7.08.1991
C     13.11.92
C     15.06.94
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C*                                                                     *
C*    POPAMMA  ZERO  PEHAHAEHA  TOHEH KOOPHAT HE     *
C*    AAHHX HK.                                                *
C*                                                                     *
C*     A P A M E T P :                                               *
C*    =================                                                *
C*                                                                     *
C*    ISTEP -CO AOB, POEAHHX BO KPBO.                    *
C*    NX    -PAMEPHOCT POCTPAHCTBA EPMEHHX.                       *
C*    NDIM  -ABEHHA CTPOHA PAMEPHOCT MATP DFUN.             *
C*    NG    -HOMEP ABHO EPEMEHHO.                                 *
C*    NCAN  -HOMEP KAHAA  BBOA PETATOB.                      *
C*    IPRZ  -APAMETP, OPEE OHOT POTOKOA.                 *
C*    NUF   -CO HK, CCEEMX HA KPBO.                     *
C*    IFUNS -MACCB HOMEPOB CCEEMX HK.                       *
C*    STX2  -KOOPHAT TEKE TOK HA KPBO.                       *
C*    EPS   -TOHOCT OPEEEH TOK HA KPBO B METOE HTOHA.    *
C*    FUN   -M OPOPAMM BCEH OPEEX HK.         *
C*    DFDX  -M OPOPAMM BCEH KOAHA OPEEX HK.*
C*    DFUN  -MACCB, COEPA KOAH OPEEX HK.          *
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C*    P MEHEH MAKCMAHOO CA EPEMEHHX  NDIM -HEOXOMO   *
C*    MEHT PAMEPHOCT MACCBOB:                                   *
C*    STX1(*) STX2(*) X1(*) X2(*) XZERO(*) VMOVE(*)                    *
C* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . *
C*    P MEHEH MAKCMAHOO CA HK, CCEEMX HA KPBO.*
C*    HEOXOMO MEHT PAMEPHOCT MACCBOB:                        *
C*    FUNS1(*) IFUNS(*) IFUNSA(*) IERF(*) FUNS2(*).                    *
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
      IMPLICIT REAL*8 (A-H,O-Z)
      IMPLICIT INTEGER*2(I-N)
      include 'beetlebf.dim'
      CHARACTER*56 TEXT
      DIMENSION STX1(NDIM), STX2(NDIM), X1(NDIM), X2(NDIM),
     A          XZERO(NDIM), FUNS1(IFMAX), IFUNS(IFMAX),
     B          DFUN(NDIM,NX), INDEX(NPTYP)
      EXTERNAL FUN, DFDX, OUT
C
      COMMON /ADD3B/ EPSZER
C
      COMMON /OUT1/ FUNS2(IFMAX)
      COMMON /OUT2/ INDZ, IERF(IFMAX)
      COMMON /OUT4/ EPSZ, EPSR, FZERO
C
      COMMON /ZERO2/ IFUNSA(IFMAX)
      COMMON /WRTO1/ NFIX1, NFIX
      COMMON /WRTO2/ DMOVE1, DMOVE
      COMMON /WRTO4/ EPSC, EPSN
      COMMON /WRTO6/ ITC,IT2
      COMMON /WRTO7/ VMOVE(NDIM),VMOVN(NDIM)
      SAVE STX1,FUNS1,/OUT1/,/OUT2/,/OUT4/
C
      ISTOP = 0
      IF (NUF .EQ. 0) RETURN
          DO 100 I=1,NPTYP
             INDEX(I) = 0
 100      CONTINUE
          EPSC  = EPS
C
C.... BCEHE HAEH BCEX HK B TEKE TOKE HA KPBO.
C
          DO 200 IFUN=1,NUF
            INDF        = IFUNSA (IFUN)
            IER         = 0
            FUNS2(INDF) = FUNALL (INDF,NX,STX2,FUN,DFDX,IER,ISTOP)
            IF (ISTOP .NE. 0) RETURN
            IF (IER   .EQ. 0) GOTO 170
C
C.... HE BCEHO HAEHE HK B TEKE TOKE HA KPBO.
C
                IF (ISTEP .EQ. 0) FUNS1(INDF) = -666.D+33
                                  FUNS2(INDF) = -666.D+33
                IERF(INDF) = IER
                GOTO 190
 170        CONTINUE
            IF (IERF(INDF) .EQ. 0) GOTO 180
C
C.... HE BCEH HAEH HK B PEX TOKAX HA KPBO;
C     BCEHHOE HAEHE HK B TEKE TOKE HE POBEPETC.
C
                FUNS1(INDF) = FUNS2(INDF)
                IERF(INDF)  = 0
 180        CONTINUE
 190        CONTINUE
 200      CONTINUE
C
C.... BBO POTOKOA PACETA HK.
C
          IPRTCL = 3
#if defined(hib)
          CALL WRTZER (IPRTCL,INDF,IWRT,ISTEP,IPRZ,IT,IDIV,NCAN,NX,
     A                 NDIM,ITER,NUF,IFUNS,EPSR,EPSZ,FUNS2,
     B                 X2,FX,DFUN)
#endif
C
C.... OPAOTKA OOBATEEM TEKE TOK HA KPBO 
C     BCEHHX HAEH HK.
C
          INDEX(1) = 1
          CALL OUT (ISTEP,INDEX,NX,NDIM,STX2,VMOVE,DFUN,ISTOP)
          IF (ISTOP .NE. 0) RETURN
          INDEX(1) = 0
          IF (ISTEP .EQ. 0) GOTO 390
              ITMAX = 10
              EPSZ  = EPSZER
C
C.... K POBEPK HA CMEH HAKA BCEX BCEHHX HAEH.
C
              DO 380 IFUN=1,NUF
                 INDZ  = 0
                 INDF = IFUNSA(IFUN)
C
C.... POBEPKA COB:
C     1). IFUNS(IFUN) < 0 -H HE TOHETC;
C     2). IERF (INDF) .NE. 0 -HAEHE HK HE BCEHO;
C
                 IF (IFUNS(IFUN) .LT. 0) GOTO 370
                 IF (IERF (INDF) .NE. 0) GOTO 370
C
C.... OOTOBKA PAOX MACCBOB.
C
                 DO 210 I=1,NX
                    X1(I) = STX1(I)
                    X2(I) = STX2(I)
 210             CONTINUE
C
C.... POBEPKA COB CMEH HAKA.
C
                 F1 = FUNS1(INDF)
                 F2 = FUNS2(INDF)
                 IF (F1*F2 .GT. 0.D0) GOTO 370
                 DF = DABS((F1-F2)/(X1(NFIX1)-X2(NFIX1)))
                 IF (DF.LT.0.1*EPSZ) GOTO 370
		 INDLOC = 0
C
C.... K TOHEH KOOPHAT H HK.
C
                     DO 300 ITER =1,ITMAX
C
C.... POHO KOOPHAT H HK.
C
 215              CONTINUE
                  IF (INDLOC .EQ. 0) RX = F2/(F2-F1)
                  IF (INDLOC .EQ. 1) RX = 0.5D0
                  IF (INDLOC .EQ. 2) RX = 4.D0/9.D0
C
                        DO 220 I=1,NX
                           XZERO(I) = X2(I)-(X2(I)-X1(I))*RX
 220                    CONTINUE
                        IT  = ITC
                        IPR = 0
                        IER = 0
c          WRITE (TEXT,1001) ITER
c          WRITE (6,1001) ITER
c 1001     FORMAT(
c     *   '  ZERO: Iter=',I2,41X)
C         CALL Showte(TEXT)
                        CALL NEWTN (NX,NDIM,NG,NFIX1,NCAN,XZERO,EPS,
     A                            EPSN,IT,IPR,FUN,DFDX,DFUN,IER,ISTOP)
                        IF (ISTOP .NE. 0) RETURN
                        IF (IER   .EQ. 0) GOTO 230
                        INDLOC=INDLOC+1
                        IF (INDLOC .LE. 2) GOTO 215
C
C.... HE COC HTOHOBCKE TEPA.
C
 225                    CONTINUE
                            IPRTCL = 2
                            IWRT   = 1 - IER
                            GOTO 320
 230                    CONTINUE
        	R1 = 0.D0
		R2 = 0.D0
		DO 235 I=1,NX
                   R1 = R1+(XZERO(I)-STX1(I))*(STX2(I)-STX1(I))
                   R2 = R2+(XZERO(I)-STX2(I))*(STX2(I)-STX1(I))
 235            CONTINUE
                IF (R1*R2 .GT. 0.) GOTO 225
                        IER   = 0
                        FZERO = FUNALL(INDF,NX,XZERO,FUN,DFDX,IER,ISTOP)
c          WRITE (TEXT,1002) FZERO
c          WRITE (6,1002) FZERO
c 1002     FORMAT(
c     *   '  ZERO: Fzero=',G9.2,33X)
C         CALL Showte(TEXT)
                        IF (ISTOP .NE. 0) RETURN
                        IF (IER   .EQ. 0) GOTO 240
                        INDLOC=INDLOC+1
                        IF (INDLOC .LE. 2) GOTO 215
C
C.... HE BCEH HAEH HK HA KPBO.
C
                            IPRTCL = 2
                            IWRT   = 0
                            GOTO 320
 240                    CONTINUE
C
C.... BOP HTEPBAA, COEPAEO H HK.
C
                            IF (F1*FZERO .LT. 0.D0) GOTO 260
                                F1 = FZERO
                                DO 250 I=1,NX
                                   X1(I) = XZERO(I)
 250                            CONTINUE
                                GOTO 280
 260                        CONTINUE
                                DO 270 I=1,NX
                                   X2(I) = XZERO(I)
 270                            CONTINUE
                                F2 = FZERO
 280                         CONTINUE
C
C.... KOHTPO OCTHTO TOHOCT.
C
                       EPSR = DABS(X2(NFIX1)-X1(NFIX1))
                       DF = DABS((F1-F2)/(X1(NFIX1)-X2(NFIX1)))
                       FN=    DABS (FZERO/DF)
                       IF (EPSR.LE.EPSZ .OR. FN.LE.0.1*EPSZ) GOTO 310
 300                 CONTINUE
                     ITER = ITMAX
                     INDZ = -1
 310                 CONTINUE
C
C.... BAA POTOKOA: HAEHO PEHE K H HK.
C
                     IPRTCL = 1
c                     CALL WRTZER (IPRTCL,INDF,IWRT,ISTEP,IPRZ,IT,IDIV,
c     A                            NCAN,NX,NDIM,ITER,NUF,IFUNS,
c     B                            EPSR,EPSZ,XZERO,X2,FZERO,DFUN)
                     INDEX(3) = INDF
                     CALL OUT (ISTEP,INDEX,NX,NDIM,XZERO,VMOVE,
     A                         DFUN,ISTOP)
                     IF (ISTOP .NE. 0) RETURN
                     GOTO 380
 320                 CONTINUE
C
C.... BAA POTOKOA: HE COC HTOHOBCKE TEPA 
C                       HE BCEHO HAEHE HK.
C
                     EPSR = DABS(X2(NFIX1)-X1(NFIX1))
C
                     FZERO = F1
                     IF (DABS(F1) .LE. DABS(F2)) GOTO 340
                         FZERO = F2
                         DO 330 I=1,NX
                            X1(I) = X2(I)
 330                     CONTINUE
 340                 CONTINUE
                     DMOVER= DMOVE
                     DMOVE = DMOVE1
                     NFIXR = NFIX
                     NFIX  = NFIX1
#if defined(hib)
                     CALL WRTZER (IPRTCL,INDF,IWRT,ISTEP,IPRZ,IT,IDIV,
     A                            NCAN,NX,NDIM,ITER,NUF,IFUNS,
     B                            EPSR,EPSZ,X1,XZERO,FZERO,DFUN)
#endif
                     DMOVE = DMOVER
                     NFIX  = NFIXR
C
C.... OOHTEHA OPAOTKA BCEHHX HAEH HK.
C
                     INDZ     =-1
                     INDEX(3) = INDF
                     CALL OUT (ISTEP,INDEX,NX,NDIM,X1,VMOVE,
     A                         DFUN,ISTOP)
                     IF (ISTOP .NE. 0) RETURN
 370             CONTINUE
 380          CONTINUE
 390      CONTINUE
C
C.... OOTOBKA K OEPEHOM A BO KPBO.
C
          DO 400 I=1,NX
            STX1(I) = STX2(I)
 400      CONTINUE
          DO 410 IFUN = 1,NUF
            INDF        =IFUNSA(IFUN)
            FUNS1(INDF) = FUNS2(INDF)
 410      CONTINUE
          RETURN
          END
