/* cp_action.c  routines to handle the actions sent by the notifier. */

#include "cp_head.h"

extern char *get_selection();
static char *datastr;
int canv1; /* holds canvas number, set in canvas_evt routine */
static FILE *fp; 
Textsw_mark script_command;
static char next[BUFSIZE];
extern Menu cmd_menu,pack_menu,screen_opt_menu,
	O_menu,R_menu,C_menu,K_menu,
	inquiry_menu,misc_menu,special_menu,color_menu,param_menu,
	screen_c_menu,disp_opt_menu;
extern complex ss_view();

struct Overlaps
 {
	int v,w;
	float angle;
	struct Overlaps *next;
 };

void
script_sw_notify_proc(textsw,attributes)
Textsw textsw;
Attr_avlist attributes;
{
	int pass_on = FALSE;	
	Attr_avlist attrs;
	extern void (*default_textsw_notify)();
	char filename[NAME_MAX];
	Textsw_index pos;

	for (attrs=attributes;*attrs;attrs=attr_next(attrs))
	 {
		switch ((Textsw_action)(*attrs))
		 {
case TEXTSW_ACTION_LOADED_FILE: /* want to mark next command line */
 {
	sprintf(filename,"Script Window - ");
	if (textsw_append_file_name(script_sw,filename)!=0)
		strcat(filename,"(NONE)\0");
	xv_set(script_frame,XV_LABEL,filename,0);
	pos=(Textsw_index)xv_get(script_sw,TEXTSW_INSERTION_POINT);
	if ((int)pos==0) script_file_data_mark=script_file_cmd_mark
		= script_file_path_mark
		=(Textsw_mark)
		   textsw_add_mark(script_sw,pos,TEXTSW_MARK_DEFAULTS);
		/* probably new file */
	pass_on=TRUE;
	break;
 }
case TEXTSW_ACTION_EDITED_FILE: /* indicate editing */
 {
	sprintf(filename,"Script Window - ");
	if (textsw_append_file_name(script_sw,filename)!=0) /* no file name */
	 {
		strcat(filename,"(NONE)\0");
		pos=(Textsw_index)xv_get(script_sw,TEXTSW_INSERTION_POINT);
		if ((int)pos < 6)   script_file_data_mark
		   =script_file_cmd_mark
		   =script_file_path_mark
		   =(Textsw_mark)
			textsw_add_mark(script_sw,pos,TEXTSW_MARK_DEFAULTS);
		/* probably starting empty file */
	 }
	strcat(filename," (edited)\0");
	xv_set(script_frame,XV_LABEL,filename,0);
	pass_on=TRUE;
	break;
 }
case TEXTSW_ACTION_EDITED_MEMORY: /* editing empty window */
 {
	sprintf(filename,"Script Window - (NONE) (edited)");
	xv_set(script_frame,XV_LABEL,filename,0);
	pass_on=TRUE;
	break;
 }
default:
 {
	pass_on=TRUE;
	break;
 }
		 } /* end of switch */
	 } /* end of for */
	if ((int)xv_get(script_sw,TEXTSW_LENGTH) == 0)
	 {
		sprintf(filename,"Script Window - (NONE)");
		xv_set(script_frame,XV_LABEL,filename,0);
	 } 
	if (pass_on) default_textsw_notify(textsw,attributes);
} /* script_sw_notify_proc */	

char *
find_script_data(datastr,flag) /* Search forward in file to locate data
following given <name>; loads buffer. flag 1=pack,2=path,3=cmds. Data must 
begin shortly after <name>. */ 
char *datastr;
int flag;
{
	int length,stop_flag=0,total;
	Textsw_index name1,name2,key2,first,last_plus_one,end_pos,lastpt;
	char *buffer,prefix[6];

	total=(int)xv_get(script_sw,TEXTSW_LENGTH);
	lastpt=name1=(Textsw_index)xv_get(script_sw,TEXTSW_INSERTION_POINT);
	while (flag==1 && !stop_flag 
		&& (int)name1<total && (int)name1>=(int)lastpt) 
		/* search for pack data */
	 {
		if (textsw_find_bytes(script_sw,&name1,&name2,datastr,
			(int)strlen(datastr),0)<0 || (int)name1<(int)lastpt)
			{window_bell(script_sw);return NULL;}
		lastpt=name2;
		if (textsw_find_bytes(script_sw,&name2,&key2,"COUNT:",6,0)>=0
		   && ((int)name2-(int)name1)<=(strlen(datastr)+12) 
		   && (int)name2>=5)
			 /* found name with nearby data */
		 {
			stop_flag=1;
			xv_get(script_sw,TEXTSW_CONTENTS,
				(Textsw_index)(name2-5),prefix,5);
			prefix[5]='\0';
			if (strcmp(prefix,"CHECK")==0) 
			   first=(Textsw_index)(name2-5);
			else if(strcmp(prefix+1,"NODE")==0) 
			   first=(Textsw_index)(name2-4);
			else {window_bell(script_sw);return NULL;}
				 /* malformed data */
		 }
		name1=lastpt;
	 }
	while (flag==2 && !stop_flag 
		&& (int)name1<total && (int)name1>=(int)lastpt) 
			/* search for path data */
	 {
		if (textsw_find_bytes(script_sw,&name1,&name2,datastr,
			(int)strlen(datastr),0)<0 || (int)name1<(int)lastpt)
			{window_bell(script_sw);return NULL;}
		lastpt=name2;
		if (textsw_find_bytes(script_sw,&name2,&key2,"PATH",4,0)>=0
		   && ((int)name2-(int)name1)<=(strlen(datastr)+8))
			/* found name with nearby data */
		 {
			stop_flag=1;
			first=name2;
		 }
		name1=lastpt;
	 }
	while (flag==3 && !stop_flag 
		&& (int)name1<total && (int)name1>=(int)lastpt) 
			/* search for cmds data */
	 {
		if (textsw_find_bytes(script_sw,&name1,&name2,datastr,
			(int)strlen(datastr),0)<0 || (int)name1<(int)lastpt)
			{window_bell(script_sw);return NULL;}
		lastpt=name2;
		if (textsw_find_bytes(script_sw,&name2,&key2,"CMDS",4,0)>=0
		   && ((int)name2-(int)name1)<=(strlen(datastr)+8))
			/* found name with nearby data */
		 {
			stop_flag=1;
			first=name2;
		 }
		name1=lastpt;
	 }
	 if (!stop_flag || textsw_find_bytes(script_sw,&key2,&last_plus_one,
		"END",3,0)<0)
		{window_bell(script_sw);return NULL;}
			/* malformed/missing data set */
	length=(int)last_plus_one-(int)first;
	buffer=(char *)malloc(length+2);
	end_pos=(Textsw_index)xv_get(script_sw,TEXTSW_CONTENTS,
		(int)first,buffer,length);
	if (end_pos != (int)first+length)
	 {window_bell(script_sw);return NULL;}
	buffer[length]='\n';buffer[length+1]='\0';
	return buffer;
} /* find_script_data */

int
find_next_script_cmd(direction,ex_flag) /* finds and selects (or executes) 
next (or previous) command from insertion pt in script. Return -1 
if command not found, else return index of first character.
direction: 0=forward, 1=backward. */
int direction,ex_flag;
{
	int cmd_length,cmd_shift;
	unsigned dir;
	Textsw_index	first,last_plus_one,pos,dummy;
	char *datastr;

	dir=(unsigned)direction;
	if (ex_flag) 
		first=(Textsw_index) xv_get(script_sw,TEXTSW_INSERTION_POINT);
	else first=textsw_find_mark(script_sw,script_file_cmd_mark);
	dummy=first;
	pos=textsw_find_bytes(script_sw,&dummy,&last_plus_one,
		"]:=",3,dir);
	if ( pos<0 || (dir==0 && pos < first) 
		|| (dir==1 && pos >= first) ) 
	 {
		(void) window_bell(script_sw);
		return -1;
	 }
	first=dummy=last_plus_one;
	datastr=(char *)malloc(1024);
	pos=(Textsw_index) xv_get(script_sw,TEXTSW_CONTENTS,(int)first,
		datastr,1023);
	if ((cmd_length=(int)pos - (int)first)<1024) 
		datastr[cmd_length]='\0';
	else datastr[1023]='\0';
	if (!cmd_search(datastr,&cmd_shift))
		/* didn't get anything */
	 {
		(void) window_bell(script_sw);
		free(datastr);
		return -1;
	 }
	dummy=dummy+(Textsw_index)cmd_shift;
	if (ex_flag) 
	 {
		free(next_script_cmd);
		next_script_cmd=datastr;
		xv_set(script_sw,TEXTSW_INSERTION_POINT,dummy,0);
		textsw_possibly_normalize(script_sw,dummy);
	 	script_file_cmd_mark=(Textsw_mark)
			textsw_add_mark(script_sw,dummy,TEXTSW_MARK_DEFAULTS);
		return cmd_length;
	 }
	textsw_set_selection(script_sw,first,dummy,1);
	textsw_possibly_normalize(script_sw,dummy);
	return 0;	
} /* find_next_script_cmd */

int
exe_named_cmd(datastr) /* Search script file, execute first cmd 
beginning [datastr]:=  Else, first beginning [datastr}:=
The curly bracket means the command won't be executed unless called
explicitly with label. */
char *datastr;
{
	int cmd_length,cmd_shift,count=0;
	char next[256],bracket[260],*cmdstr;
	Textsw_index	pos,first,last_plus_one;

	cmd_search_depth++;
	first=(Textsw_index)0;
	stripsp(datastr);
	if (cmd_search_depth>10|| !grab_next(&datastr,next)) 
	 {
		cmd_search_depth--;
		return 0;
	 }
	sprintf(bracket,"[%s]:=",next);
	pos=textsw_find_bytes(script_sw,&first,&last_plus_one,
		bracket,(int)strlen(bracket),0); 
	if (pos<0) /* not found */
	 {
		sprintf(bracket,"[%s}:=",next);
		pos=textsw_find_bytes(script_sw,&first,&last_plus_one,
			bracket,(int)strlen(bracket),0); 
		if (pos<0) /* still not found */
		 {
			(void) window_bell(script_sw);
			cmd_search_depth--;
			return 0;
		 }
	 }
	first=last_plus_one;
	cmdstr=(char *)malloc(1024);
	pos=(Textsw_index) xv_get(script_sw,TEXTSW_CONTENTS,(int)first,
		cmdstr,1023);
	if ((cmd_length=(int)pos - (int)first)<1024) 
		cmdstr[cmd_length]='\0';
	else cmdstr[1023]='\0';
	if (!cmd_search(cmdstr,&cmd_shift))
		/* didn't get anything */
	 {
		(void) window_bell(script_sw);
		free(cmdstr);
		cmd_search_depth--;
		return 0;
	 }
	cmdstr[cmd_shift]='\0';
	count=sort_cmd(cmdstr);
	cmd_search_depth--;
	free(cmdstr);
	return count;
} /* exe_named_cmd */

void
cmd_proc(item,event) Panel_item item; Event *event; /* cmd_menu actions.*/
{
	if (event_action(event)==ACTION_MENU && event_is_down(event))
		menu_show(cmd_menu,panel,event,0);
	else if (event_action(event)==ACTION_SELECT && event_is_down(event) )
		sort_cmd(cmd_history);
}

void
cmd_line_proc(item,event) Panel_item item; Event *event;
{
	strcpy(buf,(char *)xv_get(cmd_item,PANEL_VALUE));
	sort_cmd(buf);
	xv_set(cmd_item,PANEL_VALUE,"",0);
} /* cmd_line_proc */

handle_cmd_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	char *cmd_stream;
	int act=(int) xv_get(menuitem,MENU_VALUE);

	switch (act)
	 {
case 1: /* repeat last command */
 {sort_cmd(cmd_history); return;} 
case 2: /* execute selected command string */
 {
	if (!strlen(cmd_stream = get_selection(1))) return;
	if (sort_cmd(cmd_stream)) strcpy(cmd_history,cmd_stream);
		/* if command seems to work, it is stored for later use. */
	return;
 }
case 3: /* print `cmd_history' at end of scratch_sw */
{
	xv_set(scratch_sw,TEXTSW_INSERTION_POINT,TEXTSW_INFINITY,NULL);
	sprintf(buf,"\n"); strcat(buf,cmd_history);strcat(buf,"\n");
	textsw_insert(scratch_sw,buf,strlen(buf));
	return;
 } 
	 } /* end of switch */
} /* handle_cmd_proc */

void
pack_proc(item,event) Panel_item item; Event *event; /* pack_menu actions.*/
{if (event_action(event)==ACTION_MENU && event_is_down(event))
	menu_show(pack_menu,panel,event,0);}

void
handle_path_io_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	char *filename;
	int act=(int) xv_get(menuitem,MENU_VALUE);

	if (!strlen(filename=get_selection(1)))
	 {
		strcpy(msgbuf,"You must make a filename selection");
		emsg();
		return;
	 }
	if (act==1) /* read */
	 {
		sprintf(buf,"read_path %s",filename);
		handle_cmd(buf);
		return;
	 }
	else if (act==2)
	 {
		if ((fp=fopen(buf,"r")) != NULL)
		 {
		   sprintf(buf,"File %s already exists. Overwrite???",
			filename);
		   fclose(fp);
		   if (!confirm_action(buf)) return;
		 }
		sprintf(buf,"write_path %s",filename);
		handle_cmd(buf);	
		return;
	 }
} /* handle_path_io_proc */
		
void
handle_write_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	char *filename;
	int act=(int) xv_get(menuitem,MENU_VALUE);

	if (!strlen(filename=get_selection(1)))
	 {
		strcpy(msgbuf,"You must make a filename selection");
		emsg();
		return;
	 }
	if (act == 5) /* write directly to script file */
	 {
		sprintf(buf,"write -s %s",filename);
		handle_cmd(buf);
		return;
	 }
	set_packing_path();
	strcpy(buf,path);
	strcat(buf,filename);
	if ((fp=fopen(buf,"r")) != NULL)
	 {
		sprintf(buf,"File %s already exists. Overwrite???",filename);
		fclose(fp);
		if (!confirm_action(buf)) return;
	 }
	if (act==6)
	 {
		sprintf(buf,"eucl_write %s",filename);
		handle_cmd(buf);
		return;
	 }
	strcpy(buf,"write");
	switch (act)
	 {
		case 2: /* combinatoric info only */
		 {strcat(buf," -c ");break;}
		case 3: /* minimal */
		 {strcat(buf," -m ");break;}
		case 4: /* maximal */
		 {strcat(buf," -M ");break;}
		default: /* default */
		 {strcat(buf," -d ");break;}
	 }
	strcat(buf,filename);
	handle_cmd(buf);
} /* handle_write_proc */

void
handle_pack_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int p=current_p,p1,act=(int) xv_get(menuitem,MENU_VALUE);
	char *filename,*datastr;

	switch (act)
	 {
case 1:   /* select and read from file */
 {
	if (!strlen(filename = get_selection(1)))
	 {
		strcpy(msgbuf,"You must make a filename selection.");
		emsg();return;
	 }
	if (packdata[p].status)
	 {
		sprintf(buf,"Overwrite active pack?");
		if (!confirm_action(buf)) return;
	 }
	sprintf(buf,"read %s",filename);
	handle_cmd(buf);
	return;
 }
case 3:  /* copy to selected pack */
 {
	if (!strlen(datastr = get_selection(1))
	   || sscanf(datastr,"%d",&p1)!=1 || p1<0 || p1>=NUM_PACKS
	   || !packdata[current_p].status)
	 {
	   strcpy(msgbuf,"Data form: p. Copy active pack data to pack p. ");
	   emsg();return;
	 }
	if (packdata[p1].status)
	 {
		sprintf(buf,"Pack %d already full. OK?",p1);
		if (!confirm_action(buf)) return;
	 }
	sprintf(buf,"copy -p%d %d",current_p,p1);
	if (!handle_cmd(buf)) {strcpy(msgbuf,"Copy failed");emsg();}
	return;
 }
case 4: /* start new pack with a flower seed */
 {
	datastr = get_selection(1);
	if (packdata[p].status)
	 {
		sprintf(buf,"Current pack has contents. Overwrite?");
		if (!confirm_action(buf)) return;
	 }
	sprintf(buf,"seed %s",datastr);
	if (!handle_cmd(buf)) {strcpy(msgbuf,"Seed failed to take.");emsg();}
	return;
 }
case 5: /* read path from a file */
 {
	if (!strlen(filename = get_selection(1)))
	 {
		strcpy(msgbuf,"You must select a filename containing the path.");
		emsg();
		return;
	 }
	sprintf(buf,"read_path %s",filename);
	handle_cmd(buf);
	return;
 }
 		 } /* end of cases */
} /* pack_proc */

/* ------------------------ */

void
screen_up_proc(item,event) Panel_item item; Event *event;
/* screen_opt_menu actions. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
		menu_show(screen_opt_menu,panel,event,0);}

void
setup_proc() /* displays panel for setting various options */
{
	if (xv_get(setup_frame,WIN_SHOW))
		xv_set(setup_frame,WIN_SHOW,FALSE,0);
	else xv_set(setup_frame,WIN_SHOW,TRUE,0);
}

handle_screen_up_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int pnum,act=(int) xv_get(menuitem,MENU_VALUE);
	extern void canvas_life();

	if (act==0) return;
	pnum=act-1; 
	if (!packdata[pnum].status) 
	 	{sprintf(msgbuf,"Note: pack %d is empty.",pnum);msg();}
	canvas_life(pnum,1);
	return;
} /* screen_up_proc */

void
cmd_up_proc(item,event) Panel_item item;Event *event;
{cmd_up(1);}

cmd_up(sflag) /* displays the cmd_frame, msg_frame, text_frame,
and script frame if sflag . */
int sflag;
{
	xv_set(cmd_frame,WIN_SHOW,TRUE,0);
	xv_set(msg_frame,WIN_SHOW,TRUE,0);
	if (sflag) xv_set(text_frame,WIN_SHOW,TRUE,0);
}

void
script_up_proc() /* open script_frame */
{
	if (xv_get(script_frame,WIN_SHOW))
		xv_set(script_frame,WIN_SHOW,FALSE,0);
	else {strcpy(buf,"script");handle_cmd(buf);}
}

/* ------------------------ */


/* ------------------------ */

Radjust_proc(item,event) Panel_item item; Event *event; /* R_menu actions. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
	menu_show(R_menu,panel,event,0);}

handle_radjust_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int cp=current_p,act=(int) xv_get(menuitem,MENU_VALUE);
	float a,b;

	switch (act)
	 {
case 1: /* set one or more radii */
 {
  	if (!strlen(datastr=get_selection(1)))
	 {
		strcpy(msgbuf,"You must select (decimal) radius and vertex numbers.");
		emsg();return;
	 }
	sprintf(buf,"set_rad %s",datastr);
	break;
 }
case 2: /* set boundary radii to infinity (and adjust bdry 'aim'.)*/
 {
	if (packdata[cp].hes==0)
	 {
		strcpy(msgbuf,"This is euclidean pack, can't set radii to infinity.");
		emsg();return;
	 }
	sprintf(buf,"set_rad -0.1 b");
	handle_cmd(buf);
	sprintf(buf,"set_aim -0.1 b");
	break;
 }
case 3: /* increment radii using inc_factor */
 {
  	if (!strlen(datastr=get_selection(1)))
	 {
		strcpy(msgbuf,"You must select vertices to increment.");
		emsg();return;
	 }
	sprintf(buf,"inc_rad %s",datastr);
	break;
 } 
case 4:  /* Increment all finite bdry radii using inc_factor. */ 
	sprintf(buf,"inc_rad b");break;
case 5: /* decrement radii using 1/inc_factor */
 {
  	if (!strlen(datastr=get_selection(1)))
	 {
		strcpy(msgbuf,"You must select vertices to decrement.");
		emsg();return;
	 }
	sprintf(buf,"dec_rad %s",datastr);
	break;
 }
case 6:  /* Decrement all finite bdry radii using dec_factor. */ 
	sprintf(buf,"dec_rad b");break;
case 7: /* set random radii */
 {
  	if (!strlen(datastr=get_selection(1)))
	 {
		strcpy(msgbuf,"You must select vertices to randomize.");
		emsg();return;
	 }
	sprintf(buf,"set_rand %s",datastr);
	break;
 }
case 8: /* scale pack by a eucl_factor */
	sprintf(buf,"scale");break;
case 9: /* create spiral packing using selected two parameters */
 {
	if (!strlen(datastr=get_selection(1)) 
		|| sscanf(datastr,"%lf %lf",&a,&b)!=2 || a<=0 || b<=0)
		{strcpy(msgbuf,"Data form: a b. Select two positive parameters.");emsg();return;}
	sprintf(buf,"spiral %s",datastr);
	if (!handle_cmd(buf)) 
		{strcpy(msgbuf,"Something went wrong with spiraling.");emsg();}
	return;
 }
	 } /* end of switch */
	handle_cmd(buf);
} /* handle_radjust_proc */

/* ------------------------ */

Oadjust_proc(item,event) Panel_item item; Event *event; /* O_menu actions. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
	menu_show(O_menu,panel,event,0);}

handle_oadjust_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	char buff[40];
	int act=(int) xv_get(menuitem,MENU_VALUE),p=current_p;
	float ang;

	switch (act)
	 {
case 1: /* set all overlaps */
 {
	if (!strlen(datastr = get_selection(1))) ang=0.0;
	else if (!sscanf(datastr,"%lf",&ang) || ang<0 || ang>0.500)
	 {
		strcpy(msgbuf,"Selected overlap angle was not in [0,.5].");
 		emsg();return;
	 }
	sprintf(buff,"set_overlap %lf",ang);
	break;
 }
case 2: /* set selected overlaps, a + pairs v w */
 {	
	if (!strlen(datastr = get_selection(1)))
	 {
		strcpy(msgbuf,"Data form: a v w.. angle a an list of node pairs.");
 		emsg();return;
	 }
	sprintf(buff,"set_overlap %s",datastr);
	break;
 }
case 3: /* reset all to zero, free memory */
 {free_overlaps(&packdata[p]);return; }
	 } /* end of switch */
	handle_cmd(buff);
} /* handle_oadjust_proc */

/* ------------------------ */

Cadjust_proc(item,event) Panel_item item; Event *event;/* C_menu actions.*/
{if (event_action(event)==ACTION_MENU && event_is_down(event))
	menu_show(C_menu,panel,event,0);}

handle_cadjust_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int act=(int) xv_get(menuitem,MENU_VALUE);
	
	switch (act)
	 {
case 1: /* set to Andreev values (0 at bdry, 2pi interior) */
 {
	sprintf(buf,"set_aim -d");
	if (handle_cmd(buf)) 
		{strcpy(msgbuf,"Set aim values to default.");msg();}
	else 
		{strcpy(msgbuf,"Something went wrong with setting default aim values.");emsg();}
	return;
 }
case 2: /* set selected aim values */
 {
	if (!strlen(datastr=get_selection(1)))
		strcpy(buf,
"You must select (decimal) curvature, then list vertex numbers.");
	sprintf(buf,"set_aim %s",datastr);
	handle_cmd(buf);
	return;
 }
case 3: /* reset all aims to current curvature values */
	sprintf(buf,"set_aim -c");break;
case 4: /* reset interior aims to 2pi, bdry to -1 so they don't change.*/
	sprintf(buf,"set_aim -d");break;
	 } /* end of switch */
	handle_cmd(buf);
} /* Cadjust_proc */
	
/* ------------------------ */

quit_proc(item,event) /* close up shop */
Panel_item item;Event *event;
{quit();}

quit()
{
	sprintf(buf,"Please confirm the QUIT.");
	if (!confirm_action(buf)) return;
	textsw_erase(msg_sw,0,TEXTSW_INFINITY);
	textsw_erase(scratch_sw,0,TEXTSW_INFINITY);
	textsw_erase(log_sw,0,TEXTSW_INFINITY);
	textsw_erase(script_sw,0,TEXTSW_INFINITY);
	xv_destroy_safe(base_frame); 
} /* quit */

/* ------------------------ */

help_proc() /* popup help text window (read only) */
{
	if (xv_get(help_frame,WIN_SHOW))
		xv_set(help_frame,WIN_SHOW,FALSE,0);
	else xv_set(help_frame,WIN_SHOW,TRUE,0);
} 

/* ------------------------ */

history_proc() /* popup history text window */
{	if (xv_get(history_frame,WIN_SHOW))
		xv_set(history_frame,WIN_SHOW,FALSE,0);
	else xv_set(history_frame,WIN_SHOW,TRUE,0);
	textsw_possibly_normalize(log_sw,
		(Textsw_index) xv_get(log_sw,TEXTSW_INSERTION_POINT));
}

/* ------------------------ */

Kadjust_proc(item,event) Panel_item item; Event *event; /* K_menu actions. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
	menu_show(K_menu,panel,event,0);}

handle_kadjust_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int act=(int) xv_get(menuitem,MENU_VALUE);

	switch (act)
	 {
case 2: /* enclosing bdry circles */
{
	if (!strlen(datastr = get_selection(1)))
	 {
		strcpy(msgbuf,"Data: n v1 v2 ... Enclose vertices with n added circles."); 
		emsg();
		return ;
	 }
	sprintf(buf,"enclose %s",datastr);
	break;
 }	
case 3: /* adjoin */
 {
	if (!strlen(datastr = get_selection(1))) *datastr='\0';
	sprintf(buf,"adjoin %s",datastr);
	break;
 }
case 4: /* apply the cookie cutter */
 {sprintf(buf,"cookie");break; }
case 7: /* swap node numbers */
 {
	if (!strlen(datastr=get_selection(0))) return;
	sprintf(buf,"swap %s",datastr);
	break;
 }
	 } /* end of switch */
	handle_cmd(buf);
} /* Kadjust_proc */

void
handle_set_abc_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int act=(int) xv_get(menuitem,MENU_VALUE);

	if (!strlen(datastr=get_selection(1))) return; 
	switch (act)
	 {
case 1: sprintf(buf,"alpha %s",datastr);break;
case 2: sprintf(buf,"beta %s",datastr);break;
case 3: sprintf(buf,"gamma %s",datastr);break;
case 4: sprintf(buf,"node_active %s",datastr);break;
	 } 
	handle_cmd(buf);
} /* handle_set_abc_proc */

void
handle_add_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int v,w,d,n,act=(int) xv_get(menuitem,MENU_VALUE);

	switch (act)
	 {
case 2: /* add layer of nodes to boundary segment;
start at v, end at w; new nodes d degree (to extent possible). */
 {
	if (!strlen(datastr=get_selection(1)) 
		|| sscanf(datastr,"%d %d %d",&v,&w,&d)!=3
		|| d<3 || d>MAX_PETALS 
		|| !packdata[current_p].packK_ptr[v].bdry_flag
		|| !packdata[current_p].packK_ptr[w].bdry_flag)
	 {
		strcpy(msgbuf,"Data: `v w d', adds degree d circles from bdry vertex v to w.");
		emsg();return;
	 }
	sprintf(buf,"add_lay %d %d %d",v,w,d);
	break;
 }
case 3: /* add n whole generations of degree d */
 {
	if (!strlen(datastr=get_selection(1)) 
		|| sscanf(datastr,"%d %d",&n,&d)!=2 
		|| n<1 || d<3 || d>MAX_PETALS+1)
	 {
		strcpy(msgbuf,"Data: 'n d'. number n of generations of degree d.");
		emsg();return;
	 }
	sprintf(buf,"add_gen %d %d",n,d);
	break;
 }
case 4: /* add ideal bdry point (new node surrounded by one of bdry comps) */
 {
	if (!strlen(datastr=get_selection(1)) 
		|| sscanf(datastr,"%d",&v)!=1 
		|| v<1 || v>packdata[current_p].nodecount 
		|| packdata[current_p].packK_ptr[v].bdry_flag)
	 {
		strcpy(msgbuf,"Data: 'v'. v should be a boundary vertex.");
		emsg();
		return;
	 }
	sprintf(buf,"add_ideal %d",v);
	break;
 }	
default: /* add bdry circle clkwise from v. */
 {
	if (!strlen(datastr = get_selection(1)))
	 {
		strcpy(msgbuf,"Data form: v..  Adjoin circle to each v and its clockwise neighbor."); 
		emsg();return;
	 }
	sprintf(buf,"add_circle %s",datastr);
	break;
 }
	 } /* end of switch */
	handle_cmd(buf);
} /* handle_add_proc */

void
handle_remove_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int v1,v2,act=(int) xv_get(menuitem,MENU_VALUE);

	switch (act)
	 {
case 1: /* remove bdry circle */
 {
	if (!strlen(datastr=get_selection(1)))
	 {
		strcpy(msgbuf,"Data form: v. You must select a bdry vertex.");
		emsg();return;
	 }
	sprintf(buf,"rm_cir %s",datastr);
	if (!handle_cmd(buf))
	 {
		strcpy(msgbuf,"Something went wrong removing bdry circle.");
		emsg();
	 }
	return;
 }
case 2: /* remove edge between bdry verts */
 {
	if (!strlen(datastr=get_selection(1)) 
		|| sscanf(datastr,"%d%d",&v1,&v2)!=2)
		{strcpy(msgbuf,"you must select end verts of edge");emsg();}
	sprintf(buf,"rm_edge %d %d",v1,v2);
	if (handle_cmd(buf))
	 {
		sprintf(msgbuf,"REMOVED edge from %d to %d; p=%d",
			v1,v2,current_p);
		msg();
		handle_cmd("Fix");
	 }
	else 
	 {
		strcpy(msgbuf,"Something went wrong removing edge.");
		emsg();
	 }
	return;
 }
	 } /* end of switch */
} /* handle_remove_proc */

/* ------------------------ */

inquiry_proc(item,event) Panel_item item; Event *event; /*inquiry_menu acts. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
	menu_show(inquiry_menu,panel,event,0);}

handle_inquiry_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int act=(int) xv_get(menuitem,MENU_VALUE),code;

	if (!strlen(datastr=get_selection(1))) *datastr='\0';
	switch (act) {
	 case 1: {code=1;break;}
	 case 2: {code=2;break;}
	 case 4: {code=12;break;}
	 case 5: {code=13;break;} }
	print_inq_data(&packdata[current_p],code,datastr);
} /* handle_inquiry_proc */

void
handle_sel_inq_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int act=(int) xv_get(menuitem,MENU_VALUE);

	if (!strlen(datastr=get_selection(1))) *datastr='\0';
	print_inq_data(&packdata[current_p],act+3,datastr);
} /* handle_sel_inq_proc */

void
handle_spec_inq_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int act=(int) xv_get(menuitem,MENU_VALUE);

	if (!strlen(datastr=get_selection(1))) *datastr='\0';
	print_inq_data(&packdata[current_p],act+15,datastr);
} /* handle_spec_inq_proc */

/* ------------------------ */

/* sel_print_proc is in `postp.c' */

misc_proc(item,event) Panel_item item; Event *event;/* misc_menu actions. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
	menu_show(misc_menu,panel,event,0);}

handle_misc_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int act=(int) xv_get(menuitem,MENU_VALUE);

	if (!packdata[current_p].status)
	 {
		sprintf(msgbuf,"Pack %d is empty.",current_p);
		emsg();return;
	 }
	switch (act)
	 {
case 4: /* converts eucl to sph data */
 {sprintf(buf,"geom_to_s");break;}
case 5: /* converts hyp to eucl data */
 {sprintf(buf,"geom_to_e");break;}
case 6: /* converts hyp to hyp data */
 {sprintf(buf,"geom_to_h");break;}
	 } /* end of switch */
	handle_cmd(buf);
} /* misc_proc */

void
handle_repack_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int act=(int) xv_get(menuitem,MENU_VALUE);

	if (!packdata[current_p].status)
	 {
		sprintf(msgbuf,"Pack %d is empty.",current_p);
		emsg();
		return;
	 }
	switch (act)
	 {
case 2: /* adjust radii at selected (or active) nodes. */
 {
	if (!strlen(datastr = get_selection(1)))
	 {
		strcpy(msgbuf,"Data form: v.. list of nodes.");
		emsg();
		return;
	 }
	sprintf(buf,"repack -v %s",datastr);
	break;
 } 
default: /* repack, n passes. */
 {sprintf(buf,"repack %s",get_selection(0));break;}
	 } /* end of switch */
	handle_cmd(buf);
} /* handle_repack_proc */

void
handle_fix_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int act=(int) xv_get(menuitem,MENU_VALUE);

	if (!packdata[current_p].status)
	 {
		sprintf(msgbuf,"Pack %d is empty.",current_p);
		emsg();
		return;
	 }
	switch (act)
	 {
case 2: sprintf(buf,"fix -s");break; /* ang sums */
case 3: sprintf(buf,"fix -c");break; /* centers */
case 4: sprintf(buf,"fix -a");break; /* aims */
case 5: sprintf(buf,"fix -K");break; /* combinatorics */
case 6: sprintf(buf,"Fix");break;
default: sprintf(buf,"fix");break;
	 }
	handle_cmd(buf);
} /* handle_fix_proc */

void
handle_mob_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int act=(int) xv_get(menuitem,MENU_VALUE);
	float angle;
	complex cent;

	if (!packdata[current_p].status)
	 {
		sprintf(msgbuf,"Pack %d is empty.",current_p);
		emsg();
		return;
	 }
	switch (act)
	 {
case 1: /* apply Mobius to put vert v (or active) at origin */
 {
	if (strlen(datastr = get_selection(0)) > 4)
	 {
		strcpy(msgbuf,"Data form: v. Select vertex (default is the active vertex).");
		emsg();
		return;
	 }
	sprintf(buf,"center_vert %s",datastr);
	if (!handle_cmd(buf)) 
		{strcpy(msgbuf,"Mobius move failed.");emsg();}
	return;
 }
case 2: /* apply Mobius to put selected pt at origin */
 {
	if (!strlen(datastr = get_selection(0)) 
		|| sscanf(datastr,"%lf %lf",&cent.re,&cent.im)!=2)
	 {
		strcpy(msgbuf,"You must select real and imaginary parts."); 
		emsg();
		return ;
	 }
	sprintf(buf,"center_point %s",datastr);
	if (!handle_cmd(buf)) 
		{strcpy(msgbuf,"Mobius move failed.");emsg();}
	return;
 }
case 3: /* rotate by angle */
 {
	if (!strlen(datastr = get_selection(1))
		|| sscanf(datastr,"%lf",&angle)!=1)
	 {
		strcpy(msgbuf,"You must select rotation angle."); 
		emsg();
		return ;
	 }
	angle *= M_PI;
	sprintf(buf,"rotate %lf",angle);
	if (!handle_cmd(buf)) 
		{strcpy(msgbuf,"Rotate operation failed.");emsg();}
	return;
 }
case 4: /* apply Mob */
 {
	if (!strlen(datastr = get_selection(0)))
	 {
		strcpy(msgbuf,"Data: v.. select vertices"); 
		emsg();
		return ;
	 }
	sprintf(buf,"Mobius %s",datastr);
	handle_cmd(buf); 
	return;
 }
case 5: /* apply Mob inverse */
 {
	if (!strlen(datastr = get_selection(0)))
	 {
		strcpy(msgbuf,"Data: v.. select vertices"); 
		emsg();
		return ;
	 }
	sprintf(buf,"Mobius_inv %s",datastr);
	handle_cmd(buf); 
	return;
 }
	 } /* end of switch */
} /* handle_mob_proc */

/* ------------------------ */

special_proc(item,event) Panel_item item; Event *event; /* special_menu acts.
These routines are in 'specialp.c' so they can be changed easily. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
	menu_show(special_menu,panel,event,0);}

handle_special_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int act=(int) xv_get(menuitem,MENU_VALUE);

	if (act>7) return; /* inactive routines */
	if (!strlen(datastr = get_selection(0))) *datastr='\0';
	sprintf(buf,"special%d %s",act,datastr);
	handle_cmd(buf);
} /* special_proc */

/* ------------------------ */

void
color_proc(item,event) /* color choices */
Panel_item item;Event *event;
{ if (event_action(event)==ACTION_MENU && event_is_down(event))
		menu_show(color_menu,panel,event,0);}

void
handle_cir_color_proc(menu,menuitem) Menu menu; Menu_item menuitem;
{
	int act = xv_get(menuitem,MENU_VALUE);

	if (!strlen(datastr=get_selection(1))) *datastr='\0';
	switch(act)
	 {
case 1: 
  color_circles(&packdata[current_p],5,datastr); return; /* foreground */
case 2: 
  color_circles(&packdata[current_p],4,datastr); return; /* background */
case 3: 
  color_circles(&packdata[current_p],1,datastr); return; /* radii */
case 4: 
  color_circles(&packdata[current_p],3,datastr); return; /* compare to q */
case 5: 
  color_circles(&packdata[current_p],6,datastr); return; /* give code, list */
case 6:
  color_circles(&packdata[current_p],7,datastr); return; /* copy */
case 7:
  color_circles(&packdata[current_p],8,datastr); return; /* model curvature */
	 }
} /* handle_cir_color_proc */

void
handle_face_color_proc(menu,menuitem) Menu menu; Menu_item menuitem;
{
	int act = xv_get(menuitem,MENU_VALUE);

	if (!strlen(datastr=get_selection(1))) *datastr='\0';
	switch(act)
	 {
case 1: 
 color_faces(&packdata[current_p],5,datastr); return; /* foreground */
case 2: 
  color_faces(&packdata[current_p],4,datastr); return; /* background */
case 3: 
  color_faces(&packdata[current_p],1,datastr); return; /* area */
case 4: 
  color_faces(&packdata[current_p],3,datastr); return; /* compare to q */
case 5: 
  color_faces(&packdata[current_p],6,datastr); return; /* give code, list */
case 6:
  color_faces(&packdata[current_p],7,datastr); return; /* copy */
	 }
} /* handle_cir_color_proc */

/* --------------- beginning of procedures from parameter panel */

void
factor_inc_proc(item,value,event) /* change value of factor using slider. 
inc_factor should lie between 1 and 2. */
Panel_item item;int value;Event *event;
{float v=.01*value,l=log(2.0);inc_factor=exp(v*l);} 

void
eucl_factor_proc(item,value,event) /* change value of Euclidean scaling
factor using slider */
Panel_item item;int value;Event *event;
{eucl_factor=value*.01;return;} 

void
fill_pattern_proc(item,value,event) /* sets fill pattern for mono */
Panel_item item;int value;Event *event;
{
	fill_mode=value;
	switch (value)
	 {
	case 0: /* grey (default) */
		XSetFillStyle(display,gc_fill,FillStippled);return;
	case 1: /* white */
		XSetFillStyle(display,gc_fill,FillSolid);return;
	 } /* end of switch */
	panel_set(fill_pattern,PANEL_VALUE,value,0);
} /* fill_pattern_proc */

/* -----------  end of procedures from parameter panel */

void
active_p_proc(item,value,event) /* changes current pack */
Panel_item item;
int value;
Event *event;
{ chg_active_pack(value);}

chg_active_pack(pnum) /* change active pack to pnum */
int pnum;
{
	if (pnum==current_p) return;
	if ((int)xv_get(canvas_frame[pnum],WIN_SHOW)) 
		xv_set(canvas_frame[pnum],WIN_SHOW,TRUE,0);
	set_cursor(&screendata[current_p],screendata[current_p].ms_flag);
	live_node[current_p]=live_face[current_p]=0;
	current_p=pnum;
	xv_set(active_pack_item,PANEL_VALUE,current_p,0);
	set_cursor(&screendata[current_p],screendata[current_p].ms_flag);
} /* chg_active_pack */

int
pack_num(p) /* return pack number from pointer */
struct p_data *p;
{int i;for (i=0;i<NUM_PACKS;i++) if (&packdata[i]==p) return i;return 0;}

int
screen_num(q) /* return screen number from pointer */
struct s_data *q;
{int i;for (i=0;i<NUM_PACKS;i++) if (&screendata[i]==q) return i;return 0;}

int
enfoldcall(p,datastr)
struct p_data *p;
char *datastr;
{
	int n,m,vert,i,count=0,enfold_flag=0,hits;
	struct K_data *pK_ptr;
	char *node_ptr,*endptr;
	extern struct Vertlist *node_link_parse();
	struct Vertlist *vertlist,*trace;

	pK_ptr=p->packK_ptr;
	node_ptr=datastr;
	if (!grab_next(&node_ptr,next) || sscanf(next,"%d",&n)!=1
		|| n<0 || n>(MAX_PETALS-3)) return 0;
	if ( (vertlist=node_link_parse(p,node_ptr,&endptr,&hits)) != NULL)
	 {
		trace=vertlist;
		do {
			vert=trace->v;
			if (pK_ptr[vert].bdry_flag)
			 {
				m=MAX_PETALS-pK_ptr[vert].num-1;
				m=(n<m)? n:m;
				for (i=1;i<=m;i++) add_vert(p,vert);
				enfold_flag=enfold(p,vert);
				count++;
			 }
			trace=trace->next;
		 } while (trace!=NULL && enfold_flag);
		vert_free(&vertlist);
	 }
	if (count)
	 {
		if (!pK_ptr[p->beta].bdry_flag) choose_beta(p);
		complex_count(p,FALSE);
		facedraworder(p,NULL);
		fillcurves(p);
	 }
	return count;
} /* enfoldcall */

int
adjoincall(datastr) /* return 0 on error */
char *datastr;
{
	int pnum1,pnum2,v1,v2,n,n1,n2,*oldnew=NULL;
	int v,j,vv,ww,offset=0,over_flag=0;
	float angle;
	struct p_data *p1,*p2;
	struct K_data *pK_ptr1;
	struct Overlaps *overlaps=NULL,*trace;

	if (sscanf(datastr,"%d %d %d %d %d",&pnum1,&pnum2,&v1,&v2,&n)==5
		&& pnum1>=0 && pnum1<NUM_PACKS && pnum2>=0 && pnum2<NUM_PACKS)
	 {
		p1=&packdata[pnum1];p2=&packdata[pnum2];
		pK_ptr1=p1->packK_ptr;
		if (pnum1!=pnum2) offset=p1->nodecount;
		if ((n1=edge_count(p1,v1))<n || n<0) 
			/* signal to identify as many edges as possible */
			/* this needs more work for all possible cases ?? */
		 {
			if (n1<1 || (n2=edge_count(p2,v2))<1)
				return 0;
			if (n1==n2) n=n1-1;
			else n= (n1<n2) ? n1:n2;
		 }

 		if ( p1->overlap_status || p2->overlap_status )
			over_flag=1;

/* overlaps of pnum1 saved as linked list */
		if (p1->overlap_status) 
		 {
			overlaps=(struct Overlaps *)
				calloc(1,sizeof(struct Overlaps));
			trace=overlaps;
			for (v=1;v<=p1->nodecount;v++)
			for (j=0;j<(pK_ptr1[v].num+pK_ptr1[v].bdry_flag);j++)
			 {
			   if ( v<pK_ptr1[v].flower[j]
			      && (angle=pK_ptr1[v].overlaps[j])!=1.0 )
			    {
				trace->v=v;
				trace->w=pK_ptr1[v].flower[j];
				trace->angle=angle;
				trace=trace->next=(struct Overlaps *)
				   calloc(1,sizeof(struct Overlaps));
			    }
			 }
		 }

/* now try to adjoin */
		if (adjoin(p1,p2,v1,v2,n,&oldnew))
		 {
			complex_count(p1,TRUE);


/* restablish saved overlaps */
if(over_flag && alloc_overlaps(p1))
 {
	if (!offset && overlaps) /* self-adjoin, use new indices */
	 {
		trace=overlaps;
		while (trace && trace->next!=NULL)
		 {
			vv=oldnew[trace->v];
			ww=oldnew[trace->w];
			set_overlap(p1,vv,nghb(p1,vv,ww),trace->angle);
			trace=trace->next;
			free(overlaps);
			overlaps=trace;
		 }
		free(overlaps);
	 }
	else if (overlaps) /* reset pnum1 overlaps */
	 {
		trace=overlaps;
		while (trace && trace->next!=NULL)
		 {
			set_overlap(p1,trace->v,
			   nghb(p1,trace->v,trace->w),trace->angle);
			trace=trace->next;
			free(overlaps);
			overlaps=trace;
		 }
		free(overlaps);
		overlaps=NULL;
	 }
	if ( offset && p2->overlap_status ) 
		/* new overlaps from p2? */		
	 {
		for(v=1;v<=p2->nodecount;v++)
		 {
		   vv=oldnew[v];
		   for(j=0;j<p2->packK_ptr[v].num+
			p2->packK_ptr[v].bdry_flag;j++)
		    {
			if (v<p2->packK_ptr[v].flower[j])
			 {
			   ww=oldnew[p2->packK_ptr[v].flower[j]];
			   if ((angle=p2->packK_ptr[v].overlaps[j])!=1.0)
				set_overlap(p1,vv,nghb(p1,vv,ww),angle);
			 }
		    }
		 }
	 }
 }


			fillcurves(p1);
			facedraworder(p1,NULL);
			set_aim_default(p1);
			p1->active_node=p1->beta; 
			sprintf(msgbuf,"adjoin %d %d %d %d %d;",
				pnum1,pnum2,v1,v2,n);
			if (oldnew) free(oldnew);
			if (trace=overlaps)
			 {
			   while (trace && trace->next) 
			    {
				overlaps=trace->next;
				free(trace);
				trace=overlaps;
			    }
			   free(overlaps);
			 }
			msg();return 1;
		 }
	 }
	strcpy(msgbuf,"Something went wrong with 'adjoin' routine.");
	emsg();
	if (oldnew) free(oldnew);
	if (trace=overlaps)
	 {
		while (trace && trace->next) 
		 {
			overlaps=trace->next;
			free(trace);
			trace=overlaps;
		 }
			   free(overlaps);
	 }
	return 0;
} /* adjoincall */

/* ================ notify procedures for setting parameters ======*/

void
param_proc(item,event) Panel_item item; Event *event; /* param_menu setting.*/
{
	if (event_action(event)==ACTION_MENU && event_is_down(event))
	 menu_show(param_menu,setup_frame,event,0);
}

handle_param_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int act=(int) xv_get(menuitem,MENU_VALUE);

	if (!strlen(datastr=get_selection(1))) return;
	switch (act)
	 {
case 1: sprintf(buf,"set_cycle %s",datastr);break;
case 2: sprintf(buf,"set_accur %s",datastr);break;
case 3: sprintf(buf,"set_toler %s",datastr);break;
case 4: sprintf(buf,"set_err %s",datastr);break;
case 5: sprintf(buf,"set_iter %s",datastr);break;
case 6: sprintf(buf,"set_post_size %s",datastr);break;
case 7: sprintf(buf,"set_brush %s",datastr);break;
default: return;
	 } /* end of switch */
	handle_cmd(buf);
}

close_setup_proc(item,event) 
Panel_item item;Event *event; 
{xv_set(setup_frame,WIN_SHOW,FALSE,0);}
	
void
canvas_life(p,act) /* open/close canvas p if act=1/0. Assume screen not
yet open and pack is active. */
int p,act;
{
	switch (act)
	 {
case 0: /* close */
 {
	xv_set(screen_frame[p],WIN_SHOW,FALSE,0);
	panel_set(manip_item[p],PANEL_VALUE,0,0);
	xv_set(manip_frame[p],FRAME_CMD_PIN_STATE,FRAME_CMD_PIN_OUT,
		WIN_SHOW,FALSE,0);
	xv_set(canvas_frame[p],WIN_SHOW,FALSE,0);
	screendata[p].ms_flag=live_node[p]=live_face[p]=0;
	break;
 }
case 1: /* open canvas */
 {
	xv_set(canvas_frame[p],WIN_SHOW,TRUE,0);
	screendata[p].ms_flag=live_node[p]=live_face[p]=0;
	break;
 }
 	 } /* end of switch */
} /* canvas_life */

screen_toggles_proc(item,value,event) 
Panel_item item;int value;Event *event;
{
	int i,snum=-1;

	for (i=0;i<NUM_PACKS;i++) if (item==tog[i]) {snum=i;break;}
	if (snum<0) return;
	if (value==0) screendata[snum].unitcircle=1;
	else screendata[snum].unitcircle=0;
} /* screen_toggles_proc */

screen_coord_proc(item,value,event) 
Panel_item item;int value;Event *event;
{
	int i,snum=-1;

	for (i=0;i<NUM_PACKS;i++) if (item==sopt[i]) {snum=i;break;}
	if (snum<0) return;
	if (value==0) screendata[snum].coord_flag=0;
	else screendata[snum].coord_flag=1;
} /* screen_coord_proc */

reset_proc(item,event) Panel_item item;Event *event;
{
	int i,pnum=-1;

	for (i=0;i<NUM_PACKS;i++) if (item==rset[i]) {pnum=i;break;}
	if (pnum<0) return;
	reset_screen(packdata[pnum].screen);
} /* reset_proc */

close_popup_proc(item,event) Panel_item item;Event *event;
{
	int i,snum=-1;

	for (i=0;i<NUM_PACKS;i++) if (item==clsup[i]) {snum=i;break;}
	if (snum<0) return;
	xv_set(screen_frame[snum],WIN_SHOW,FALSE,0);
}

int
reset_screen(q) /* resets screen boxes for screen, use default height. */
struct s_data *q;
{
	int width,height,snum=screen_num(q);
	float halfwidth;

	q->display_opt=1;
	xv_set(sopt[snum],PANEL_VALUE,0,0);
	if (packdata[snum].hes<0)
	 {
		q->unitcircle=1;
		xv_set(tog[snum],PANEL_TOGGLE_VALUE,0,TRUE,0);
		q->coord_flag=0;
		xv_set(sopt[snum],PANEL_TOGGLE_VALUE,0,FALSE,0);
	 }
	else if (packdata[snum].hes==0)
	 {
		q->unitcircle=0;
		xv_set(tog[snum],PANEL_TOGGLE_VALUE,0,FALSE,0);
		q->coord_flag=0;
		xv_set(sopt[snum],PANEL_TOGGLE_VALUE,0,FALSE,0);
	 }
	else
	 {
		q->unitcircle=0;
		xv_set(tog[snum],PANEL_TOGGLE_VALUE,0,FALSE,0);
		q->coord_flag=1;
		xv_set(sopt[snum],PANEL_TOGGLE_VALUE,0,TRUE,0);
	 }
	q->pix_box.rx=width=(int)xv_get(canvas_frame[snum],XV_WIDTH);
	q->pix_box.ry=height=(int)xv_get(canvas_frame[snum],XV_HEIGHT);
	q->box=std_real_box;
	halfwidth=(q->box.ry-q->box.ly)
		*width/height/2.0;
	q->box.lx=(-1)*halfwidth;
	q->box.rx=halfwidth;
	q->factor=1.0;		
	xv_set(sfac[snum],PANEL_VALUE,0,0);
	return 1;
} /* reset_screen */


screen_factor_proc(item,value,event) Panel_item item;int value;Event *event;
	/* sets factor for screen resizing - larger factor 
	means smaller picture (more on screen)*/
{
	float v=.01*value,l=log(2.0);
	int i,pnum=-1;

	for (i=0;i<NUM_PACKS;i++) if (item==sfac[i]) {pnum=i;break;}
	if (pnum<0) return;
	screendata[pnum].factor = exp((-v)*l);
}  /* screen_factor_proc */

screen_size_proc(item,event) Panel_item item;Event *event;
 /* screen resizing based on current factor; keeps center fixed. */
{
	float hx,hy,cx,cy,factor;
	int i,snum=-1;
	struct s_data *q;

	for (i=0;i<NUM_PACKS;i++) if (item==ssize[i]) {snum=i;break;}
	if (snum<0) return;
	q=&screendata[snum];
	factor=q->factor;
	cx=(q->box.lx+q->box.rx)*0.5; 
	cy=(q->box.ly+q->box.ry)*0.5;
	hx=(q->box.rx-q->box.lx)*factor*0.5; 
	hy=(q->box.ry-q->box.ly)*factor*0.5;
	q->box.lx =cx-hx;
	q->box.rx =cx+hx;
	q->box.ly =cy-hy;
	q->box.ry =cy+hy;
} /* screen_size_proc */

screen_c_proc(item,event) Panel_item item;Event *event;
/* for centering screen on vertex number or given point */
{
	int i,pnum=-1;

	if (event_action(event)==ACTION_MENU && event_is_down(event))
	 {
		for (i=0;i<NUM_PACKS;i++) if (item==scent[i]) {pnum=i;break;}
		if (pnum<0) return;
		canv1=pnum;
		menu_show(screen_c_menu,screen_frame[pnum],event,0);
	}
}

handle_c_menu_proc(menu,menuitem) /* for centering screen */
Menu menu;
Menu_item menuitem;
{
	int act=(int)xv_get(menuitem,MENU_VALUE),v,front;
	complex ctr;
	float hx,hy,cx,cy,rad;
	struct p_data *p;
	struct s_data *q;
	
	p=&packdata[canv1];
	q=p->screen;
	switch (act)
	 {
case 1:  /* have selected vertex number, else use active node */
 {
	if (    ( 
		(strlen(datastr = get_selection(0)) && sscanf(datastr,"%d",&v)) 
		|| (v=p->active_node)
		)
		&& v>0 && v<=p->nodecount 
	   )
	 {
		if (p->hes<-okerr) 
		   h_to_e_data(p->packR_ptr[v].center,
			p->packR_ptr[v].rad,&ctr,&rad);
		else if (p->hes<okerr) 
			ctr=p->packR_ptr[v].center;
		else 
		 {
		   ctr=ss_view(p->screen,
		   	p->packR_ptr[v].center,1,&front);
		   if (!front) return;
		   ctr=s_pt_to_visual_plane(ctr);
		 }
		hx=(q->box.rx-q->box.lx)*0.5;
		hy=(q->box.ry-q->box.ly)*0.5;
		q->box.lx=ctr.re-hx;
		q->box.rx=ctr.re+hx;
		q->box.ly=ctr.im-hy;
		q->box.ry=ctr.im+hy;
		sprintf(msgbuf,"Centered %d.",v);
		msg();
		return;
	 }
	return;
 }
case 2: /* select real and imaginary parts for center */
 {
	if (!strlen(datastr = get_selection(1)))
	 {
		strcpy(msgbuf,"You must select real and imaginary parts."); 
		emsg();
		return;
	 }
	hx=(q->box.rx-q->box.lx)*0.5;
	hy=(q->box.ry-q->box.ly)*0.5;
	if (sscanf(datastr,"%lf%lf",
		&cx,&cy))
	 {	
		q->box.lx=cx-hx;
		q->box.rx=cx+hx;
		q->box.ly=cy-hy;
		q->box.ry=cy+hy;
		sprintf(msgbuf,"Centered (%lf,%lf)",cx,cy); 
		msg();
		return;
	 }
	strcpy(msgbuf,"Data form: re  im. Try again.");
	emsg();
	return;
 }
	 } /* end of switch */
} /* handle_c_menu_proc */
	
s_display_proc(item,event) Panel_item item;Event *event;
{
	int i,pnum=-1;
	
	for (i=0;i<NUM_PACKS;i++) if (item==sdp[i]) {pnum=i;break;}
	if (pnum<0) return;
	clear_canvas(&screendata[pnum]);
	disp_screen(&packdata[pnum],screendata[pnum].display_opt,0);
} /* s_display_proc */

void
base_resize_proc(window,event,arg) Window window; Event *event; 
Notify_arg arg;
{ 
 	Rect rect;

	if (event_action(event)!=WIN_RESIZE) return;
	frame_get_rect(base_frame,&rect);
	rect.r_top+=xv_get(base_frame,XV_HEIGHT)+5;
	rect.r_width=(short)xv_get(base_frame,XV_WIDTH);
/*	xv_set(cmd_frame,
		WIN_X,(int)rect.r_left,
		WIN_Y,(int)rect.r_top,
		XV_WIDTH,(int)rect.r_width,
		XV_HEIGHT,30,
		0);
*/
} /* base_resize_proc */	

void
canvas_s_proc(window,event,arg) Window window; Event *event; Notify_arg arg;
{ 
	int i,snum=-1,width,height;
	float midpt,halfwidth;
	struct s_data *q;

	if (event_action(event)!=WIN_RESIZE) return; 
		/* ?? catches too many events ?? */
	for (i=0;i<NUM_PACKS;i++) if (window==canvas_frame[i]) {snum=i; break;}
	if (snum<0) return;
	q=&screendata[snum];
	if ((width=(int)xv_get(window,XV_WIDTH))<100) width=100;
	if (width>MAX_PIXEL) width=MAX_PIXEL;
	if ((height=(int)xv_get(window,XV_HEIGHT))<100) height=100;
	if (height>MAX_PIXEL) height=MAX_PIXEL;
	if (q->pix_box.rx!=width 
	   || q->pix_box.ry!=height)
	 {
		XSetForeground(display,gc,bgcolor);
		XFillRectangle(display,q->xpm,gc,0,0,MAX_PIXEL,MAX_PIXEL);
		XSetForeground(display,gc,fgcolor); /* clear canvas */
		q->pix_box.rx=width; q->pix_box.ry=height;
		/* keep same center, same real height; adjust real width */
		midpt=(q->box.lx+q->box.rx)/2;
		halfwidth=(q->box.ry-q->box.ly)
			*width/height/2.0;
		q->box.lx=midpt-halfwidth;
		q->box.rx=midpt+halfwidth;
		display_call(&packdata[snum]," ");
	 }
} /* canvas_s_proc */

void
cl_pr_proc(c_frame) Frame c_frame;
{ 
	int i,pnum=-1;

	for (i=0;i<NUM_PACKS;i++) if (c_frame==canvas_frame[i]) {pnum=i; break;}
	if (pnum<0) return;
	canvas_life(pnum,0);
} /* cl_pr_proc */

int
canvas_num1(canv) /* returns number of canvas, 0 to NUM_PACKS-1 */
Canvas canv;
{int i;for (i=0;i<NUM_PACKS;i++) if (canv==canvas[i]) return i;return -1;}

int
canv_paint_num(canv) /* returns number of canvas_paint_window, 0-3 */
Canvas canv;
{int i;for (i=0;i<NUM_PACKS;i++) if (canv==canvas_paint_window(canvas[i])) 
		return i;
	return -1;
} /* canvas_paint_num */

void
canvas_repaint_proc(canvas,pw,display,xid,xrects)
Canvas canvas;Xv_Window pw;Display *display;Window xid;Xv_xrectlist *xrects;
{
	int h,w;
	struct s_data *q;

	q=packdata[canvas_num1(canvas)].screen;
	w=q->pix_box.rx-q->pix_box.lx;
	h=q->pix_box.ry-q->pix_box.ly;
	XCopyArea(display,q->xpm,xid,gc,0,0,w,h,0,0);
}

void
scr_popup_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int snum=canv1;

	if (!packdata[snum].status) 
	 {sprintf(msgbuf,"pack %d is empty",snum);emsg();return;}
	if (screen_frame[snum])
		xv_set(screen_frame[snum],WIN_SHOW,TRUE,0);
} /* scr_popup_proc */

void
cir_com_proc(menu,menuitem) /* display open circles and complex */
Menu menu;
Menu_item menuitem;
{
	int snum=canv1;

	if (!packdata[snum ].status) 
	 {sprintf(msgbuf,"pack %d is empty",snum);emsg();return;}
	screendata[snum].display_opt=8;
	panel_set(sopt[snum],PANEL_VALUE,4,0);
	sprintf(buf,"disp -p%d ",snum);
	handle_cmd(buf);
} /* cir_com_proc */

void
clr_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int snum=canv1,act=(int)xv_get(menuitem,MENU_VALUE);

	if (!packdata[snum].status) 
	 {sprintf(msgbuf,"pack %d is empty",snum);emsg();return;}
	sprintf(buf,"disp -p%d -w",snum);
	handle_cmd(buf);
	if (act==2) return;
	sprintf(buf,"disp -p%d ",snum);
	handle_cmd(buf);
} /* clr_proc */

void
circles_ofs_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int snum=canv1,act=(int)xv_get(menuitem,MENU_VALUE);

	if (!packdata[snum].status) 
	 {sprintf(msgbuf,"pack %d is empty",snum);emsg();return;}
	switch (act)
	 {
case 1: screendata[snum].display_opt=1; /*open circles*/
	panel_set(sopt[snum],PANEL_VALUE,0,0);
	sprintf(buf,"disp -p%d",snum);break;
case 2: screendata[snum].display_opt=0; /*filled circles*/
	panel_set(sopt[snum],PANEL_VALUE,1,0);
	sprintf(buf,"disp -p%d",snum);break;
case 3: 
 {
	if (!strlen(datastr=get_selection(0)))
		{strcpy(msgbuf,"You must select vertex numbers. ");
		emsg();return;}
	sprintf(buf,"disp -p%d -cf %s",snum,datastr);
	break;
 }
case 4: {sprintf(buf,"disp -p%d -cf m",snum);break;} /* marked circles */
	 } /* end of switch */
	handle_cmd(buf);
} /* circles_ofs_proc */

void
complex_ofs_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int snum=canv1,act=(int)xv_get(menuitem,MENU_VALUE);

	if (!packdata[snum].status) 
	 {sprintf(msgbuf,"pack %d is empty",snum);emsg();return;}
	switch (act)
	 {
case 1: screendata[snum].display_opt=4; /*open complex*/
	panel_set(sopt[snum],PANEL_VALUE,2,0);
	sprintf(buf,"disp -p%d",snum);break;
case 2: screendata[snum].display_opt=7; /*filled complex*/
	panel_set(sopt[snum],PANEL_VALUE,3,0);
	sprintf(buf,"disp -p%d",snum);break;
case 3: 
{
	if (!strlen(datastr=get_selection(0)))
	   {strcpy(msgbuf,"You must select face indices.");emsg();return;}
	sprintf(buf,"disp -p%d -ff %s",snum,datastr);
	break;
 }
case 4: {sprintf(buf,"disp -p%d -ff m",snum);break;} /* marked faces */
	 } /* end of switch */
	handle_cmd(buf);
} /* complex_ofs_proc */

void
label_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int snum=canv1,act=(int)xv_get(menuitem,MENU_VALUE);
	char *header;

	if (!packdata[snum].status) 
	 {sprintf(msgbuf,"Pack %d is empty",snum);emsg();return;}
	switch (act)
	 {
case 1: /* label circles */
	sprintf(buf,"disp -p%d -nc",snum);break;
case 2: /* label faces */
	sprintf(buf,"disp -p%d -nf",snum);break;
case 3: /* caption */
 {
	if (!strlen(header=get_selection(0)))
	 {
		strcpy(msgbuf,"You must select the desired caption. ");
		emsg();return;
	 }
	sprintf(buf,"disp -p%d -t %s",snum,header);
 }
	 } /* end of switch */
	handle_cmd(buf);
} /* label_proc */

void
output_proc(menu,menuitem)
Menu menu;
Menu_item menuitem;
{
	int snum=canv1,act=(int)xv_get(menuitem,MENU_VALUE);

	if (!packdata[snum].status) 
	 {sprintf(msgbuf,"pack %d is empty",snum);emsg();return;}
	switch (act)
	 {
case 2: {sprintf(buf,"print -p%d",snum); 
	handle_cmd(buf);
	break; }
	 } /* end of switch */
} /* output_proc */

void
canvas_evt(canv,event) Canvas canv;Event *event;
	 /* handle mouse events in canvas  */
{
	int count,snum=canv_paint_num(canv),node,i1,i2,newnode,sflag;
	int face,w1,w2,k,colr;
	complex comppt;
	Textsw_index point;
	XPoint *Xptr;
	extern XPoint *path_XPoints();
	extern struct Vertlist *cir_search(),*tri_search();
	struct Pathlist *trace,*newspot;
	struct Vertlist *vtrace,*nodelist=NULL;
	struct Edgelist *fflag;
	struct p_data *p;
	struct s_data *q;
	struct K_data *pK_ptr;
	
	canv1=snum;	
	p=&packdata[snum];
	q=p->screen;
	sflag=p->screen->ms_flag;
	switch (event_id(event)) /* switch on event from canvas menu */
	{

/*=============== RIGHT BUTTON =====================*/

case MS_RIGHT:
 {
	if (!p->status) return;
	if ((b_flip || r_flip) 
		&& event_right_is_down(event)) /* abandon flip */
	 {
		free(b_flip);free(r_flip);b_flip=r_flip=NULL;
		return;
	 }
 	menu_show(disp_opt_menu,canvas[snum],event,0);
	break;
 }

/*=============== MIDDLE BUTTON =====================*/

case MS_MIDDLE:
 {
	if ( event_middle_is_down(event) && sflag==0 &&
	   (nodelist=tri_search(p,(int)event->ie_locx,(int)event->ie_locy)) ) 
	 {
		vtrace=nodelist;
		do
		 {
			node=vtrace->v; 
			vtrace=vtrace->next;
		   /* draw filled face */
			draw_any_face(p,node,1,FG_COLOR,1);
		   /* put index in scratch window */
			point=(Textsw_index) 
			   xv_get(scratch_sw,TEXTSW_INSERTION_POINT);
			xv_set(scratch_sw,
			   TEXTSW_INSERTION_POINT,TEXTSW_INFINITY,NULL);
			sprintf(buf," %d ",node);
			textsw_insert(scratch_sw,buf,strlen(buf));
			xv_set(scratch_sw,TEXTSW_INSERTION_POINT,
			   point,NULL);
		   /* if 'shift', then mark face */
			if (event_shift_is_down(event)) 
				p->faces[node].mark++;
		 } /* end of do */
		while (vtrace!=NULL);
		vert_free(&nodelist);
	 }
	else if (event_middle_is_down(event) && sflag==9 &&
		(nodelist=tri_search(p,
		(int)event->ie_locx,(int)event->ie_locy)) ) 
	 {
		if (nodelist!=NULL && nodelist->v != live_face[snum]) 
		 {
			vert_free(&(nodelist->next));  /* use only one */
			draw_any_face(p,nodelist->v,1,FG_COLOR,1);
			live_face[snum]= layout_facelist(&packdata[current_p],
				1,&nodelist,1,live_face[snum],0,SHOW);

		 }
	 }
	break;
 }


/*=============== LEFT BUTTON =====================*/

case MS_LEFT:
 {
	if (!sflag && (b_flip || r_flip) 
		&& event_left_is_down(event)) /* select vert */
	 {
		pK_ptr=p->packK_ptr;
		if ((nodelist=cir_search(p,
			(int)event->ie_locx,(int)event->ie_locy)) )
		 {
			if (b_flip) {fflag=b_flip;colr=60;}
			else {fflag=r_flip;colr=180;}
				/* which flag? */
			if (!fflag->v) /* selecting first vert */
			 {
				fflag->v=nodelist->v;
				vert_free(&nodelist);
				return;
			 }
			else if (!fflag->w) /* selecting second vert */
			 {
				fflag->w=nodelist->v;
				vert_free(&nodelist);
				if ((k=nghb(p,fflag->v,fflag->w))<0)
				 {fflag->w=0;return;}
					/* find common nghbs */
				if (!pK_ptr[fflag->v].bdry_flag 
				   || k<pK_ptr[fflag->v].num)
					w1=pK_ptr[fflag->v].flower[k+1];
				if ((k=nghb(p,fflag->w,fflag->v))
				   <pK_ptr[fflag->w].num
				   || !pK_ptr[fflag->w].bdry_flag)
					w2=pK_ptr[fflag->w].flower[k+1];
					/* color and mark */
				pK_ptr[fflag->v].color
				   =pK_ptr[fflag->w].color
				   =pK_ptr[w1].color=pK_ptr[w2].color=colr;
				pK_ptr[fflag->v].mark
				   =pK_ptr[fflag->w].mark
				   =pK_ptr[w1].mark=pK_ptr[w2].mark=1;
					/* execute commands */
				sprintf(buf,"flip -p%d %d %d",
					snum,fflag->v,fflag->w);
				handle_cmd(buf);
				sprintf(buf,"mark -p%d -cw {c: d == 6}",snum);
				handle_cmd(buf);
				if ((p->euler==1 || p->euler==2) 
				   && p->genus==0) /* simply connected */
				 {
				   sprintf(buf,"repack -p%d",snum);
				   handle_cmd(buf);
				   sprintf(buf,"fix -p%d",snum);
				   handle_cmd(buf);
				   sprintf(buf,"disp -p%d -w -cf m -f",snum);
				   handle_cmd(buf);
				 }
				else
				 {
				   sprintf(buf,"disp -p%d -w -c -cf m",q);
				   handle_cmd(buf);
				 }
			 }
		 }
		/* abandon selection process */
		free(b_flip);free(r_flip);b_flip=r_flip=NULL;
		return;
	 }
	if (sflag==8) /* add to path */
	 {
		pix_to_r((int)event->ie_locx,(int)event->ie_locy,
			&comppt,q->pix_box,
			q->box,Aspect);
		newspot=(struct Pathlist *)calloc(1,
				sizeof(struct Pathlist));
		newspot->x=comppt.re;newspot->y=comppt.im;
		if (newpath==NULL) {newpath=newspot; return;}
		else
		 {
			count=2;
			trace=newpath;
			while (trace->next!=NULL) 
			 {
				trace=trace->next;
				count++;
			 }
			if (fabs(trace->x-newspot->x)>okerr
				|| fabs(trace->y-newspot->y)>okerr)
				trace->next=newspot;
		 }
		Xptr=path_XPoints(q,newpath,&count);
		XDrawLines(display,q->xid,gc,Xptr,count,CoordModeOrigin);
		XDrawLines(display,q->xpm,gc,Xptr,count,CoordModeOrigin);
		free(Xptr);
		return;
	 }		
	if (sflag==5 && event_left_is_down(event)) 
			/* determine coords of cursor */
	 {
		pix_to_r((int)event->ie_locx,(int)event->ie_locy,
			&comppt,q->pix_box,
			q->box,Aspect);
		point=(Textsw_index) xv_get(scratch_sw,
		   TEXTSW_INSERTION_POINT);
		xv_set(scratch_sw,TEXTSW_INSERTION_POINT,
		   TEXTSW_INFINITY,NULL);
		sprintf(buf," %lf %lf ",comppt.re,comppt.im);
		textsw_insert(scratch_sw,buf,strlen(buf));
		xv_set(scratch_sw,TEXTSW_INSERTION_POINT,
		   point,NULL);
		return;
	 }
	if ( event_left_is_down(event) && 
	   (nodelist=cir_search(p,(int)event->ie_locx,(int)event->ie_locy)) )
	 {
		vtrace=nodelist;
		do
		 {
			node=vtrace->v; 
			vtrace=vtrace->next;
			switch (sflag) 
			 {
case 0: /* desensitized mouse */
 {
	p->active_node=node;
		   /* draw circle number */
	draw_cir_number(p,node,node,1);
		   /* put index in scratch window */
	point=(Textsw_index) xv_get(scratch_sw,
	   TEXTSW_INSERTION_POINT);
	xv_set(scratch_sw,TEXTSW_INSERTION_POINT,
	   TEXTSW_INFINITY,NULL);
	sprintf(buf," %d ",node);
	textsw_insert(scratch_sw,buf,strlen(buf));
	xv_set(scratch_sw,TEXTSW_INSERTION_POINT,
	   point,NULL);
		   /* if 'shift', then mark face */
	if (event_shift_is_down(event)) 
		p->packK_ptr[node].mark++;
	break;
 }
case 1: /* change size */
 { /* not implemented yet */ break;}
case 2: /* add circle */
 {
	sprintf(buf,"add_circle -p%d %d",snum,node);
	handle_cmd(buf);
	newnode=p->nodecount;
	face=1;
	while ( face<=p->facecount 
	   && (find_index(p,face,newnode)<0) )
		face++;
	comp_center_face(p,face,-1);
	p->packK_ptr[newnode].color=FG_COLOR;
	draw_any_circle(p,newnode,1,FG_COLOR,1);
	break;
 }
case 3: /* delete circle; only does first from the list. */
 {
	sprintf(buf,"rm_circle -p%d %d",snum,node);
	if (handle_cmd(buf))
	 {
		clear_canvas(q);
		disp_screen(p,q->display_opt,0);
		sprintf(msgbuf,"Removed circle %d from pack %d.",node,snum);
		msg();
	 }
	vert_free(&nodelist);
	return;
 }
case 4: /* put in bdry edge */
 {
	sprintf(buf,"enclose -p%d 0 %d",snum,node);
	if (handle_cmd(buf))
	 {
	   i1=p->packK_ptr[node].flower[0];
	   i2=p->packK_ptr[node].
		flower[p->packK_ptr[node].num-1];
	   draw_edge(p,i1,i2,-1,1);
	 }
	break;
 }
case 6: /* increment radius */
 {
	sprintf(buf,"inc_rad -p%d %d",snum,node);
	handle_cmd(buf);
	draw_any_circle(p,node,1,FG_COLOR,1);
	break;
 }
case 7: /* decrement radius */
 {
	sprintf(buf,"dec_rad -p%d %d",snum,node);
	handle_cmd(buf);
	draw_any_circle(p,node,1,FG_COLOR,1);
	break;
 }
case 9: /* draw circles */
 {
	if (node!=live_node[snum] && node>0 
	   && node<=packdata[current_p].nodecount)
	 {
		draw_any_circle(p,node,1,FG_COLOR,1);
			/* draw on canvas q */
		draw_any_circle(&packdata[current_p],node,1,FG_COLOR,1);
			/* draw on projected canvas */
		live_node[snum]=node;
	 }
	break;
 }			
			 } /* end of switch on ms_flag */
		 } /* end of do */
		while (vtrace!=NULL);
		vert_free(&nodelist);
	 } /* end of if */	
	break;	
 } /* end of MS_LEFT case */

/*=============== DRAG =====================*/

case LOC_DRAG:
 {
	if (sflag==8 && event_left_is_down(event)) 
		/* add to path */
	 {
		pix_to_r((int)event->ie_locx,(int)event->ie_locy,
			&comppt,q->pix_box,q->box,Aspect);
		newspot=(struct Pathlist *)calloc(1,
				sizeof(struct Pathlist));
		newspot->x=comppt.re;newspot->y=comppt.im;
		if (newpath==NULL) {newpath=newspot; return;}
		else
		 {
			count=2;
			trace=newpath;
			while (trace->next!=NULL) 
			 {
				trace=trace->next;
				count++;
			 }
			trace->next=newspot;
		 }
		Xptr=path_XPoints(q,newpath,&count);
		XDrawLines(display,q->xid,gc,Xptr,count,CoordModeOrigin);
		XDrawLines(display,q->xpm,gc,Xptr,count,CoordModeOrigin);
		free(Xptr);
		return;
	 }
	else if (sflag==9) 
	 {
		if (event_middle_is_down(event) &&
		   (nodelist=tri_search(p,(int)event->ie_locx,
		   (int)event->ie_locy)) 
		   && (node=nodelist->v) != live_face[snum]
		   && node<=packdata[current_p].facecount) 
		 {
			vert_free(&(nodelist->next));  /* use only one */
			draw_any_face(p,nodelist->v,1,FG_COLOR,1);
			live_face[snum]= layout_facelist(&packdata[current_p],
				1,&nodelist,1,live_face[snum],0,SHOW);

		 }
		else if (event_left_is_down(event) &&
			(nodelist=cir_search(p,(int)event->ie_locx,
			(int)event->ie_locy)) && nodelist->v!=live_node[snum])
		 {
			vtrace=nodelist;
			do
			 {
			   node=vtrace->v;
			   if (node>0 && node<=packdata[current_p].nodecount)
			    {
				draw_any_circle(p,node,1,FG_COLOR,1);
				live_node[snum]=node;
			    }
			   vtrace=vtrace->next;
			 }
			while (vtrace!=NULL);
			vert_free(&nodelist);
		 }
	 }
	break;
 } /* end LOC_DRAG */

/*=============== "Whitehead move" keyboard events =====================*/

/* two players: b and r (blue and red). Pressing key when in canvas
initiates a turn; then two vertices are selected with LEFT_MOUSE to
complete it */

case 'b': /* set blue player to pick two vertices */
 {
	if (event_is_down(event)) /* b key being held */
	 {
		b_flip=(struct Edgelist *)calloc(1,sizeof(struct Edgelist));
		b_flip->v=b_flip->w=0;
		free(r_flip);r_flip=NULL;
	 }
	break;
 }
case 'r': /* set red player to pick two vertices */
 {
	if (event_is_down(event)) /* r key being held */
	 {
		free(b_flip);b_flip=NULL;
		r_flip=(struct Edgelist *)calloc(1,sizeof(struct Edgelist));
		r_flip->v=r_flip->w=0;
	 }
	break;
 }
	} /* end of 'event' switch */
} /* canvas_evt */



/* ======================== related routines =======================*/

int
mark(p,i) /* display node number of circle, make it the active_node. 
Repeating erases number. */
struct p_data *p;
int i;
{
	int x,y;
	complex normpt;
	char num[8];

	sprintf(num,"%d",i);
	r_to_pix(p->packR_ptr[(p->active_node=i)].center,&normpt,
		p->screen->pix_box,p->screen->box,Aspect);
	x=(int)normpt.re;
	if (i>10) x -= 5;
	if (i>100) x -= 5; /* shift a little for better positioning */
	y=(int)normpt.im;
/*	XSetFunction(display,gc,GXcopy);*/
	XDrawString(display,p->screen->xid,gc,x,y,num,strlen(num));
/*	XSetFunction(display,gc,GXcopy);*/
} /* mark */
		
struct Vertlist *
cir_search(p,x,y) /* find list of circles containing point (x,y). */
struct p_data *p;
int x,y;
{
	int i;
	struct Vertlist *trace,*nodelist;

	nodelist=NULL;
	for (i=1;i<=p->nodecount;i++)
	 {
		if (pt_in_cir(p,i,x,y))
		 {
		   if (!nodelist)
		    {
			nodelist=(struct Vertlist *)
			   calloc(1,sizeof(struct Vertlist));
			nodelist->v=i;
			trace=nodelist;
		    }
		   else
		    {
			trace->next=(struct Vertlist *)
			   calloc(1,sizeof(struct Vertlist));
			trace=trace->next;
			trace->v=i;
		    }
		 }
	 }
	return nodelist;
} /* cir_search */

int
pt_in_cir(p,n,x,y) /* pt in circle? */
struct p_data *p;
int n,x,y;
{
	int front;
	float a,u,v,rad;
	complex pt,w,ectr;
	extern complex ss_view(),proj_vec_to_sph();

	pix_to_r(x,y,&pt,p->screen->pix_box,
		p->screen->box,Aspect);
	if (p->hes>okerr)
	 {
		if ((a=pt.re*pt.re+pt.im*pt.im)>=1.0) return 0; 
			/* not in sphere */
		pt=proj_vec_to_sph(sqrt(1.0-a),pt.re,pt.im);
		return ( (s_dist(pt,ss_view(p->screen,
			p->packR_ptr[n].center,1,&front))<
			p->packR_ptr[n].rad) );
	 }
	if (p->hes<0)
		h_to_e_data(p->packR_ptr[n].center,
		   p->packR_ptr[n].rad, &ectr,&rad);
	else if (p->hes==0)
	 {
		rad=p->packR_ptr[n].rad;
		ectr=p->packR_ptr[n].center;
	 }
	w=csub(pt,ectr);
	if ( (u=fabs(w.re))<rad && (v=fabs(w.im))<rad &&
		     (u*u+v*v)<rad*rad ) return 1;
	return 0;
} /* pt_in_cir */

struct Vertlist *
tri_search(p,x,y) /* find list of (eucl) triangles under pt (x,y) */
struct p_data *p;
int x,y;
{
	int j;
	complex pt;
	struct Vertlist *trace,*nodelist;

	nodelist=NULL;
	for (j=1;j<=p->facecount;j++)
	 {
		pix_to_r(x,y,&pt,p->screen->pix_box,p->screen->box,Aspect);
		if (pt_in_tri(p,j,pt.re,pt.im))
		 {
		   if (!nodelist)
		    {
			nodelist=(struct Vertlist *)
			   calloc(1,sizeof(struct Vertlist));
			nodelist->v=j;
			trace=nodelist;
		    }
		   else
		    {
			trace->next=(struct Vertlist *)
			   calloc(1,sizeof(struct Vertlist));
			trace=trace->next;
			trace->v=j;
		    }
		 }
	 }
	return nodelist;
} /* tri_search */

int
pt_in_tri(p,n,x,y) /* pt in triangle? */
struct p_data *p;
int n;
float x,y;
{
	int k,rflag=0,iflag=0,front;
	complex ctr[3],pt;
	float det,dum,a;
	extern float row_col();
	extern complex ss_view();

	if (p->hes>okerr)
	 {
		if ((a=(x*x+y*y))>=1.0) return 0; /* not in sphere */
		pt=proj_vec_to_sph(sqrt(1.0-a),x,y);
		return ( pt_in_sph_tri(pt,
		   ss_view(p->screen,p->packR_ptr
			[p->faces[n].vert[0]].center,
			1,&front),
		   ss_view(p->screen,p->packR_ptr
			[p->faces[n].vert[1]].center,
			1,&front),
		   ss_view(p->screen,p->packR_ptr
			[p->faces[n].vert[2]].center,
			1,&front)) );
	 }
	for (k=0;k<=2;k++)
	 {
		if (p->hes<0) 
		   h_to_e_data(p->packR_ptr
			[p->faces[n].vert[k]].center,
			p->packR_ptr[p->faces[n].vert[k]].rad,
		        &ctr[k],&dum);
		else ctr[k]=p->packR_ptr
			[p->faces[n].vert[k]].center;
		rflag += (x<=ctr[k].re);
		iflag += (y<=ctr[k].im);
	 }
	if ( rflag < 3 && rflag > 0 && iflag < 3 && iflag > 0 ) 
			/* possible? */
	 {
		if ((ctr[0].re*(ctr[1].im-ctr[2].im)
		   -ctr[1].re*(ctr[0].im-ctr[2].im)
		   +ctr[2].re*(ctr[0].im-ctr[1].im))>0) det=1.0;
		else det=-1.0;
		if  /* check for convex combination */
	   (  (det*row_col(x,y,ctr[1].re,ctr[2].re,ctr[1].im,ctr[2].im))>0
	   && (det*row_col(x,y,ctr[2].re,ctr[0].re,ctr[2].im,ctr[0].im))>0
	   && (det*row_col(x,y,ctr[0].re,ctr[1].re,ctr[0].im,ctr[1].im))>0 )
			return 1;
		
	 }
	return 0;
} /* pt_in_tri */

float
row_col(x,y,xa,xb,ya,yb)
float x,y,xa,xb,ya,yb;
{ return (x*(ya-yb)-y*(xa-xb)+xa*yb-xb*ya);}

void
manip_proc(item,value,event) Panel_item item;int value;Event *event;
{
	int snum=0,count;
	XPoint *Xptr;
	extern XPoint *path_XPoints();
	struct Pathlist *trace;
	struct p_data *p;
	struct s_data *q;

/* ms_flag codes: 
	0 = desensitized mouse
	1 = changing size of circles (not yet implemented)
	2 = adding circle to bdry circle
	3 = deleting bdry circle
	4 = enfolding bdry vert
	5 = crosshairs for coords 
	6 = increment radii
	7 = decrement radii
	8 = drawing path
	9 = projection mode
*/

	while (item!=manip_item[snum] && snum<NUM_PACKS) snum++;
	if (snum==NUM_PACKS) return;
	q=packdata[snum].screen;
	p=&packdata[snum];
	
	switch(value)
	 {
case 1: /* add circles */ {set_cursor(q,2);return;}
case 2: /* enfold */ {set_cursor(q,4);return;}
case 3: /* delete circles */ {set_cursor(q,3);return;}
case 4: /* increment radii */ {set_cursor(q,6);return;}
case 5: /* decrement radii */ {set_cursor(q,7);return;}
case 6:
case 7: /* start path */
 {
	path_free(&newpath);
		/* display the alpha circle */
	draw_any_circle(p,p->alpha,1,FG_COLOR,1);
	set_cursor(q,8);
	return;
 }
case 8: /* accept path and desensitize */
 {
	if (q->ms_flag!=8) return;
	if (newpath==NULL) break;
	count=1;
	trace=newpath;
	while (trace->next!=NULL) {trace=trace->next;count++;}
	if (count>=3)
	 {
		if (trace->x!=newpath->x || trace->y!=newpath->y)
		 {
			trace->next=(struct Pathlist *)calloc
				(1,sizeof(struct Pathlist));
			trace->next->x=newpath->x;
			trace->next->y=newpath->y;
			count++;
			Xptr=path_XPoints(q,newpath,&count);
			XDrawLines(display,q->xid,gc,
				Xptr,count,CoordModeOrigin);
			XDrawLines(display,q->xpm,gc,
				Xptr,count,CoordModeOrigin);
			free(Xptr);
		 } /* make sure path closes up */
		path_free(&pathlist);
		pathlist=newpath;
		pathlength=count;
	 }
	newpath=NULL;
	break;
 } /* break to desensitize mouse */
case 9: /* show coords */ {set_cursor(q,5);return;}
case 10: /* project faces. ie, draw on active pack */
 {
	set_cursor(q,9);
	live_face[snum]=0;
	return;
 }
	 } /* end of switch */

/* desensitize mouse */

	set_cursor(q,0);
	live_node[snum]=live_face[snum]=0; 
	return;
} /* manip_proc */

void
show_manip_frame_proc(menu,menuitem) Menu menu; Menu_item menuitem;
{  
	int x,y;
	Rect rect;

	frame_get_rect(canvas_frame[canv1],&rect);
	y=(int)rect.r_top;
	x=(int)(rect.r_left+rect.r_width+5);
	xv_set(manip_frame[canv1],WIN_X,x,WIN_Y,y,WIN_SHOW,TRUE,0);
} 

void
ms_repack_proc(menu,menuitem) Menu menu; Menu_item menuitem;
{
	if (packdata[canv1].locks) return;
	rifflecall(&packdata[canv1],totalpasses,1,0);
	comp_pack_centers(&packdata[canv1]);
}

void
show_path_proc(menu,menuitem) Menu menu; Menu_item menuitem;
{
	sprintf(buf,"disp -p%d -g",canv1);
	handle_cmd(buf);
}

void
quicksave_proc(menu,menuitem)  Menu menu; Menu_item menuitem;
{
	char filename[128],holdname[128];

	strcpy(holdname,packdata[canv1].file_name);
	set_packing_path();
	strcpy(filename,path);
	sprintf(buf,"tmp%d.p",canv1);
	strcat(filename,buf);
	if (open_and_write(&packdata[canv1],filename,2))
		strcpy(packdata[canv1].file_name,holdname); 
	else {strcpy(msgbuf,"quicksave has failed.");emsg();}
	strcpy(packdata[canv1].file_name,holdname);
	return;
} /* quicksave_proc */

void
manip_frame_done_proc(subframe) 
Frame subframe;
{
	int q=0;
	
	while (subframe!=manip_frame[q] && q<NUM_PACKS) q++;
	if (q==NUM_PACKS) return;
	live_node[q]=live_face[q]=0; 
	set_cursor(&screendata[q],0);
	xv_set(subframe,FRAME_CMD_PIN_STATE,FRAME_CMD_PIN_OUT,
		XV_SHOW,FALSE,0);
} /* manip_frame_done_proc */

/*  ==============  Routines for choosing the color settings ============ */

int
radius_col_comp(p) /* color gradations based on radii, index 1-19 (blues). */
struct p_data *p;
{
	float b,t;
	int i;
	struct R_data *pR_ptr;

	pR_ptr=p->packR_ptr;
	b=t=pR_ptr[1].rad;
	for (i=2;i<=p->nodecount;i++)
	 {
		if (pR_ptr[i].rad>t) t=pR_ptr[i].rad;
		if (pR_ptr[i].rad<b) b=pR_ptr[i].rad;
	 }
	if (b<0) b=0.0;
	if (t<=0 || fabs(t-b)/t<.005) /* problem of small variation */
	 {
		for (i=1;i<=p->nodecount;i++) p->packK_ptr[i].color=20;
		return 1;
	 }
	if (p->hes<0)
		for (i=1;i<=p->nodecount;i++)
		 {
			p->packK_ptr[i].color=
				1+(int)(18.0*(pR_ptr[i].rad-b)/(t-b));
		 }
	else if (p->hes==0)
		for (i=1;i<=p->nodecount;i++)
		 {
			p->packK_ptr[i].color=
				1+(int)(18.0*(pR_ptr[i].rad-t)/(b-t));
		 }
	return 1;
} /* radius_col_comp */

int
area_col_comp(p) /* color gradations, index 1-19 (blues). */
struct p_data *p;
{
	float b,t,*areas;
	int i,flag=1;
	struct R_data *pR_ptr;

	pR_ptr=p->packR_ptr;
	t=0.0;
	b=h_area(pR_ptr[p->faces[1].vert[0]].rad,
				pR_ptr[p->faces[1].vert[1]].rad,
				pR_ptr[p->faces[1].vert[2]].rad);
	if ( !(areas=(float *)malloc((p->facecount+1)*sizeof(float))) ) 
		return 0;
	if (p->hes<0)
		for (i=1;i<=p->facecount;i++)
		 {
			areas[i]=h_area(pR_ptr[p->faces[i].vert[0]].rad,
				pR_ptr[p->faces[i].vert[1]].rad,
				pR_ptr[p->faces[i].vert[2]].rad);
			t=(areas[i]>t) ? areas[i]:t;
			b=(areas[i]<b) ? areas[i]:b;
		 }
	else if (p->hes==0)
		for (i=1;i<=p->facecount;i++)
		 {
			areas[i]=e_area(pR_ptr[p->faces[i].vert[0]].rad,
				pR_ptr[p->faces[i].vert[1]].rad,
				pR_ptr[p->faces[i].vert[2]].rad);
			t=(areas[i]>t) ? areas[i]:t;
			b=(areas[i]<b) ? areas[i]:b;
		 }
	if (b==0.0) flag=0;
	if (t==0 || fabs(t-b)/t<.005)
		for (i=1;i<=p->facecount;i++) p->faces[i].color=20;
	else for (i=1;i<=p->facecount;i++)
	 {
		p->faces[i].color=
			1+(int)(18.0*(areas[i]-t)/(b-t));
	 }
	free(areas);
	return (flag);
} /* area_col_comp */


h_compare_area(p,q) /* compare ratio of hyperbolic areas of faces from 
	p and q. Use 2-color ramp, lower indices 
	indicating q larger, uppers indicating p larger. */
struct p_data *p,*q;
{
	int i,node;
	float b=1.0,ratio,*areas_p,*areas_q;
	struct R_data *pR_ptr,*qR_ptr;

	pR_ptr=p->packR_ptr;
	qR_ptr=q->packR_ptr;
	node=(p->facecount>q->facecount) ? q->facecount : p->facecount;
	if (!( areas_p=(float *)malloc((node+1)*sizeof(float)) )
		|| !( areas_q=(float *)malloc((node+1)*sizeof(float)) ) ) 
		return 0;
	for (i=1;i<=node;i++)
	 {
		areas_p[i]=h_area(pR_ptr[p->faces[i].vert[0]].rad,
				pR_ptr[p->faces[i].vert[1]].rad,
				pR_ptr[p->faces[i].vert[2]].rad);
		areas_q[i]=h_area(qR_ptr[q->faces[i].vert[0]].rad,
				qR_ptr[q->faces[i].vert[1]].rad,
				qR_ptr[q->faces[i].vert[2]].rad);
		ratio=areas_q[i]/areas_p[i];
		if (ratio>b) b=ratio;
		if ((1.0/ratio)>b) b=1.0/ratio;
	 }
	if (b==1) for (i=1;i<=p->facecount;i++) p->faces[i].color=20;
	else
	 {
		for (i=1;i<=node;i++)
		 {
		   if ((ratio=areas_p[i]/areas_q[i])>1.0)
		     p->faces[i].color=
			(int)(20.0+19.0*(ratio-1.0)/(b-1.0));
		   else 
		     p->faces[i].color=
			1+(int)(18.0*(1.0-(1.0/ratio-1.0)/(b-1.0)));
		 }
	 }
	free(areas_p);free(areas_q);
	if (node<p->facecount) for (i=node+1;i<=p->facecount;i++)
		p->faces[i].color=20;
	return 1;
} /* h_compare_area */

h_compare_cl(p,q) /* compare ratio of hyp radii of packs p and q,
	put results into colors of pack p. Use 2-color ramp, lower indices 
	indicating q larger, uppers indicating p larger. Data is scaled. */
struct p_data *p,*q;
{
	int i,node;
	float b=1.0,ratio;
	struct K_data *pK_ptr;
	struct R_data *pR_ptr,*qR_ptr;

	pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
	qR_ptr=q->packR_ptr;
	node=(p->nodecount>q->nodecount) ? q->nodecount : p->nodecount;
	for (i=1;i<=node;i++)
	 {
		if (pR_ptr[i].rad>0.0 && qR_ptr[i].rad>0.0)
		 {
			ratio=log(pR_ptr[i].rad)/log(qR_ptr[i].rad);
			if (ratio>b) b=ratio;
			else if ((1.0/ratio)>b) b=1.0/ratio;
		 }
	 } /* determine b for scaling purposes */
	if (b==1.0) 
	 {
		for (i=1;i<=node;i++)
		 {
			if (pR_ptr[i].rad<=0.0 && qR_ptr[i].rad>0.0)
				pK_ptr[i].color=39;
			else if (pR_ptr[i].rad>0.0 && qR_ptr[i].rad<=0.0)
				pK_ptr[i].color=1;
			else pK_ptr[i].color=20;
		 }
		return;
	 }
	for (i=1;i<=node;i++)
	 {
		if (pR_ptr[i].rad<=0.0 && qR_ptr[i].rad>0.0)
			pK_ptr[i].color=39;
		else if (pR_ptr[i].rad>0.0 && qR_ptr[i].rad<=0.0)
			pK_ptr[i].color=1;
		else
		 {
			ratio=log(pR_ptr[i].rad)/log(qR_ptr[i].rad);
			if (ratio>1.0) pK_ptr[i].color=
				(int)(20.0+19.0*(1.0-ratio)/(1.0-b));
			else pK_ptr[i].color=
				(int)(20.0-18.0*(1.0-1.0/ratio)/(1.0-b));
		 }
	 }
	if (node<p->nodecount) for (i=node+1;i<=p->nodecount;i++)
		pK_ptr[i].color=20;
	return;
} /* h_compare_cl */

e_compare_cl(p,q) /* compare ratio of eucl radii of packs p and q,
	put results into colors of pack p. Use 2-color ramp, lower indices 
	indicating q larger, uppers indicating p larger. Data is scaled. */
struct p_data *p,*q;
{
	int i,node;
	float b=1.0,ratio;
	struct K_data *pK_ptr;
	struct R_data *pR_ptr,*qR_ptr;

	pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
	qR_ptr=q->packR_ptr;
	node=(p->nodecount>q->nodecount) ? q->nodecount : p->nodecount;
	for (i=1;i<=node;i++)
	 {
		ratio=pR_ptr[i].rad/qR_ptr[i].rad;
		if (ratio>b) b=ratio;
		else if ((1/ratio)>b) b=1/ratio;
	 } /* determine b for scaling purposes */
	if (b==1.0) 
	 {
		for (i=1;i<=node;i++) pK_ptr[i].color=20;
		return;
	 }
	for (i=1;i<=node;i++)
	 {
		ratio=pR_ptr[i].rad/qR_ptr[i].rad;
		if (ratio>1.0) pK_ptr[i].color=
			(int)(20.0+19.0*(1.0-ratio)/(1.0-b));
		else pK_ptr[i].color=
			(int)(20.0-18.0*(1.0-1.0/ratio)/(1.0-b));
	 }
	if (node<p->nodecount) for (i=node+1;i<=p->nodecount;i++)
		pK_ptr[i].color=20;
	return;
} /* e_compare_cl */

e_compare_area(p,q) /* compare ratio of eucl areas of faces from 
	p and q. Use 2-color ramp, lower indices 
	indicating q larger, uppers indicating p larger. */
struct p_data *p,*q;
{
	int i,node,flag=1;
	float b=1.0,ratio,*areas_p,*areas_q;
	struct R_data *pR_ptr,*qR_ptr;

	pR_ptr=p->packR_ptr;
	qR_ptr=q->packR_ptr;
	node=(p->facecount>q->facecount) ? q->facecount : p->facecount;
	if (!(areas_p=(float *)malloc((node+1)*sizeof(float)) ) 
		|| !(areas_q=(float *)malloc((node+1)*sizeof(float)) ) ) 
		return 0;
	for (i=1;i<=node;i++)
	 {
		areas_p[i]=e_area(pR_ptr[p->faces[i].vert[0]].rad,
				pR_ptr[p->faces[i].vert[1]].rad,
				pR_ptr[p->faces[i].vert[2]].rad);
		areas_q[i]=e_area(qR_ptr[q->faces[i].vert[0]].rad,
				qR_ptr[q->faces[i].vert[1]].rad,
				qR_ptr[q->faces[i].vert[2]].rad);
		ratio=areas_q[i]/areas_p[i];
		if (ratio>b) b=ratio;
		if (1.0/ratio>b) b=1.0/ratio;
	 }
	if (b==1) flag=0;
	else
	 {
		for (i=1;i<=node;i++)
		 {
		   if ((ratio=areas_p[i]/areas_q[i])>1.0)
		     p->faces[i].color=
			(int)(20.0+19.0*(ratio-1.0)/(b-1.0));
		   else 
		     p->faces[i].color=
			1+(int)(18.0*(1.0-(1.0/ratio-1.0)/(b-1.0)));
		 }
	 }
	free(areas_p);free(areas_q);
	if (node<p->facecount) for (i=node+1;i<=p->facecount;i++)
		p->faces[i].color=20;
	return (flag);
} /* e_compare_area */

int
color_circles(p,f,datastr)
struct p_data *p;
int f;
char *datastr;
{
	int cp,i,ccode,hits;
	float base;
	struct K_data *pK_ptr;
	extern struct Vertlist *node_link_parse();
	struct Vertlist *vertlist,*trace;
	char *endptr;

	pK_ptr=p->packK_ptr;
	if (!p->status) return 0;
	switch(f)
	 {
case 5: /* fill with foreground */
 {
	for (i=1;i<=p->nodecount;i++) pK_ptr[i].color=FG_COLOR;
 	return 1;
 }
case 4: /* fill with background */
 {
	for (i=1;i<=p->nodecount;i++) pK_ptr[i].color=BG_COLOR;
 	return 1;
 }
case 1: /* color by radius */
 {
	return (radius_col_comp(p));
 }
case 3: /* color by comparison */
 {
	if (!sscanf(datastr,"%d",&cp) || cp<0 || cp>NUM_PACKS
		|| !packdata[cp].status
		|| packdata[cp].hes!=p->hes) return 0;
	if (p->hes<0) {h_compare_cl(p,&packdata[cp]);return 1;}
	else if (p->hes==0) {e_compare_cl(p,&packdata[cp]);return 1;}
	return 0;
 }
case 6: /* specified color, circles */
 {
	if (!grab_next(&datastr,next) || !sscanf(next,"%d",&ccode) 
		|| ccode<0 || ccode>255) return 0;
	if ((vertlist=node_link_parse(p,datastr,&endptr,&hits))==NULL) return 0;
	trace=vertlist;
	while (trace!=NULL)
	 {
		pK_ptr[trace->v].color=ccode;
		trace=trace->next;
	 }
	vert_free(&vertlist);
	return 1;	
 }
case 7: /* take colors from pack cp */
 {
	if (!sscanf(datastr,"%d",&cp) || cp<0 || cp>NUM_PACKS
		|| !packdata[cp].status) cp=current_p;
	for (i=1;i<=p->nodecount;i++)
		if (i<=packdata[cp].nodecount) 
			pK_ptr[i].color=packdata[cp].packK_ptr[i].color;
	return 1;
 }
case 8: /* compare model curvature to value: red=pos, blue=neg */
 {
	if (!sscanf(datastr,"%lf",&base)) base=0.0;
	else
	 {
		if (base<=0) base=(-1.0)*sqrt((-1.0)*base);
		else base=sqrt(base);
	 }
	color_kappa(p,base);
 }
	 } /* end of switch */
	return 0;
} /* color_circles */
	
int
color_faces(p,f,datastr)
struct p_data *p;
int f;
char *datastr;
{
	int cp,i,ccode,hits;
	extern struct Vertlist *face_link_parse();
	struct Vertlist *vertlist,*trace;
	char *endptr;

	if (!p->status) return 0;
	switch(f)
	 {
case 5: /* foreground */
 {
	for (i=1;i<=p->facecount;i++) p->faces[i].color=FG_COLOR;
 	return 1;
 }
case 4: /* background */
 {
	for (i=1;i<=p->facecount;i++) p->faces[i].color=BG_COLOR;
 	return 1;
 }
case 1: /* color by area */
 {
	return (area_col_comp(p));
 }
case 3: /* color by area comparison */
 {
	if (!sscanf(datastr,"%d",&cp) || cp<0 || cp>NUM_PACKS
		|| !packdata[cp].status
		|| packdata[cp].hes!=p->hes) return 0;
	if (p->hes<0) {h_compare_area(p,&packdata[cp]);return 1;}
	else if (p->hes==0) {e_compare_area(p,&packdata[cp]);return 1;}
	return 0;
 }
case 6: /* specified color, faces */
 {
	if (!grab_next(&datastr,next) || !sscanf(next,"%d",&ccode) 
		|| ccode<0 || ccode>199) return 0;
	if ((vertlist=face_link_parse(p,datastr,&endptr,&hits))==NULL) return 0;
	trace=vertlist;
	while (trace!=NULL)
	 {
		p->faces[trace->v].color=ccode;
		trace=trace->next;
	 }
	vert_free(&vertlist);
	return 1;	
 }
case 7: /* take colors from pack cp */
 {
	if (!sscanf(datastr,"%d",&cp) || cp<0 || cp>NUM_PACKS
		|| !packdata[cp].status) cp=current_p;
	for (i=1;i<=p->facecount;i++)
		if (i<=packdata[cp].facecount) 
			p->faces[i].color=packdata[cp].faces[i].color;
	return 1;
 }
	 } /* end of switch */
	return 0;
} /* color_faces */

blue_to_red_ramp() /* set up color ramp. Starts with dark blue, ends with
	dark red. Index 20 is white. */
{
	int i;
	
	for (i=0;i<20;i++)
	 {blue[i]=255;red[i]=green[i]=(int)(i*10);}
	blue[20]=red[20]=green[20]=255; /* middle color is white */
	for (i=21;i<40;i++)
	 {red[i]=255;blue[i]=green[i]=(int)(255-(i-100)*10);}
	for (i=42;i<43;i++) 
		{red[i]=0;green[i]=0;blue[i]=255;}

		/* additional colors once used by Woodrow Johnson:
		   neutral color fill, then misc. colors.  */
/* disable for now

	red[210]=255;green[210]=0;blue[210]=0;
	red[211]=235;green[211]=10;blue[211]=10;
	red[212]=255;green[212]=105;blue[212]=180;
	red[213]=255;green[213]=20;blue[213]=147;
	red[214]=255;green[214]=165;blue[214]=0;
	red[215]=205;green[215]=133;blue[215]=0;
	red[216]=255;green[216]=255;blue[216]=0;
	red[217]=205;green[217]=205;blue[217]=0;
	red[218]=0;green[218]=255;blue[218]=0;
	red[219]=34;green[219]=139;blue[219]=34;
	red[220]=64;green[220]=224;blue[220]=208;
	red[221]=0;green[221]=255;blue[221]=255;
	red[222]=135;green[222]=206;blue[222]=250;
	red[223]=95;green[223]=158;blue[223]=160;
	red[224]=205;green[224]=133;blue[224]=63;
	red[225]=160;green[225]=82;blue[225]=45;
	red[226]=235;green[226]=110;blue[226]=100;
	red[227]=255;green[227]=140;blue[227]=0;
	red[228]=205;green[228]=183;blue[228]=158;
	red[229]=238;green[229]=203;blue[229]=173;
	red[230]=221;green[230]=160;blue[230]=221;
	red[231]=185;green[231]=48;blue[231]=185;
*/
	return;

} /* blue_to_red_ramp */

int
set_packing_path() /* read from config window */
{
	int n;
	char stuff[BUFSIZE],buff[BUFSIZE];

	strcpy(buff,(char *)xv_get(dir_name_item,PANEL_VALUE));
	stripsp(buff);
	stuff[0]='\0';
	if (!strncmp(buff,"$HOME",5) || (buff[0]=='~') )
	 {
		strcpy(stuff,home_dir);
		if (buff[0]=='~') strcat(stuff,buff+1);
		else strcat(stuff,buff+5);
	 }
	else strcat(stuff,buff);
	sprintf(path,"%s",stuff);
	if ((n=strlen(path))>0 && path[n-1]!='/') strcat(path,"/");
	return 1;
} /* set_pathing_path */		

