;;; mew-virtual.el --- Virtual mode for Mew

;; Author:  Kazu Yamamoto <Kazu@Mew.org>
;; Created: Oct  2, 1996
;; Revised: Aug 24, 1998

;;; Code:

(defconst mew-virtual-version "mew-virtual.el version 0.17")

(require 'mew)

;;;
;;; Virtual mode
;;;

(defun mew-virtual-mode ()
  "Major mode for reading messages.
The keys that are defined for this mode are:

SPC	Read through messages. That is, display a message, scroll it, 
	and move-then-display another message. 
	See 'mew-summary-show-direction' to set 'up, 'down, 
	'next(current direction) or 'stop. Default is 'down.
DEL	Back-scroll this message. Unnecessary header fields are hidden
	over the window. Type DEL to see them when a message is displayed.
.	Force to display this message. If without MIME analysis, force 
	to analyze this message.

RET	Make this message scroll up with one line.
M-RET	Make this message scroll down with one line.
-	Make this message scroll down with one line.

C-n	Go to the next line.
C-p	Go to the previous line.
n	Move to below then display. Targets includes parts, messages 
	marked with '*', and non-marked messages.
p	Move to above then display. Targets includes parts, messages 
	marked with '*', and non-marked messages.
j	Jump to a message according to the number which you input.

i	Get +inbox asynchronously.
g	Go to the folder which you input.

w	Write a message. A new draft is prepared in Draft mode.
a	Answer to this message. A new draft is prepared in Draft mode. 
	Mew automatically decides To: and Cc:.
A	Answer to this message. A new draft is prepared in Draft mode. 
	Mew automatically decides To: and Cc: and cites the body.
f	Forward this message to a third person. A new draft is prepared in 
	Draft mode and this message is automatically attached.
F	Forward messages marked with '@' to a third person. A new draft 
	is prepared in Draft mode and this message is automatically 
	attached. 

E	Edit this message again to send. Or edit this rfc822 part
	typically included MIME-encapsulated error message.
	In a draft folder, it just edits the message. Otherwise, 
	copy the message to draft folder, then edit.
M-e	Edit an old fashioned error message in which the original message 
	is encapsulated after \"----- Original message follows -----\".
r	Resend this message with Resent-To:. It is strongly 
	discouraged to use this command since beginners are always 
	confused. Please use 'f' instead.

v	Toggle \"Virtual mode only\" and \"Virtual & Message mode\". If 
	you choose \"Virtual mode only\", you can quickly put the delete 
	marks since the next message is not displayed.
M-a	Toggle \"MIME analysis mode\" and \"non MIME analysis mode\". In 
	\"non MIME analysis mode\", the message is quickly displayed in 
	 Message mode because MIME analysis is skipped.
M-l	Make the current line to the center of Virtual mode.

*	Put the review the '*' mark on this message. 
	Use N or P to jump to a message marked with '*'.
	It can overlay '@'. The cursor stays always.
	See also 'mo', 'md', 'mr', and 'ma'.
N	Jump to the message marked with '*' below.
P	Jump to the message marked with '*' above.

@	Put the multi the '@' mark on this message for 'F', 'M-s', 
	and 'M-t'. It can overlay the '*' mark. The cursor stays always.
u	Cancel the mark on this message.
U	Cancel all marks according to what you input.

C-cC-s	Incremental search forward in Message mode.
C-cC-r	Incremental search backward in Message mode.

M-s	Apply \"unshar\" on messages marked with '@'.
M-t	Apply \"uudecode\" on messages marked with '@'.

y	Copy this message or save this part as the file name which 
	you input.
#	Print this message or this part.
|	Send this message via pipe.

S	Sort messages and list them up again.
O	Pack messages and list them up again.
B	De-capsulate embedded messages in MIME format.
Z	Update the list of aliases. If you type 'C-u Z' the list 
	of folders are also updated in addition to that of aliases. 

q	Suspend Mew then switch to another buffer. All buffers of 
	Mew retain, so you can resume with buffer operations.
Q	Quit Mew. All buffers of Mew are erased.
C-cC-q	Erase the current mode(buffer).

C-cC-l	Convert to character sets used locally.
C-cC-x	Display xface.
C-cC-f	PGP public key fetch.
"
  (interactive)
  (setq major-mode 'mew-virtual-mode)
  (setq mode-name "Virtual")
  (setq mode-line-buffer-identification mew-mode-line-id)
  (use-local-map mew-summary-mode-map)
  (setq buffer-read-only t)
  (setq truncate-lines t)
  (setq selective-display t)
  (setq selective-display-ellipses nil)
  (mew-summary-setup-mode-line)
  (mew-summary-setup-menu)
  (mew-virtual-highlight-setup)
  (mew-highlight-cursor-line)
  (run-hooks 'mew-virtual-mode-hook))

(defun mew-virtual-folder-message ()
  (interactive)
  (looking-at "^ *\\([0-9]+\\).*\r\\(.*\\)$")
  (message "%s" (mew-match 2)))

(defun mew-summary-virtual ()
  (interactive)
  (mew-summary-only
   (let ((folder (concat 
		  "++" 
		  (mew-input-string "Virtual folder name %s(%s): " 
				    "" ;; dummy
				    "virtual")))
	 (folders (mew-input-folders (buffer-name)))
	 (grep (mew-input-pick-pattern)))
     (mew-folder-setup folder)
     (mew-summary-scan-body mew-prog-imls
			    'mew-virtual-mode
			    folder
			    mew-cs-virtual
			    nil
			    folders
			    grep))))

(provide 'mew-virtual)

;;; Copyright Notice:

;; Copyright (C) 1996, 1997, 1998 Mew developing team.
;; All rights reserved.

;; Redistribution and use in source and binary forms, with or without
;; modification, are permitted provided that the following conditions
;; are met:
;; 
;; 1. Redistributions of source code must retain the above copyright
;;    notice, this list of conditions and the following disclaimer.
;; 2. Redistributions in binary form must reproduce the above copyright
;;    notice, this list of conditions and the following disclaimer in the
;;    documentation and/or other materials provided with the distribution.
;; 3. Neither the name of the team nor the names of its contributors
;;    may be used to endorse or promote products derived from this software
;;    without specific prior written permission.
;; 
;; THIS SOFTWARE IS PROVIDED BY THE TEAM AND CONTRIBUTORS ``AS IS'' AND
;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;; PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE TEAM OR CONTRIBUTORS BE
;; LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
;; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
;; SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
;; BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
;; OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
;; IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

;;; mew-virtual.el ends here
