/*
 * gbconfig.c
 */

#include <stdio.h>
#include <strings.h>
#include <errno.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <proplist.h>

#include "gbuffy.h"

static GtkWidget *ConfigureWindow = NULL;
static GtkWidget *TitleEntry;
static GtkWidget *PathEntry;
static GtkWidget *CommandEntry;
static GtkWidget *PollTimeEntry;
static GtkWidget *MaildirEntry;
static GtkWidget *MailboxCList;
static GtkWidget *TypeOptionMenu;

typedef struct _OptionMenuItem
{
  gchar *name;
  GtkSignalFunc func;
  gpointer data;
} OptionMenuItem;

static GtkWidget * create_option_menu (OptionMenuItem items[], gint num_items)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  GtkWidget *optionmenu;
  int x;

  optionmenu = gtk_option_menu_new ();
  menu = gtk_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);

  for (x = 0; x < num_items; x++)
  {
    menuitem = gtk_menu_item_new_with_label (items[x].name);
    gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
	(GtkSignalFunc) items[x].func, items[x].data);
    gtk_menu_append (GTK_MENU (menu), menuitem);
    gtk_widget_show (menuitem);
  }
  gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu), 0);

  return optionmenu;
}

static void configure_select_mailbox (GtkWidget *clist, gint row, gint column,
                               GdkEventButton *event, gpointer data)
{
  BOX_INFO *box;

  box = (BOX_INFO *) gtk_clist_get_row_data (GTK_CLIST (clist), row);
  box->selected = TRUE;
  gtk_entry_set_text (GTK_ENTRY (TitleEntry), NONULL (box->title));
  gtk_entry_set_text (GTK_ENTRY (PathEntry), NONULL (box->path));
  gtk_entry_set_text (GTK_ENTRY (CommandEntry), NONULL (box->command));
  /* 
   * FIXME: currently, this assumes a lot about the type corresponding
   * to the index of the option menu
   */
  gtk_option_menu_set_history (GTK_OPTION_MENU (TypeOptionMenu), box->type);
}

static void configure_unselect_mailbox (GtkWidget *clist, gint row, gint column,
                                 GdkEventButton *event, gpointer data)
{
  BOX_INFO *box;

  box = (BOX_INFO *) gtk_clist_get_row_data (GTK_CLIST (clist), row);
  box->selected = FALSE;
  if (box->title)
    free (box->title);
  box->title = strdup (gtk_entry_get_text (GTK_ENTRY (TitleEntry)));
  if (box->path)
    free (box->path);
  box->path = strdup (gtk_entry_get_text (GTK_ENTRY (PathEntry)));
  if (box->command)
    free (box->command);
  box->command = strdup (gtk_entry_get_text (GTK_ENTRY (CommandEntry)));
  gtk_clist_set_text (GTK_CLIST (clist), row, 0, box->title);
}

static void configure_set_type (GtkWidget *widget, gpointer data)
{
  BOX_INFO *box;

  box = MailboxInfo;
  while (box != NULL)
  {
    if (box->selected)
    {
      box->type = GPOINTER_TO_INT (data);
    }
    box = box->next;
  }
}

static void configure_insert (GtkWidget *button, GdkEventButton *event, gpointer data)
{
  BOX_INFO *box;
  int x;

  box = MailboxInfo;
  while (box && box->next)
    box = box->next;

  if (box)
  {
    box->next = (BOX_INFO *) calloc (1, sizeof (BOX_INFO));
    box = box->next;
  }
  else
    box = (BOX_INFO *) calloc (1, sizeof (BOX_INFO));

  if (MailboxInfo == NULL)
    MailboxInfo = box;

  box->title = strdup ("New Box");
  x = gtk_clist_append (GTK_CLIST (MailboxCList), &(box->title));
  gtk_clist_set_row_data (GTK_CLIST (MailboxCList), x, box);
  gtk_clist_select_row (GTK_CLIST (MailboxCList), x, 0);
}

static void configure_delete (GtkWidget *button, GdkEventButton *event, gpointer data)
{
  BOX_INFO *box, *last;
  int row = 0;

  last = box = MailboxInfo;
  while (box != NULL)
  {
    if (box->selected)
    {
      gtk_clist_remove (GTK_CLIST (MailboxCList), row); 
      if (box->title)
	free (box->title);
      if (box->path)
	free (box->path);
      if (box->command)
	free (box->command);
      last->next = box->next;
      box = last->next;
    }
    else
    {
      last = box;
      box = box->next;
    }
    row++;
  }
  gtk_entry_set_text (GTK_ENTRY (TitleEntry), "");
  gtk_entry_set_text (GTK_ENTRY (PathEntry), "");
  gtk_entry_set_text (GTK_ENTRY (CommandEntry), "");
}

static void configure_close (GtkWidget *button, GdkEventButton *event, gpointer data)
{
  BOX_INFO *box;
  int row = 0;

  box = MailboxInfo;
  while (box != NULL)
  {
    if (box->selected)
    {
      if (box->title)
	free (box->title);
      box->title = strdup (gtk_entry_get_text (GTK_ENTRY (TitleEntry)));
      if (box->path)
	free (box->path);
      box->path = strdup (gtk_entry_get_text (GTK_ENTRY (PathEntry)));
      if (box->command)
	free (box->command);
      box->command = strdup (gtk_entry_get_text (GTK_ENTRY (CommandEntry)));
      gtk_clist_set_text (GTK_CLIST (MailboxCList), row, 0, box->title);
    }
    row++;
    box = box->next;
  }
  safe_free ((void *)&Maildir);
  Maildir = safe_strdup (gtk_entry_get_text (GTK_ENTRY (MaildirEntry)));
  PollTime = atoi (gtk_entry_get_text (GTK_ENTRY (PollTimeEntry)));

  gtk_widget_hide (ConfigureWindow);
  gbuffy_display ();
}

static void configure_save (GtkWidget *button, GdkEventButton *event, gpointer data)
{
  BOX_INFO *box;
  int row = 0;
  char buf[STRING_LEN];

  box = MailboxInfo;
  while (box != NULL)
  {
    if (box->selected)
    {
      if (box->title)
	free (box->title);
      box->title = strdup (gtk_entry_get_text (GTK_ENTRY (TitleEntry)));
      if (box->path)
	free (box->path);
      box->path = strdup (gtk_entry_get_text (GTK_ENTRY (PathEntry)));
      if (box->command)
	free (box->command);
      box->command = strdup (gtk_entry_get_text (GTK_ENTRY (CommandEntry)));
      gtk_clist_set_text (GTK_CLIST (MailboxCList), row, 0, box->title);
    }
    row++;
    box = box->next;
  }
  safe_free ((void *)&Maildir);
  Maildir = safe_strdup (gtk_entry_get_text (GTK_ENTRY (MaildirEntry)));
  PollTime = atoi (gtk_entry_get_text (GTK_ENTRY (PollTimeEntry)));

  gbuffy_save_conf ();
}

static void toggle_var_callback (GtkWidget *button, gpointer data)
{
  int *var = (int *)data;

  *var = (GTK_TOGGLE_BUTTON (button)->active) ? 1 : 0;
}

void gbuffy_configure_dialog ()
{
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *entry;
  GtkWidget *button;
  GtkWidget *frame;
  char *titles[] = {"Mailboxes", NULL};
  BOX_INFO *box;
  int x;
  static OptionMenuItem *types = NULL;
  char buf[STRING_LEN];

  if (ConfigureWindow == NULL)
  {
    ConfigureWindow = gtk_dialog_new ();

    gtk_signal_connect (GTK_OBJECT (ConfigureWindow), "destroy",
	GTK_SIGNAL_FUNC(gtk_widget_destroyed),
	&ConfigureWindow);

    gtk_window_set_title (GTK_WINDOW (ConfigureWindow), "GBuffy: Configuration");

    frame = gtk_widget_new (gtk_frame_get_type (),
		      "GtkFrame::shadow", GTK_SHADOW_ETCHED_IN,
		      "GtkFrame::label_xalign", 0.1,
		      "GtkFrame::label", "Mailbox Configuration",
		      "GtkContainer::border_width", 10,
		      "GtkWidget::visible", TRUE,
		      NULL); 

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (ConfigureWindow)->vbox), frame, TRUE, TRUE, 0);
    hbox = gtk_hbox_new (TRUE, 0);
    gtk_container_add (GTK_CONTAINER (frame), hbox);
    MailboxCList= gtk_clist_new_with_titles (1, titles);
    gtk_clist_set_column_width (GTK_CLIST (MailboxCList), 0, 100);
    gtk_clist_set_policy (GTK_CLIST (MailboxCList), GTK_POLICY_AUTOMATIC,
	GTK_POLICY_AUTOMATIC);

    box = MailboxInfo;
    x = 0;
    while (box != NULL)
    {
      gtk_clist_append (GTK_CLIST (MailboxCList), &(box->title));
      gtk_clist_set_row_data (GTK_CLIST (MailboxCList), x, box);
      x++;
      box = box->next;
    }
    gtk_box_pack_start (GTK_BOX (hbox), MailboxCList, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(MailboxCList), "select_row",
	GTK_SIGNAL_FUNC(configure_select_mailbox), NULL);
    gtk_signal_connect(GTK_OBJECT(MailboxCList), "unselect_row",
	GTK_SIGNAL_FUNC(configure_unselect_mailbox), NULL);
    gtk_widget_show (MailboxCList);

    table = gtk_table_new (3, 5, FALSE);
    gtk_table_set_row_spacings (GTK_TABLE (table), 5);
    gtk_table_set_col_spacings (GTK_TABLE (table), 5);
    gtk_container_border_width (GTK_CONTAINER (table), 10);
    gtk_box_pack_start (GTK_BOX (hbox), table, TRUE, TRUE, 0);

    if (types == NULL)
    {
      types = (OptionMenuItem *) calloc (GB_MAX, sizeof (OptionMenuItem));
      for (x = 0; x < GB_MAX; x++)
      {
	types[x].name = MailboxClass[x].name;
	types[x].func = GTK_SIGNAL_FUNC (configure_set_type);
	types[x].data = GINT_TO_POINTER (x);
      }
    }
    label = gtk_label_new ("Type:");
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1, 
	GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 0);
    gtk_widget_show (label);
    TypeOptionMenu = create_option_menu (types, GB_MAX);
    gtk_table_attach (GTK_TABLE (table), TypeOptionMenu, 1, 2, 0, 1, 
	GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 0);
    gtk_widget_show (TypeOptionMenu);

    label = gtk_label_new ("Title:");
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2, 
	GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 0);
    gtk_widget_show (label);
    TitleEntry = gtk_entry_new ();
    gtk_table_attach (GTK_TABLE (table), TitleEntry, 1, 2, 1, 2, 
	GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 0);
    gtk_widget_show (TitleEntry);

    label = gtk_label_new ("Path:");
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3, 
	GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 5);
    gtk_widget_show (label);
    PathEntry = gtk_entry_new ();
    gtk_table_attach (GTK_TABLE (table), PathEntry, 1, 2, 2, 3, 
	GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 5);
    gtk_widget_show (PathEntry);

    label = gtk_label_new ("Command:");
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4, 
	GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 5);
    gtk_widget_show (label);
    CommandEntry = gtk_entry_new ();
    gtk_table_attach (GTK_TABLE (table), CommandEntry, 1, 2, 3, 4, 
	GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 5);
    gtk_widget_show (CommandEntry);

    gtk_widget_show (table);
    gtk_widget_show (hbox);

    table = gtk_table_new (3, 5, FALSE);
    gtk_table_set_row_spacings (GTK_TABLE (table), 5);
    gtk_table_set_col_spacings (GTK_TABLE (table), 5);
    gtk_container_border_width (GTK_CONTAINER (table), 10);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (ConfigureWindow)->vbox), table, TRUE, TRUE, 0);
    button = gtk_check_button_new_with_label ("Vertical");
    gtk_table_attach (GTK_TABLE (table), button, 0, 1, 0, 1, 
	GTK_FILL, GTK_EXPAND, 0, 5);
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), Vertical);
    gtk_signal_connect(GTK_OBJECT(button), "toggled",
	GTK_SIGNAL_FUNC(toggle_var_callback), &Vertical);
    gtk_widget_show (button);

    label = gtk_label_new ("Mail Directory:");
    gtk_table_attach (GTK_TABLE (table), label, 1, 2, 0, 1, 
	GTK_FILL, GTK_EXPAND, 0, 5);
    gtk_widget_show (label);
    MaildirEntry = gtk_entry_new ();
    gtk_entry_set_text (GTK_ENTRY (MaildirEntry), NONULL (Maildir));
    gtk_table_attach (GTK_TABLE (table), MaildirEntry, 3, 4, 0, 1, 
	GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 5);
    gtk_widget_show (MaildirEntry);

    label = gtk_label_new ("Poll Time:");
    gtk_table_attach (GTK_TABLE (table), label, 1, 2, 1, 2, 
	GTK_FILL, GTK_EXPAND, 0, 5);
    gtk_widget_show (label);
    PollTimeEntry = gtk_entry_new ();
    snprintf (buf, sizeof (buf), "%d", PollTime);
    gtk_entry_set_text (GTK_ENTRY (PollTimeEntry), buf);
    gtk_table_attach (GTK_TABLE (table), PollTimeEntry, 3, 4, 1, 2, 
	GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 5);
    gtk_widget_show (PollTimeEntry);
    gtk_widget_show (table);

    button = gtk_button_new_with_label ("Insert");
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (ConfigureWindow)->action_area), 
	button, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
	GTK_SIGNAL_FUNC(configure_insert), NULL);
    gtk_widget_show (button);
    button = gtk_button_new_with_label ("Delete");
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (ConfigureWindow)->action_area), 
	button, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
	GTK_SIGNAL_FUNC(configure_delete), NULL);
    gtk_widget_show (button);
    button = gtk_button_new_with_label ("Save");
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (ConfigureWindow)->action_area), 
	button, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
	GTK_SIGNAL_FUNC(configure_save), NULL);
    gtk_widget_show (button);
    button = gtk_button_new_with_label ("Close");
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (ConfigureWindow)->action_area), 
	button, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
	GTK_SIGNAL_FUNC(configure_close), &ConfigureWindow);
    gtk_widget_show (button);
  }
  if (!GTK_WIDGET_VISIBLE (ConfigureWindow))
    gtk_widget_show (ConfigureWindow);
  else
    gtk_widget_hide (ConfigureWindow);
}

