
/* @(#)$Id: save_opts.h,v 1.11.4.3 1999/10/10 16:25:26 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.11.4.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/*
 *	Defines for the storage of options portion of the Elm system.
 */

typedef struct {
    char letter;		/* menu letter on options screen */
    char *menu;			/* menu prompt */
    int  menu_msg;		/* NLS message number of menu prompt */
    char *parm;			/* parameter to modify */
    int (*post)();		/* post processing function */
    char *one_liner;		/* one line help message */
    int  one_liner_msg; 	/* NLS message number of one line help message */
    } opts_menu;

#define DT_SYN 0    /* synonym entry (old name) */
#define DT_STR 1    /* string */
#define DT_NUM 2    /* number */
#define DT_BOL 3    /* ON/OFF (boolean) */
#define DT_CHR 4    /* character */
#define DT_WEE 5    /* weed list */
#define DT_ALT 6    /* alternate addresses list */
#define DT_SRT 7    /* sort-by code */
#define DT_MLT 8    /* multiple destinations for data */
#define DT_ASR 9    /* sort-by code */
#define DT_PRM 10   /* file permissions */
#ifdef FFR_OPTION_FUNC
#define DT_FUNC 11  /* function to be called for proecess option */
#endif
#define DT_LONG 12    /* number */
#ifdef USE_PGP
#define DT_PGPVER 13    /* enum pgp_version */
#endif

#define DT_MASK 037 /* mask for data type */
#define FL_LOCAL 0040          /* flag if changed */
#define FL_NOSPC 0100          /* flag if preserve blanks as "_" */
#define FL_SYS   0200          /* flag if only valid in system RC */
#define FL_OR    0400          /* flag if boolean value may have been set */
#define FL_AND  01000          /* flag if boolean value may have been unset */

typedef struct {
   int nlen;
   char **list;
}  enumerate_list;

typedef struct { 
	char 	name[NLEN]; 	/* name of instruction */
	long 	offset;		/* offset into elmrc-info file */
        int	flags;	/* DT_STR, DT_NUM, DT_BOL, etc */
        union {
	    char 	*str;
	    int 	*num;
	    long        *l_num;
	    int 	*bol;
	    char 	*chr;
	    char 	**weed;
	    struct addr_rec **alts;
	    int 	*sort;
#if FFR_OPTION_FUNC
	    option_func  *func;
#endif
#ifdef USE_PGP 
	    enum pgp_version  *pgpver;
#endif
	} val;
    int size_val;
    enumerate_list   *e_ptr;
} save_info_recs;

/*
 *	since many C compilers cannot init a union as a static
 *	init, make the same structure with just the char * for
 *	the union pointer.
 */
typedef struct { 
	char 	name[NLEN]; 	/* name of instruction */
	long 	offset;		/* offset into elmrc-info file */
        int	flags;	/* DT_STR, DT_NUM, DT_BOL, etc */
        char 	*str;
        int              size_val;
        enumerate_list   *e_ptr;
	} save_info_recs_init;

#define SAVE_INFO_STR(x) (save_info[x].val.str)
#define SAVE_INFO_NUM(x) (save_info[x].val.num)
#define SAVE_INFO_LONG(x) (save_info[x].val.l_num)
#ifdef USE_PGP 
#define SAVE_INFO_PGPVER(x) (save_info[x].val.pgpver)
#endif
#define SAVE_INFO_BOL(x) (save_info[x].val.bol)
#define SAVE_INFO_CHR(x) (save_info[x].val.chr)
#define SAVE_INFO_WEE(x) (save_info[x].val.weed)
#define SAVE_INFO_ALT(x) (save_info[x].val.alts)
#define SAVE_INFO_SRT(x) (save_info[x].val.sort)
#define SAVE_INFO_ASR(x) (save_info[x].val.sort)
#define SAVE_INFO_SYN(x) (save_info[x].val.str)
#define SAVE_INFO_MLT(x) (save_info[x].val.weed)

#ifdef SAVE_OPTS

/* "lists" for DT_MLT.  These and DT_SYN could be eliminated if support
   of the old parameter names was dropped.
*/
char *SIGS[]={"remotesignature","localsignature",NULL},
	*ALWAYS[]={"alwayskeep","alwaysstore",NULL};

static char * USERLEVELS[] = { "beginner", "intermediate", "expert", NULL };
static enumerate_list USERLEVEL = {3, &(USERLEVELS[0]) };

static char * NOENCODINGS[] = { "pass-7bit", "pass-8bit", "pass-binary", NULL };
static enumerate_list NOENCODING = {3, &(NOENCODINGS[0]) };

#if defined(USE_PGP) 
static char * PGP_SIGN_TYPES[] = { "application/pgp", "text/plain", 
				   "text/x-pgp", NULL };
static enumerate_list PGP_SIGN_TYPE = {3, &(PGP_SIGN_TYPES[0]) };

static char * PGP_VERSIONS[] = { "default", "pgp2", "pgp5", "gpg", NULL };
static enumerate_list PGP_VERSION = {4, &(PGP_VERSIONS[0]) };

#endif

#if 0
#define ZZZ_SAVE_TYPE save_info_recs
#define ZZZ_DT_ASR(A) DT_ASR, { sort: A }
#define ZZZ_DT_SRT(A) DT_SRT, { sort: A }
#define ZZZ_DT_STR(A) DT_STR, { str: A }
#define ZZZ_DT_STR_(x,A) DT_STR|x, { str: A }
#define ZZZ_DT_ALT(A) DT_ALT, { alts: A }
#define ZZZ_DT_BOL(A) DT_BOL, { bol: A }
#define ZZZ_DT_BOL_(x,A) DT_BOL|x, { bol: A }
#define ZZZ_DT_MLT(A) DT_MLT, { weed: A }
#define ZZZ_DT_SYN(A) DT_SYN, { str: A }
#define ZZZ_DT_NUM(A) DT_NUM, { num: A }
#define ZZZ_DT_LONG(A) DT_NUM, { l_num: A }
#ifdef USE_PGP 
#define ZZZ_DT_PGPVER(A) DT_PGPVER, { pgpver: A }
#endif
#if FFR_OPTION_FUNC
#define ZZZ_DT_FUNC(A) DT_FUNC, { func: A }
#endif
#define ZZZ_DT_CHR(A) DT_CHR, { chr: A }
#define ZZZ_DT_PRM(A) DT_PRM, { num: A }
#define ZZZ_DT_WEE(A) DT_WEE, { weed: A }
#else
#define ZZZ_SAVE_TYPE save_info_recs_init 
#define ZZZ_DT_ASR(A) DT_ASR,(char *)A
#define ZZZ_DT_SRT(A) DT_SRT,(char *)A 
#define ZZZ_DT_STR(A) DT_STR,A
#define ZZZ_DT_STR_(x,A) DT_STR|x,A 
#define ZZZ_DT_ALT(A) DT_ALT,(char *)A
#define ZZZ_DT_BOL(A) DT_BOL,(char *)A
#define ZZZ_DT_BOL_(x,A) DT_BOL|x,(char *)A
#define ZZZ_DT_MLT(A) DT_MLT,(char *)A
#define ZZZ_DT_SYN(A) DT_SYN,A
#define ZZZ_DT_NUM(A) DT_NUM,(char *)A
#define ZZZ_DT_LONG(A) DT_NUM,(char *)A 
#ifdef USE_PGP 
#define ZZZ_DT_PGPVER(A) DT_PGPVER,(char *)A
#endif
#if FFR_OPTION_FUNC
#define ZZZ_DT_FUNC(A)( DT_FUNC,(char *)A
#endif
#define ZZZ_DT_CHR(A) DT_CHR,(char *)A
#define ZZZ_DT_PRM(A) DT_PRM,(char *)A
#define ZZZ_DT_WEE(A) DT_WEE,(char *)A
#endif

ZZZ_SAVE_TYPE save_info_data[] = {
{"aliassortby",		-1L,ZZZ_DT_ASR(&alias_sortby), 0, NULL},
{"alteditor",		-1L,ZZZ_DT_STR(alternative_editor),
   sizeof alternative_editor, NULL},
{"alternatives",	-1L,ZZZ_DT_ALT(&alternative_addresses), 0, NULL},
{"alwaysdelete",	-1L,ZZZ_DT_BOL(&always_del), 0, NULL},
{"alwayskeep",		-1L,ZZZ_DT_BOL(&always_keep), 0, NULL},
{"alwaysleave",		-1L,ZZZ_DT_MLT(ALWAYS), 0, NULL},
{"alwaysstore",		-1L,ZZZ_DT_BOL(&always_store), 0, NULL},
{"arrow",		-1L,ZZZ_DT_BOL_(FL_OR,&arrow_cursor), 0, NULL},
{"ask",			-1L,ZZZ_DT_BOL(&question_me), 0,   NULL},
{"askcc",		-1L,ZZZ_DT_BOL(&prompt_for_cc), 0, NULL},
#ifdef USE_PGP
{"askpgpsig",		-1L,ZZZ_DT_BOL(&pgp_askpgpsig), 0, NULL},
#endif
{"attribution",		-1L,ZZZ_DT_STR(attribution), sizeof attribution, NULL},
{"auto-cc",		-1L,ZZZ_DT_SYN("copy"), 0, NULL},
{"autocopy",		-1L,ZZZ_DT_BOL(&auto_copy), 0, NULL},
#ifdef BACKGROUD_PROCESSES       
{ "background-wait-time",-1L,ZZZ_DT_NUM(&background_wait_time), 0, NULL }, 
#endif
  /* {"bounce",		-1L,ZZZ_DT_SYN("bounceback"), 0, NULL},
     {"bounceback",	-1L,ZZZ_DT_NUM(&bounceback), 0, NULL},
     */
{"builtinlines",	-1L,ZZZ_DT_NUM(&builtin_lines), 0, NULL},
{"calendar",		-1L,ZZZ_DT_STR(raw_calendar_file), 
   sizeof raw_calendar_file, NULL},
{"cc",			-1L,ZZZ_DT_SYN("askcc"), 0, NULL},
{"charset",		-1L,ZZZ_DT_STR(raw_charset), sizeof raw_charset, NULL},
#if FFR_OPTION_FUNC
{"compatcharsets",	-1L,ZZZ_DT_FUNC(charset_compatfunc),0, NULL},
#else
{"compatcharsets",      -1L,ZZZ_DT_STR(charset_compatlist), 
   sizeof charset_compatlist, NULL},
#endif
{"configoptions",	-1L,ZZZ_DT_STR(config_options), sizeof config_options, 
   NULL},
{"confirmappend",	-1L,ZZZ_DT_BOL(&confirm_append), 0, NULL},
{"confirmcreate",	-1L,ZZZ_DT_BOL(&confirm_create), 0, NULL},
{"confirmfiles",	-1L,ZZZ_DT_BOL(&confirm_files), 0, NULL},
{"confirmfolders",	-1L,ZZZ_DT_BOL(&confirm_folders), 0, NULL},
{"convert-comment-to-fullname",-1L,ZZZ_DT_BOL(&convert_comment), 0, NULL},
{"copy",		-1L,ZZZ_DT_BOL(&auto_cc), 0, NULL},
{"delete",		-1L,ZZZ_DT_SYN("alwaysdelete"),   0, NULL},
{"displaycharset",	-1L,ZZZ_DT_STR(raw_display_charset),
   sizeof raw_display_charset, NULL},
#ifdef USE_DSN
{"dsn-success",         -1L,ZZZ_DT_BOL(&DSN_success), 0, NULL },
#endif
{"easyeditor",		-1L,ZZZ_DT_STR(e_editor),   sizeof e_editor,   NULL},
{"editor",		-1L,ZZZ_DT_STR(raw_editor), sizeof raw_editor, NULL},
{"escape",		-1L,ZZZ_DT_CHR(&escape_char), 0,       NULL},
{"folders",		-1L,ZZZ_DT_SYN("maildir"), 0,                  NULL},
{"forcename",		-1L,ZZZ_DT_BOL(&force_name), 0,        NULL},
{"form",		-1L,ZZZ_DT_SYN("forms"), 0,                    NULL},
{"forms",		-1L,ZZZ_DT_BOL(&allow_forms), 0,       NULL},
{"fullname",		-1L,ZZZ_DT_STR(full_username), sizeof full_username, NULL},
#ifdef USE_PGP
{"gpg",	        -1L,ZZZ_DT_STR(raw_gpg_path), sizeof raw_gpg_path, NULL},
#endif
{"hostdomain",		-1L,ZZZ_DT_STR_(FL_SYS,hostdomain), sizeof hostdomain, 
   NULL},
{"hostfullname",	-1L,ZZZ_DT_STR_(FL_SYS,hostfullname), sizeof hostfullname, 
   NULL},
{"hostname",		-1L,ZZZ_DT_STR_(FL_SYS,hostname),     sizeof hostname, 
   NULL},
  /* {"hpkeypad",	-1L,ZZZ_DT_SYN("keypad"), 0, NULL}, */
  /* {"hpsoftkeys",	-1L,ZZZ_DT_SYN("softkeys"), 0, NULL}, */
{"keep",		-1L,ZZZ_DT_SYN("keepempty"), 0, NULL},
{"keepempty",		-1L,ZZZ_DT_BOL(&keep_empty_files), 0, NULL},
#ifdef USE_PGP
{"keeppassfor",         -1L,ZZZ_DT_NUM(&pgp_keeppassfor), 0, NULL},
#endif
  /* {"keypad",		-1L,ZZZ_DT_BOL_(FL_OR,&hp_terminal), 0, NULL}, */
{"localsignature",	-1L,ZZZ_DT_STR(raw_local_signature), 
   sizeof raw_local_signature, NULL},
#ifdef SYSCALL_LOCKING
{"lock-folders",        -1L,ZZZ_DT_BOL(&lockfolders),0, NULL},
{"lock-in-copy",        -1L,ZZZ_DT_BOL(&lock_in_copy),0, NULL},
#endif
{"mailbox",		-1L,ZZZ_DT_SYN("receivedmail"), 0, NULL},
{"maildir",		-1L,ZZZ_DT_STR(raw_folders), sizeof raw_folders, NULL},
{"mailedit",		-1L,ZZZ_DT_SYN("editor"), 0, NULL},
{"mailpermissions",	-1L,ZZZ_DT_PRM(&mail_permissions), 0, NULL},
{"menu",		-1L,ZZZ_DT_BOL_(FL_AND,&mini_menu), 0, NULL},
{"menus",		-1L,ZZZ_DT_SYN("menu"), 0, NULL},
{"metamail",		-1L,ZZZ_DT_STR(raw_metamail_path), 
   sizeof raw_metamail_path, NULL},
{"metoo",		-1L,ZZZ_DT_BOL(&metoo), 0, NULL},
{"mimeforward",		-1L,ZZZ_DT_BOL(&mimeforward), 0, NULL},
{"movepage",		-1L,ZZZ_DT_BOL(&move_when_paged), 0, NULL},
{"movewhenpaged",	-1L,ZZZ_DT_SYN("movepage"), 0, NULL},
{"name",		-1L,ZZZ_DT_SYN("fullname"), 0, NULL},
{"names",		-1L,ZZZ_DT_BOL(&names_only), 0, NULL},
{"noencoding",-1L,ZZZ_DT_NUM(&allow_no_encoding), 0, &NOENCODING},
                                 /* 1 (8bit): Allow 8bit without -B8BITMIME
                                  * 2 (biary): Allow binary without -BBINARYMIME and
                                  *    and 8bit without -B8BITMIME */
{"nohdrencoding",       -1L,ZZZ_DT_BOL(&allow_no_hdrencoding), 0, NULL},
{"noheader",		-1L,ZZZ_DT_BOL(&noheader), 0, NULL},
{"noheaderfwd",		-1L,ZZZ_DT_BOL(&noheaderfwd), 0, NULL},
{"page",		-1L,ZZZ_DT_SYN("pager"), 0, NULL},
{"pagealternative",	-1L,ZZZ_DT_BOL(&pagealternative), 0, NULL},
{"pagemultipart",	-1L,ZZZ_DT_BOL(&pagemultipart), 0, NULL},
{"pager",		-1L,ZZZ_DT_STR(raw_pager), sizeof raw_pager, NULL},
{"pagesigned",	        -1L,ZZZ_DT_BOL(&pagesigned), 0, NULL},
#ifdef USE_PGP
{"pgp",		       -1L,ZZZ_DT_SYN("pgp2"), 0, NULL},
{"pgp-sign-type",	-1L,ZZZ_DT_NUM(&pgp_sign_type),
                                   sizeof pgp_sign_type, &PGP_SIGN_TYPE},
{"pgp-version",	       -1L,ZZZ_DT_PGPVER(&send_pgp_version),
                                   sizeof send_pgp_version, &PGP_VERSION},
{"pgp2",	       -1L,ZZZ_DT_STR(raw_pgp2_path), sizeof raw_pgp2_path, NULL},
{"pgp5-dir",           -1L,ZZZ_DT_STR(raw_pgp5_dir), sizeof raw_pgp5_dir, NULL},
#endif /* USE_PGP */
{"pointnew",		-1L,ZZZ_DT_BOL(&point_to_new), 0, NULL},
{"pointtonew",		-1L,ZZZ_DT_SYN("pointnew"), 0, NULL},
{"precedences",		-1L,ZZZ_DT_STR(allowed_precedences), 
   sizeof allowed_precedences, NULL},
{"prefix",		-1L,ZZZ_DT_STR_(FL_NOSPC,prefixchars),
   sizeof prefixchars, NULL},
{"print",		-1L,ZZZ_DT_STR(raw_printout), sizeof raw_printout, NULL},
{"printmail",		-1L,ZZZ_DT_SYN("print"), 0, NULL},
{"promptafter",		-1L,ZZZ_DT_BOL(&prompt_after_pager), 0, NULL},
{"question",		-1L,ZZZ_DT_SYN("ask"), 0, NULL},
{"quoteforward",	-1L,ZZZ_DT_BOL(&quote_forward), 0, NULL},
{"readdatapercentinc",	-1L,ZZZ_DT_NUM(&readdatapercentinc), 0, NULL},
{"readmsginc",		-1L,ZZZ_DT_NUM(&readmsginc), 0, NULL},
{"receivedmail",	-1L,ZZZ_DT_STR(raw_recvdmail), sizeof raw_recvdmail, NULL},
{"remotesignature",	-1L,ZZZ_DT_STR(raw_remote_signature), 
   sizeof raw_remote_signature, NULL},
{"require-mime-version-for-body-encoding",
   -1L,ZZZ_DT_BOL(&req_mime_bodyencoding), 0, NULL},
{"require-mime-version-for-hdr-encoding",
   -1L,ZZZ_DT_BOL(&req_mime_hdrencoding), 0, NULL},
{"resolve",		-1L,ZZZ_DT_BOL(&resolve_mode), 0, NULL},
{"savebyname",		-1L,ZZZ_DT_SYN("savename"), 0, NULL},
{"savemail",		-1L,ZZZ_DT_SYN("sentmail"), 0, NULL},
{"savename",		-1L,ZZZ_DT_BOL(&save_by_name), 0, NULL},
{"saveto",		-1L,ZZZ_DT_SYN("sentmail"), 0, NULL},
{"send-mime-plain-text", -1L, ZZZ_DT_BOL(&send_mime_plain), 
   sizeof send_mime_plain, NULL },
{"sentmail",		-1L,ZZZ_DT_STR(raw_sentmail), sizeof raw_sentmail, NULL},
{"shell",		-1L,ZZZ_DT_STR(raw_shell), sizeof raw_shell, NULL},
#ifdef USE_PGP
{"showpgppreamble",	-1L,ZZZ_DT_BOL(&pgp_noarmor), 0, NULL},
#endif
{"showto",		-1L,ZZZ_DT_BOL(&showto), 0, NULL},
{"sigdashes",		-1L,ZZZ_DT_BOL(&sig_dashes), 0, NULL},
{"signature",		-1L,ZZZ_DT_MLT(SIGS), 0, NULL},
{"sleepmsg",		-1L,ZZZ_DT_NUM(&sleepmsg), 0, NULL},
  /* {"softkeys",	-1L,ZZZ_DT_BOL(FL_OR,&hp_softkeys), 0, 
     NULL}, */
{"sort",		-1L,ZZZ_DT_SYN("sortby"), 0, NULL},
{"sort-thread-max-time", -1L, ZZZ_DT_NUM(&sort_thread_max_time), 0, NULL},
{"sortby",		-1L,ZZZ_DT_SRT(&sortby), 0, NULL},
{"store",		-1L,ZZZ_DT_SYN("alwaysstore"), 0, NULL},
{"timeout",		-1L,ZZZ_DT_LONG(&elm_timeout), 0, NULL},
{"titles",		-1L,ZZZ_DT_BOL(&title_messages), 0, NULL},
{"tmpdir",	       -1L,ZZZ_DT_STR(raw_temp_dir), sizeof raw_temp_dir, NULL},
#ifdef USE_PGP
{"usepgppass",          -1L,ZZZ_DT_BOL(&pgp_keeppass), 0, NULL},
#endif
{"userlevel",		-1L,ZZZ_DT_NUM(&user_level), 0, &USERLEVEL},
{"username",		-1L,ZZZ_DT_SYN("fullname"), 0, NULL},
{"usetite",		-1L,ZZZ_DT_BOL_(FL_AND,&use_tite), 0, NULL},
{"visualeditor",	-1L,ZZZ_DT_STR(v_editor), sizeof v_editor, NULL},
{"weed",		-1L,ZZZ_DT_BOL(&elm_filter), 0, NULL},
{"weedout",		-1L,ZZZ_DT_WEE(weedlist), 0, NULL},
};
int NUMBER_OF_SAVEABLE_OPTIONS=(sizeof(save_info_data)/sizeof(save_info_recs_init));
save_info_recs *save_info = (save_info_recs *) save_info_data;
#else
extern save_info_recs *save_info;
extern int NUMBER_OF_SAVEABLE_OPTIONS;
#endif

