/*								-*- C++ -*-
 * $Id: DLG_font.h,v 1.1 1996-09-25 11:06:09+02 mho Exp $
 *
 * Purpose: font dialog box
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1996, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1996, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef FontDialog_h
#define FontDialog_h

#ifdef __GNUG__
#pragma interface
#endif

#define wxFontDialog wxGenericFontDialog

class wxFontData: public wxObject
{
 DECLARE_DYNAMIC_CLASS(wxFontData)
 public:
  wxColour fontColour;
  Bool showHelp;
  Bool allowSymbols;
  Bool enableEffects;
  wxFont *initialFont;
  wxFont *chosenFont;
  int minSize;
  int maxSize;

  wxFontData(void);
  ~wxFontData(void);

  inline void SetAllowSymbols(Bool flag) { allowSymbols = flag; }
  inline Bool GetAllowSymbols(void) { return allowSymbols; }
  inline void SetColour(wxColour& colour) { fontColour = colour; }
  inline wxColour &GetColour(void) { return fontColour; }
  inline void SetShowHelp(Bool flag) { showHelp = flag; }
  inline Bool GetShowHelp(void) { return showHelp; }
  inline void EnableEffects(Bool flag) { enableEffects = flag; }
  inline Bool GetEnableEffects(void) { return enableEffects; }
  inline void SetInitialFont(wxFont *font) { initialFont = font; }
  inline wxFont *GetInitialFont(void) { return initialFont; }
  inline void SetChosenFont(wxFont *font) { chosenFont = font; }
  inline wxFont *GetChosenFont(void) { return chosenFont; }
  inline void SetRange(int minRange, int maxRange) { minSize = minRange; maxSize = maxRange; }

  void operator=(const wxFontData& data);
};

class wxChoice;
class wxText;
class wxCheckBox;

class wxGenericFontDialog: public wxDialogBox
{
 DECLARE_DYNAMIC_CLASS(wxGenericFontDialog)
 protected:
  wxFontData fontData;
  wxFont *dialogFont;
  wxWindow *dialogParent;

  // Area reserved for font display
  wxRectangle fontRect;

  wxChoice *familyChoice;
  wxChoice *styleChoice;
  wxChoice *weightChoice;
  wxChoice *colourChoice;
  wxCheckBox *underLineCheckBox;
  wxText   *pointSizeText;

  static Bool fontDialogCancelled;
 public:
 
  wxGenericFontDialog(void);
  wxGenericFontDialog(wxWindow *parent, wxFontData *data = NULL);
  ~wxGenericFontDialog(void);

  Bool Create(wxWindow *parent, wxFontData *data = NULL);

  Bool Show(Bool show);
  inline wxFontData& GetFontData(void) { return fontData; }

  // Internal functions
  void OnEvent(wxMouseEvent& event);
  void OnPaint(void);
  Bool OnClose(void);
  Bool OnCharHook(wxKeyEvent& event);

  virtual void CreateWidgets(void);
  virtual void InitializeFont(void);
  
  virtual void PaintFontBackground(void);
  virtual void PaintFont(void);

  virtual void OnOk(void);
  virtual void OnCancel(void);
  virtual void OnChangeFont(void);
};

char *wxFontFamilyIntToString(int family);
char *wxFontWeightIntToString(int weight);
char *wxFontStyleIntToString(int style);
int wxFontFamilyStringToInt(char *family);
int wxFontWeightStringToInt(char *weight);
int wxFontStyleStringToInt(char *style);

#endif // FontDialog_h
