#include <winbase.h>
#include <wincon.h>
const int MaxCompNameLen = 256;

//=========================>>> vGetFullPath <<<==========================
  char* vGetFullPath(char *buf, char *fname, int len)
  {
    LPTSTR toss;

    return (char *) GetFullPathName(  fname, len, buf, &toss  );
  }

//=========================>>> vChDrive <<<==========================
  int vChDrive(int drive)
  {
    char temp [3] = "-:";
    temp[0] = drive + 'A';
    return SetCurrentDirectory(temp);
  }



//=========================>>> vGetUserName <<<==========================
  int vGetUserName( char* s, int len)
  {
    // Set s to user name

    char UserName[MaxCompNameLen+1];
    DWORD cch = sizeof UserName;

    if (GetUserName(UserName, &cch))
      {
	strncpy(s, UserName, len);
	return 1;
      }
    s[0] = 0;
    return 0;
  }


//=========================>>> vGetHostName <<<==========================
  void vGetHostName(char* s, int len)
  {
    // Get host name

    char HostName[MaxCompNameLen+1];
    DWORD cch = sizeof HostName;

    if (GetComputerName(HostName, &cch))
      {
	strcpy(s, "PC ");
	strncpy(s + 3, szHostName, len - 3);
      }
    else
	strncpy(s, "PC (Win32)", len);
  }


//=========================>>> vGetPid <<<==========================
  long vGetPid()
  {
    // return process ID

    return (long)GetCurrentProcessId();
  }


//=========================>>> vGetCWD <<<==========================
  int vGetCWD(char* buf, int len)
  {
    // Get name of current directory 

    return (getcwd(buf, len) != 0 ? 1 : 0);
  }




/*
 * The normal _chdir() does not change the default drive.  This one does.
 * Returning 0 implies success; -1 implies failure.
 */
//=========================>>> vGetUserName <<<==========================
    int
vim_chdir(
    char *path)
{
    if (path[0] == NUL)		/* just checking... */
	return -1;

    if (isalpha(path[0]) && path[1] == ':')	/* has a drive name */
    {
	if (_chdrive(TO_LOWER(path[0]) - 'a' + 1) != 0)
	    return -1;		/* invalid drive name */
	path += 2;
    }

    if (*path == NUL)		/* drive name only */
	return 0;

    return chdir(path);	       /* let the normal chdir() do the rest */
}


/*
 * this version of remove is not scared by a readonly (backup) file
 */
//=========================>>> vGetUserName <<<==========================
    int
vim_remove(
    char_u *name)
{
    SetFileAttributes(name, FILE_ATTRIBUTE_NORMAL);
    return DeleteFile(name) ? 0 : -1;
}


/*
 * win95rename works around a bug in rename (aka MoveFile) in
 * Windows 95: rename("foo.bar", "foo.bar~") will generate a
 * file whose short file name is "FOO.BAR" (its long file name will
 * be correct: "foo.bar~").  Because a file can be accessed by
 * either its SFN or its LFN, "foo.bar" has effectively been
 * renamed to "foo.bar", which is not at all what was wanted.  This
 * seems to happen only when renaming files with three-character
 * extensions by appending a suffix that does not include ".".
 * Windows NT gets it right, however, with an SFN of "FOO~1.BAR".
 *
 * Like rename(), returns 0 upon success, non-zero upon failure.
 * Should probably set errno appropriately when errors occur.
 */
    int
win95rename(
    const char	*pszOldFile,
    const char	*pszNewFile)
{
    char	szTempFile[_MAX_PATH];
    char	szNewPath[_MAX_PATH];
    char	*pszFilePart;
    HANDLE	hf;

#undef rename

    /* get base path of new file name */
    if (GetFullPathName(pszNewFile, _MAX_PATH, szNewPath, &pszFilePart) == 0)
	return -1;
    else
	*pszFilePart = NUL;

    /* Get (and create) a unique temporary file name in directory of new file */
    if (GetTempFileName(szNewPath, "VIM", 0, szTempFile) == 0)
	return -2;

    /* blow the temp file away */
    if (! DeleteFile(szTempFile))
	return -3;

    /* rename old file to the temp file */
    if (! MoveFile(pszOldFile, szTempFile))
	return -4;

    /* now create an empty file called pszOldFile; this prevents
     * the operating system using pszOldFile as an alias (SFN)
     * if we're renaming within the same directory.  For example,
     * we're editing a file called filename.asc.txt by its SFN,
     * filena~1.txt.  If we rename filena~1.txt to filena~1.txt~
     * (i.e., we're making a backup while writing it), the SFN
     * for filena~1.txt~ will be filena~1.txt, by default, which
     * will cause all sorts of problems later in buf_write.  So, we
     * create an empty file called filena~1.txt and the system will have
     * to find some other SFN for filena~1.txt~, such as filena~2.txt
     */
    if ((hf = CreateFile(pszOldFile, GENERIC_WRITE, 0, NULL, CREATE_NEW,
			 FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE)
	return -5;
    if (! CloseHandle(hf))
	return -6;

    /* rename the temp file to the new file */
    if (! MoveFile(szTempFile, pszNewFile))
	return -7;

    /* Seems to be left around on Novell filesystems */
    DeleteFile(szTempFile);

    /* finally, remove the empty old file */
    if (! DeleteFile(pszOldFile))
	return -8;

    return 0;	/* success */
}

/*
 * Special version of getenv(): use $HOME when $VIM not defined.
 */
//=========================>>> vGetUserName <<<==========================
    char_u *
vim_getenv(
    char_u *var)
{
    char_u  *retval;
    retval = (char_u *)getenv((char *)var);

    if (retval == NULL && STRCMP(var, "VIM") == 0)
	retval = (char_u *)getenv("HOME");

#ifdef MCH_WRITE_DUMP
    if (fdDump)
    {
	fprintf(fdDump, "$%s = \"%s\"\n", var, retval);
	fflush(fdDump);
    }
#endif

    return retval;
}


/*
 * Get the default shell for the current hardware platform
 */
//=========================>>> vGetUserName <<<==========================
    char*
default_shell()
{
    char* psz = NULL;

    PlatformId();

    if (g_PlatformId == VER_PLATFORM_WIN32_NT)		/* Windows NT */
	psz = "cmd.exe";
    else if (g_PlatformId == VER_PLATFORM_WIN32_WINDOWS)  /* Windows 95 */
	psz = "command.com";

    return psz;
}


#ifdef USE_CLIPBOARD

// initialization for clipboard
    clip_init(TRUE);

    /*
     * Vim's own clipboard format recognises whether the text is char, line, or
     * rectangular block.  Only useful for copying between two Vims.
     */
    clipboard.format = RegisterClipboardFormat("VimClipboard");
/*
 * Clipboard stuff, for cutting and pasting text to other windows.
 */

/*
 * Get the current selection and put it in the clipboard register.
 */
//=========================>>> vGetUserName <<<==========================
    void
clip_mch_request_selection()
{
    int	    type;
    HGLOBAL hMem;
    char_u  *str = NULL;

    /*
     * Don't pass GetActiveWindow() as an argument to OpenClipboard() because
     * then we can't paste back into the same window for some reason - webb.
     */
    if (OpenClipboard(NULL))
    {
	/* Check for vim's own clipboard format first */
	if ((hMem = GetClipboardData(clipboard.format)) != NULL)
	{
	    str = (char_u *)hMem;
	    switch (*str++)
	    {
		default:
		case 'L':	type = MLINE;	break;
		case 'C':	type = MCHAR;	break;
		case 'B':	type = MBLOCK;	break;
	    }
	    /* TRACE("Got '%c' type\n", str[-1]); */
	}
	/* Otherwise, check for the normal text format */
	else if ((hMem = GetClipboardData(CF_TEXT)) != NULL)
	{
	    str = (char_u *)hMem;
	    type = (strchr((char*) str, '\r') != NULL) ? MLINE : MCHAR;
	    /* TRACE("TEXT\n"); */
	}

	if (hMem != NULL && *str != NUL)
	{
	    LPCSTR psz = (LPCSTR) str;
	    char_u *temp_clipboard = (char_u *)lalloc(STRLEN(psz) + 1, TRUE);
	    char_u *pszTemp = temp_clipboard;

	    if (temp_clipboard != NULL)
	    {
		while (*psz != NUL)
		{
		    const char* pszNL = strchr(psz, '\r');
		    const int len = (pszNL != NULL) ? pszNL - psz : STRLEN(psz);

		    STRNCPY(pszTemp, psz, len);

		    pszTemp += len;
		    if (pszNL != NULL)
			*pszTemp++ = '\n';

		    psz += len + ((pszNL != NULL) ? 2 : 0);
		}

		*pszTemp = NUL;
		clip_yank_selection(type, temp_clipboard,
				    (long)(pszTemp - temp_clipboard));
		vim_free(temp_clipboard);
	    }
	}
	CloseClipboard();
    }
}

/*
 * Make vim the owner of the current selection.
 */
//=========================>>> vGetUserName <<<==========================
    void
clip_mch_lose_selection()
{
    /* Nothing needs to be done here */
}

/*
 * Make vim the owner of the current selection.  Return OK upon success.
 */
//=========================>>> vGetUserName <<<==========================
    int
clip_mch_own_selection()
{
    /*
     * Never actually own the clipboard.  If another application sets the
     * clipboard, we don't want to think that we still own it.
     */
    return FAIL;
}

/*
 * Send the current selection to the clipboard.
 */
//=========================>>> vGetUserName <<<==========================
    void
clip_mch_set_selection()
{
    char_u  *str = NULL;
    long_u  cch;
    int	    type;
    HGLOBAL hMem = NULL;
    HGLOBAL hMemVim = NULL;
    LPSTR   lpszMem = NULL;
    LPSTR   lpszMemVim = NULL;

    /* If the '*' register isn't already filled in, fill it in now */
    clipboard.owned = TRUE;
    clip_get_selection();
    clipboard.owned = FALSE;

    type = clip_convert_selection(&str, &cch);

    if (type < 0)
	return;

    if ((hMem = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, cch+1)) != NULL
	&& (lpszMem = (LPSTR)GlobalLock(hMem)) != NULL
	&& (hMemVim = GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE, cch+2)) != NULL
	&& (lpszMemVim = (LPSTR)GlobalLock(hMemVim)) != NULL)
    {
	switch (type)
	{
	    default:
	    case MLINE:	    *lpszMemVim++ = 'L';    break;
	    case MCHAR:	    *lpszMemVim++ = 'C';    break;
	    case MBLOCK:    *lpszMemVim++ = 'B';    break;
	}

	STRNCPY(lpszMem, str, cch);
	lpszMem[cch] = NUL;

	STRNCPY(lpszMemVim, str, cch);
	lpszMemVim[cch] = NUL;

	/*
	 * Don't pass GetActiveWindow() as an argument to OpenClipboard()
	 * because then we can't paste back into the same window for some
	 * reason - webb.
	 */
	if (OpenClipboard(NULL))
	{
	    if (EmptyClipboard())
	    {
		SetClipboardData(clipboard.format, hMemVim);
		SetClipboardData(CF_TEXT, hMem);
	    }

	    CloseClipboard();
	}
    }
    if (lpszMem != NULL)
	GlobalUnlock(hMem);
    if (lpszMemVim != NULL)
	GlobalUnlock(hMemVim);

    vim_free(str);
}

#endif /* USE_CLIPBOARD */
