/**
 *
 * $Id: Shadow.c,v 1.13 1998/09/12 15:05:42 rwscott Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static const char rcsid[] = "$Id: Shadow.c,v 1.13 1998/09/12 15:05:42 rwscott Exp $";

#include <LTconfig.h>
#include <XmI/XmI.h>

#include <Xm/XmP.h>
#include <Xm/PrimitiveP.h>
#include <Xm/ManagerP.h>

#include <XmI/DebugUtil.h>
#include <XmI/ShadowI.h>

void
_XmClearBorder(Display *display,
	       Window win,
	       Position x,
	       Position y,
	       Dimension width,
	       Dimension height,
	       Dimension shadow_thick)
{
    _XmClearBorder_1_2_(display, win, x, y, width, height, shadow_thick);
}

void
_XmDrawShadows(Display *display,
	       Window win,
	       GC topShadowGC,
	       GC bottomShadowGC,
	       Position x, Position y,
	       Dimension width, Dimension height,
	       Dimension shadowThickness,
	       unsigned int shadowType)
{
    _XmDrawShadows_1_2_(display, win, topShadowGC, bottomShadowGC,
                        x, y, width, height, shadowThickness, shadowType);
}

void
_XmDrawShadow(Display *display,
	      Drawable d,
	      GC top_gc,
	      GC bottom_gc,
	      Dimension shad_thick,
	      Position x,
	      Position y,
	      Dimension width,
	      Dimension height)
{
    _XmDrawShadow_1_2_(display, d, top_gc, bottom_gc, shad_thick,
		        x, y, width, height);
}

void
_XmDrawArrow(Display *display,
	     Window win,
	     GC topGC,
	     GC bottomGC,
	     GC fillGC,
	     Position x, Position y,
	     Dimension width, Dimension height,
	     Dimension shadowThickness,
	     unsigned char direction)
{
    _XmDrawArrow_1_2_(display, win, topGC, bottomGC, fillGC, x, y,
                      width,height, shadowThickness, direction);
}

void
_XmDrawDiamond(Display *display,
	       Window win,
	       GC bottomGC,
	       GC topGC,
	       GC selectGC,
	       Position x, Position y,
	       Dimension width, Dimension height,
	       Dimension shadowThickness,
	       Dimension fill)
{
    _XmDrawDiamond_1_2_(display, win, bottomGC, topGC, selectGC, 
                        x, y, width, height, shadowThickness, fill);
}

void
_XmDrawSeparator(Display *display,
		 Drawable win,
		 GC top_gc,
		 GC bottom_gc,
		 GC separator_GC,
		 Position wx,
		 Position wy,
		 Dimension wwidth,
		 Dimension wheight,
		 Dimension shadowThickness,
		 Dimension margin,
		 unsigned char orientation,
		 unsigned char separator_type)
{
    _XmDrawSeparator_1_2_(display, win, top_gc, bottom_gc, separator_GC,
                          wx, wy, wwidth, wheight, shadowThickness, margin,
                          orientation, separator_type);
}

void
_XmDrawSimpleHighlight(Display *display,
		       Drawable d,
		       GC gc,
		       Position x,
		       Position y,
		       Dimension width,
		       Dimension height,
		       Dimension highlight_thick)
{
    _XmDrawSimpleHighlight_1_2_(display, d, gc, x, y, width, height,
                                highlight_thick);
}

void
_XmDrawHighlight(Display *display,
		 Drawable d,
		 GC gc,
		 Position x,
		 Position y,
		 Dimension width,
		 Dimension height,
		 Dimension highlight_thick,
		 int line_style)
{
    _XmDrawHighlight_1_2_(display, d, gc, x, y, width, height,
                          highlight_thick, line_style);
}

/*
 * Undocumented but present since the early days.
 * XmDiary is an example of their use.
 *
 * Looks like they just call the methods ...
 */
void
_XmHighlightBorder(Widget w)
{
    _XmHighlightBorder_1_2_(w);
}

void
_XmUnhighlightBorder(Widget w)
{
    _XmUnhighlightBorder_1_2_(w);
}
