#include "obgtkCTree.h"

@implementation Gtk_CTree
- castGtkCTree:(GtkCTree *) castitem
{
  gtkctree = castitem;

  return [super castGtkCList:GTK_CLIST(castitem)];
}

- initWithCTreeInfo:(gint) columns
		   :(gint) tree_column
{
  return [self castGtkCTree:GTK_CTREE(gtk_ctree_new(columns, tree_column))];
}

- initWithCTreeInfoTitles:(gint) ncolumns
			 :(gint) tree_column
		   Titles:(char **) titles
{
  return [self castGtkCTree:GTK_CTREE(gtk_ctree_new_with_titles(ncolumns, tree_column, titles))];
}

- (GtkCTreeNode *)insert_node:(GtkCTreeNode *) parent
			     :(GtkCTreeNode *) sibling
			     :(gchar **) text
			     :(guint8) spacing
			     :(GdkPixmap *) pixmap_closed
			     :(GdkBitmap *) mask_closed
			     :(GdkPixmap *) pixmap_opened
			     :(GdkBitmap *) mask_opened
			     :(gboolean) is_leaf
			     :(gboolean) expanded
{
  return gtk_ctree_insert_node(gtkctree, parent, sibling, text, spacing,
			       pixmap_closed, mask_closed,
			       pixmap_opened, mask_opened,
			       is_leaf, expanded);
}

- remove_node:(GtkCTreeNode *) node
{
  gtk_ctree_remove_node(gtkctree, node);

  return self;
}

/* XXX TODO: lots of iterator functions missing here - need to find
   a nice way to map into ObjC */
- move:(GtkCTreeNode *) node
      :(GtkCTreeNode *) new_parent
      :(GtkCTreeNode *) new_sibling
{
  gtk_ctree_move(gtkctree, node, new_parent, new_sibling);
  return self;
}

- expand:(GtkCTreeNode *) node
{
  gtk_ctree_expand(gtkctree, node);
  return self;
}

- expand_recursive:(GtkCTreeNode *) node
{
  gtk_ctree_expand_recursive(gtkctree, node);
  return self;
}

- expand_to_depth:(GtkCTreeNode *) node :(gint) depth
{
  gtk_ctree_expand_to_depth(gtkctree, node, depth);
  return self;
}

- collapse:(GtkCTreeNode *) node
{
  gtk_ctree_collapse(gtkctree, node);
  return self;
}

- collapse_recursive:(GtkCTreeNode *) node
{
  gtk_ctree_collapse_recursive(gtkctree, node);
  return self;
}

- collapse_to_depth:(GtkCTreeNode *) node :(gint) depth
{
  gtk_ctree_collapse_to_depth(gtkctree, node, depth);
  return self;
}

- toggle_expansion:(GtkCTreeNode *) node
{
  gtk_ctree_toggle_expansion(gtkctree, node);
  return self;
}

- toggle_expansion_recursive:(GtkCTreeNode *) node
{
  gtk_ctree_toggle_expansion_recursive(gtkctree, node);
  return self;
}

- select:(GtkCTreeNode *) node
{
  gtk_ctree_select(gtkctree, node);
  return self;
}

- select_recursive:(GtkCTreeNode *) node
{
  gtk_ctree_select_recursive(gtkctree, node);
  return self;
}

- unselect:(GtkCTreeNode *) node
{
  gtk_ctree_unselect(gtkctree, node);
  return self;
}

- unselect_recursive:(GtkCTreeNode *) node
{
  gtk_ctree_unselect_recursive(gtkctree, node);
  return self;
}

- real_select_recursive:(GtkCTreeNode *) node :(gint) state
{
  gtk_ctree_real_select_recursive(gtkctree, node, state);
  return self;
}
@end
