/* 
 *  GGI/3D interface
 *
 *  Copyright (C) 1998 by Jon Taylor. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <ggi/ggi.h>

typedef	ggi_sint	ggi_s;
typedef	ggi_uint	ggi_u;

typedef	uint16							ggi_alpha;
#define	GGI_MAX_ALPHA	255

/***********************************************************/
/* library initialization and exit */

int	ggi3DInit(void);
int	ggi3DExit(void);

/***********************************************************/
/* visual */

int	ggi3DOpen(ggi_visual_t vis);
int	ggi3DClose(ggi_visual_t vis);

/***********************************************************/
/* graphics context */

typedef	struct {
	ggi_float x, y, z;
} ggi3d_coord;

/***********************************************************/
/* drawing */

typedef struct {
	ggi_float x1, y1, z1, x2, y2, z2, x3, y3, z3; 
} ggi3d_triangle;

/* primitives */

int ggi3DDrawTriangle(ggi_visual_t vis, 
		      ggi_float x1, ggi_float y1, ggi_float z1, 
		      ggi_float x2, ggi_float y2, ggi_float z2, 
		      ggi_float x3, ggi_float y3, ggi_float z3);
	
/***********************************************************/

