/* $Id: visual.c,v 1.5 1998/10/18 15:52:25 becka Exp $
***************************************************************************

  Linear 1 bit graphics (high-bit-right)

  Copyright (C) 1995 Andreas Beck   [becka@ggi-project.org]
  Copyright (C) 1997 Jason McMullan  [jmcc@ggi-project.org]
  Copyright (C) 1998 Andrew Apted  [andrew@ggi-project.org]

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>


int GGIdlinit(ggi_visual *vis, const char *version,void *argptr)
{
	/* Color mapping 
	 */
/* !!!	vis->opcolor->packcolors=GGIpackcolors; */
/* !!!	vis->opcolor->unpackpixels=GGIunpackpixels; */

	/* Frame handling
	 */

	vis->opdraw->setreadframe=GGI_default_setreadframe;
	vis->opdraw->setwriteframe=GGI_default_setwriteframe;
	
	/* Generic drawing
	 */
	vis->opdraw->putc=GGIputc;
	vis->opdraw->getcharsize=GGIgetcharsize;

	vis->opdraw->putpixel_nc=GGIputpixel_nc;
	vis->opdraw->putpixel=GGIputpixel;
	vis->opdraw->drawpixel_nc=GGIdrawpixel_nc;
	vis->opdraw->drawpixel=GGIdrawpixel;
	vis->opdraw->getpixel=GGIgetpixel;

	/* Not yet implemented:
	 *	drawhline_nc, drawvline_nc,
	 *	puthline, putvline,
	 *	gethline, getvline.
	 */

	/* Left to generic-stubs:
	 *    drawhline, drawvline, drawline,
	 *    puts, copybox, crossblit.
	 */

	return GGI_DL_OPCOLOR | GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *vis)
{
	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
