#ifndef MXSTDLIB_H
#define MXSTDLIB_H

/* Standard stuff I use often -- not Python specific */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#else
#define INT_MAX 2147483647
#endif

/* My own macros for memory allocation... */
#ifdef MAL_MEM_DEBUG
# define newstruct(x) \
         (printf("* malloc for struct "#x" (%s:%i)\n",__FILE__,__LINE__),\
	  (x *)malloc(sizeof(x)))
# define cnewstruct(x) \
         (printf("* calloc for struct "#x" (%s:%i)\n",c,__FILE__,__LINE__),\
	  (x *)calloc(sizeof(x),1))
# define new(x,c) \
         (printf("* malloc for "#c"=%i '"#x"'s (%s:%i)\n",c,__FILE__,__LINE__),\
	  (x *)malloc(sizeof(x)*(c)))
# define cnew(x,c) \
         (printf("* calloc for "#c"=%i '"#x"'s (%s:%i)\n",c,__FILE__,__LINE__),\
	  (x *)calloc((c),sizeof(x)))
# define resize(var,x,c) \
         (printf("* realloc "#x" at %X to size "#c"=%i (%s:%i)\n",x,c,__FILE__,__LINE__),\
	  (x *)realloc((void*)(var),sizeof(x)*(c)))
# define free(x) \
         (printf("* freeing "#x" at %X (%s:%i)\n",x,__FILE__,__LINE__),\
	  free((void*)(x)))
#else
# define newstruct(x) (x *)malloc(sizeof(x))
# define cnewstruct(x) (x *)calloc(sizeof(x),1)
# define new(x,c) (x *)malloc(sizeof(x)*(c))
# define cnew(x,c) (x *)calloc((c),sizeof(x))
# define resize(var,x,c) (x *)realloc((void*)(var),sizeof(x)*(c))
# define free(x) free((void*)(x))
#endif

/* Debugging printf's */
#ifdef MAL_DEBUG
# ifdef PyFloat_AS_DOUBLE /* check whether we're compiling a Python ext. */
#  define DPRINTF if (Py_DebugFlag) printf
# else
#  define DPRINTF printf
# endif
#else
# define DPRINTF if (0) printf
#endif

/* The usual bunch... */
#ifndef max
#define max(a,b) ((a>b)?(a):(b))
#endif
#ifndef min
#define min(a,b) ((a<b)?(a):(b))
#endif

/* EOF */
#endif

