#!/usr/local/bin/python -uO
            
import DateTime
__version__ = DateTime.__version__
from DateTime import *
import time

print 'Testing mxDateTime version',__version__
print

# wintertime
t = winter = DateTimeFromAbsDateTime(729368,55931.522913)
print t
print repr(t)

x = float(t)
print 'as ticks:',x
print 'time.gmtime:',time.gmtime(x),'(note the seconds)'
print 'time.localtime:',time.localtime(x)
print 'tuple:',t.tuple()

print

# summertime
t = summer = DateTimeFromAbsDateTime(729200,55931.522913)
print t
print repr(t)

x = float(t)
print 'as ticks:',x
print 'time.gmtime:',time.gmtime(x),'(note the seconds)'
print 'time.localtime:',time.localtime(x)
print 'tuple:',t.tuple()

print

t = Timestamp(1900,1,1,12,23,34.5)
print t
assert t.tuple()[:6] == (1900,1,1,12,23,34.5)

t = DateTimeFromCOMDate(12345.6)
print t
assert t.COMDate() == 12345.6

t = DateTimeFromCOMDate(-12345.6)
print t
assert t.COMDate() == -12345.6

x = time.time()
print 'ticks:',x
t = DateTimeFromTicks(x)
print t.tuple(), t.absdate, t.abstime
assert t.ticks() == x

# Python Number protocol:
t1 = Date(1997,12,31)
t2 = Date(1997,12,30)
d = t2 - t1
try:
    t1 + t2
except TypeError:
    pass
try:
    t2 * t1
except TypeError:
    pass
try:
    t2 / t1
except TypeError:
    pass

# Deltas
assert DateTimeDelta(2,1,-1,-3).tuple() == (2, 0, 58, 57.0)
assert DateTimeDelta(2,0,-1,-3).tuple() == (1, 23, 58, 57.0)
assert DateTime(1998,1,9) + DateTimeDelta(-1) == DateTime(1998,1,8)
assert DateTime(1998,1,9) - DateTimeDelta(1) == DateTime(1998,1,8)
assert DateTime(1998,1,9) - DateTimeDelta(1.5) == DateTime(1998,1,7,12,0,0)
assert DateTime(1998,1,9) - DateTime(1969,4,6) == DateTimeDelta(10505)
assert DateTimeDelta(10000) / (DateTimeDelta(10000) * 0.5) == 2.0

# Rounding problems with COM dates
t = DateTime(1998, 2, 24, 12, 40, 11)
c = DateTimeFromCOMDate(t.COMDate())
print 'DateTime->COM Date->DateTime rounding error:',(t == c) * 'no' or 'yes'
print 'COM Dates compare:',(t.COMDate()==c.COMDate()) * 'equal' or 'not equal'
print 'diff =',t-c,'in seconds:',t.second - c.second
print 'using cmp(,,0.5):',(cmp(t,c,0.5) == 0) * 'equal' or 'not equal'

# Sanity check
print 'Running constructor test... (this could take a few minutes)'
p = None
for year in range(1900,2101):
    for month in range(1,13):
        for day in range(1,32):
            try:
                t = Date(year,month,day)
            except RangeError:
                continue
            if p:
                try:
                    assert p + 1 == t
                    assert (p+1).tuple() == t.tuple()
                    assert t.tuple()[:3] == (year,month,day)
                except AssertionError:
                    raise AssertionError,\
                          'problem with p = %s, p+1 = %s and t = %s' %\
                          (p,p+1,t)
            p = t
print 'Date construction works.'

# Non zero testing
if t:
    print 'Non zero testing works.'

# ticks and dst
try:
    summer.ticks(0,0)
    winter.ticks(0,0)
    summer.ticks(0,1)
    winter.ticks(0,1)
except SystemError:
    print
    print '-'*72
    print 'WARNING:'
    print
    print 'The mktime() C API on your platform does not support'
    print 'setting the DST flag to anything other than -1. This'
    print 'will cause the datetime.ticks() method to raise an'
    print 'error in case you pass a DST flag other than -1.'
    print '-'*72

try:
    summer.gmticks()
except AttributeError:
    print
    print '-'*72
    print 'NOTE:'
    print
    print 'The system does not provide a timegm() C API:'
    print 'datetime.gmticks() is not available. If you think that'
    print 'you do have that API, try editing the Setup file of this'
    print 'module, and then do a "make clean; make".'
    print '-'*72

# Sanity checks
date1 = now() + RelativeDateTime(day=1,month=1,hour=0,minute=0,second=0)
date2 = now() + RelativeDateTime(day=1,month=6,hour=0,minute=0,second=0)

try:
    assert date1.ticks() == apply(time.mktime,date1.tuple())
    assert date2.ticks() == apply(time.mktime,date2.tuple())
except:
    print
    print '-'*72
    print 'WARNING:'
    print
    print 'Conversion from DateTime instances to ticks is not relyable'
    print 'on your platform. Please run "python testticks.py" and send'
    print 'the output to the author at mal@lemburg.com.'
    print
    print '-'*72

try:
    assert time.localtime(apply(time.mktime,date1.tuple()))[:6] == \
           date1.tuple()[:6]
    assert time.localtime(apply(time.mktime,date2.tuple()))[:6] == \
           date2.tuple()[:6]
except:
    print
    print '-'*72
    print 'WARNING:'
    print
    print 'time.localtime() and time.mktime() are not inverse functions'
    print 'on your platform. This may lead to strange results in some'
    print 'applications. Please run "python testticks.py" and send'
    print 'the output to the author at mal@lemburg.com.'
    print
    print '-'*72

print
print

# Try importing a subpackage
import DateTime.Feasts
Feasts._test()

print
print 'Works.'
