/*
 * twlog:  A basic ham loging program using Motif
 * Copyright (C) 1997 Ted Williams WA0EIR (ted@bluestone.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139,
 * USA. See the COPYING file in this directory.
 *
 * Versions: 1.1 -  Oct 1997 
 */

/*
 * main Function
 * Main defines a structure for the application defined resources,
 * initializes the toolkit, builds the widgets, initializes some
 * variables, and then realizes the widgets. 
 */

#include "twlog.h"

void  main (int argc, char *argv[])
{
   XtAppContext ac;
   LogRes log_res;
   int length;
   Dimension h, w;
   XtActionsRec actions[] =
	    {
               {"CRkey", CRkey}
            };

   /*
    * Describe the application defined resources. This struct is
    * for the app resources which are read in the resource
    * file.  See the resource file (Twlog) for more info.
    */
   XtResource app_res_desc[] =
        {
           {
           XmNdirpath,                    /* Name */
           XmCDirpath,                    /* Class */
           XmRString,                     /* Target data type */
           sizeof (char *),               /* size of target type */
           XtOffsetOf (LogRes, dirpath),  /* Offset into LogRes */
           XmRImmediate,                  /* Default data type */
           "bogus"                        /* Pointer to default value */
           },

           {
           XmNtzone,                      /* Same a above */
           XmCTzone,
           XmRInt,
           sizeof (int),
           XtOffsetOf (LogRes, tzone),
           XtRImmediate,
           (XtPointer)2                   /* Force an error if not found */
           },

           {
           XmNbands,                      /* Same a above */
           XmCBands,
           XmRXmStringTable,
           sizeof (XmStringTable),
           XtOffsetOf (LogRes, bands),
           XtRString,
           "Not Found"                    /* Default to "Not Found" */
           },

           {
           XmNdefault_band,               /* Same a above */
           XmCDefault_band,
           XmRInt,
           sizeof (int),
           XtOffsetOf (LogRes, default_band),
           XtRImmediate, 0                /* Default to first button*/
           },

           {
           XmNmodes,                      /* Same a above */
           XmCModes,
           XmRXmStringTable,
           sizeof (XmStringTable),
           XtOffsetOf (LogRes, modes),
           XtRString,
           "Not Found"                    /* Default to "Not Found" */
           },

           {
           XmNdefault_mode,               /* Same a above */
           XmCDefault_mode,
           XmRInt,
           sizeof (int),
           XtOffsetOf (LogRes, default_mode),
           XtRImmediate, 0                /* Default to first button*/
           },

           {
           XmNpower,                      /* Same a above */
           XmCPower,
           XmRXmStringTable,
           sizeof (XmStringTable),
           XtOffsetOf (LogRes, power),
           XtRString,
           "Not Found"                    /* Default to "Not Found" */
           },

           {
           XmNdefault_power,              /* Same a above */
           XmCDefault_power,
           XmRInt,
           sizeof (int),
           XtOffsetOf (LogRes, default_power),
           XtRImmediate, 0                /* Default to first button*/
           }
        };

   /*
    * Initialize the tool kit and create the application shell
    * and get the app defined resources
    */
   logSH = XtVaAppInitialize (&ac, "Twlog", NULL, 0, &argc, argv, NULL,
              XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE,
              XmNiconName, "TWLOG",
              NULL);

   XtGetApplicationResources (logSH, &log_res, app_res_desc,
      XtNumber (app_res_desc), NULL, 0);

   /*
    * Build the widgets
    */
   build_widgets (logSH, log_res);

   /*
    * Initialize dirpath, logpath, and helppath.
    * This calculates the length of the dirpath resource +
    * MAXNAME, and mallocs space for it. Then, it copies the
    * resource string into it and cats LOGFILE on the end.  The
    * pointer for the helpfile gets the same treatment.
    */
    
   length = strlen (log_res.dirpath);
   dirpath = malloc (length);
   strcpy (dirpath, log_res.dirpath);
   
   logpath = malloc (length + MAXNAME);
   strcpy (logpath, dirpath);
   strcat (logpath, LOGFILE);

   helppath = malloc (length + MAXNAME);
   strcpy (helppath, dirpath);
   strcat (helppath, HELPFILE);

   /*
    * Initialize the Timezone
    * Check the timezone resource and do a tzset if OK.  If the value
    * is bad or the resource was not found (default resource = 2
    * above) force an error and exit.
    */
   switch (log_res.tzone)
   {
      case 0:
         putenv ("TZ=localtime");
         break;

      case 1:
         putenv ("TZ=GMT");
         break;

      default:
         fprintf (stderr, "Error in Twlog file - Time Zone Choice must be 0 or 1\n");
         exit (1);
   }
   tzset();

   /*
    * Add Actions
    */
  XtAppAddActions(ac, actions, XtNumber(actions));
    
   /*
    * Realize widgets, set min and max window sizes, and enter
    * main loop Realize everything.  The managers have done their
    * geometry calcs and the heights and widths have been
    * determined, based on the font selected, and NUMCOLS, so get
    * the height and width.  Set max and min height to current
    * height.  Set min width to current width.  Then, go into loop
    * mode.
    */
   XtRealizeWidget (logSH);
  
   XtVaGetValues (logSH,
      XmNheight, &h,
      XmNwidth, &w,
      NULL);

   XtVaSetValues (logSH,
      XmNminHeight, h,
      XmNmaxHeight, h,
      XmNminWidth, w,
      NULL);

   XtAppMainLoop (ac);
}
