/*###################################################################*/
/*##                          GQview 0.4.3                         ##*/
/*##       This software is Copyright (C) 1998 by John Ellis.      ##*/
/*## This software falls under the GNU Public License. Please read ##*/
/*##              the COPYING file for more information            ##*/
/*###################################################################*/

#include "gqview.h"

static gint thumbs_running = 0;

static void update_file_count_label();
static gchar *truncate_hist_text(gchar *t, gint l);
static void update_history_menu();

static void update_file_count_label()
{
	gchar sbuf[24];
	if (filelist_count == 1)
		sprintf(sbuf,"1 file");
	else
		sprintf(sbuf,"%d files",filelist_count);
	gtk_label_set(GTK_LABEL(statuslabel),sbuf);
}


void change_dir_to_home()
{
	gchar *newdir = homedir();
	if (!strcmp(newdir,current_dir)) return;
	set_current_dir(newdir);
	refresh_dir();
}

gint dot_file_check(gchar *file)
{
	gchar dot[] = ".";
	if (!strcmp(file,".") || !strcmp(file,"..")) return 1;
	if (file[0] == dot[0]) return 0;
	return 1;
}

gint filter_file_check(gchar *file)
{
	gchar *f_ptr = &FILTER[0];
	gchar *file_ptr;
	gchar txt [] = ";";
	gchar txtbuf [10];
	int i;

	while (f_ptr < &FILTER[0] + strlen(FILTER))
		{
		i=0;
		while (*f_ptr != txt[0] && *f_ptr != txt[1])
			{
			txtbuf[i] = *f_ptr;
			f_ptr++;
			i++;
			}
		f_ptr++;
		txtbuf[i] = txt[1];
		file_ptr = &file[0] + strlen(file) - i;
		if (!strcasecmp(file_ptr,txtbuf)) return 1;
		}
	return 0;
}

void rebuild_filter()
{
	strcpy(FILTER,"");

	if (FILTER_INCLUDE_PPM) strcat (FILTER, ".ppm;");
	if (FILTER_INCLUDE_PNG) strcat (FILTER, ".png;");
	if (FILTER_INCLUDE_JPG) strcat (FILTER, ".jpg;.jpeg;");
	if (FILTER_INCLUDE_TIF) strcat (FILTER, ".tif;.tiff;");
	if (FILTER_INCLUDE_PGM) strcat (FILTER, ".pgm;");
	if (FILTER_INCLUDE_XPM) strcat (FILTER, ".xpm;");
	if (FILTER_INCLUDE_GIF) strcat (FILTER, ".gif;");
	if (FILTER_INCLUDE_PCX) strcat (FILTER, ".pcx;");
	if (FILTER_INCLUDE_BMP) strcat (FILTER, ".bmp;");
	if (strcmp(CUSTOM_FILTER,"") != 0) strcat (FILTER, CUSTOM_FILTER);
}

void history_menu_select(GtkWidget *widget, gchar *newdir)
{
	set_current_dir(newdir);
	refresh_dir();
	filelist_pos = -1;
}

static gchar *truncate_hist_text(gchar *t, gint l)
{
	gchar *tp;
	gchar *tbuf;
	if (l >= strlen(t)) return g_strdup(t);
	tp = t + strlen(t) - l;
	while (tp[0] != '/' && tp < t + strlen(t)) tp++;
		/* this checks to see if directory name is longer than l, if so */
		/* reset the length of name to l, it's better to have a partial */
		/* name than no name at all. */
	if (tp >= t + strlen(t)) tp = t + strlen(t) - l;
	tbuf = g_strconcat("/...", tp, NULL);
	return tbuf;
}

static void update_history_menu()
{
	static GList *history_list = NULL;
	GtkWidget *historymenu;
	GtkWidget *button;
	gchar *hist;
	gchar *hist_ptr;

	if (history_list)
		{
		g_list_foreach(history_list, (GFunc) g_free, NULL);
		g_list_free(history_list);
		history_list = NULL;
		}

	hist = g_strdup(current_dir);
	hist_ptr = hist + strlen(hist) - 1 ;
	
	historymenu = gtk_menu_new();
	while (hist_ptr > hist)
		{
		gchar *path;
		gchar *hist_trunc;
		hist_trunc = truncate_hist_text(hist,32);
		button = gtk_menu_item_new_with_label (hist_trunc);
		g_free(hist_trunc);

		path = g_strdup(hist);
		history_list = g_list_append(history_list, path);
		gtk_signal_connect (GTK_OBJECT (button), "activate",
			(GtkSignalFunc) history_menu_select, path);

		gtk_menu_append (GTK_MENU (historymenu),button);
		gtk_widget_show (button);

		while (hist_ptr[0] != '/') hist_ptr--;
		hist_ptr[0] = '\0';
		}
	g_free(hist);
	/* looks like we have to add the root directory manually */
	button = gtk_menu_item_new_with_label ("/");

	gtk_signal_connect (GTK_OBJECT (button), "activate",
		(GtkSignalFunc) history_menu_select, "/");

	gtk_menu_append (GTK_MENU (historymenu),button);
	gtk_widget_show (button);

	gtk_option_menu_set_menu(GTK_OPTION_MENU(historypulldown),historymenu);
}

void update_list_highlight(gint old, gint new, gint move)
{
	if (old >= 0)
		{
		gtk_clist_set_background(GTK_CLIST(filelist_clist), old,
			&GTK_WIDGET (filelist_clist)->style->bg[GTK_STATE_PRELIGHT]);
		gtk_clist_set_foreground(GTK_CLIST(filelist_clist), old,
			&GTK_WIDGET (filelist_clist)->style->fg[GTK_STATE_PRELIGHT]);
		}
	if (new >= 0)
		{
		gtk_clist_set_background(GTK_CLIST(filelist_clist), new,
			&GTK_WIDGET (filelist_clist)->style->bg[GTK_STATE_SELECTED]);
		gtk_clist_set_foreground(GTK_CLIST(filelist_clist), new,
			&GTK_WIDGET (filelist_clist)->style->fg[GTK_STATE_SELECTED]);
		}
	if (move)
		gtk_clist_moveto (GTK_CLIST(filelist_clist), new, 0, 0.5, 0.0);
}

void change_dir(GtkWidget *widget, gint row, gint column, GdkEventButton *bevent)
{
	gchar newdir[255];
	if (bevent->button != 1) return;
	strcpy(newdir,dirlist_get_item(row));
	set_current_dir(newdir);
	refresh_dir();
}

void change_file(GtkWidget *widget, GdkEventButton *bevent, gpointer data)
{
	gint row = -1;
	gint column = -1;
	if (bevent->window != GTK_CLIST(widget)->clist_window) return;

	gtk_clist_get_selection_info (GTK_CLIST (widget), bevent->x, bevent->y,&row, &column);
	if (row == -1 || column == -1) return;

	switch (bevent->button)
		{
		case 1:
			update_list_highlight(filelist_pos, row, FALSE);
			filelist_pos = row;
			load_from_filelist(row);
			break;
		case 2:
			break;
		case 3:
			strcpy(current_file,filelist_get_item(row));
			gtk_menu_popup (GTK_MENU(menu_filelist_popup), NULL, NULL, NULL, NULL,
				bevent->button, bevent->time);
			break;
		default:
			break;
		}

	gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "button_press_event");
}

void interrupt_thumbs()
{
	if (thumbs_running > 0) thumbs_running ++;
}

void refresh_dir()
{
	gint i;
	gint td = FALSE;
	gint filelist_width = 1;
	gint dirlist_width = 1;
	gint new_width;

	interrupt_thumbs();

	gtk_label_set(GTK_LABEL(statuslabel),"reading directory...");
	if (popwindow)
		gtk_widget_draw_children(popwindow);
	else
		gtk_widget_draw_children(mainwindow);

	read_dir();
	if (ENABLE_THUMB_CACHING) maintain_thumbnail_dir(current_dir, FALSE);

	gtk_clist_freeze (GTK_CLIST (dirlist_clist));
	gtk_clist_clear (GTK_CLIST (dirlist_clist));

	dirlist_sort();
	filelist_sort();

	for (i=0; i < dirlist_count; i++)
		{
		gchar *duh[] = { "x", };
		duh[0] = dirlist_get_item(i);
		gtk_clist_append(GTK_CLIST(dirlist_clist),duh);

		new_width = gdk_string_width(dirlist_clist->style->font,duh[0]);
		if (new_width > dirlist_width)
			dirlist_width = new_width;
		}
	gtk_clist_set_column_width(GTK_CLIST(dirlist_clist),0,dirlist_width);
	
	gtk_clist_thaw (GTK_CLIST (dirlist_clist));

	update_history_menu();

	if (!strcmp(current_dir,image_dir_name)) td = TRUE;
	filelist_pos = -1;

	if (!thumbnail_mode)
		{
		gtk_clist_freeze (GTK_CLIST (filelist_clist));
		gtk_clist_clear (GTK_CLIST (filelist_clist));
		gtk_clist_set_row_height (GTK_CLIST(filelist_clist), GTK_WIDGET(filelist_clist)->style->font->ascent
			 + GTK_WIDGET(filelist_clist)->style->font->descent + 1);
		for (i=0; i < filelist_count; i++)
			{
			gchar *duh[] = { "x", };
			duh[0] = filelist_get_item(i);
			gtk_clist_append(GTK_CLIST(filelist_clist),duh);
			if (td && !strcmp(duh[0],image_file_name)) filelist_pos = i;

			new_width = gdk_string_width(filelist_clist->style->font,duh[0]);
			if (new_width > filelist_width)
				filelist_width = new_width;
			}
		gtk_clist_set_column_width(GTK_CLIST(filelist_clist),0,filelist_width);
		gtk_clist_thaw (GTK_CLIST (filelist_clist));
		if (filelist_pos >=0)
			update_list_highlight(-1, filelist_pos, TRUE);
		}
	else
		{
		int list_p = 0;
		int t,c,p;
		gchar *list_text;
		gchar *fn_text;

		gtk_clist_freeze (GTK_CLIST (filelist_clist));
		gtk_clist_set_row_height (GTK_CLIST(filelist_clist), thumb_max_height + 2);

		for (i=0; i < filelist_count; i++)
			{
			fn_text = filelist_get_item(i);
			if (td && !strcmp(fn_text,image_file_name)) filelist_pos = i;
			c = TRUE;
			while (c)
				{
				if (GTK_CLIST(filelist_clist)->rows > list_p)
					{
					guint8 spacing;
					GdkPixmap *nopixmap;
					GdkBitmap *nomask;
					if (GTK_CLIST(filelist_clist)->rows > 0 && gtk_clist_get_cell_type(GTK_CLIST(filelist_clist),list_p,0) == GTK_CELL_PIXTEXT)
						{
						gtk_clist_get_pixtext (GTK_CLIST(filelist_clist),list_p, 0, &list_text, &spacing,&nopixmap,&nomask);
						p = TRUE;
						}
					else
						{
						gtk_clist_get_text (GTK_CLIST(filelist_clist),list_p, 0, &list_text);
						p = FALSE;
						}
					t = strcmp(fn_text,list_text);
					}
				else
					{
					t = -1;
					}
				if (t<0)
					{
					/* new item is less than one in list, add it and continue */
					gchar *lt[] = { "x", };
					lt[0] = filelist_get_item(i);
					gtk_clist_insert(GTK_CLIST(filelist_clist),list_p,lt);
					gtk_clist_set_shift(GTK_CLIST(filelist_clist), list_p, 0, 0, 5 + thumb_max_width);
					p = FALSE;
					c = FALSE;
					}
				if (t>0)
					{
					/* new item is greater than one in list, remove the list item */
					gtk_clist_remove(GTK_CLIST(filelist_clist),list_p);
					}
				if (t==0)
					{
					/* new item is the list item, nothing needs to be done, almost */
					if (!p) gtk_clist_set_shift(GTK_CLIST(filelist_clist), list_p, 0, 0, 5 + thumb_max_width);
					c = FALSE;
					}
				}
			list_p++;

			new_width = gdk_string_width(filelist_clist->style->font,fn_text) + 5 + thumb_max_width;
			if (new_width > filelist_width)
				filelist_width = new_width;
			}

		/* if any rows are left after list_p in clist, remove them (they no longer belong)*/
		if (GTK_CLIST(filelist_clist)->rows > list_p)
			{
			while (GTK_CLIST(filelist_clist)->rows > list_p)
				{
				gtk_clist_remove(GTK_CLIST(filelist_clist),list_p);
				}
			}

		gtk_clist_set_column_width(GTK_CLIST(filelist_clist),0,filelist_width);
		gtk_clist_thaw (GTK_CLIST (filelist_clist));

		if (filelist_pos >=0)
			update_list_highlight(-1, filelist_pos, TRUE);

		gtk_label_set(GTK_LABEL(statuslabel),"generating thumbs...");
		/* now make the thumbs */
		i = 0;
		while (i < filelist_count)
			{
			gint past_run;
			fn_text = filelist_get_item(i);
			if (gtk_clist_get_cell_type(GTK_CLIST(filelist_clist),i,0) != GTK_CELL_PIXTEXT)
				{
				gchar th_buf[512];
				gint padding, padding_left;
				GdkPixmap *th_pixmap = NULL;
				GdkBitmap *th_mask = NULL;

				sprintf(th_buf,"%s/%s",current_dir,fn_text);
				padding = create_thumbnail(th_buf,&th_pixmap,&th_mask);
				padding_left = padding / 2;
				padding -= padding_left;
				gtk_clist_set_shift(GTK_CLIST(filelist_clist), i, 0, 0, padding_left);
				gtk_clist_set_pixtext (GTK_CLIST(filelist_clist), i, 0, fn_text, padding + 5, th_pixmap, th_mask);
				}

			gtk_progress_bar_update (GTK_PROGRESS_BAR (progressbar), (float)(i+1) / filelist_count);

			thumbs_running ++;
			past_run = thumbs_running;
			while(gtk_events_pending()) gtk_main_iteration();
			if (thumbs_running > past_run)
				{
				thumbs_running -= 2;
				gtk_progress_bar_update (GTK_PROGRESS_BAR (progressbar), 0.0);
				update_file_count_label();
				if (debug_mode) printf("thumb generation interupted\n");
				return;
				}
			thumbs_running --;
			/* if a file was renamed/deleted, check so we do not miss any thumbs */
			if (fn_text == filelist_get_item(i)) i++;
			}

		gtk_progress_bar_update (GTK_PROGRESS_BAR (progressbar), 0.0);
		}

	update_file_count_label();
}

