/*###################################################################*/
/*##                          GQview 0.4.3                         ##*/
/*##       This software is Copyright (C) 1998 by John Ellis.      ##*/
/*## This software falls under the GNU Public License. Please read ##*/
/*##              the COPYING file for more information            ##*/
/*###################################################################*/

#include "gqview.h"

	/* widgets */
static GtkWidget	*configwindow;
static GtkWidget	*configvbox;
static GtkWidget	*configtabs;
static GtkWidget	*radiobuttongroup;
static GtkWidget	*startup_path_entry;
static GtkWidget	*custom_filter_entry;
static GtkWidget	*editor_name_entry[8];
static GtkWidget	*editor_command_entry[8];

	/* variables */
static gint	STARTUP_PATH_ENABLE_C;

static gint	FILTERING_DISABLE_C;
static gint	DOT_FILES_C;

static gint	FILTER_INCLUDE_PPM_C;
static gint	FILTER_INCLUDE_PNG_C;
static gint	FILTER_INCLUDE_JPG_C;
static gint	FILTER_INCLUDE_TIF_C;
static gint	FILTER_INCLUDE_PGM_C;
static gint	FILTER_INCLUDE_XPM_C;
static gint	FILTER_INCLUDE_GIF_C;
static gint	FILTER_INCLUDE_PCX_C;
static gint	FILTER_INCLUDE_BMP_C;
static gint	ZOOM_MODE_C;
static gint	thumb_max_width_c;
static gint	thumb_max_height_c;
static gint	ENABLE_THUMB_CACHING_C;
static gint	confirm_delete_c;
static gint	fit_window_c;
static gint	limit_window_size_c;
static gint	max_window_size_c;
static gint	save_on_exit_c;
static gint	restore_tool_c;

static void max_window_size_cb(GtkObject *adj, gpointer data);
static void thumb_size_48_selected();
static void thumb_size_64_selected();
static void thumb_size_85_selected();
static void thumb_size_100_selected();
static void limit_window_size_selected(GtkWidget *w);
static void fit_window_selected(GtkWidget *w);
static void save_on_exit_selected(GtkWidget *w);
static void restore_tool_selected(GtkWidget *w);
static void cache_thumbnails_selected(GtkWidget *w);
static void confirm_delete_selected(GtkWidget *w);
static void dot_files_mode_selected(GtkWidget *w);
static void zoom_mode_orig_selected();
static void zoom_mode_fit_selected();
static void zoom_mode_nochange_selected();
static void startup_path_mode_selected(GtkWidget *w);
static void change_startup_to_current();
static void filtering_mode_selected(GtkWidget *w);
static void filter_include_selected(GtkWidget *w, gpointer data);
static void hide_configuration_window();
static void save_button_pressed();
static void apply_configuration_window();
static void create_config_window(gint start_tab);

static void max_window_size_cb(GtkObject *adj, gpointer data)
{
	max_window_size_c = (gint)GTK_ADJUSTMENT(adj)->value;
} 

static void thumb_size_48_selected()
{
	thumb_max_width_c = 48;
	thumb_max_height_c = 48;
}

static void thumb_size_64_selected()
{
	thumb_max_width_c = 64;
	thumb_max_height_c = 64;
}

static void thumb_size_85_selected()
{
	thumb_max_width_c = 85;
	thumb_max_height_c = 64;
}

static void thumb_size_100_selected()
{
	thumb_max_width_c = 100;
	thumb_max_height_c = 100;
}

static void limit_window_size_selected(GtkWidget *w)
{
	limit_window_size_c = GTK_TOGGLE_BUTTON (w)->active;
}

static void fit_window_selected(GtkWidget *w)
{
	fit_window_c = GTK_TOGGLE_BUTTON (w)->active;
}

static void save_on_exit_selected(GtkWidget *w)
{
	save_on_exit_c = GTK_TOGGLE_BUTTON (w)->active;
}

static void restore_tool_selected(GtkWidget *w)
{
	restore_tool_c = GTK_TOGGLE_BUTTON (w)->active;
}

static void cache_thumbnails_selected(GtkWidget *w)
{
	ENABLE_THUMB_CACHING_C = GTK_TOGGLE_BUTTON (w)->active;
}

static void confirm_delete_selected(GtkWidget *w)
{
	confirm_delete_c = GTK_TOGGLE_BUTTON (w)->active;
}

static void dot_files_mode_selected(GtkWidget *w)
{
	DOT_FILES_C = GTK_TOGGLE_BUTTON (w)->active;
}

static void zoom_mode_orig_selected()
{
	ZOOM_MODE_C = 1;
}

static void zoom_mode_fit_selected()
{
	ZOOM_MODE_C = 2;
}

static void zoom_mode_nochange_selected()
{
	ZOOM_MODE_C = 3;
}

static void startup_path_mode_selected(GtkWidget *w)
{
	STARTUP_PATH_ENABLE_C = GTK_TOGGLE_BUTTON (w)->active;
}

static void change_startup_to_current()
{
	gtk_entry_set_text(GTK_ENTRY(startup_path_entry),current_dir);
}

static void filtering_mode_selected(GtkWidget *w)
{
	FILTERING_DISABLE_C = GTK_TOGGLE_BUTTON (w)->active;
}

static void filter_include_selected(GtkWidget *w, gpointer data)
{
	gint *t;
	t = (int *) data;
	*t = GTK_TOGGLE_BUTTON (w)->active;
}

void show_about_info()
{
	if (!configwindow)
		create_config_window(4);
		gtk_widget_show(configwindow);
}

void show_configuration_window()
{
	if (!configwindow)
		create_config_window(0);
		gtk_widget_show(configwindow);
}

static void hide_configuration_window()
{
	gtk_widget_destroy(configwindow);
	configwindow = NULL;
}

static void save_button_pressed()
{
	apply_configuration_window();
	save_options();
}

static void apply_configuration_window()
{
	gchar *new_path;
	gchar *new_filter;
	gchar *s_ptr;
	gint change = 0;
	int i;

	new_path = gtk_entry_get_text(GTK_ENTRY(startup_path_entry));
	new_filter = gtk_entry_get_text(GTK_ENTRY(custom_filter_entry));

	for (i=0; i<8 ;i++)
		{
		s_ptr = gtk_entry_get_text(GTK_ENTRY(editor_name_entry[i]));
		if (!strcmp(s_ptr,editor_name + (i*33))) change = 1;
		strcpy(editor_name + (i*33),s_ptr);

		s_ptr = gtk_entry_get_text(GTK_ENTRY(editor_command_entry[i]));
		if (!strcmp(s_ptr,editor_command + (i*256))) change = 1;
		strcpy(editor_command + (i*256),s_ptr);
		}
	if (change == 1) update_edit_menu();

	change =0;
	if (DOT_FILES != DOT_FILES_C) change = 1;
	if (FILTERING_DISABLE != FILTERING_DISABLE_C) change = 1;
	if (FILTER_INCLUDE_JPG != FILTER_INCLUDE_JPG_C) change = 1;
	if (FILTER_INCLUDE_PPM != FILTER_INCLUDE_PPM_C) change = 1;
	if (FILTER_INCLUDE_PNG != FILTER_INCLUDE_PNG_C) change = 1;
	if (FILTER_INCLUDE_TIF != FILTER_INCLUDE_TIF_C) change = 1;
	if (FILTER_INCLUDE_PGM != FILTER_INCLUDE_PGM_C) change = 1;
	if (FILTER_INCLUDE_XPM != FILTER_INCLUDE_XPM_C) change = 1;
	if (FILTER_INCLUDE_GIF != FILTER_INCLUDE_GIF_C) change = 1;
	if (FILTER_INCLUDE_PCX != FILTER_INCLUDE_PCX_C) change = 1;
	if (FILTER_INCLUDE_BMP != FILTER_INCLUDE_BMP_C) change = 1;
	if (strcmp(CUSTOM_FILTER,new_filter) != 0) change =1;

	FILTER_INCLUDE_JPG = FILTER_INCLUDE_JPG_C;
	FILTER_INCLUDE_PPM = FILTER_INCLUDE_PPM_C;
	FILTER_INCLUDE_PNG = FILTER_INCLUDE_PNG_C;
	FILTER_INCLUDE_TIF = FILTER_INCLUDE_TIF_C;
	FILTER_INCLUDE_PGM = FILTER_INCLUDE_PGM_C;
	FILTER_INCLUDE_XPM = FILTER_INCLUDE_XPM_C;
	FILTER_INCLUDE_GIF = FILTER_INCLUDE_GIF_C;
	FILTER_INCLUDE_PCX = FILTER_INCLUDE_PCX_C;
	FILTER_INCLUDE_BMP = FILTER_INCLUDE_BMP_C;

	thumb_max_width = thumb_max_width_c;
	thumb_max_height = thumb_max_height_c;
	ENABLE_THUMB_CACHING = ENABLE_THUMB_CACHING_C;
	confirm_delete = confirm_delete_c;
	ZOOM_MODE = ZOOM_MODE_C;
	fit_window = fit_window_c;
	limit_window_size = limit_window_size_c;
	max_window_size = max_window_size_c;
	save_on_exit = save_on_exit_c;
	restore_tool = restore_tool_c;
	DOT_FILES = DOT_FILES_C;
	FILTERING_DISABLE = FILTERING_DISABLE_C;
	STARTUP_PATH_ENABLE = STARTUP_PATH_ENABLE_C;
	strcpy(STARTUP_PATH,new_path);
	strcpy(CUSTOM_FILTER,new_filter);
	hide_configuration_window();
	if (change)
		{
		rebuild_filter();
		refresh_dir();
		}
}

static void create_config_window(gint start_tab)
{
	GtkWidget *hbox;
	GtkWidget *button;
	GtkWidget *frame;
	GtkWidget *label;
	GtkWidget *vbox;
	GtkWidget *vbox1;
	GtkWidget *vbox2;
	GtkWidget *table;
        GtkObject *adj;
        GtkWidget *spin;

	gchar infostr[255];
	int i;
	char s[7];

	configwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (configwindow), "delete_event",(GtkSignalFunc) hide_configuration_window, NULL);
	gtk_window_set_policy (GTK_WINDOW (configwindow), FALSE, FALSE, FALSE);
	gtk_window_set_title (GTK_WINDOW (configwindow), "GQview configuration");
	gtk_container_border_width (GTK_CONTAINER (configwindow), 5);

	configvbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(configwindow),configvbox);
	gtk_widget_show(configvbox);

	hbox = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_end(GTK_BOX(configvbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	button = gtk_button_new_with_label("Ok");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) apply_configuration_window, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 20);
	gtk_widget_show(button);

	button = gtk_button_new_with_label("Save");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) save_button_pressed, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 20);
	gtk_widget_show(button);

	button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",(GtkSignalFunc) hide_configuration_window, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 20);
	gtk_widget_show(button);

	configtabs = gtk_notebook_new();
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK(configtabs), GTK_POS_TOP);
	gtk_box_pack_start (GTK_BOX(configvbox), configtabs, TRUE, TRUE, 0);

	/* general options tab */

	frame = gtk_frame_new(NULL);
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_show(frame);
	label = gtk_label_new("General");
	gtk_notebook_append_page (GTK_NOTEBOOK (configtabs), frame, label);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (vbox), 5);
	gtk_container_add (GTK_CONTAINER(frame),vbox);
	gtk_widget_show(vbox);
	
	frame = gtk_frame_new("Initial directory");
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(frame),vbox1);
	gtk_widget_show(vbox1);

	STARTUP_PATH_ENABLE_C = STARTUP_PATH_ENABLE;
	button = gtk_check_button_new_with_label ("On startup, change to this directory:");
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), STARTUP_PATH_ENABLE_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) startup_path_mode_selected, button);
	gtk_widget_show(button);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	startup_path_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(startup_path_entry),STARTUP_PATH);
	gtk_box_pack_start(GTK_BOX(hbox),startup_path_entry,TRUE,TRUE,0);
	gtk_widget_show(startup_path_entry);

	button = gtk_button_new_with_label ("Use current");
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) change_startup_to_current, NULL);
	gtk_box_pack_end(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	confirm_delete_c = confirm_delete;
	button = gtk_check_button_new_with_label ("Confirm file delete");
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), confirm_delete_c);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) confirm_delete_selected, button);
	gtk_widget_show(button);

	save_on_exit_c = save_on_exit;
	button = gtk_check_button_new_with_label ("Save settings on exit");
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), save_on_exit_c);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) save_on_exit_selected, button);
	gtk_widget_show(button);

	restore_tool_c = restore_tool;
	button = gtk_check_button_new_with_label ("Remember tool state (float/hidden)");
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), restore_tool_c);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) restore_tool_selected, button);
	gtk_widget_show(button);

	/* image tab */

	frame = gtk_frame_new(NULL);
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_show(frame);
	label = gtk_label_new("Image");
	gtk_notebook_append_page (GTK_NOTEBOOK (configtabs), frame, label);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (vbox), 5);
	gtk_container_add (GTK_CONTAINER(frame),vbox);
	gtk_widget_show(vbox);
	
	frame = gtk_frame_new("When new image is selected:");
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(frame),vbox1);
	gtk_widget_show(vbox1);

	ZOOM_MODE_C = ZOOM_MODE;
	radiobuttongroup = gtk_radio_button_new_with_label (NULL,"Zoom to original size");
	if (ZOOM_MODE_C == 1) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(radiobuttongroup), 1);
	gtk_signal_connect (GTK_OBJECT(radiobuttongroup),"clicked",(GtkSignalFunc) zoom_mode_orig_selected, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), radiobuttongroup, FALSE, FALSE, 0);
	gtk_widget_show(radiobuttongroup);

	button = gtk_radio_button_new_with_label (gtk_radio_button_group(GTK_RADIO_BUTTON(radiobuttongroup)),"Fit image to window");
	if (ZOOM_MODE_C == 2) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), 1);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) zoom_mode_fit_selected, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	button = gtk_radio_button_new_with_label (gtk_radio_button_group(GTK_RADIO_BUTTON(radiobuttongroup)),"Leave Zoom at previous setting");
	if (ZOOM_MODE_C == 3) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), 1);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) zoom_mode_nochange_selected, NULL);
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	fit_window_c = fit_window;
	button = gtk_check_button_new_with_label ("Fit window to image when tools are hidden/floating");
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), fit_window_c);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) fit_window_selected, button);
	gtk_widget_show(button);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	limit_window_size_c = limit_window_size;
	button = gtk_check_button_new_with_label ("Limit size when auto-sizing window (%):");
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), limit_window_size_c);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) limit_window_size_selected, button);
	gtk_widget_show(button);

	max_window_size_c = max_window_size;
	adj = gtk_adjustment_new((float)max_window_size_c, 10.0, 150.0, 1, 1, 1);
        spin = gtk_spin_button_new( GTK_ADJUSTMENT(adj), 1, 0 );
        gtk_box_pack_start( GTK_BOX(hbox), spin, FALSE, FALSE, 5);
        gtk_signal_connect( GTK_OBJECT(adj),"value_changed",GTK_SIGNAL_FUNC(max_window_size_cb), NULL);
        gtk_spin_button_set_update_policy( GTK_SPIN_BUTTON(spin),GTK_UPDATE_ALWAYS );
        gtk_widget_show(spin);

	frame = gtk_frame_new("Thumbnails");
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(frame),vbox1);
	gtk_widget_show(vbox1);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	thumb_max_width_c = thumb_max_width;
	thumb_max_height_c = thumb_max_height;

	label = gtk_label_new("Size:");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
	gtk_widget_show(label);

	radiobuttongroup = gtk_radio_button_new_with_label (NULL,"48x48");
	gtk_box_pack_start(GTK_BOX(hbox), radiobuttongroup, FALSE, FALSE, 0);
	if (thumb_max_width_c == 48 && thumb_max_height_c == 48) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(radiobuttongroup), 1);
	gtk_signal_connect (GTK_OBJECT(radiobuttongroup),"clicked",(GtkSignalFunc) thumb_size_48_selected, NULL);
	gtk_widget_show(radiobuttongroup);

	button = gtk_radio_button_new_with_label (gtk_radio_button_group(GTK_RADIO_BUTTON(radiobuttongroup)),"64x64");
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	if (thumb_max_width_c == 64 && thumb_max_height_c == 64) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), 1);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) thumb_size_64_selected, NULL);
	gtk_widget_show(button);

	button = gtk_radio_button_new_with_label (gtk_radio_button_group(GTK_RADIO_BUTTON(radiobuttongroup)),"85x64");
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	if (thumb_max_width_c == 85 && thumb_max_height_c == 64) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), 1);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) thumb_size_85_selected, NULL);
	gtk_widget_show(button);

	button = gtk_radio_button_new_with_label (gtk_radio_button_group(GTK_RADIO_BUTTON(radiobuttongroup)),"100x100");
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	if (thumb_max_width_c == 100 && thumb_max_height_c == 100) gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), 1);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) thumb_size_100_selected, NULL);
	gtk_widget_show(button);

	ENABLE_THUMB_CACHING_C = ENABLE_THUMB_CACHING;
	button = gtk_check_button_new_with_label ("Cache thumbnails");
	gtk_box_pack_start(GTK_BOX(vbox1), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), ENABLE_THUMB_CACHING_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) cache_thumbnails_selected, button);
	gtk_widget_show(button);

	/* filtering tab */

	frame = gtk_frame_new(NULL);
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_show(frame);
	label = gtk_label_new("Filtering");
	gtk_notebook_append_page (GTK_NOTEBOOK (configtabs), frame, label);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (vbox), 5);
	gtk_container_add (GTK_CONTAINER(frame),vbox);
	gtk_widget_show(vbox);
	
	DOT_FILES_C = DOT_FILES;
	button = gtk_check_button_new_with_label ("Show entries that begin with a dot");
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), DOT_FILES_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) dot_files_mode_selected, button);
	gtk_widget_show(button);

	FILTERING_DISABLE_C = FILTERING_DISABLE;
	button = gtk_check_button_new_with_label ("Disable File Filtering");
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), FILTERING_DISABLE_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) filtering_mode_selected, button);
	gtk_widget_show(button);

	frame = gtk_frame_new("Include files of type:");
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 0);
	gtk_widget_show(frame);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(frame),vbox1);
	gtk_widget_show(vbox1);

	hbox = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX(hbox), vbox2,FALSE, FALSE, 0);
	gtk_widget_show(vbox2);

	FILTER_INCLUDE_JPG_C = FILTER_INCLUDE_JPG;
	button = gtk_check_button_new_with_label ("JPG / JPEG");
	gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), FILTER_INCLUDE_JPG_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) filter_include_selected, (gpointer) &FILTER_INCLUDE_JPG_C);
	gtk_widget_show(button);
	
	FILTER_INCLUDE_XPM_C = FILTER_INCLUDE_XPM;
	button = gtk_check_button_new_with_label ("XPM");
	gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), FILTER_INCLUDE_XPM_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) filter_include_selected, (gpointer) &FILTER_INCLUDE_XPM_C);
	gtk_widget_show(button);

	FILTER_INCLUDE_TIF_C = FILTER_INCLUDE_TIF;
	button = gtk_check_button_new_with_label ("TIF / TIFF");
	gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), FILTER_INCLUDE_TIF_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) filter_include_selected, (gpointer) &FILTER_INCLUDE_TIF_C);
	gtk_widget_show(button);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX(hbox), vbox2, FALSE, FALSE, 0);
	gtk_widget_show(vbox2);

	FILTER_INCLUDE_GIF_C = FILTER_INCLUDE_GIF;
	button = gtk_check_button_new_with_label ("GIF");
	gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), FILTER_INCLUDE_GIF_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) filter_include_selected, (gpointer) &FILTER_INCLUDE_GIF_C);
	gtk_widget_show(button);

	FILTER_INCLUDE_PNG_C = FILTER_INCLUDE_PNG;
	button = gtk_check_button_new_with_label ("PNG");
	gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), FILTER_INCLUDE_PNG_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) filter_include_selected, (gpointer) &FILTER_INCLUDE_PNG_C);
	gtk_widget_show(button);

	FILTER_INCLUDE_PPM_C = FILTER_INCLUDE_PPM;
	button = gtk_check_button_new_with_label ("PPM");
	gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), FILTER_INCLUDE_PPM_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) filter_include_selected, (gpointer) &FILTER_INCLUDE_PPM_C);
	gtk_widget_show(button);
	
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX(hbox), vbox2, FALSE, FALSE, 0);
	gtk_widget_show(vbox2);

	FILTER_INCLUDE_PGM_C = FILTER_INCLUDE_PGM;
	button = gtk_check_button_new_with_label ("PGM");
	gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), FILTER_INCLUDE_PGM_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) filter_include_selected, (gpointer) &FILTER_INCLUDE_PGM_C);
	gtk_widget_show(button);

	FILTER_INCLUDE_PCX_C = FILTER_INCLUDE_PCX;
	button = gtk_check_button_new_with_label ("PCX");
	gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), FILTER_INCLUDE_PCX_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) filter_include_selected, (gpointer) &FILTER_INCLUDE_PCX_C);
	gtk_widget_show(button);

	FILTER_INCLUDE_BMP_C = FILTER_INCLUDE_BMP;
	button = gtk_check_button_new_with_label ("BMP");
	gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 0);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), FILTER_INCLUDE_BMP_C);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) filter_include_selected, (gpointer) &FILTER_INCLUDE_BMP_C);
	gtk_widget_show(button);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new("Custom file types:");
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
	gtk_widget_show(label);

	custom_filter_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(custom_filter_entry),CUSTOM_FILTER);
	gtk_box_pack_start(GTK_BOX(vbox1),custom_filter_entry,FALSE,FALSE,0);
	gtk_widget_show(custom_filter_entry);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new("format: [.foo;.bar]");
	gtk_box_pack_end(GTK_BOX(hbox),label,FALSE,FALSE,5);
	gtk_widget_show(label);

	/* editor entry tab */

	frame = gtk_frame_new(NULL);
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_show(frame);
	label = gtk_label_new("External Editors");
	gtk_notebook_append_page (GTK_NOTEBOOK (configtabs), frame, label);

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_border_width (GTK_CONTAINER (vbox), 5);
	gtk_container_add (GTK_CONTAINER(frame),vbox);
	gtk_widget_show(vbox);

	table=gtk_table_new(3,9,FALSE);
	gtk_container_add (GTK_CONTAINER(vbox),table);
	gtk_widget_show(table);

	label = gtk_label_new("#");
	gtk_table_attach_defaults(GTK_TABLE (table),label, 0, 1, 0, 1);
	gtk_widget_show(label);
	label = gtk_label_new("Menu name");
	gtk_table_attach_defaults(GTK_TABLE (table),label, 1, 2, 0, 1);
	gtk_widget_show(label);
	label = gtk_label_new("Command Line");
	gtk_table_attach_defaults(GTK_TABLE (table),label, 2, 3, 0, 1);
	gtk_widget_show(label);

	for (i=0; i<8; i++)
		{

		sprintf(s,"%d",i+1);
		label = gtk_label_new(s);
		gtk_table_attach_defaults(GTK_TABLE (table),label, 0, 1, i+1, i+2);
		gtk_widget_show(label);

		editor_name_entry[i] = gtk_entry_new_with_max_length(32);
		gtk_widget_set_usize(editor_name_entry[i],80,-1);
		gtk_entry_set_text(GTK_ENTRY(editor_name_entry[i]),editor_name + (i*33));
		gtk_table_attach_defaults(GTK_TABLE (table),editor_name_entry[i],1,2,i+1,i+2);
		gtk_widget_show(editor_name_entry[i]);

		editor_command_entry[i] = gtk_entry_new_with_max_length(255);
		gtk_widget_set_usize(editor_command_entry[i],160,-1);
		gtk_entry_set_text(GTK_ENTRY(editor_command_entry[i]),editor_command + (i*256));
		gtk_table_attach_defaults(GTK_TABLE (table),editor_command_entry[i],2,3,i+1,i+2);
		gtk_widget_show(editor_command_entry[i]);
		}
	
	/* about tab */

	frame = gtk_frame_new(NULL);
	gtk_container_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_show(frame);
	label = gtk_label_new("About");
	gtk_notebook_append_page (GTK_NOTEBOOK (configtabs), frame, label);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(frame),vbox);
	gtk_widget_show(vbox);

	button=gtk_pixmap_new(logo_pixmap,NULL);
	gtk_box_pack_start(GTK_BOX(vbox), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	sprintf(infostr,"GQview %d.%d.%d\n\nCopyright (c) 1998 by John Ellis\nwww.geocities.com/SiliconValley/Haven/5235\ngqview@geocities.com\n\nReleased under the GNU Public License",GQVIEW_VERSION_MAJOR,GQVIEW_VERSION_MINOR,GQVIEW_VERSION_REV);
	label = gtk_label_new(infostr);
	gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
	gtk_widget_show (label);

	gtk_notebook_set_page (GTK_NOTEBOOK(configtabs), start_tab);
	gtk_widget_show(configtabs);

}


