/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    map an image to polygons

    Copyright (c) 1997-1998 Mark Danks. mdanks@cybermed.ucsd.edu
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_IMAGEVERT_H_
#define INCLUDE_IMAGEVERT_H_

#include "Base/GemPixObj.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    imageVert
    
    map an image to polygons

DESCRIPTION
    
-----------------------------------------------------------------*/
class GEM_EXTERN imageVert : public GemPixObj
{
    CPPEXTERN_HEADER(imageVert, GemPixObj)

    public:

	    //////////
	    // Constructor
    	imageVert();
    	
    protected:
    	
    	//////////
    	// Destructor
    	virtual ~imageVert();

    	//////////
    	// This is a dummy function for us
    	virtual void 	processImage(imageStruct &) { }

    	//////////
    	// Do the processing
    	virtual void 	processRGBAPix(imageStruct &image, int texture);

    	//////////
    	// Do the processing
    	virtual void 	processGrayPix(imageStruct &image, int texture);

    	//////////
    	// Do the rendering.
    	virtual void 	render(GemState *state);

        //////////
        // The display list
        GLuint          m_dispList;

        //////////
        // Do we need to rebuild the display List
        int             m_rebuildList;
};

#endif	// for header file
