/* XQF - Quake server browser and launcher
 * Copyright (C) 1998 Roman Pozlevich <roma@botik.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __UTILS_H__
#define __UTILS_H__

#include <gtk/gtk.h>


extern	char *strdup_strip (const char *);
extern  char *file_in_dir (const char *, const char *);
extern  int str_isempty (const char *);
extern	char *expand_tilde (const char *path, const char *home);

extern  char *get_user_name (void);
extern  char *get_user_home (void);

extern	GList *dir_to_list (const char *dirname, 
                               char * (*filter) (const char *, const char *));

extern	GList *merge_sorted_string_lists (GList *list1, GList *list2);

extern	GSList *qsort_slist (GSList *list, 
                            int (*qsort_helper) (const void *, const void *));
extern	GList  *qsort_list  (GList *list, 
                            int (*qsort_helper) (const void *, const void *));

extern	int slist_index (GSList *list, gpointer ptr);
extern	int list_index (GList *list, gpointer ptr);

extern	GSList *slist_replicate (GSList *list);
extern	GSList *list_replicate (GList *list);

extern	void on_sig (int signum, void (*func) (int signum));
extern 	void ignore_sigpipe (void);


#endif /* __UTILS_H__ */
