/* Aisleriot - cscmi.h
 * Copyright (C) 1998 Jonathan Blandford <jrb@mit.edu>
 *
 * This game is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef CSCMI_H
#define CSCMI_H
#include <libguile.h>
#include <guile/gh.h>
#include <math.h>
#include <time.h>
#include "card.h"
#include "slot.h"
/* Generic game data */
typedef struct {
  SCM start_game_lambda;
  SCM button_pressed_lambda;
  SCM button_released_lambda;
  SCM button_clicked_lambda;
  SCM button_double_clicked_lambda;
  SCM game_over_lambda;
  SCM winning_game_lambda;
  SCM hint_lambda;
  SCM timeout_lambda;
} lambda_data;


/* variables */
extern lambda_data* game_data;

/* Init function */
void cscm_init();

/* Scheme to C functions... */
hslot_type new_slot(SCM);
GList* new_deck(SCM);
hcard_type new_card(SCM);

/* C to Scheme functions... */
SCM make_card(hcard_type);

#endif
