/* ########################################################################

			      smacXcoral.c

   File: smacXcoral.c
   Path: /home/fournigault/c/X11/xcoral-2.33/Smac/smacXcoral.c
   Description: 
   Created: Tue Feb 21 13:01:08 MET 1995
   Author: Bruno Pages
   Modified: Tue Feb 21 13:01:08 MET 1995
   Last maintained by: Bruno Pages

   RCS $Revision$ $State$
   

   ########################################################################

   Note: 

   ########################################################################

   Copyright (c) : Bruno Pages

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ######################################################################## */


#include <stdio.h>
#include <string.h>

/*#include "error.h"*/
#include "FunctionCall.h"
#include "Builtin.h"
#include "Identifier.h"
#include "funcall.h"
#include "smac.h"
#include "control.h"
#include "stack.h"

/* Le buffer courant */

char * i_buffer_courant;


/* Pour lire la region (du buffer courant) pour eval_region */

int i_curseur, i_curseur_sup;


/* Pour lire le minibuffer pour eval_expression */

char * i_minibuffer;


/* Pour lire un fichier pour load_file */

extern FILE * yyin;
extern int yyinflag;
extern char * yyinfilename;
extern int numlig;


/* ---------------------------------
   
   Les fonctions appelees par Xcoral


   Elles retournent 0 lorsque tout va
   bien, sinon une chaine de caracteres
   qui indique l'erreur

   --------------------------------- */

extern FCT(void, ClearSelectionIfNeeded,(char *));

static char * check_parser_error()
{
  if (*err_msg) {
    if (! strncmp(err_msg, "parser error", 12)) {
      extern FCT(void, DisplayWMessage ,(char *, char *, int));
      
      /* Le message n'a pas encore ete affiche */
      DisplayWMessage(err_msg, "Smac error", 1);
    }
    return err_msg;
  }

  return 0;
}

/* Chargement evaluation du fichier filename, le buffer
   courant est buff (qui n'est pas un vrai char *) */

char * ie_load_file(buff, filename)
     char * buff;
     char * filename;
{
  /* Chargement / evaluation d'un fichier */
  char * xcoral_lib = 0;
  char * smaclib = 0;
  
  ClearSelectionIfNeeded(buff);
  
  i_buffer_courant = buff;

  if ((yyin = fopen(filename, "r")) == 0) {
    char * justname = strrchr(filename, '/');
    
    if (justname)
      justname += 1;
    else
      justname = filename;
    
    smaclib = (char *) getenv ("XCORAL_SMACLIB");
    if (!smaclib) {
	xcoral_lib = malloc(strlen(XCORAL_LIB_DIR) + strlen(justname) + 2);
	sprintf(xcoral_lib, "%s/%s", XCORAL_LIB_DIR, justname);
    }
    else {
	xcoral_lib = malloc(strlen(smaclib) + strlen(justname) + 2);
	sprintf(xcoral_lib, "%s/%s", smaclib, justname);
    }
    
    if ((yyin = fopen(xcoral_lib, "r")) == 0) {
      free(xcoral_lib);
      buff = 0;
      yyin = 0;
      sprintf(err_msg, "cannot open file %s\n", filename);
      return err_msg;
    }
    else
      yyinfilename = xcoral_lib;
  }
  else
    yyinfilename = filename;
  
  yyinflag = 1;
  numlig = 0;
  *err_msg = 0;
  clear_ctrl_c();
  rerun_profile();
  
  if (! setjmp(come_back))
    load_file();

  stop_profile();
  fclose(yyin);
  if (xcoral_lib) free(xcoral_lib);
  i_buffer_courant = 0;
  i_curseur = i_curseur_sup = 0;
  yyin = 0;
  yyinflag = 0;
  yyinfilename = 0;

  return check_parser_error();
}


/* Evaluation de la region du buffer buff */

char * ie_eval_region(buff)
     char * buff;
{
  extern FCT(int, ie_mark_position,(char *));
  extern FCT(int, ie_current_position,(char *));
  extern FCT(int, ie_current_line,(char *));
  extern FCT(void, ie_goto_char,(char *, int));
  extern FCT(char *, ie_filename,(char *));
  
  ClearSelectionIfNeeded(buff);
  
  i_buffer_courant = buff;
  yyin = 0;
  yyinflag = 0;
  i_minibuffer = 0;
  *err_msg = 0;
  i_curseur = ie_mark_position(buff);
  i_curseur_sup = ie_current_position(buff);
  if (i_curseur_sup < i_curseur) {
    i_curseur = i_curseur_sup;
    i_curseur_sup = ie_mark_position(buff);
  }
  ie_goto_char(buff, i_curseur);
  numlig = ie_current_line(buff);
  yyinfilename = ie_filename(buff);
  clear_ctrl_c();
  rerun_profile();
  
  if (! setjmp(come_back))
    load_file();

  stop_profile();
  yyinfilename = 0;
  ie_goto_char(buff, i_curseur_sup);
  i_buffer_courant = 0;
  i_curseur = i_curseur_sup = 0;
  
  return check_parser_error();
}


/* Evaluation du minibuffer */

char * ie_eval_expression(buff, expr)
     char * buff;
     char * expr;
{
  int lg = strlen(expr);
  char * lexpr = malloc(lg + 3);

  if (! lexpr) return ("cannot allocate memory\n");

  ClearSelectionIfNeeded(buff);
  
  lexpr[0] = '{';
  strcpy(lexpr + 1, expr);
  lexpr[lg + 1] = '}';
  lexpr[lg + 2] = 0;
  
  yyinfilename = 0;
  i_buffer_courant = buff;
  yyin = 0;
  yyinflag = 0;
  i_minibuffer = lexpr;
  *err_msg = 0;
  i_curseur = i_curseur_sup = 0;
  numlig = 0;
  clear_ctrl_c();
  rerun_profile();
  
  if (! setjmp(come_back))
    load_file();

  stop_profile();
  i_buffer_courant = i_minibuffer = 0;
  i_curseur = i_curseur_sup = 0;
  free(lexpr);
  
  return check_parser_error();
}


/* appel d'une fonction ou non builtin, par exemple indent_line, s'il
   y a des arguments, ceux-ci ne peuvent etre que des int ou char */

char * ie_call_function(buff, fctname, narg, args)
     char * buff;
     char * fctname;
     int narg;
     int * args;
{
  ClearSelectionIfNeeded(buff);
  
  i_buffer_courant = buff;
  i_minibuffer = 0;
  yyin = 0;
  yyinflag = 0;
  *err_msg = 0;
  i_curseur = i_curseur_sup = 0;
  clear_ctrl_c();

  if (! setjmp(come_back)) {
    Identifier * ident = find_identifier(fctname);
    Function * fdef;

    if ((! ident) ||
	(! (fdef = Identifier__FunctionDef(ident)))) {
      sprintf(err_msg, "%s is not a function name", fctname);
      return err_msg;
    }
    else {
      accept_ctrl_c();
      rerun_profile();
      if (! setjmp(come_back))
	if (Function__IsBuiltin(fdef))
	  call_builtin_function_of_xcoral(fdef, narg);
	else
	  call_user_function_from_xcoral(fdef, narg, args);
      stop_profile();
      ignore_ctrl_c();
    }
  }
  
  i_buffer_courant = 0;
  i_curseur = i_curseur_sup = 0;
  
  Reinit_Control();
  Reinit_Error();
  Reinit_Stack();
  
  return (*err_msg) ? err_msg : 0;
}


/* Expansion d'un nom smac (pour eval expression) */

char * ExpandSmacName(s, n, common)
     char * s;
     int * n;
     int * common;
{
  char * result = 0;
  int rlength = 0;
  static HashItem * item = 0;
  static HashItem ** entry = 0;

  *n = 0;
  *common = strlen(s);
  
  while (HashTable_Iter(IdentifierHashTable, &item, &entry), item) {
    char * name = (char *) HashItem__Key(item);
    
    if (strstr(name, s) == name) {
      char * nresult =
	  (char *) malloc((unsigned int) rlength + strlen(name) + 3);
		 
      if (! nresult)
	return result;
	
      if (result) bcopy(result, nresult, rlength);
      strcpy(nresult + rlength, name);
      *n += 1;
      if (Identifier__FunctionDef((Identifier *) HashItem__Data(item))) {
	strcat(nresult + rlength, "()");
	rlength += strlen(name) + 3;
      }
      else
	rlength += strlen(name) + 1;
      if (result) free(result);
      result = nresult;
    }
  }

  if ((*n == 1) && (*(result + strlen(result) - 1) == ')'))
    *(result + strlen(result) - 1) = 0;
  
  return result;
}

/* Retourne la liste des fonctions definies, builtin ou non.

   Pour initialiser le processus init doit etre non nul,
   Les appels retourne un char * qui est le nom d'une fonction
   a chaque appel, 0 en fin de liste. Il ne doit pas y avoir
   de chargement/evaluation de code pendant le parcours */
   
char * ie_function_list(init)
     int init;
{
  static HashItem * item;
  static HashItem ** entry;
  
  if (init) {
    item = 0;
    entry = 0;
  }

  for (;;) {
    HashTable_Iter(IdentifierHashTable, &item, &entry);

    if (! item)
      return 0;
    else if (Identifier__FunctionDef((Identifier *) HashItem__Data(item)))
      return (char *) HashItem__Key(item);
  }
}


/* La meme chose pour les donnees (variables globales) */
   
char * ie_data_list(init)
     int init;
{
  static HashItem * item;
  static HashItem ** entry;
  
  if (init) {
    item = 0;
    entry = 0;
  }

  for (;;) {
    HashTable_Iter(IdentifierHashTable, &item, &entry);

    if (! item)
      return 0;
    else if (! Identifier__FunctionDef((Identifier *) HashItem__Data(item)))
      return (char *) HashItem__Key(item);
  }
}

     
/* ------------------------------------------------
   
   Les fonctions d'Xcoral appelees par l'interprete
   
   ------------------------------------------------ */

Object builtin_current_position(a)		/* la position courante */
     Instruction ** a;
{
  extern FCT(int, ie_current_position,(char *));
  Object result;

  ignore_ctrl_c();
  result = ie_current_position(i_buffer_courant);
  accept_ctrl_c();
  
  return result;
}

Object builtin_current_char(a)			/* le caractere courant */
     Instruction ** a;				/* 0 en fin de fichier  */
{
  extern FCT(char, ie_current_char,(char *));
  Object result;

  ignore_ctrl_c();
  result = ie_current_char(i_buffer_courant);
  accept_ctrl_c();
  
  return result;
}

Object builtin_previous_char(a)			/* le caractere precedant */
     Instruction ** a;				/* 0 en debut de fichier  */
{
  extern FCT(char, ie_previous_char,(char *));
  Object result;

  ignore_ctrl_c();
  result = ie_previous_char(i_buffer_courant);
  accept_ctrl_c();
  
  return result;
}

Object builtin_next_char(a)			/* le caractere suivant */
     Instruction ** a;				/* 0 en debut de fichier  */
{
  extern FCT(char, ie_next_char,(char *));
  Object result;

  ignore_ctrl_c();
  result = ie_next_char(i_buffer_courant);
  accept_ctrl_c();
  
  return result;
}

Object builtin_the_char(a)	/* le caractere correspondant a la position */
     Instruction ** a;		/* 0 en cas d'erreur  */
{
  extern FCT(char, ie_the_char,(char *, int));
  Object result = Eval(*a);

  ignore_ctrl_c();
  result = ie_the_char(i_buffer_courant, result);
  accept_ctrl_c();
  
  return result;
}
Object builtin_goto_previous_char(a)		/* recule d'un caractere */
     Instruction ** a;				/* si possible */
{
  extern FCT(void, ie_goto_previous_char,(char *));

  ignore_ctrl_c();
  ie_goto_previous_char(i_buffer_courant);
  accept_ctrl_c();
  return 0;
}

Object builtin_goto_next_char(a)		/* avance d'un caractere */
     Instruction ** a;				/* si possible */
{
  extern FCT(void, ie_goto_next_char,(char *));

  ignore_ctrl_c();
  ie_goto_next_char(i_buffer_courant);
  accept_ctrl_c();
  return 0;
}

Object builtin_goto_char(a)			/* change de position */
     Instruction ** a;				/* si possible */
{
  extern FCT(void, ie_goto_char,(char *, int));
  Object arg = Eval(*a);
  
  ignore_ctrl_c();
  ie_goto_char(i_buffer_courant, arg);
  accept_ctrl_c();
  return 0;
}

Object builtin_beginning_of_line(a)	/* la position du debut de ligne */
     Instruction ** a;
{
  extern FCT(int, ie_beginning_of_line,(char *));
  Object result;

  ignore_ctrl_c();
  result = ie_beginning_of_line(i_buffer_courant);
  accept_ctrl_c();
  
  return result;
}

Object builtin_goto_beginning_of_line(a)	/* va en debut de ligne */
     Instruction ** a;
{
  extern FCT(void, ie_goto_beginning_of_line,(char *));

  ignore_ctrl_c();
  ie_goto_beginning_of_line(i_buffer_courant);
  accept_ctrl_c();
  return 0;
}

Object builtin_end_of_line(a)		/* la position de la fin de ligne */
     Instruction ** a;
{
  extern FCT(int, ie_end_of_line,(char *));
  Object result;

  ignore_ctrl_c();
  result = ie_end_of_line(i_buffer_courant);
  accept_ctrl_c();
  
  return result;
}

Object builtin_goto_end_of_line(a)		/* va enfin de ligne */
     Instruction ** a;
{
  extern FCT(void, ie_goto_end_of_line,(char *));

  ignore_ctrl_c();
  ie_goto_end_of_line(i_buffer_courant);
  accept_ctrl_c();
  return 0;
}

Object builtin_at_end_of_file(a)			/* fin de fichier ? */
     Instruction ** a;
{
  extern FCT(int, ie_at_end_of_file,(char *));
  Object result;

  ignore_ctrl_c();
  result = ie_at_end_of_file(i_buffer_courant);
  accept_ctrl_c();
  
  return result;
}

Object builtin_end_of_file(a)		/* la position de la fin de fichier */
     Instruction ** a;
{
  extern FCT(int, ie_end_of_file,(char *));
  Object result;

  ignore_ctrl_c();
  result = ie_end_of_file(i_buffer_courant);
  accept_ctrl_c();
  
  return result;
}

Object builtin_goto_end_of_file(a)		/* va a la fin du fichier */
     Instruction ** a;
{
  extern FCT(void, ie_goto_end_of_file,(char *));

  ignore_ctrl_c();
  ie_goto_end_of_file(i_buffer_courant);
  accept_ctrl_c();
  return 0;
}

Object builtin_goto_previous_line(a)		/* remonte d'une ligne */
    Instruction ** a;
{
  extern FCT(void, ie_goto_beginning_of_line,(char *));
  extern FCT(void, ie_goto_next_char,(char *));
  extern FCT(void, ie_goto_previous_char,(char *));
  extern FCT(int, ie_current_position,(char *));
  extern FCT(char, ie_current_char,(char *));
  int col = ie_current_position(i_buffer_courant);
  
  ignore_ctrl_c();
  ie_goto_beginning_of_line(i_buffer_courant);
  if (ie_current_position(i_buffer_courant)) {
    col -= ie_current_position(i_buffer_courant);
    ie_goto_previous_char(i_buffer_courant);
    ie_goto_beginning_of_line(i_buffer_courant);
    while (col-- && (ie_current_char(i_buffer_courant) != '\n'))
      ie_goto_next_char(i_buffer_courant);
  }
  accept_ctrl_c();
  return 0;
}

Object builtin_goto_next_line(a)		/* descend d'une ligne */
    Instruction ** a;
{
  extern FCT(void, ie_goto_beginning_of_line,(char *));
  extern FCT(void, ie_goto_end_of_line,(char *));
  extern FCT(void, ie_goto_next_char,(char *));
  extern FCT(void, ie_goto_previous_char,(char *));
  extern FCT(int, ie_current_position,(char *));
  extern FCT(char, ie_current_char,(char *));
  int col = ie_current_position(i_buffer_courant);
  
  ignore_ctrl_c();
  ie_goto_beginning_of_line(i_buffer_courant);
  col -= ie_current_position(i_buffer_courant);
  ie_goto_end_of_line(i_buffer_courant);
  ie_goto_next_char(i_buffer_courant);
  while (col-- && (ie_current_char(i_buffer_courant) != '\n'))
    ie_goto_next_char(i_buffer_courant);
  accept_ctrl_c();
  return 0;
}

Object builtin_goto_line(a)			/* change de ligne */
    Instruction ** a;
{
  extern FCT(void, ie_goto_beginning_of_line,(char *));
  extern FCT(void, ie_goto_end_of_line,(char *));
  extern FCT(void, ie_goto_end_of_file,(char *));
  extern FCT(void, ie_goto_next_char,(char *));
  extern FCT(void, ie_goto_previous_char,(char *));
  extern FCT(void, ie_goto_char,(char *, int));
  extern FCT(int, ie_current_position,(char *));
  extern FCT(char, ie_current_char,(char *));
  extern FCT(int, ie_line_count,(char *));
  extern FCT(int, ie_current_line,(char *));
  int nline = Eval(*a);
  
  if ((nline >= 0) && 
      (nline < ie_line_count(i_buffer_courant)) &&
      (nline != ie_current_line(i_buffer_courant))) {
    int col = ie_current_position(i_buffer_courant);
  
    ignore_ctrl_c();
    ie_goto_beginning_of_line(i_buffer_courant);
    col -= ie_current_position(i_buffer_courant);
    
    if (nline < ie_current_line(i_buffer_courant))
      if (nline < (ie_current_line(i_buffer_courant) / 2)) {
        ie_goto_char(i_buffer_courant,0);
	while (nline--) {
	  ie_goto_end_of_line(i_buffer_courant);
	  ie_goto_next_char(i_buffer_courant);
	 }
      }
      else
	for (nline = ie_current_line(i_buffer_courant) - nline; nline--;) {
	  ie_goto_previous_char(i_buffer_courant);
	  ie_goto_beginning_of_line(i_buffer_courant);
	}
    else
      if (nline > ((nline + ie_line_count(i_buffer_courant)) / 2)) {
	ie_goto_end_of_file(i_buffer_courant);
	for (nline = ie_current_line(i_buffer_courant) - nline; nline--;) {
	  ie_goto_previous_char(i_buffer_courant);
	  ie_goto_beginning_of_line(i_buffer_courant);
	}
      }
      else
	for (nline -= ie_current_line(i_buffer_courant); nline--;) {
	  ie_goto_end_of_line(i_buffer_courant);
	  ie_goto_next_char(i_buffer_courant);
        }

    /* On est en debut de ligne, retourne a la colonne initiale */
    while (col-- && (ie_current_char(i_buffer_courant) != '\n'))
      ie_goto_next_char(i_buffer_courant);

    accept_ctrl_c();
  }
  
  return 0;
}

Object builtin_current_line_to_top(a)
    Instruction ** a;
{
  extern FCT(void, ie_current_line_to_top,(char *));

  ignore_ctrl_c();
  ie_current_line_to_top(i_buffer_courant);
  accept_ctrl_c();
  return 0;
}

Object builtin_current_line(a)
    Instruction ** a;
{
  extern FCT(int, ie_current_line,(char *));
  Object result;
  
  ignore_ctrl_c();
  result = ie_current_line(i_buffer_courant);
  accept_ctrl_c();
  
  return result;
}

Object builtin_line_count(a)
    Instruction ** a;
{
  extern FCT(int, ie_line_count,(char *));
  Object result;
  
  ignore_ctrl_c();
  result = ie_line_count(i_buffer_courant);
  accept_ctrl_c();
  
  return result;
}

Object builtin_insert_char(a)			/* insere et avance */
     Instruction ** a;
{
  extern FCT(void, ie_insert_char,(char *, int));
  Object arg = Eval(*a);

  ignore_ctrl_c();
  ie_insert_char(i_buffer_courant, arg);
  accept_ctrl_c();
  return 0;
}

Object builtin_insert_string(a)			/* insere et avance */
     Instruction ** a;
{
  extern FCT(void, ie_insert_char,(char *, int));
  char * str = (char *) Eval(*a);

  ignore_ctrl_c();
#ifdef RUNTIMECHECK
  check_strlen(str);
#endif
  while (*str)
    ie_insert_char(i_buffer_courant, *str++);
  accept_ctrl_c();
  return 0;
}

Object builtin_delete_char(a)			/* detruit caract */
     Instruction ** a;
{
  extern FCT(void, ie_delete_char,(char *));

  ignore_ctrl_c();
  ie_delete_char(i_buffer_courant);
  accept_ctrl_c();
  return 0;
}

Object builtin_replace_char(a)		/* remplace sans avancer */
     Instruction ** a;
{
  extern FCT(void, ie_replace_char,(char *, int));
  Object arg = Eval(*a);

  ignore_ctrl_c();
  ie_replace_char(i_buffer_courant, arg);
  accept_ctrl_c();
  return 0;
}

Object builtin_global_replace(a)
    Instruction ** a;
{
  extern FCT(int, ie_global_replace,(char *, char *, char *));
  char * before = (char *) Eval(a[0]);
  char * after = (char *) Eval(a[1]);
  Object result;

#ifdef RUNTIMECHECK
  check_strlen(before);
  check_strlen(after);
#endif
  ignore_ctrl_c();
  result = ie_global_replace(i_buffer_courant, before, after);
  accept_ctrl_c();

  return result;
}

Object builtin_redisplay(a)			/* reaffiche buff */
     Instruction ** a;
{
  extern FCT(void, ie_redisplay,(char *));

  ignore_ctrl_c();
  ie_redisplay(i_buffer_courant);
  accept_ctrl_c();
  return 0;
}

Object builtin_blink(a)				/* blink le caractere sous */
     Instruction ** a;				/* la position donnee */
{						/* en argument */
  extern FCT(void, ie_blink,(char *, int));
  Object arg = Eval(*a);

  ignore_ctrl_c();
  ie_blink(i_buffer_courant, arg);
  accept_ctrl_c();
  return 0;
}

Object builtin_cmd_shell(a)			/* system */
     Instruction ** a;
{
  extern FCT(int, ie_cmd_shell,(char *, char *));
  char * expr = (char *) Eval(*a);
  Object result;

#ifdef RUNTIMECHECK
  check_strlen(expr);
#endif
  ignore_ctrl_c();
  result = ie_cmd_shell(i_buffer_courant, expr);
  accept_ctrl_c();

  return result;
}

static Object strdup_end(s)
    char * s;
{
  Object result = (Object) ((s) ? RTCMalloc(strlen(s) + 1) : 0);
  
  if (result)
    strcpy((char *) result, s);
  
  accept_ctrl_c();
  return result;
}

Object builtin_cmd_shell_to_string(a)			/* system */
     Instruction ** a;
{
  extern FCT(char *, ie_shell_to_string,(char *, char *));
  char * expr = (char *) Eval(*a);

#ifdef RUNTIMECHECK
  check_strlen(expr);
#endif
  ignore_ctrl_c();
  return strdup_end(ie_shell_to_string(i_buffer_courant, expr));
}

Object builtin_msearch(a)			/* msearch(str, fin, sens)   */
						/* va sur le premier caract  */
     Instruction ** a;				/* appartenant a str qui est */
{						/* avant/apres fin           */
  extern FCT(int, ie_msearch,(char *, char *, int, int));
  char * expr = (char *) Eval(*a);
  int end = (int) Eval(a[1]);
  int sens = (int) Eval(a[2]);
  Object result;

#ifdef RUNTIMECHECK
  check_strlen(expr);
#endif
  ignore_ctrl_c();
  result = ie_msearch(i_buffer_courant, expr, end, sens);
  accept_ctrl_c();

  return result;
}


Object builtin_backward_search(a)
    Instruction ** a;
{
  extern FCT(int, ie_backward_search,(char *, char *));
  char * str = (char *) Eval(*a);
  Object result;

#ifdef RUNTIMECHECK
  check_strlen(str);
#endif
  ignore_ctrl_c();
  result = ie_backward_search(i_buffer_courant, str);
  accept_ctrl_c();

  return result;
}

Object builtin_forward_search(a)
    Instruction ** a;
{
  extern FCT(int, ie_forward_search,(char *, char *));
  char * str = (char *) Eval(*a);
  Object result;

#ifdef RUNTIMECHECK
  check_strlen(str);
#endif
  ignore_ctrl_c();
  result = ie_forward_search(i_buffer_courant, str);
  accept_ctrl_c();

  return result;
}



Object builtin_create_mode(a)
     Instruction ** a;
{
  extern FCT(void, ie_create_mode,(char *, char *));
  extern FCT(void, ie_set_mode_suffixes,(char *, char *, char *));
  extern FCT(void, ie_set_mode_font,(char *, char *, char *));
  char * nom_mode = (char *) Eval(a[0]);
  char * suffixes;
  char * police;

#ifdef RUNTIMECHECK
  check_strlen(nom_mode);
#endif
  
  if (IsaNotEnoughArg(a[1]))
    suffixes = police = 0;
  else {
    suffixes = (char *) Eval(a[1]);
#ifdef RUNTIMECHECK
    if (suffixes) check_strlen(suffixes);
#endif

    if (IsaNotEnoughArg(a[2]))
      police = 0;
    else {
      police = (char *) Eval(a[2]);
#ifdef RUNTIMECHECK
      if (police) check_strlen(police);
#endif
    }
  }

  ignore_ctrl_c();
  ie_create_mode(i_buffer_courant, nom_mode);
  if (suffixes) ie_set_mode_suffixes(i_buffer_courant, nom_mode, suffixes);
  if (police) ie_set_mode_font(i_buffer_courant, nom_mode, police);
  accept_ctrl_c();
  
  return 0;
}

Object builtin_set_mode_suffixes(a)
     Instruction ** a;
{
  extern FCT(void, ie_set_mode_suffixes,(char *, char *, char *));
  char * nom_mode = (char *) Eval(a[0]);
  char * suffixes = (char *) Eval(a[1]);

#ifdef RUNTIMECHECK
  check_strlen(nom_mode);
  check_strlen(suffixes);
#endif

  ignore_ctrl_c();
  ie_set_mode_suffixes(i_buffer_courant, nom_mode, suffixes);
  accept_ctrl_c();
  
  return 0;
}

Object builtin_set_mode_font(a)
     Instruction ** a;
{
  extern FCT(void, ie_set_mode_font,(char *, char *, char *));
  char * nom_mode = (char *) Eval(a[0]);
  char * font = (char *) Eval(a[1]);

#ifdef RUNTIMECHECK
  check_strlen(nom_mode);
  check_strlen(font);
#endif

  ignore_ctrl_c();
  ie_set_mode_font(i_buffer_courant, nom_mode, font);
  accept_ctrl_c();
  
  return 0;
}

Object builtin_set_mode(a)
    Instruction ** a;
{
  extern FCT(void, ie_set_mode,(char *, char *));
  char * nom_mode = (char *) Eval(a[0]);

#ifdef RUNTIMECHECK
  check_strlen(nom_mode);
#endif

  ignore_ctrl_c();
  ie_set_mode(i_buffer_courant, nom_mode);
  accept_ctrl_c();
  
  return 0;
}


Object builtin_key_def(a)
     Instruction ** a;
{
  extern FCT(void, ie_key_def,(char *, char *, char *, char *));
  char * nom_mode = (char *) Eval(a[0]);
  char * touches = (char *) Eval(a[1]);
  char * nom_fonc = (char *) Eval(a[2]);

#ifdef RUNTIMECHECK
  check_strlen(nom_mode);
  check_strlen(touches);
  if (nom_fonc) check_strlen(nom_fonc);
#endif

  ignore_ctrl_c();
  ie_key_def(i_buffer_courant, nom_mode, touches, nom_fonc);
  accept_ctrl_c();
  
  return 0;
}


Object builtin_last_key(a)			/* retourne le dernier */
     Instruction ** a;				/* caractere tape */
{
  extern FCT(int, ie_last_key,(char *));
  Object result;
  
  ignore_ctrl_c();
  result = ie_last_key(i_buffer_courant);
  accept_ctrl_c();

  return result;
}

Object builtin_set_font(a)
     Instruction ** a;
{
  extern FCT(void, ie_set_font,(char *, char *));
  char * nom_font = (char *) Eval(*a);

#ifdef RUNTIMECHECK
  check_strlen(nom_font);
#endif

  ignore_ctrl_c();
  ie_set_font(i_buffer_courant, nom_font);
  accept_ctrl_c();
  
  return 0;
}

Object builtin_read_file(a)
    Instruction ** a;
{
  extern FCT(int, ie_read_file,(char *, char *));
  char * filename = (char *) Eval(*a);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(filename);
#endif
  ignore_ctrl_c();
  result = ie_read_file(i_buffer_courant, filename);
  accept_ctrl_c();

  return result;
}

Object builtin_save_file(a)
    Instruction ** a;
{
  extern FCT(void, ie_save_file,(char *));
  
  ignore_ctrl_c();
  ie_save_file(i_buffer_courant);
  accept_ctrl_c();

  return 0;
}

Object builtin_write_file(a)
    Instruction ** a;
{
  extern FCT(void, ie_write_file,(char *, char *));
  char * filename = (char *) Eval(*a);
  
#ifdef RUNTIMECHECK
  check_strlen(filename);
#endif
  ignore_ctrl_c();
  ie_write_file(i_buffer_courant, filename);
  accept_ctrl_c();

  return 0;
}

Object builtin_current_buffer_is_modified(a)
    Instruction ** a;
{
  extern FCT(int, ie_current_buffer_is_modified,(char *));
  int result;
  
  ignore_ctrl_c();
  result = ie_current_buffer_is_modified(i_buffer_courant);
  accept_ctrl_c();

  return result;
}

Object builtin_insert_file(a)
    Instruction ** a;
{
  extern FCT(int, ie_insert_file,(char *, char *));
  char * filename = (char *) Eval(*a);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(filename);
#endif
  ignore_ctrl_c();
  result = ie_insert_file(i_buffer_courant, filename);
  accept_ctrl_c();

  return result;
}

Object builtin_filename(a)
    Instruction ** a;
{
  extern FCT(char *, ie_filename,(char *));
  
  ignore_ctrl_c();
  return strdup_end(ie_filename(i_buffer_courant));
}

Object builtin_current_mode(a)
    Instruction ** a;
{
  extern FCT(char *, ie_current_mode,(char *));
  
  ignore_ctrl_c();
  return strdup_end(ie_current_mode(i_buffer_courant));
}

Object builtin_window_height(a)
    Instruction ** a;
{
  extern FCT(int, ie_window_height,(char *));
  int result;
  
  ignore_ctrl_c();
  result = ie_window_height(i_buffer_courant);
  accept_ctrl_c();

  return result;
}

Object builtin_window_width(a)
    Instruction ** a;
{
  extern FCT(int, ie_window_width,(char *, char));
  char c = Eval(*a);
  int result;
  
  ignore_ctrl_c();
  result = ie_window_width(i_buffer_courant, c);
  accept_ctrl_c();

  return result;
}

Object builtin_file_select(a)
    Instruction ** a;
{
  extern FCT(char *, ie_file_select,(char *));
  
  ignore_ctrl_c();
  return strdup_end(ie_file_select(i_buffer_courant));
}

Object builtin_current_window(a)
    Instruction ** a;
{
  extern FCT(int, ie_current_window,(char *));
  int result;
  
  ignore_ctrl_c();
  result = ie_current_window(i_buffer_courant);
  accept_ctrl_c();

  return result;
}

Object builtin_select_window(a)
    Instruction ** a;
{
  extern FCT(char *, ie_select_window,(char *, int));
  int win = Eval(*a);
  char * selectedwindow;
  int result;
  
  ignore_ctrl_c();
  selectedwindow = ie_select_window(i_buffer_courant, win);
  if (selectedwindow) {
    i_buffer_courant = selectedwindow;
    result = win;
  }
  else
    result = -1;
  accept_ctrl_c();

  return result;
}

Object builtin_new_window(a)
    Instruction ** a;
{
  extern FCT(int, ie_new_window,(char *));
  int result;
  
  ignore_ctrl_c();
  result = ie_new_window(i_buffer_courant);
  accept_ctrl_c();

  return result;
}

Object builtin_kill_window(a)
    Instruction ** a;
{
  extern FCT(int, ie_kill_window,(char *, int));
  int win = Eval(*a);
  
  ignore_ctrl_c();
  ie_kill_window(i_buffer_courant, win);
  accept_ctrl_c();

  return 0;
}

Object builtin_kill_current_buffer(a)
    Instruction ** a;
{
  extern FCT(int, ie_kill_current_buffer,(char *));
  
  ignore_ctrl_c();
  ie_kill_current_buffer(i_buffer_courant);
  accept_ctrl_c();

  return 0;
}

Object builtin_lower_window(a)
    Instruction ** a;
{
  extern FCT(int, ie_lower_window,(char *));
  
  ignore_ctrl_c();
  ie_lower_window(i_buffer_courant);
  accept_ctrl_c();

  return 0;
}

Object builtin_raise_window(a)
    Instruction ** a;
{
  extern FCT(int, ie_raise_window,(char *));
  
  ignore_ctrl_c();
  ie_raise_window(i_buffer_courant);
  accept_ctrl_c();

  return 0;
}

static Object builtin_wprintf(a)
     Instruction ** a;
{
  extern FCT(void, ie_insert_char,(char *, int));
  int result = 0;
  char * fmt = (char *) Eval(*a);

#ifdef RUNTIMECHECK
  check_strlen(fmt);
#endif
  
  a += 1;

  while (*fmt) {
    if (*fmt == '%')
      switch (*++fmt) {
      case 0 :
	return result;
	
      case '%' :
	ie_insert_char(i_buffer_courant, '%');
	fmt += 1;
	break;
	
      default :
	{
	  char * begin = fmt - 1;
	  char save;

	  while (! strchr("diopuxXcs", *fmt))
	    if (! *fmt++)
	      return result;

	  save = *++fmt;
	  *fmt = 0;
	  if (*(fmt - 1) == 's') {
	    char * s = (char *)  Eval(*a);

	    if (s) {
	      int strlg;
	      int lg = 0;

#ifdef RUNTIMECHECK
	      strlg = check_strlen(s);
#else
	      strlg = strlen(s);
#endif
	      sscanf(begin + 1, "%d", &lg);
	      while (lg-- > strlg)
		ie_insert_char(i_buffer_courant, ' ');
	    }
	    else
	      s = "(null)";
	    while (*s) ie_insert_char(i_buffer_courant, *s++);
	  }
	  else {
	    char str[128];
	    char * s = str;
	    
	    sprintf(s, begin, Eval(*a));
	    while (*s) ie_insert_char(i_buffer_courant, *s++);
	  }
	  result += 1;
	  *fmt = save;
	  a += 1;
	}
      }
    else
      ie_insert_char(i_buffer_courant, *fmt++);
  }
  
  return result;
}

Object builtin_display_message(a)
    Instruction ** a;
{
  extern FCT(void, DisplayWMessage ,(char *, char *, int));
  
  char * msg = (char *) Eval(a[0]);
  char * from = "";
  int flag = 0;

#ifdef RUNTIMECHECK
    check_strlen(msg);
#endif
  
  if (! IsaNotEnoughArg(a[1])) {
    from = (char *) Eval(a[1]);
#ifdef RUNTIMECHECK
    check_strlen(from);
#endif

    if (! IsaNotEnoughArg(a[2]))
      flag = (int) Eval(a[2]);
  }
  
  DisplayWMessage(msg, from, flag);
  return 0;
}

/* Choix dans une liste */

static char ** item_list;
static item_list_size;
static int n_item;

Object builtin_select_from_list(a)
    Instruction ** a;
{
  extern FCT(void, ClearListBox ,());
  extern FCT(char *, FillList ,(char *));
  extern FCT(char *, SelectFromListBox ,(char *));
  char * str = (char *) Eval(*a);

#ifdef RUNTIMECHECK
  check_strlen(str);
#endif
  
  if (! n_item) return 0;
  
  ClearListBox();
  {
    int i;
    
    for (i = 0; i != n_item; i += 1)
      FillList(item_list[i]);
  }
  
  if (! (str = SelectFromListBox(str)))
    return 0;
  
  {
    char ** p = item_list;
    
    while (
#ifdef RUNTIMECHECK
	   check_strlen(*p),
#endif
	   strcmp(*p, str))
      p += 1;
    return (Object) *p;
  }
}

Object builtin_add_list_item(a)
    Instruction ** a;
{
  extern FCT(char *, FillList ,(char *));
  char * item = (char *) Eval(*a);

#ifdef RUNTIMECHECK
  check_strlen(item);
#endif
  
  FillList(item);
  if (n_item == item_list_size) {
    if (! item_list_size) {
      if (! (item_list = (char **) calloc(10, sizeof(char *))))
	Error("No more place");
      item_list_size = 10;
    }
    else {
      char ** nl = (char **) calloc(2 * item_list_size, sizeof(char *));
    
      if (! nl)
	Error("No more place");
      memcpy((char *) nl, (char *) item_list, item_list_size * sizeof(char *));
      free(item_list);
      item_list = nl;
      item_list_size *= 2;
    }
  }
  
  item_list[n_item++] = item;
  
  return 0;
}

Object builtin_clear_list(a)
    Instruction ** a;
{
  extern FCT(void, ClearListBox ,());
  
  ClearListBox();
  if (item_list) {
    free(item_list);
    item_list = 0;
    n_item = item_list_size = 0;
  }
  return 0;
}

/* */

Object builtin_getchar(a)
    Instruction ** a;
{
  char * prompt;
    
  extern FCT(char *, GetStringFromDB, (char * prompt, int one));
  char * str;
    
  if (IsaNotEnoughArg(*a))
    prompt = "getchar ? ";
  else {
    prompt = (char *) Eval(*a);
    
#ifdef RUNTIMECHECK
    check_strlen(prompt);
#endif
  }
  
  str = GetStringFromDB(prompt, 1);
  return (str) ? (Object) *str : (Object) 0;
}

Object builtin_gets(a)
    Instruction ** a;
{
  char * prompt;
  extern FCT(char *, GetStringFromDB, (char * prompt, int one));
    
  if (IsaNotEnoughArg(*a))
    prompt = "gets ? ";
  else {
    prompt = (char *) Eval(*a);
    
#ifdef RUNTIMECHECK
    check_strlen(prompt);
#endif
  }
  
  return strdup_end(GetStringFromDB(prompt, 0));
}



/* coloriage */

Object builtin_monochrome(a)
     Instruction ** a;
{
  extern FCT(int, ie_monochrome,(char *));

  return ie_monochrome(i_buffer_courant);
}

Object builtin_remove_colors(a)
     Instruction ** a;
{
  extern FCT(void, ie_remove_colors,(char *));

  ignore_ctrl_c();
  ie_remove_colors(i_buffer_courant);
  accept_ctrl_c();
  
  return 0;
}

Object builtin_color_area(a)
     Instruction ** a;
{
  extern FCT(void, ie_color_area,(char *, int, int, char *));
  int start = (int) Eval(a[0]);
  int end = (int) Eval(a[1]);
  char * color = (char *) Eval(a[2]);

#ifdef RUNTIMECHECK
  check_strlen(color);
#endif

  ignore_ctrl_c();
  ie_color_area(i_buffer_courant, start, end, color);
  accept_ctrl_c();
  
  return 0;
}


/* region */

Object builtin_mark_position(a)
     Instruction ** a;
{
  extern FCT(int, ie_mark_position,(char *));
  Object result;

  ignore_ctrl_c();
  result = ie_mark_position(i_buffer_courant);
  accept_ctrl_c();
  
  return result;
}

Object builtin_set_mark(a)
     Instruction ** a;
{
  extern FCT(void, ie_set_mark,(char *, int));
  int pos = (int) Eval(*a);
  
  ignore_ctrl_c();
  ie_set_mark(i_buffer_courant, pos);
  accept_ctrl_c();
  
  return 0;
}

Object builtin_goto_mark(a)
     Instruction ** a;
{
  extern FCT(void, ie_goto_mark,(char *));

  ignore_ctrl_c();
  ie_goto_mark(i_buffer_courant);
  accept_ctrl_c();
  
  return 0;
}

Object builtin_reset_mark(a)
     Instruction ** a;
{
  extern FCT(void, ie_reset_mark,(char *));

  ignore_ctrl_c();
  ie_reset_mark(i_buffer_courant);
  accept_ctrl_c();
  
  return 0;
}

Object builtin_cut_region(a)
     Instruction ** a;
{
  extern FCT(void, ie_cut_region,(char *));

  ignore_ctrl_c();
  ie_cut_region(i_buffer_courant);
  accept_ctrl_c();
  
  return 0;
}

Object builtin_copy_region(a)
     Instruction ** a;
{
  extern FCT(void, ie_copy_region,(char *));

  ignore_ctrl_c();
  ie_copy_region(i_buffer_courant);
  accept_ctrl_c();
  
  return 0;
}

Object builtin_paste_region(a)
     Instruction ** a;
{
  extern FCT(void, ie_paste_region,(char *));

  ignore_ctrl_c();
  ie_paste_region(i_buffer_courant);
  accept_ctrl_c();
  
  return 0;
}


/* expression regulieres */

Object builtin_re_search_forward(a)
    Instruction ** a;
{
  extern FCT(int, ie_re_search_forward,(char*, char *regex ));
  char * regex = (char *) Eval(*a);
  int result;

#ifdef RUNTIMECHECK
  check_strlen(regex);
#endif
  ignore_ctrl_c();
  result = ie_re_search_forward(i_buffer_courant, regex);
  accept_ctrl_c();
  
  return result;
}

Object builtin_re_search_backward(a)
    Instruction ** a;
{
  extern FCT(int, ie_re_search_backward,(char*, char * ));
  char * regex = (char *) Eval(*a);
  int result;

#ifdef RUNTIMECHECK
  check_strlen(regex);
#endif
  ignore_ctrl_c();
  result = ie_re_search_backward(i_buffer_courant, regex);
  accept_ctrl_c();
  
  return result;
}

Object builtin_re_replace(a)
    Instruction ** a;
{
  char * newstring = (char *) Eval(a[0]);
  int result;
  
#ifdef RUNTIMECHECK
  check_strlen(newstring);
#endif
  if (IsaNotEnoughArg(a[1])) {
    extern FCT(int, ie_re_replace_match, (char *, char *));
    
    ignore_ctrl_c();
    result = ie_re_replace_match(i_buffer_courant, newstring);
  }
  else {
    extern FCT(int, ie_re_replace, (char *, char *, char*));
    char * regex = (char *) Eval(a[1]);
    
#ifdef RUNTIMECHECK
    check_strlen(regex);
#endif
    ignore_ctrl_c();
    result = ie_re_replace(i_buffer_courant, regex, newstring);
  }
  accept_ctrl_c();
  
  return result;
}

Object builtin_re_match_beginning(a)
    Instruction ** a;
{
  extern FCT(int, ie_re_match_beginning,(char *, int));
  int n = (int) Eval(*a);
  int result;
  
  ignore_ctrl_c();
  result = ie_re_match_beginning(i_buffer_courant, n);
  accept_ctrl_c();
  
  return result;
}

Object builtin_re_match_end(a)
    Instruction ** a;
{
  extern FCT(int, ie_re_match_end,(char *, int));
  int n = (int) Eval(*a);
  int result;
  
  ignore_ctrl_c();
  result = ie_re_match_end(i_buffer_courant, n);
  accept_ctrl_c();
  
  return result;
}

/* la montre*/

Object builtin_watch_on(a)
    Instruction ** a;
{
  extern FCT(int, ie_watch_on,(char *));
  
  ignore_ctrl_c();
  ie_watch_on(i_buffer_courant);
  accept_ctrl_c();
  
  return 0;
}

Object builtin_watch_off(a)
    Instruction ** a;
{
  extern FCT(int, ie_watch_off,(char *));
  
  ignore_ctrl_c();
  ie_watch_off(i_buffer_courant);
  accept_ctrl_c();
  
  return 0;
}

/* La fonction usleep */
Object builtin_usleep(a)
    Instruction ** a;
{
  extern FCT(int, ie_usleep,(char *, int));
  int t = (int) Eval(*a);
  
  ignore_ctrl_c();
  ie_usleep(i_buffer_courant, t);
  accept_ctrl_c();
  
  return 0;
}

#ifndef LIONEL
#include "../result_types.h"
#include "../file_dict.h"
#include "../class_dict.h"
#include "../proc_dict.h"
#include "../global_dict.h"

/* le browser */

Object builtin_browser_set_pp(a)
    Instruction ** a;
{
  extern FCT(void, browser_set_pp,(char *, char *));
  char * mode = (char *) Eval(a[0]);
  char * path = (char *) Eval(a[1]);
#ifdef RUNTIMECHECK
  check_strlen(mode);
  check_strlen(path);
#endif

  browser_set_pp(mode, path);
  return 0;
}

Object builtin_browser_set_pp_options(a)
    Instruction ** a;
{
  extern FCT(void, browser_set_pp_options,(char *, char *));
  char * mode = (char *) Eval(a[0]);
  char * opt = (char *) Eval(a[1]);
#ifdef RUNTIMECHECK
  check_strlen(mode);
  check_strlen(opt);
#endif

  browser_set_pp_options(mode, opt);
  return 0;
}

Object builtin_browser_add(a)
    Instruction ** a;
{
  extern FCT(void, browser_add,(char *, int));
  char * file = (char *) Eval(a[0]);
#ifdef RUNTIMECHECK
  check_strlen(file);
#endif
  ignore_ctrl_c();
  browser_add(file, (IsaNotEnoughArg(a[1])) ? 0 : (int) Eval(a[1]));
  accept_ctrl_c();
  return 0;
}

Object builtin_browser_del(a)
    Instruction ** a;
{
  extern FCT(void, RemoveFiles,(char *));
  char * file = (char *) ((IsaNotEnoughArg(a[1])) ? 0 : (char *) Eval(a[0]));
#ifdef RUNTIMECHECK
  if (file)
    check_strlen(file);
#endif

  ignore_ctrl_c();
  RemoveFiles(file);
  accept_ctrl_c();
  return 0;
}

Object builtin_browser_class_file(a)
    Instruction ** a;
{
  extern FCT(char *, browser_class_file,(char *, int *));
  char * name = (char *) Eval(a[0]);
  int * p = (int *) ((IsaNotEnoughArg(a[1])) ? 0 : (int *) Eval(a[1]));
  char * file;
  int line;
  extern FCT(char *, browser_class_file,(char *, int *));
#ifdef RUNTIMECHECK
  extern FCT(Object, check_int_indirection_assignment,(int *, Object));
  
  check_strlen(name);
#endif
  
  ignore_ctrl_c();
  file = browser_class_file(name, &line);
 
  if (file) {
    if (p) {
#ifdef RUNTIMECHECK
      check_int_indirection_assignment(p, line - 1);
#else
      *p = line - 1;
#endif
    }
    return strdup_end(file);
  }
  
  accept_ctrl_c();
  return 0;
}

Object builtin_browser_class_parents(a)
    Instruction ** a;
{
  FCT(extern ParentRec **, get_parents_list,(char *, int));
  char * class_name = (char *) Eval(a[0]);
  ParentRec ** list;
  char ** result = 0;
  
#ifdef RUNTIMECHECK
  check_strlen(class_name);
#endif

  ignore_ctrl_c();
  if ((list = get_parents_list(class_name, 1)) != 0) {
    unsigned nentry;
    unsigned names_size = 0;
    
    for (nentry = 0; list[nentry]; nentry += 1)
      names_size += strlen(list[nentry]->_name) + 1;
  
    result = (char **) RTCMalloc(sizeof(char*) * (nentry * 2 + 1) + names_size);
    
    if (result) {
      char * p = (char *) &result[2 * nentry + 1];
      ParentRec ** l = list;
      
      for (nentry = 0; *l; nentry += 2, l += 1) {
	static scope_to_bits[] = {
	  0,	/* UNKNOWN_SCOPE */
	  4,	/* PUBLIC_SCOPE */
	  2,	/* PROTECTED_SCOPE */
	  1	/* PRIVATE_SCOPE */
	};
	result[nentry] = p;
	strcpy(p, (*l)->_name);
	p += strlen((*l)->_name) + 1;
	*((int *) &result[nentry + 1]) = scope_to_bits[(*l)->_scope];
      }
      result[nentry] = 0;
    }
  }
  
  free(list);
  accept_ctrl_c();
  return (Object) result;
}

Object builtin_browser_class_children(a)
    Instruction ** a;
{
  extern FCT(char **, get_sons_list,(char *));
  char * class_name = (char *) Eval(a[0]);
  char ** list;
  char ** result = 0;
  
#ifdef RUNTIMECHECK
  check_strlen(class_name);
#endif
  
  ignore_ctrl_c();
  if ((list = get_sons_list(class_name)) != 0) {
    unsigned nentry;
    unsigned names_size = 0;
    
    for (nentry = 0; list[nentry]; nentry += 1)
      names_size += strlen(list[nentry]) + 1;
  
    result = (char **) RTCMalloc(sizeof(char*) * (nentry + 1) + names_size);
    
    if (result) {
      char * p = (char *) &result[nentry + 1];
      
      for (nentry = 0; list[nentry]; nentry += 1) {
	result[nentry] = p;
	strcpy(p, list[nentry]);
	p += strlen(list[nentry]) + 1;
      }
      result[nentry] = 0;
    }
  }
  
  free(list);
  accept_ctrl_c();
  return (Object) result;
}

Object builtin_browser_class_methods(a)
    Instruction ** a;
{
  FCT(extern StringTable*, get_methods_list,(char *, int));
  extern MethodRec* marked_list;
  extern int marked_count;
  char * result = (char *) Eval(a[0]);
  
#ifdef RUNTIMECHECK
  check_strlen(result);
#endif
  
  ignore_ctrl_c();
  {
    StringTable* x = get_methods_list(result, 0);
    
    if (x) {
      char * declfile = marked_list->_decl_file->_name;
      char * lastfile;
      unsigned strsize = strlen(declfile) + 1;
      MethodRec* list;
      unsigned i;

      free(x);
      
      lastfile = declfile;
      i = marked_count;
      list = marked_list;
      while (i--) {
	char * ifile;
	
	strsize += strlen(list->_name) + METHOD_PLENGTH + 1;
	if (list->_impl_file &&
	    strcmp(ifile = list->_impl_file->_name, declfile) &&
	    strcmp(ifile, lastfile)) {
	  strsize += strlen(ifile) + 1;
	  lastfile = ifile;
	}
	list = list->_next_marked;
      }
      if ((result = RTCMalloc((marked_count * 5 + 2) * sizeof(char *) + 
			      strsize))
	  != 0) {
	char * pdeclfile = (char *) &((char **) result)[marked_count * 5 + 2];
	char * plastfile;
	char * p;
	unsigned index = 1;
	
	lastfile = declfile;
	i = marked_count;
	list = marked_list;
	strcpy(pdeclfile, declfile);
	p = pdeclfile + strlen(declfile) + 1;
	((char **) result)[0] = pdeclfile;
	while (i--) {
	  char * ifile;
	
	  ((char **) result)[index] = p;
	  strcpy(p, list->_name - METHOD_PLENGTH);
	  p += strlen(list->_name) + METHOD_PLENGTH + 1;
	  *((int *) &((char **) result)[index + 1]) = list->_decl_line - 1;
	  *((int *) &((char **) result)[index + 2]) = list->_decl;
	  if (! list->_impl_file)
	    ((char **) result)[index + 3] = 0;
	  else {
	    if (! strcmp(ifile = list->_impl_file->_name, declfile))
	      ((char **) result)[index + 3] = pdeclfile;
	    else if (! strcmp(ifile, lastfile))
	      ((char **) result)[index + 3] = plastfile;
	    else {
	      ((char **) result)[index + 3] = p;
	      strcpy(p, ifile);
	      plastfile = p;
	      p += strlen(ifile) + 1;
	      lastfile = ifile;
	    }
	    *((int *) &((char **) result)[index + 4]) = list->_impl_line - 1;
	  }
	  index += 5;
	  {
	    MethodRec* next = list->_next_marked;
	    
	    list->_next_marked = 0;
	    list = next;
	  }
	}
	((char **) result)[index] = 0;
      }
    }
    else
      result = 0;
  }
  
  accept_ctrl_c();
  return (Object) result;
}

Object builtin_browser_class_attributes(a)
    Instruction ** a;
{
  FCT(extern StringTable*, get_attributes_list,(char *, int));
  extern AttributeRec* marked_attr_list;
  extern int marked_attr_count;
  char * result = (char *) Eval(a[0]);
  
#ifdef RUNTIMECHECK
  check_strlen(result);
#endif
  
  ignore_ctrl_c();
  {
    StringTable* x = get_attributes_list(result, 0);
    
    if (x) {
      char * declfile = marked_attr_list->_decl_file->_name;
      unsigned strsize = strlen(declfile) + 1;
      AttributeRec* list;
      unsigned i;

      free(x);
      
      i = marked_attr_count;
      list = marked_attr_list;
      while (i--) {
	strsize += strlen(list->_name) + ATTRIBUTE_PLENGTH + 1;
	list = list->_next_marked;
      }
      
      if ((result = RTCMalloc((marked_attr_count * 3 + 2) * sizeof(char *) + 
			      strsize))
	  != 0) {
	char * p = (char *) &((char **) result)[marked_attr_count * 3 + 2];
	unsigned index = 1;
	
	i = marked_attr_count;
	list = marked_attr_list;
	strcpy(p, declfile);
	((char **) result)[0] = p;
	p += strlen(declfile) + 1;
	while (i--) {
	  ((char **) result)[index] = p;
	  strcpy(p, list->_name - ATTRIBUTE_PLENGTH);
	  p += strlen(list->_name) + ATTRIBUTE_PLENGTH + 1;
	  *((int *) &((char **) result)[index + 1]) = list->_decl_line - 1;
	  *((int *) &((char **) result)[index + 2]) = list->_decl;
	  index += 3;
	  {
	    AttributeRec* next = list->_next_marked;
	    
	    list->_next_marked = 0;
	    list = next;
	  }
	}
	((char **) result)[index] = 0;
      }
    }
    else
      result = 0;
  }
  
  accept_ctrl_c();
  return (Object) result;
}

Object builtin_browser_class_flags(a)
    Instruction ** a;
{
  extern FCT(char *, browser_class_flags,(char *));
  char * class_name = (char *) Eval(a[0]);
  
#ifdef RUNTIMECHECK
  check_strlen(class_name);
#endif

  ignore_ctrl_c();
  return strdup_end(browser_class_flags(class_name));
}

Object builtin_browser_functions(a)
    Instruction ** a;
{
  extern FCT(ProcRec **, get_procs_list,(char *));
  char * prefix = (char *) Eval(a[0]);
  ProcRec ** list;
  char ** result;
  
#ifdef RUNTIMECHECK
  check_strlen(prefix);
#endif

  ignore_ctrl_c();
  if ((list = get_procs_list(prefix)) != 0) {
    ProcRec ** l;
    unsigned n;
    unsigned strsize = 0;
    
    for (n = 0, l = list; *l; l += 1, n += 1) {
      strsize += strlen((*l)->_name) + PROC_PLENGTH + 1;
      if ((*l)->_impl_file) {
	ProcRec ** sl;
	
	for (sl = list; sl != l; sl += 1)
	  if ((*sl)->_impl_file &&
	      (! strcmp((*l)->_impl_file->_name, (*sl)->_impl_file->_name)))
	    break;
	if (sl == l)
	  strsize += strlen((*l)->_impl_file->_name) + 1;
      }
    }
    if ((result = (char **) RTCMalloc((n * 3 + 1) * sizeof(char *) + strsize))
	!= 0) {
      char * p = (char *) &result[n * 3 + 1];
      
      for (n = 0, l = list; *l; l += 1, n += 3) {
	result[n] = p;
	strcpy(p, (*l)->_name - PROC_PLENGTH);
	p += strlen((*l)->_name) + PROC_PLENGTH + 1;
	if ((*l)->_impl_file) {
	  unsigned i;
	
	  for (i = 0; i != n; i += 3)
	    if (result[i + 1] &&
		(! strcmp(result[i + 1], (*l)->_impl_file->_name)))
	      break;
	  if (i == n) {
	    result[n + 1] = p;
	    strcpy(p, (*l)->_impl_file->_name);
	    p += strlen((*l)->_impl_file->_name) + 1;
	  }
	  else
	    result[n + 1] = result[i + 1];
	  *((int *) &result[n + 2]) = (*l)->_impl_line;
	}
	else
	  result[n + 1] = 0;
      }
      result[n] = 0;
    }
  }
  else
    result = 0;
  
  accept_ctrl_c();
  return (Object) result;
}

Object builtin_browser_globals(a)
    Instruction ** a;
{
  extern FCT(GlobalRec **, get_globals_list,(char *));
  char * prefix = (char *) Eval(a[0]);
  GlobalRec ** list;
  char ** result;
  
#ifdef RUNTIMECHECK
  check_strlen(prefix);
#endif

  ignore_ctrl_c();
  if ((list = get_globals_list(prefix)) != 0) {
    GlobalRec ** l;
    unsigned n;
    unsigned strsize = 0;
    
    for (n = 0, l = list; *l; l += 1, n += 1) {
      strsize += strlen((*l)->_name) + GLOBAL_PLENGTH + 1;
      if ((*l)->_impl_file) {
	GlobalRec ** sl;
	
	for (sl = list; sl != l; sl += 1)
	  if ((*sl)->_impl_file &&
	      (! strcmp((*l)->_impl_file->_name, (*sl)->_impl_file->_name)))
	    break;
	if (sl == l)
	  strsize += strlen((*l)->_impl_file->_name) + 1;
      }
    }
    if ((result = (char **) RTCMalloc((n * 3 + 1) * sizeof(char *) + strsize))
	!= 0) {
      char * p = (char *) &result[n * 3 + 1];
      
      for (n = 0, l = list; *l; l += 1, n += 3) {
	result[n] = p;
	strcpy(p, (*l)->_name - GLOBAL_PLENGTH);
	p += strlen((*l)->_name) + GLOBAL_PLENGTH + 1;
	if ((*l)->_impl_file) {
	  unsigned i;
	
	  for (i = 0; i != n; i += 3)
	    if (result[i + 1] &&
		(! strcmp(result[i + 1], (*l)->_impl_file->_name)))
	      break;
	  if (i == n) {
	    result[n + 1] = p;
	    strcpy(p, (*l)->_impl_file->_name);
	    p += strlen((*l)->_impl_file->_name) + 1;
	  }
	  else
	    result[n + 1] = result[i + 1];
	  *((int *) &result[n + 2]) = (*l)->_impl_line;
	}
	else
	  result[n + 1] = 0;
      }
      result[n] = 0;
    }
  }
  else
    result = 0;
  
  accept_ctrl_c();
  return (Object) result;
}

Object builtin_browser_select_class(a)
    Instruction ** a;
{
  extern FCT(int, browser_select_class,(char *));
  char * prefix = (char *) Eval(a[0]);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(prefix);
#endif

  ignore_ctrl_c();
  result = (Object) browser_select_class(prefix);
  accept_ctrl_c();
  return result;
}

Object builtin_browser_select_method(a)
    Instruction ** a;
{
  extern FCT(int, browser_select_method,(char *));
  char * prefix = (char *) Eval(a[0]);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(prefix);
#endif

  ignore_ctrl_c();
  result = (Object) browser_select_method(prefix);
  accept_ctrl_c();
  return result;
}

Object builtin_browser_select_attribute(a)
    Instruction ** a;
{
  extern FCT(int, browser_select_attribute,(char *));
  char * prefix = (char *) Eval(a[0]);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(prefix);
#endif

  ignore_ctrl_c();
  result = (Object) browser_select_attribute(prefix);
  accept_ctrl_c();
  return result;
}

Object builtin_browser_select_function(a)
    Instruction ** a;
{
  extern FCT(int, browser_select_proc,(char *));
  char * prefix = (char *) Eval(a[0]);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(prefix);
#endif

  ignore_ctrl_c();
  result = (Object) browser_select_proc(prefix);
  accept_ctrl_c();
  return result;
}

Object builtin_browser_select_global(a)
    Instruction ** a;
{
  extern FCT(int, browser_select_global,(char *));
  char * prefix = (char *) Eval(a[0]);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(prefix);
#endif

  ignore_ctrl_c();
  result = (Object) browser_select_global(prefix);
  accept_ctrl_c();
  return result;
}

Object builtin_browser_edit(a)
    Instruction ** a;
{
  extern FCT(void, ButtonEdit,());
  extern FCT(void, DisplayBrowserIfNeverMap,());
  
  ignore_ctrl_c();
  DisplayBrowserIfNeverMap();
  ButtonEdit();
  accept_ctrl_c();
  return 0;
}

Object builtin_browser_class_entry(a)
    Instruction ** a;
{
  extern FCT(int, browser_class_entry,(char *));
  char * prefix = (char *) Eval(a[0]);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(prefix);
#endif

  ignore_ctrl_c();
  result = (Object) browser_class_entry(prefix);
  accept_ctrl_c();
  return result;
}

Object builtin_browser_function_entry(a)
    Instruction ** a;
{
  extern FCT(int, browser_function_entry,(char *));
  char * prefix = (char *) Eval(a[0]);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(prefix);
#endif

  ignore_ctrl_c();
  result = (Object) browser_function_entry(prefix);
  accept_ctrl_c();
  return result;
}

Object builtin_browser_global_entry(a)
    Instruction ** a;
{
  extern FCT(int, browser_global_entry,(char *));
  char * prefix = (char *) Eval(a[0]);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(prefix);
#endif

  ignore_ctrl_c();
  result = (Object) browser_global_entry(prefix);
  accept_ctrl_c();
  return result;
}

Object builtin_browser_file_entry(a)
    Instruction ** a;
{
  extern FCT(int, browser_file_entry,(char *));
  char * prefix = (char *) Eval(a[0]);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(prefix);
#endif

  ignore_ctrl_c();
  result = (Object) browser_file_entry(prefix);
  accept_ctrl_c();
  return result;
}

Object builtin_browser_class(a)
    Instruction ** a;
{
  extern FCT(char *, browser_class,(int));
  int n = (int) Eval(a[0]);
  
  ignore_ctrl_c();
  return strdup_end(browser_class(n));
}

Object builtin_browser_function(a)
    Instruction ** a;
{
  extern FCT(char *, browser_function,(int));
  int n = (int) Eval(a[0]);
  
  ignore_ctrl_c();
  return strdup_end(browser_function(n));
}

Object builtin_browser_global(a)
    Instruction ** a;
{
  extern FCT(char *, browser_global,(int));
  int n = (int) Eval(a[0]);
  
  ignore_ctrl_c();
  return strdup_end(browser_global(n));
}

Object builtin_browser_file(a)
    Instruction ** a;
{
  extern FCT(char *, browser_file,(int));
  int n = (int) Eval(a[0]);
  
  ignore_ctrl_c();
  return strdup_end(browser_file(n));
}

Object builtin_browser_dump(a)
    Instruction ** a;
{
  extern FCT(int, browser_dump,(char *));
  char * fn = (char *) Eval(a[0]);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(fn);
#endif

  ignore_ctrl_c();
  result = (Object) browser_dump(fn);
  accept_ctrl_c();
  
  return result;
}

Object builtin_browser_restore(a)
    Instruction ** a;
{
  extern FCT(int, browser_restore,(char *));
  char * fn = (char *) Eval(a[0]);
  Object result;
  
#ifdef RUNTIMECHECK
  check_strlen(fn);
#endif

  ignore_ctrl_c();
  result = (Object) browser_restore(fn);
  accept_ctrl_c();
  
  return result;
}

Object builtin_browser_show_all(a)
    Instruction ** a;
{
  extern FCT(void, browser_show_all,());
  extern FCT(void, RefreshBrowserInfos,());
  
  ignore_ctrl_c();
  browser_show_all();
  RefreshBrowserInfos();
  accept_ctrl_c();
  
  return 0;
}

static Object builtin_browser_hide_x(x)
    unsigned x;
{
  extern FCT(void, RefreshBrowserInfos,());
  
  ignore_ctrl_c();
  if (! (Hide_Bits & x)) {
    Hide_Bits |= x;
    RefreshBrowserInfos();
  }
  accept_ctrl_c();
  
  return 0;
}

static Object builtin_browser_show_x(x)
    unsigned x;
{
  extern FCT(void, RefreshBrowserInfos,());
  
  ignore_ctrl_c();
  if (Hide_Bits & x) {
    Hide_Bits &= ~x;
    RefreshBrowserInfos();
  }
  accept_ctrl_c();
  
  return 0;
}

Object builtin_browser_hide_private_members(a)
    Instruction ** a;
{
  return builtin_browser_hide_x(HidePrivate);
}

Object builtin_browser_hide_protected_and_private_members(a)
    Instruction ** a;
{
  extern FCT(void, RefreshBrowserInfos,());
  
  ignore_ctrl_c();
  if ((Hide_Bits & (HidePrivate | HideProtected)) !=
      (HidePrivate | HideProtected)) {
    Hide_Bits |= HidePrivate | HideProtected;
    RefreshBrowserInfos();
  }
  accept_ctrl_c();
  
  return 0;
}

Object builtin_browser_show_protected_and_private_members(a)
    Instruction ** a;
{
  return builtin_browser_show_x(HidePrivate | HideProtected);
}

Object builtin_browser_hide_inherited_members(a)
    Instruction ** a;
{
  return builtin_browser_hide_x(HideInherited);
}

Object builtin_browser_show_inherited_members(a)
    Instruction ** a;
{
  return builtin_browser_show_x(HideInherited);
}

Object builtin_browser_hide_internal_types(a)
    Instruction ** a;
{
  return builtin_browser_hide_x(HideInternalTypes);
}

Object builtin_browser_show_internal_types(a)
    Instruction ** a;
{
  return builtin_browser_show_x(HideInternalTypes);
}

Object builtin_browser_hide_static_functions(a)
    Instruction ** a;
{
  return builtin_browser_hide_x(HideStaticFunctions);
}

Object builtin_browser_show_static_functions(a)
    Instruction ** a;
{
  return builtin_browser_show_x(HideStaticFunctions);
}

Object builtin_browser_hide_static_globals(a)
    Instruction ** a;
{
  return builtin_browser_hide_x(HideStaticGlobals);
}

Object builtin_browser_show_static_globals(a)
    Instruction ** a;
{
  return builtin_browser_show_x(HideStaticGlobals);
}

Object builtin_browser_hide_children_of(a)
    Instruction ** a;
{
  extern FCT(void, RefreshBrowserInfos,());
  extern FCT(ClassRec *, find_class,(char *));
  char * name = (char *) Eval(a[0]);
  ClassRec * obj;
  
#ifdef RUNTIMECHECK
  check_strlen(name);
#endif
  
  ignore_ctrl_c();
  if (((obj = find_class(name)) != 0) && (! (obj->_hide & HideChildrenOf))) {
    obj->_hide |= HideChildrenOf;
    RefreshBrowserInfos();
  }
  accept_ctrl_c();
  
  return 0;
}

Object builtin_browser_show_children_of(a)
    Instruction ** a;
{
  extern FCT(void, RefreshBrowserInfos,());
  extern FCT(ClassRec *, find_class,(char *));
  char * name = (char *) Eval(a[0]);
  ClassRec * obj;
  
#ifdef RUNTIMECHECK
  check_strlen(name);
#endif
  
  ignore_ctrl_c();
  if (((obj = find_class(name)) != 0) && (obj->_hide & HideChildrenOf)) {
    obj->_hide &= ~HideChildrenOf;
    RefreshBrowserInfos();
  }
  accept_ctrl_c();
  
  return 0;
}

Object builtin_browser_hide_class(a)
    Instruction ** a;
{
  extern FCT(void, RefreshBrowserInfos,());
  extern FCT(ClassRec *, find_class,(char *));
  char * name = (char *) Eval(a[0]);
  ClassRec * obj;
  
#ifdef RUNTIMECHECK
  check_strlen(name);
#endif
  
  ignore_ctrl_c();
  if (((obj = find_class(name)) != 0) && (! (obj->_hide & UserHide))) {
    obj->_hide |= UserHide;
    RefreshBrowserInfos();
  }
  accept_ctrl_c();
  
  return 0;
}

Object builtin_browser_show_class(a)
    Instruction ** a;
{
  extern FCT(void, RefreshBrowserInfos,());
  extern FCT(ClassRec *, find_class,(char *));
  char * name = (char *) Eval(a[0]);
  ClassRec * obj;
  
#ifdef RUNTIMECHECK
  check_strlen(name);
#endif
  
  ignore_ctrl_c();
  if (((obj = find_class(name)) != 0) && (obj->_hide & UserHide)) {
    obj->_hide &= ~UserHide;
    RefreshBrowserInfos();
  }
  accept_ctrl_c();
  
  return 0;
}

Object builtin_browser_show_global(a)
    Instruction ** a;
{
  extern FCT(void, RefreshBrowserInfos,());
  extern FCT(GlobalRec *, find_global,(char *));
  char * name = (char *) Eval(a[0]);
  GlobalRec * obj;
  
#ifdef RUNTIMECHECK
  check_strlen(name);
#endif
  
  ignore_ctrl_c();
  if (((obj = find_global(name)) != 0) && (obj->_hide & UserHide)) {
    obj->_hide &= ~UserHide;
    RefreshBrowserInfos();
  }
  accept_ctrl_c();
  
  return 0;
}

Object builtin_browser_hide_global(a)
    Instruction ** a;
{
  extern FCT(void, RefreshBrowserInfos,());
  extern FCT(GlobalRec *, find_global,(char *));
  char * name = (char *) Eval(a[0]);
  GlobalRec * obj;
  
#ifdef RUNTIMECHECK
  check_strlen(name);
#endif
  
  ignore_ctrl_c();
  if (((obj = find_global(name)) != 0) && (! (obj->_hide & UserHide))) {
    obj->_hide |= UserHide;
    RefreshBrowserInfos();
  }
  accept_ctrl_c();
  
  return 0;
}

Object builtin_browser_show_function(a)
    Instruction ** a;
{
  extern FCT(void, RefreshBrowserInfos,());
  extern FCT(ProcRec *, find_proc,(char *));
  char * name = (char *) Eval(a[0]);
  ProcRec * obj;
  
#ifdef RUNTIMECHECK
  check_strlen(name);
#endif
  
  ignore_ctrl_c();
  if (((obj = find_proc(name)) != 0) && (obj->_hide & UserHide)) {
    obj->_hide &= ~UserHide;
    RefreshBrowserInfos();
  }
  accept_ctrl_c();
  
  return 0;
}

Object builtin_browser_hide_function(a)
    Instruction ** a;
{
  extern FCT(void, RefreshBrowserInfos,());
  extern FCT(ProcRec *, find_proc,(char *));
  char * name = (char *) Eval(a[0]);
  ProcRec * obj;
  
#ifdef RUNTIMECHECK
  check_strlen(name);
#endif
  
  ignore_ctrl_c();
  if (((obj = find_proc(name)) != 0) && (! (obj->_hide & UserHide))) {
    obj->_hide |= UserHide;
    RefreshBrowserInfos();
  }
  accept_ctrl_c();
  
  return 0;
}
#endif

/* */

void Init_Smac_Xcoral()
{
  static Type * string_int_int[3];
  static Type * string_string_string[3];
  static Type * string_string_int[3];
  static Type * int_int_string[3];
    
  string_string_int[0] = string_string_int[1] = Type_String;
  string_string_int[2] = Type_Int;
  
  string_string_string[0] =
      string_string_string[1] =
	  string_string_string[2] = Type_String;
    
  string_int_int[0] = Type_String;
  string_int_int[1] = string_int_int[2] = Type_Int;
  
  int_int_string[0] = int_int_string[1] = Type_Int;
  int_int_string[2] = Type_String;
    
  new_builtin("current_position", Type_Int, 0, 0, builtin_current_position);
  new_builtin("current_char", Type_Char, 0, 0, builtin_current_char);
  new_builtin("previous_char", Type_Char, 0, 0, builtin_previous_char);
  new_builtin("next_char", Type_Char, 0, 0, builtin_next_char);
  new_builtin("the_char", Type_Char, 1, &Type_Int, builtin_the_char);
  new_builtin("goto_previous_char", Type_Void, 0, 0, builtin_goto_previous_char);
  new_builtin("goto_next_char", Type_Void, 0, 0, builtin_goto_next_char);
  new_builtin("goto_char", Type_Void, 1, &Type_Int, builtin_goto_char);
  new_builtin("beginning_of_line", Type_Int, 0, 0, builtin_beginning_of_line);
  new_builtin("goto_beginning_of_line", Type_Void, 0, 0, builtin_goto_beginning_of_line);
  new_builtin("end_of_line", Type_Int, 0, 0, builtin_end_of_line);
  new_builtin("goto_end_of_line", Type_Void, 0, 0, builtin_goto_end_of_line);
  new_builtin("at_end_of_file", Type_Int, 0, 0, builtin_at_end_of_file);
  new_builtin("end_of_file", Type_Int, 0, 0, builtin_end_of_file);
  new_builtin("goto_end_of_file", Type_Void, 0, 0, builtin_goto_end_of_file);
  new_builtin("goto_previous_line", Type_Void, 0, 0, builtin_goto_previous_line);
  new_builtin("goto_next_line", Type_Void, 0, 0, builtin_goto_next_line);
  new_builtin("goto_line", Type_Void, 1, &Type_Int, builtin_goto_line);
  new_builtin("current_line_to_top", Type_Void, 0, 0, builtin_current_line_to_top);
  new_builtin("line_count", Type_Int, 0, 0, builtin_line_count);
  new_builtin("current_line", Type_Int, 0, 0, builtin_current_line);
  new_builtin("insert_char", Type_Void, 1, &Type_Char, builtin_insert_char);
  new_builtin("insert_string", Type_Void, 1, &Type_String, builtin_insert_string);
  new_builtin("delete_char", Type_Void, 0, 0, builtin_delete_char);
  new_builtin("replace_char", Type_Void, 1, &Type_Char, builtin_replace_char);
  new_builtin("redisplay", Type_Void, 0, 0, builtin_redisplay);
  new_builtin("blink", Type_Void, 1, &Type_Int, builtin_blink);
  
  new_builtin("cmd_shell", Type_Int, 1, &Type_String, builtin_cmd_shell);
  new_builtin("cmd_shell_to_string", Type_String, 1, &Type_String,
	      builtin_cmd_shell_to_string);

  new_builtin("msearch", Type_Int, 3, string_int_int, builtin_msearch);
  new_builtin("backward_search", Type_Int, 1, &Type_String,
	      builtin_backward_search);
  new_builtin("forward_search", Type_Int, 1, &Type_String,
	      builtin_forward_search);
  new_builtin("global_replace", Type_Int, 2, string_string_string,
	      builtin_global_replace);

  HashTable__Add(builtin_fct_nbre_arg_min,
		 new_builtin("create_mode", Type_Void,
			     3, string_string_string,
			     builtin_create_mode),
		 1 + 1);
  new_builtin("set_mode_suffixes", Type_Void, 2, string_string_string,
	      builtin_set_mode_suffixes);
  new_builtin("set_mode_font", Type_Void, 2, string_string_string,
	      builtin_set_mode_font);
  new_builtin("key_def", Type_Void, 3, string_string_string,
	      builtin_key_def);
  new_builtin("set_mode", Type_Void, 1, &Type_String,
	      builtin_set_mode);

  new_builtin("last_key", Type_Int, 0, 0, builtin_last_key);

  new_builtin("set_font", Type_Void, 1, &Type_String, builtin_set_font);
  
  new_builtin("read_file", Type_Int, 1, &Type_String, builtin_read_file);
  new_builtin("save_file", Type_Void, 0, 0, builtin_save_file);
  new_builtin("write_file", Type_Void, 1, &Type_String, builtin_write_file);
  new_builtin("filename", Type_String, 0, 0, builtin_filename);
  new_builtin("insert_file", Type_Int, 1, &Type_String, builtin_insert_file);
  new_builtin("window_height", Type_Int, 0, 0, builtin_window_height);
  new_builtin("window_width", Type_Int, 1, &Type_Char, builtin_window_width);
  new_builtin("file_select", Type_String, 0, 0, builtin_file_select);
  new_builtin("current_window", Type_Int, 0, 0, builtin_current_window);
  new_builtin("select_window", Type_Int, 1, &Type_Int, builtin_select_window);
  new_builtin("new_window", Type_Int, 0, 0, builtin_new_window);
  new_builtin("kill_window", Type_Void, 1, &Type_Int, builtin_kill_window);
  new_builtin("kill_current_buffer", Type_Void, 0, 0, builtin_kill_current_buffer);
  new_builtin("lower_window", Type_Void, 0, 0, builtin_lower_window);
  new_builtin("raise_window", Type_Void, 0, 0, builtin_raise_window);
  new_builtin("current_buffer_is_modified", Type_Int, 0, 0,
	      builtin_current_buffer_is_modified);

  HashTable__Add(builtin_fct_nbre_arg_min,
		 new_builtin("wprintf", Type_Int, 1, &Type_String,
			     builtin_wprintf),
		 1 + 1);
  HashTable__Add(builtin_fct_nbre_arg_min,
		 new_builtin("display_message", Type_Void, 3,
			     string_string_int, builtin_display_message),
		 1 + 1);

  new_builtin("add_list_item", Type_Void, 1, &Type_String,
	      builtin_add_list_item);
  new_builtin("clear_list", Type_Void, 0, 0, builtin_clear_list);
  new_builtin("select_from_list", Type_String, 1, &Type_String,
	      builtin_select_from_list);
  HashTable__Add(builtin_fct_nbre_arg_min,
		 new_builtin("getchar", Type_Int, 1, &Type_String,
			     builtin_getchar),
		 0 + 1);
  HashTable__Add(builtin_fct_nbre_arg_min,
		 new_builtin("gets", Type_String, 1, &Type_String,
			     builtin_gets),
		 0 + 1);

  new_builtin("monochrome", Type_Int, 0, 0, builtin_monochrome);
  new_builtin("remove_colors", Type_Void, 0, 0, builtin_remove_colors);
  new_builtin("color_area", Type_Void, 3, int_int_string,
	      builtin_color_area);
  
  new_builtin("mark_position", Type_Int, 0, 0, builtin_mark_position);
  new_builtin("cut_region", Type_Void, 0, 0, builtin_cut_region);
  new_builtin("copy_region", Type_Void, 0, 0, builtin_copy_region);
  new_builtin("paste_region", Type_Void, 0, 0, builtin_paste_region);
  new_builtin("set_mark", Type_Void, 1, &Type_Int, builtin_set_mark);
  new_builtin("goto_mark", Type_Void, 0, 0, builtin_goto_mark);
  new_builtin("reset_mark", Type_Void, 0, 0, builtin_reset_mark);
  
  new_builtin("re_forward_search", Type_Int, 1, &Type_String,
	      builtin_re_search_forward);
  new_builtin("re_backward_search", Type_Int, 1, &Type_String,
	      builtin_re_search_backward);
  HashTable__Add(builtin_fct_nbre_arg_min,
		 new_builtin("re_replace", Type_Int, 2, string_string_string,
			     builtin_re_replace),
		 1 + 1);
  new_builtin("re_match_beginning", Type_Int, 1, &Type_Int,
	      builtin_re_match_beginning);
  new_builtin("re_match_end", Type_Int, 1, &Type_Int, builtin_re_match_end);
  
  new_builtin("watch_on", Type_Void, 0, 0, builtin_watch_on);
  new_builtin("watch_off", Type_Void, 0, 0, builtin_watch_off);
  new_builtin("usleep", Type_Void, 1, &Type_Int, builtin_usleep);
  new_builtin("current_mode", Type_String, 0, 0, builtin_current_mode);
  
#ifndef LIONEL
  {
    static Type * pString;
    static Type * pInt;
    static Type * string_pint[2];
    
    pString = Type__Type(Type_String, T_Pointer, sizeof(char **));
    pInt = Type__Type(Type_Int, T_Pointer, sizeof(int *));
    string_pint[0] = Type_String;
    string_pint[1] = pInt;
    
    new_builtin("browser_set_pp", Type_Void, 2, string_string_string,
		builtin_browser_set_pp);
    new_builtin("browser_set_pp_options", Type_Void, 2, string_string_string,
		builtin_browser_set_pp_options);
    HashTable__Add(builtin_fct_nbre_arg_min,
		   new_builtin("browser_add", Type_Void, 2, 
			       &string_string_int[1], builtin_browser_add),
		   1 + 1);
    HashTable__Add(builtin_fct_nbre_arg_min,
		   new_builtin("browser_del", Type_Void, 1, 
			       &Type_String, builtin_browser_del),
		   0 + 1);
    HashTable__Add(builtin_fct_nbre_arg_min,
		   new_builtin("browser_class_file", Type_String, 2, 
			       string_pint, builtin_browser_class_file),
		   1 + 1);
    new_builtin("browser_class_parents", pString, 1, &Type_String,
		builtin_browser_class_parents);
    new_builtin("browser_class_children", pString, 1, &Type_String,
		builtin_browser_class_children);
    new_builtin("browser_class_methods", pString, 1, &Type_String,
		builtin_browser_class_methods);
    new_builtin("browser_class_attributes", pString, 1, &Type_String,
		builtin_browser_class_attributes);
    new_builtin("browser_class_flags", Type_String, 1, &Type_String,
		builtin_browser_class_flags); 
    new_builtin("browser_functions", pString, 1, &Type_String,
		builtin_browser_functions);
    new_builtin("browser_globals", pString, 1, &Type_String,
		builtin_browser_globals);
    new_builtin("browser_select_class", Type_Int, 1, &Type_String,
		builtin_browser_select_class); 
    new_builtin("browser_select_method", Type_Int, 1, &Type_String,
		builtin_browser_select_method); 
    new_builtin("browser_select_attribute", Type_Int, 1, &Type_String,
		builtin_browser_select_attribute); 
    new_builtin("browser_select_function", Type_Int, 1, &Type_String,
		builtin_browser_select_function); 
    new_builtin("browser_select_global", Type_Int, 1, &Type_String,
		builtin_browser_select_global); 
    new_builtin("browser_edit", Type_Void, 0, 0, builtin_browser_edit); 
    new_builtin("browser_class_entry", Type_Int, 1, &Type_String,
		builtin_browser_class_entry); 
    new_builtin("browser_function_entry", Type_Int, 1, &Type_String,
		builtin_browser_function_entry); 
    new_builtin("browser_global_entry", Type_Int, 1, &Type_String,
		builtin_browser_global_entry); 
    new_builtin("browser_file_entry", Type_Int, 1, &Type_String,
		builtin_browser_file_entry); 
    new_builtin("browser_class", Type_String, 1, &Type_Int,
		builtin_browser_class); 
    new_builtin("browser_function", Type_String, 1, &Type_Int,
		builtin_browser_function); 
    new_builtin("browser_global", Type_String, 1, &Type_Int,
		builtin_browser_global); 
    new_builtin("browser_file", Type_String, 1, &Type_Int,
		builtin_browser_file); 
    new_builtin("browser_dump", Type_Int, 1, &Type_String,
		builtin_browser_dump); 
    new_builtin("browser_restore", Type_Int, 1, &Type_String,
		builtin_browser_restore); 
    new_builtin("browser_show_all", Type_Void, 0, 0,
		builtin_browser_show_all); 
    new_builtin("browser_hide_private_members", Type_Void, 0, 0,
		builtin_browser_hide_private_members); 
    new_builtin("browser_hide_protected_and_private_members", Type_Void, 0, 0,
		builtin_browser_hide_protected_and_private_members); 
    new_builtin("browser_show_protected_and_private_members", Type_Void, 0, 0,
		builtin_browser_show_protected_and_private_members); 
    new_builtin("browser_hide_inherited_members", Type_Void, 0, 0,
		builtin_browser_hide_inherited_members); 
    new_builtin("browser_show_inherited_members", Type_Void, 0, 0,
		builtin_browser_show_inherited_members); 
    new_builtin("browser_hide_internal_types", Type_Void, 0, 0,
		builtin_browser_hide_internal_types); 
    new_builtin("browser_show_internal_types", Type_Void, 0, 0,
		builtin_browser_show_internal_types); 
    new_builtin("browser_hide_static_functions", Type_Void, 0, 0,
		builtin_browser_hide_static_functions); 
    new_builtin("browser_show_static_functions", Type_Void, 0, 0,
		builtin_browser_show_static_functions); 
    new_builtin("browser_hide_static_globals", Type_Void, 0, 0,
		builtin_browser_hide_static_globals); 
    new_builtin("browser_show_static_globals", Type_Void, 0, 0,
		builtin_browser_show_static_globals); 
    new_builtin("browser_hide_children_of", Type_Void, 1, &Type_String,
		builtin_browser_hide_children_of); 
    new_builtin("browser_show_children_of", Type_Void, 1, &Type_String,
		builtin_browser_show_children_of); 
    new_builtin("browser_hide_class", Type_Void, 1, &Type_String,
		builtin_browser_hide_class); 
    new_builtin("browser_show_class", Type_Void, 1, &Type_String,
		builtin_browser_show_class); 
    new_builtin("browser_hide_global", Type_Void, 1, &Type_String,
		builtin_browser_hide_global); 
    new_builtin("browser_show_global", Type_Void, 1, &Type_String,
		builtin_browser_show_global); 
    new_builtin("browser_hide_function", Type_Void, 1, &Type_String,
		builtin_browser_hide_function); 
    new_builtin("browser_show_function", Type_Void, 1, &Type_String,
		builtin_browser_show_function); 
}
#endif
}
