/**********************************************************************/
/* FORMULR.H : definitions pour Gestion de formulaires en mode texte  */
/**********************************************************************/

/*
    Copyright (C) 1996, 1997 Free Software Foundation, Inc.
    Ce programme fait partie du package JERED et est soumis, comme le
    reste du package JERED, a la Gnu General Public License version 2
    ou superieure dont voici un extrait et dont vous pouvez lire
    la totalite en consultant le fichier COPYING.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#define ON              0x0001  /* Turn On */
#define OFF             0x0000  /* Turn Off */

#define RADIOBUTTON     'R'     /* format bouton radio */
#define YESNO           'Y'     /* format Y/O/N */
#define OUINON          'O'     /* format O/N */
#define HHEXA           'X'     /* format hexa majuscule */
#define LHEXA           'x'     /* format hexa minuscule */
#define ASCNORM         's'     /* format ascii libre */
#define HASCNORM        'S'     /* format ascii transforme en majuscules */
#define NUMERIC         '9'     /* format numerique seulement */

#define NOERROR         0x0000  /* pas d'erreur */
#define ERROR           0x7FFF  /* erreur */
#define ALREADYOPEN     0x7FFE  /* erreur: formulaire deja ouvert */
#define NOTENOUGHMEM    0x7FFD  /* erreur: pas assez de memoire */

#define OKBUTTON        0x0F00  /* l'utilisateur a appuye sur entree */
#define CANCELBUTTON    0x0F01  /* l'utilisateur a appuye sur ESCAPE */
#define NEXTZONE        0x0F02  /* l'utilisateur veut aller en zone suivante */
#define PREVZONE        0x0F03  /* l'utilisateur veut aller en zone precedente */
#define FIRSTZONE       0x0F04  /* l'utilisateur veut se placer sur la premiere zone */
#define LASTZONE        0x0F05  /* l'utilisateur veut se placer sur la derniere zone */
#define EXITBUTTON      0x0F06  /* l'utilisateur veut quitter le masque depuis une fonction externe */

#define MODENORMAL      0x0000  /* sur la derniere zone on y reste et sur la premiere aussi */
#define MODEROULEAU     0x0001  /* sur la derniere zone on passe a la premiere et vice versa */
#define MODEOMBRAGE     0x0002  /* formulaire courant avec ombrage */

#define SIMPLECADRE     0x0000  /* cadre simple */
#define DOUBLECADRE     0x0001  /* cadre double */

#define NEFORCEPAS      0x0000  /* on peut saisir des chaines vides */
#define FORCESAISIE     0x0001  /* oblige a ne pas saisir de chaine vide */
#define ZONESORTIE      0x0002  /* indique qu'une zone est uniquement en sortie */

typedef struct _FORMTEXT *      PTFTEXT;
typedef struct _FORMZONE *      PTFZONE;
typedef struct _FORMULAIRE *    PTFORMU;
typedef struct _FORMLISTE *     PTFLISTE;

typedef struct _FORMTEXT
{
        int xr;                 /* abscisse par rapport au formulaire */
        int yr;                 /* ordonnee par rapport au formulaire */
        char *texte;            /* chaine de texte */
        chtype textcolor;       /* couleur du texte */
        PTFTEXT tsuiv;          /* pointeur vers la chaine suivante */
} FORMTEXT;

typedef struct _FORMZONE
{
        int xr;                 /* abscisse par rapport au formulaire */
        int yr;                 /* ordonnee par rapport au formulaire */
        int lastkey;            /* touche de sortie de la zone */
        int force;              /* oblige ou non a ne pas saisir de chaine vide */
        char *variable;         /* variable d'entree/sortie */
        chtype varcolor;        /* couleur de saisie/affichage de la variable */
        char *format;           /* format de saisie ou d'affichage */
        char *fill;             /* chaine de remplissage du fond de la zone */
        chtype fillcolor;       /* couleur de remplissage du fond de la zone */
        char *defaut;           /* valeur par defaut */
        char *valmin;           /* valeur minimum */
        char *valmax;           /* valeur maximum */
        char *aidenlig;         /* aide en ligne */
        chtype aidecolor;         /* couleur de l'aide en ligne */
        int (*controle)(char *);                /* fonction de controle post-saisie (0 si invalide) ou NULL si inutilise */
        int (*compare)(char *, char *);         /* fonction de comparaison entre deux donnees du type en cours */
        void (*actioncar)(struct _FORMULAIRE *, struct _FORMZONE *);    /* action a effectuer avant chaque reaffichage de la zone */
        void (*actiondeb)(struct _FORMULAIRE *, struct _FORMZONE *);    /* action d'entree de zone */
        void (*actionfin)(struct _FORMULAIRE *, struct _FORMZONE *);    /* action de sortie de zone */
        PTFZONE zprec;          /* pointeur vers zone precedente */
        PTFZONE zsuiv;          /* pointeur vers zone suivante */
} FORMZONE;

typedef struct _FORMULAIRE
{
        int x;                  /* abscisse absolue du formulaire */
        int y;                  /* ordonnee absolue du formulaire */
        int l;                  /* largeur du formulaire */
        int h;                  /* hauteur du formulaire */
        int curx;               /* colonne courante de saisie */
        int cury;               /* ligne courante de saisie */
        int atoufer;            /* zone a tout faire: bit 0 = 1: mode rouleau, sinon mode normal */
        int lastkey;            /* touche de sortie du formulaire: ENTER ou ESCAPE */
        int ligaide;            /* ligne de l'aide en ligne de ce formulaire */
        chtype *prepa;          /* pointeur vers memoire pour preparer le formulaire */
        chtype *sauve;          /* pointeur pour sauver l'ecran sous le formulaire */
        char *ftitre;           /* titre du formulaire */
        chtype tcolor;          /* couleur du titre du formulaire */
        chtype fcolor;          /* couleur de remplissage du formulaire */
        chtype ccolor;          /* couleur du cadre du formulaire */
        int typecadre;          /* type de cadre du formulaire */
        int (*help)(struct _FORMULAIRE *, struct _FORMZONE *);     /* fonction d'aide du formulaire en cours */
        PTFZONE lastzone;       /* zone en cours de saisie du formulaire */
        PTFZONE zfirst;         /* pointeur vers la premiere zone du formulaire */
        PTFTEXT tfirst;         /* pointeur vers la premiere chaine texte du formulaire */
        PTFORMU fsuiv;          /* pointeur vers formulaire suivant */
        PTFORMU fprec;          /* pointeur vers le formulaire precedent */
} FORMULAIRE;

typedef struct _FORMLISTE
{
        PTFORMU ffirst; /* pointeur vers le premier formulaire de la liste */
} FORMLISTE;

/**********************************************************************/
void affiche_formulaire(PTFORMU);
void ajuste_formulaire(PTFORMU);
void construit_texte(PTFORMU, PTFTEXT);
void construit_zone(PTFORMU, PTFZONE);
void centre_formulaire(PTFORMU);
void ferme_formulaire(PTFORMU);
void free_allocated_fliste(PTFLISTE);
void init_application_fliste(PTFLISTE liste, int (*aide)(PTFORMU, PTFZONE), int typecad, int atoufer, chtype coulcadre, chtype coulfond, chtype coultitre, chtype coultexte, chtype coulzone, chtype coulfill, chtype coulaide);
void maj_zone(PTFORMU, PTFZONE);
int lire_formulaire(PTFORMU);
int lire_formulaire_simple(PTFORMU);
int lire_zone(PTFORMU, PTFZONE);
int ouvre_formulaire(PTFORMU);
int valide_caractere(char, char);
int valide_zone(PTFZONE);
PTFORMU cree_formulaire_vide(PTFLISTE);
PTFZONE cree_zone_vide(PTFORMU);
PTFTEXT cree_texte_vide(PTFORMU);
void set_esc_clear(int);
void reaffiche_zones(PTFORMU);
void raz_zones(PTFORMU);
void zones_en_entree(PTFORMU);
void zones_en_sortie(PTFORMU);
