/* vi:set ts=8 sts=0 sw=8:
 * $Id: menu.c,v 1.14 1998/10/18 03:56:35 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <string.h>
#include "doc.h"
#include "menu.h"
#include "msgbar.h"
#include "msgbox.h"
#include "print.h"
#include "about.h"
#include "clipboard.h"
#include "toolbar.h"
#include "search.h"
#include "prefs.h"
#include "project.h"
#include "prjbar.h"
#include "misc.h"

#define MENU_PATH_RECENT_DOC	"<Main>/File/Open Recent.../"

#ifdef WANT_GNOME
static GnomeUIInfo file_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("New"), NULL,
		doc_new_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
		'N', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Open..."), NULL,
		doc_new_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
		'O', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Open Recent..."), NULL,
		doc_new_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
		'O', GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Save"), NULL,
		doc_save_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
		'S', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Save As..."), NULL,
		doc_saveas_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVEAS
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Close"), NULL,
		doc_close_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
		'W', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Close All"), NULL,
		doc_close_all_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE
		NULL, GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Print"), NULL,
		print_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT,
		'P', GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("File Info"), NULL,
		doc_info_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
		'I', GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Exit"), NULL,
		win_close_all_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
		'Q', GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* file_menu */

static GnomeUIInfo edit_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Cut"), NULL,
		cut_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CUT,
		'X', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Copy"), NULL,
		copy_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_COPY,
		'C', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Paste"), NULL,
		paste_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PASTE,
		'V', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Select All"), NULL,
		selall_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
		'A', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Find..."), NULL,
		search_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
		'F', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Find Again"), NULL,
		search_again_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
		NULL, GDK_CONTROL_MASK, NULL
	},
#ifdef NOTYET
	{
		GNOME_APP_UI_ITEM, N_("Replace"), NULL,
		search_replace_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
		NULL, GDK_CONTROL_MASK, NULL
	},
#endif
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Goto Line #..."), NULL,
		goto_line_cb, NULL, NULL,
		GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* edit_menu */

#ifdef WANT_PROJECT
static GnomeUIInfo project_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Toggle Project Bar"), NULL,
		prjbar_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("New Project"), NULL,
		NULL, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Open Project"), NULL,
		prj_open_cb, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Edit Project"), NULL,
		NULL, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Save Project"), NULL,
		NULL, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Close Project"), NULL,
		prj_close_cb, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Project List"), NULL,
		NULL, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Edit a Project"), NULL,
		NULL, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* project_menu */
#endif	/* WANT_PROJECT */

static GnomeUIInfo window_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Doc List"), NULL,
		doc_list_show, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		'L', GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Messages"), NULL,
		msgbox_show, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		'M', GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Window List"), NULL,
		win_list_show, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("New Window"), NULL,
		win_new_with_doc, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Close Window"), NULL,
		win_close_cb, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* project_menu */

static GnomeUIInfo toolbar_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Toggle"), NULL,
		tb_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Pic & Text"), NULL,
		tb_pic_text, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Pic Only"), NULL,
		tb_pic_only, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Text Only"), NULL,
		tb_text_only, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Tooltips ON"), NULL,
		tb_ttip_on, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Tooltips OFF"), NULL,
		tb_ttip_off, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* toolbar_menu */

static GnomeUIInfo doctab_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Toggle"), NULL,
		win_dtab_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Top"), NULL,
		win_dtab_top, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Bottom"), NULL,
		win_dtab_bot, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Left"), NULL,
		win_dtab_left, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Right"), NULL,
		win_dtab_right, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* doctab_menu */

static GnomeUIInfo options_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("Toggle Message Bar"), NULL,
		msgbar_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_ITEM, N_("Toggle Wordwrap"), NULL,
		win_wwrap_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	{
		GNOME_APP_UI_SUBTREE, N_("Doc Tabs"), NULL,
		&doctab_menu
	},
	{
		GNOME_APP_UI_SUBTREE, N_("Toolbar"), NULL,
		&toolbar_menu
	},
	{ GNOME_APP_UI_SEPARATOR },
	{
		GNOME_APP_UI_ITEM, N_("Preferences..."), NULL,
		prefs_cb, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* options_menu */

static GnomeUIInfo help_menu[] = {
	{
		GNOME_APP_UI_ITEM, N_("About gnotepad+"), NULL,
		msgbar_toggle, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL,
		NULL, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
}; /* help_menu */

GnomeUIInfo main_menu[] = {
	{
		GNOME_APP_UI_SUBTREE, N_("File"), NULL,
		&file_menu, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL
	},
	{
		GNOME_APP_UI_SUBTREE, N_("Edit"), NULL,
		&edit_menu, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL
	},
	{
		GNOME_APP_UI_SUBTREE, N_("Window"), NULL,
		&window_menu, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL
	},
	{
		GNOME_APP_UI_SUBTREE, N_("Options"), NULL,
		&options_menu, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL
	},
	{
		GNOME_APP_UI_SUBTREE, N_("About"), NULL,
		&about_menu, NULL, NULL,
		GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL
	},
	GNOMEUIINFO_END
}; /* main_menu */

#endif	/* WANT_GNOME */

/*** local variables ***/
static void menu_add(GtkMenuFactory *menubar, char *submenupath,
	char *newmenupath, char *accel, GtkMenuCallback cb, gpointer cbdata);
static void menu_remove(GtkMenuFactory *menubar, char *menupath);

static GtkMenuFactory *mainfact;
static GtkMenuEntry mainmenu[] = {
	{"<Main>/File/New", "<control>N", doc_new_cb, NULL, NULL},
	{"<Main>/File/Open...", "<control>O", doc_open_cb, NULL, NULL},
	{MENU_PATH_RECENT_DOC, NULL, NULL, NULL, NULL},
	{"<Main>/File/<separator>", NULL, NULL, NULL, NULL},
	{"<Main>/File/Save", "<control>S", doc_save_cb, NULL, NULL},
	{"<Main>/File/Save As...", NULL, doc_saveas_cb, NULL, NULL},
	{"<Main>/File/Close", "<control>W", doc_close_cb, NULL, NULL},
	{"<Main>/File/Close All", NULL, doc_close_all_cb, NULL, NULL},
	{"<Main>/File/<separator>", NULL, NULL, NULL, NULL},
	{"<Main>/File/Print...", "<control>P", print_cb, NULL, NULL},
	{"<Main>/File/<separator>", NULL, NULL, NULL, NULL},
	{"<Main>/File/File Info", "<control>I", doc_info_cb, NULL, NULL},
	{"<Main>/File/<separator>", NULL, NULL, NULL, NULL},
	{"<Main>/File/Exit", "<control>Q", win_close_all_cb, NULL, NULL},
	{"<Main>/Edit/Cut", "<control>X", cut_cb, NULL, NULL},
	{"<Main>/Edit/Copy", "<control>C", copy_cb, NULL, NULL},
	{"<Main>/Edit/Paste", "<control>V", paste_cb, NULL, NULL},
	{"<Main>/Edit/Select All", "<control>A", selall_cb, NULL, NULL},
	{"<Main>/Edit/<separator>", NULL, NULL, NULL, NULL},
	{"<Main>/Edit/Find...", "<control>F", search_cb, NULL, NULL},
	{"<Main>/Edit/Find Again", NULL, search_again_cb, NULL, NULL},
#ifdef NOTYET
	{"<Main>/Edit/Replace", "<control>R", search_replace_cb, NULL, NULL},
#endif
	{"<Main>/Edit/<separator>", NULL, NULL, NULL, NULL},
	{"<Main>/Edit/Goto Line #...", NULL, goto_line_cb, NULL, NULL},
#ifdef WANT_PROJECT
	{"<Main>/Project/Toggle Project Bar", NULL, prjbar_toggle, NULL, NULL},
	{"<Main>/Project/<separator>", NULL, NULL, NULL, NULL},
	{"<Main>/Project/New Project", NULL, NULL, NULL, NULL},
	{"<Main>/Project/Open Project", NULL, prj_open_cb, NULL, NULL},
	{"<Main>/Project/Edit Project", NULL, NULL, NULL, NULL},
	{"<Main>/Project/Save Project", NULL, NULL, NULL, NULL},
	{"<Main>/Project/Close Project", NULL, prj_close_cb, NULL, NULL},
	{"<Main>/Project/<separator>", NULL, NULL, NULL, NULL},
	{"<Main>/Project/Current Project Info", NULL, NULL, NULL, NULL},
	{"<Main>/Project/Project List", NULL, NULL, NULL, NULL},
	{"<Main>/Project/Edit A Project", NULL, NULL, NULL, NULL},
#endif	/* WANT_PROJECT */
	{"<Main>/Window/Doc List", "<control>L", doc_list_show, NULL, NULL},
	{"<Main>/Window/Messages", "<control>M", msgbox_show, NULL, NULL},
	{"<Main>/Window/<separator>", NULL, NULL, NULL},
	{"<Main>/Window/Window List", NULL, win_list_show, NULL, NULL},
	{"<Main>/Window/New Window", NULL, win_new_with_doc, NULL, NULL},
	{"<Main>/Window/Close Window", NULL, win_close_cb, NULL, NULL},
	{"<Main>/Options/Toggle Message Bar", NULL, msgbar_toggle, NULL, NULL},
	{"<Main>/Options/Toggle Wordwrap", NULL, win_wwrap_toggle, NULL, NULL},
	{"<Main>/Options/Doc Tabs/Toggle", NULL, win_dtab_toggle, NULL, NULL},
	{"<Main>/Options/Doc Tabs/<separator>", NULL, NULL, NULL, NULL},
	{"<Main>/Options/Doc Tabs/Top", NULL, win_dtab_top, NULL, NULL},
	{"<Main>/Options/Doc Tabs/Bottom", NULL, win_dtab_bot, NULL, NULL},
	{"<Main>/Options/Doc Tabs/Left", NULL, win_dtab_left, NULL, NULL},
	{"<Main>/Options/Doc Tabs/Right", NULL, win_dtab_right, NULL, NULL},
	{"<Main>/Options/Toolbar/Toggle", NULL, tb_toggle, NULL, NULL},
	{"<Main>/Options/Toolbar/<separator>", NULL, NULL, NULL, NULL},
	{"<Main>/Options/Toolbar/Pic & Text", NULL, tb_pic_text, NULL, NULL},
	{"<Main>/Options/Toolbar/Pic Only", NULL, tb_pic_only, NULL, NULL},
	{"<Main>/Options/Toolbar/Text Only", NULL, tb_text_only, NULL, NULL},
	{"<Main>/Options/Toolbar/<separator>", NULL, NULL, NULL, NULL},
	{"<Main>/Options/Toolbar/Tooltips On", NULL, tb_ttip_on, NULL, NULL},
	{"<Main>/Options/Toolbar/Tooltips Off", NULL, tb_ttip_off, NULL, NULL},
	{"<Main>/Options/<separator>", NULL, NULL, NULL, NULL},
	{"<Main>/Options/Preferences...", NULL, prefs_cb, NULL, NULL},
	{"<Main>/Help/About gnotepad+", NULL, about_cb, NULL, NULL},
};

static qmenu_t qmenu[] = {
	{ "Cut", cut_cb },
	{ "Copy", copy_cb },
	{ "Paste", paste_cb },
	{ "<separator>", NULL },
	{ "Open in new window", doc_open_in_new_win },
	{ "<separator>", NULL },
	{ "Save", doc_save_cb },
	{ "Close", doc_close_cb },
	{ "Print", print_cb },
/*
	{ "<separator>", NULL },
	{ "Open (swap) .c/.h file", doc_swaphc_cb },
*/
	{ NULL, NULL }
};


/*** global function definitions ***/
/*
 * PUBLIC: menu_main_init
 *
 * initialize the menubar.  called from win_new().
 */
void
menu_main_init(win_t *w)
{
	GtkMenuPath *mpath;
	GtkMenuFactory *subf;
	GtkMenuEntry *newmenu;
	int numitems, i;

	/* do we really need a copy of the actual menu? */
#if PROBABLY_NOT
	newmenu = (GtkMenuEntry *)g_malloc(sizeof(mainmenu));
	memcpy(newmenu, mainmenu, sizeof(mainmenu));
#else
	newmenu = mainmenu;
#endif
	numitems = sizeof(mainmenu) / sizeof(mainmenu[0]);

	for (i = 0; i < numitems; i++)
		newmenu[i].callback_data = (gpointer)w;
	mainfact = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
	subf = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
	gtk_menu_factory_add_subfactory(mainfact, subf, "<Main>");
	gtk_menu_factory_add_entries(mainfact, newmenu, numitems);

	mpath = gtk_menu_factory_find(mainfact, "<Main>/Help");
	gtk_menu_item_right_justify(GTK_MENU_ITEM(mpath->widget));

	w->menubar = subf->widget;
#ifdef GTK_HAVE_FEATURES_1_1_0
	gtk_window_add_accel_group(GTK_WINDOW(w->toplev), subf->accel_group);
#else
	gtk_window_add_accelerator_table(GTK_WINDOW(w->toplev), subf->table);
#endif

	w->menubar_h = gtk_handle_box_new();
	gtk_container_add(GTK_CONTAINER(w->menubar_h), w->menubar);
	gtk_box_pack_start(GTK_BOX(w->mainbox), w->menubar_h, FALSE, TRUE, 0);
	gtk_widget_show(w->menubar);
	gtk_widget_show(w->menubar_h);

} /* menu_main_init */


/*
 * always removes the first entry, since adding to the menu is FIFO.
 * called from recent_list_add().
 */
void
menu_recent_doc_remove(gpointer data)
{
	int len;
	char *menupath;
	doc_new_name_t *dnnp = (doc_new_name_t *)data;

	len = strlen(MENU_PATH_RECENT_DOC) +
	      strlen((const char *)my_basename(dnnp->fname)) + 1;
	menupath = (char *)g_malloc(len);
	g_snprintf(menupath, len, "%s%s",
			MENU_PATH_RECENT_DOC, my_basename(dnnp->fname));

	menu_remove(mainfact, menupath);
	g_free(menupath);
} /* menu_recent_doc_remove */


static void
menu_remove(GtkMenuFactory *menubar, char *menupath)
{
	gtk_menu_factory_remove_paths(menubar, &menupath, 1);
} /* menu_remove */


/*
 * called from recent_list_add(), recent_list_init()
 */
void
menu_recent_doc_add(GtkMenuCallback cbfunc, gpointer data)
{
	doc_new_name_t *dnnp = (doc_new_name_t *)data;

	menu_add(mainfact, MENU_PATH_RECENT_DOC,
		(char *)my_basename(dnnp->fname), NULL, cbfunc, dnnp);
} /* menu_recent_doc_add */


static void 
menu_add(GtkMenuFactory *menubar, char *submenupath, char *newmenupath,
	char *accelerator, GtkMenuCallback callback, gpointer cbdata)
{
	GtkMenuEntry *newentry;
	int len;

	newentry = (GtkMenuEntry *)g_malloc(sizeof(GtkMenuEntry));
	len = strlen(submenupath) + strlen(newmenupath) + 1;
	newentry->path = (char *)g_malloc(len);
	g_snprintf(newentry->path, len, "%s%s", submenupath, newmenupath);
	newentry->accelerator = accelerator;
	newentry->callback = callback;
	newentry->callback_data = cbdata;
	newentry->widget = NULL;

	gtk_menu_factory_add_entries(menubar, newentry, 1);

	/*
	 * although it doesn't say that you can anywhere, it looks like we can
	 * safely free up the space we just allocated
	 */
	g_free(newentry->path);
	g_free(newentry);
} /* menu_add */


/*
 * PUBLIC: quickmenu_init
 *
 * initialize the quick popup menu (right mouse click).  called from win_new().
 */
void
quickmenu_init(win_t *w)
{
	GtkWidget *tmp;
	qmenu_t *qmp = qmenu;

	w->quickmenu = gtk_menu_new();
	while (qmp && qmp->name != NULL) {
		if (strcmp(qmp->name, "<separator>") == 0)
			tmp = gtk_menu_item_new();
		else
			tmp = gtk_menu_item_new_with_label(qmp->name);

		gtk_menu_append(GTK_MENU(w->quickmenu), tmp);
		gtk_widget_show(tmp);

		if (qmp->cb)
			gtk_signal_connect(GTK_OBJECT(tmp), "activate",
				GTK_SIGNAL_FUNC(qmp->cb), w);
		qmp++;
	}
} /* quickmenu_init */


/*
 * PUBLIC: quickmenu_show
 *
 * callback routine invoked when user clicks on right mouse button.
 */
gboolean
quickmenu_show(GtkWidget *wgt, GdkEvent *ev)
{
	if (ev->type == GDK_BUTTON_PRESS) {
		GdkEventButton *event = (GdkEventButton *)ev;
		if (event->button == 3) {
			gtk_menu_popup(GTK_MENU(wgt), NULL, NULL, NULL, NULL,
					event->button, event->time);
			return TRUE;
		}
	}
	return FALSE;
} /* quickmenu_show */


/* the end */
