
/*
 * INCLUDE.C
 *
 */

#include "defs.h"

Prototype void IncludeFile(const char *fileName);
Prototype INode	*CurINode;

Prototype const char *getToken(INode *in, int expand);
Prototype const char *expToken(Depend *dep, INode *in, const char *ptr, int mode);

char *extcolon(char **pp, char exdelim, char *pwe);

INode	*CurINode;

void
IncludeFile(const char *fileName)
{
    INode *in = MakeNode(fileName, sizeof(INode), 0);
    int vslen = VNodeStrSize(ExtDefs);
    char *path = malloc(strlen(fileName) + sizeof(CPPCMD) + vslen + 8);

    in->in_Parent = CurINode;
    in->in_Node.no_INode = in;
    in->in_Node.no_ILine = 0;
    in->in_LastNl = 1;
    InitList(&in->in_EList);

    CurINode = in;

    {
	int l;
	Node *node;

	strcpy(path, CPPCMD);
	l = strlen(path);
	for (node = GetHead(&ExtDefs->vn_List); node; node = GetNext(node)) {
	    sprintf(path + l, " %s", node->no_Name);
	    l += strlen(path + l);
	}
	sprintf(path + l, " %s", fileName);
    }

    if ((in->in_Fi = popen(path, "r")) != NULL) {
	const char *s;

	while ((s = getToken(in, EXP_FORCE)) != NULL) {
	    if (*s == '\n') {
		;
	    } else if (s[0] == '.' && s[1] != '.' && s[1] != '/') {
		if (strcmp(s, ".set") == 0) {
		    /*
		     * get variable name
		     */
		    VNode *vnode;

		    if ((s = getToken(in, EXP_FORCE)) == NULL) {
			fatal(&in->in_Node, ".set - unexpected EOF\n");
			/* not reached */
		    }
		    vnode = MakeVNode(&VarList, s);
		    while ((s = getToken(in, EXP_NORMAL)) != NULL && *s != '\n') {
			AddTail(&vnode->vn_List, &MakeDNode(s)->dn_Node);
		    }
		    CommitVNode(vnode);
		} else {
		    fatal(&in->in_Node, "Unknown directive: %s\n", s);
		    /* not reached */
		}
	    } else {
		/*
		 * Parse a dependancy:
		 *
		 * d1 d2 ... dn : s1 s2 ... sn [ : a1 a2 ... an ]
		 * d1 : s1 s2 ... sn
		 */
		List *lhs = malloc(sizeof(List));
		List *rhs = malloc(sizeof(List));
		List *ahs = malloc(sizeof(List));
		List *xlist = malloc(sizeof(List));
		List *clist = lhs;

		InitList(lhs);
		InitList(rhs);
		InitList(ahs);
		InitList(xlist);

		/*
		 * Dependancies
		 */

		while (s && *s != '\n') {
		    if (*s == ':') {
			if (clist == lhs)
			    clist = rhs;
			else if (clist == rhs)
			    clist = ahs;
			else
			    fatal(&in->in_Node, "Too many colons in dependancy line\n");
		    } else {
			AddTail(clist, &MakeDNode(s)->dn_Node);
		    }
		    if (clist == lhs)
			s = getToken(in, EXP_FORCE);
		    else
			s = getToken(in, EXP_FORCE);
		}
		if (s == NULL)
		    fatal(&in->in_Node, "Unexpected EOF\n");

		/*
		 * s1 : d1 d2 d3 ... dn
		 */

		if (lhs->li_Count == 1 && ahs->li_Count == 0) {
		    List *t = ahs;
		    ahs = rhs;
		    rhs = t;
		}

		if (lhs->li_Count != rhs->li_Count && rhs->li_Count > 1) {
		    fatal(
			&in->in_Node, 
			"lhs/rhs count mismatch for rule %s (%d,%d,%d)\n", 
			((lhs->li_Count) ? lhs->li_Node.no_Next->no_Name : "?"),
			lhs->li_Count,
			rhs->li_Count, 
			ahs->li_Count
		    );
		}

		/*
		 * Body
		 */

		{
		    int bcnt = 0;
		    int c;

		    while ((c = getc(in->in_Fi)) != EOF) {
			char buf[MAXLINE];

			++in->in_Node.no_ILine;

			/*
			 * Handle end of command sequencing
			 */

			if (c == '\n' && bcnt == 0)
			    break;

			/*
			 * Handle . directive
			 */

			if (c == '.') {
			    ungetc(c, in->in_Fi);
			    s = getToken(in, 0);

			    if (strcmp(s, ".set") == 0) {
				/*
				 * get variable name
				 */
				VNode *vnode;

				if ((s = getToken(in, 0)) == NULL) {
				    fatal(&in->in_Node, ".set - unexpected EOF\n");
				    /* not reached */
				}
				vnode = MakeVNode(xlist, s);
				while ((s = getToken(in, 0)) != NULL && *s != '\n') {
				    AddTail(&vnode->vn_List, &MakeDNode(s)->dn_Node);
				}
				CommitVNode(vnode);
			    } else if (strcmp(s, ".beg") == 0) {
				++bcnt;
			    } else if (strcmp(s, ".end") == 0) {
				if (--bcnt < 0)
				    fatal(&in->in_Node, "too many .end directives!\n");
			    } else {
				fatal(&in->in_Node, "Unknown directive in command sequence: %s\n", s);
			    }
			    while (s && *s != '\n')
				s = getToken(in, 0);
			    continue;
			}

			/*
			 * Handle command line to execute
			 */

			buf[0] = c;
			if (fgets(buf + 1, sizeof(buf) - 1, in->in_Fi) == NULL) {
			    fatal(&in->in_Node, "Unexpected EOF\n");
			}

			if (buf[0] != '#') {
			    Node *node;
			    char *s = buf;
			    int l = strlen(buf);

			    if (l && buf[l-1] == '\n')
				buf[--l] = 0;
			    while (*s && (*s == ' ' || *s == '\t'))
				++s;

			    node = MakeNode(s, sizeof(Node), 0);
			    node->no_Type = TYPE_EXEC;
			    AddTail(xlist, node);
			}
		    }
		}
		in->in_LastNl = 1;

		/*
		 * Create dependancy list
		 */

		{
		    Node *lnode;

		    for (lnode = GetHead(lhs); lnode; lnode = GetNext(lnode)) {
			Node *rnode;

			if ((rnode = GetHead(rhs)) != NULL)
			    DelNode(rhs, rnode);
			MakeDepend(lnode->no_Name, rnode, ahs, xlist);
		    }
		}
	    }
	}
	pclose(in->in_Fi);
	in->in_Fi = NULL;
    } else {
	fatal(&in->in_Node, "popen failed: %s\n", path);
	/* not reached */
    }
    CurINode = in->in_Parent;
    free(path);
}

/*
 * getToken() - get token from FILE and possibly expand it
 */

const char *
getToken(INode *in, int expand)
{
    Node *node;
    static char Buf[256];
    static char *LBuf;
    char *ptr;

top:
    if (LBuf) {
	free(LBuf);
	LBuf = NULL;
    }

    if ((node = GetHead(&in->in_EList)) != NULL) {
	DelNode(&in->in_EList, node);
	ptr = node->no_Name;
	/* cannot set LBuf here, node's no_Name may be reused XXX */
    } else {
	int c;
	int i = 0;
	int maxi = sizeof(Buf) - 1;
	int bqu = 0;
	int squ = 0;
	int dqu = 0;
	int paren = 0;

	ptr = Buf;

	while ((c = getc(in->in_Fi)) != EOF) {
	    if (c == '#') {
		if (in->in_LastNl) {
		    while ((c = getc(in->in_Fi)) != EOF && c != '\n')
			;
		    ++in->in_Node.no_ILine;
		    if (c == '\n')
			c = getc(in->in_Fi);
		}
	    }

	    if (c == '\n') {
		/*
		 * break on newline
		 */
		if (paren + bqu + squ + dqu != 0)
		    fatal(&in->in_Node, "unterminated string\n");
		if (i == 0) {
		    ptr[i++] = c;
		    c = getc(in->in_Fi);
		    in->in_LastNl = 1;
		}
		break;
	    }
	    in->in_LastNl = 0;

	    if ((c == ' ' || c == '\t') && (paren + bqu + squ + dqu == 0)) {
		/*
		 * skip leading white space
		 */
		if (i == 0)
		    continue;
		/*
		 * break on separator
		 */
		break;
	    }

	    if (c == '`')
		bqu = 1 - bqu;
	    if (c == '\"')
		dqu = 1 - dqu;
	    if (c == '\'' )
		squ = 1 - squ;
	    if (c == '(' )
		++paren;
	    if (c == '{' )
		++paren;
	    if (c == ')' )
		--paren;
	    if (c == '}' )
		--paren;

	    if (c == '\\') {
		c = getc(in->in_Fi);
		if (c == '\n') {
		    /*
		     * eat both
		     */
		    continue;
		}
		ungetc(c, in->in_Fi);
		c = '\\';
	    }

	    /*
	     * store c
	     */

	    if (i == maxi) {
		if (ptr == Buf) {
		    ptr = malloc(i * 2);
		    memmove(ptr, Buf, i);
		} else {
		    ptr = realloc(ptr, i * 2);
		}
		LBuf = ptr;
		maxi = i * 2 - 1;
	    }

	    /*
	     * make : a delimeter as well
	     */

	    if (paren + bqu + squ + dqu == 0) {
		if (c == ':' && i != 0)
		    break;

		if (i && ptr[0] == ':')
		    break;
	    }

	    ptr[i++] = c;
	}
	if (c != EOF)
	    ungetc(c, in->in_Fi);
	ptr[i] = 0;
	if (i == 0)
	    ptr = NULL;
    }

    if (expand && ptr) {
	char *p;
	int use = 0;

	for (p = ptr; *p; ++p) {
	    if ((((p[0] == '$' || p[0] == '%') && 
		(p[1] == '(' || (expand == EXP_FORCE && p[1] == '{')))) || 
		p[0] == '`'
	    ) {
		use = expand;
		break;
	    }
	}
	if (use) {
	    expToken(NULL, in, ptr, use);
	    goto top;
	}
    }

    return(ptr);
}

/*
 * expToken() - expand token, pushing the result on in_EList
 */

const char *
expToken(Depend *dep, INode *in, const char *id, int mode)
{
    static char Buf[1024];
    static char *LBuf;
    char *ptr = Buf;
    int i = 0;
    int bqi = -1;
    int vcount = 0;
    int vstart[MAXVARIND];
    int maxi = sizeof(Buf) - 1;

    if (LBuf) {
	free(LBuf);
	LBuf = NULL;
    }

    while (*id) {
	/*
	 * $(VAR)			immediate expansion
	 * $(VAR:search:replace)
	 *
	 * ${VAR}			delayed expansion
	 * ${VAR:search:replace}
	 */

	if ((id[0] == '$' || id[0] == '%') && 
	    (id[1] == '(' || (mode == EXP_FORCE && id[1] == '{'))
	) {
	    vstart[vcount++] = i;
	}
	if ((id[0] == ')' || (mode == EXP_FORCE && id[0] == '}')) && vcount) {
	    /*
	     * Expand the variable
	     */
	    int vqi = vstart[--vcount];
	    char type = ptr[vqi];
	    char we = 0;
	    char *vname;
	    char *wsrc = NULL;
	    char *wdst = NULL;
	    List *list;
	    Node *node;

	    /*
	     * Terminate the variable expression
	     */

	    ptr[i] = 0;

	    /*
	     * Extract the name, source, and destination wildcards
	     */

	    {
		char *p = ptr + vqi + 2;
		char dummy;

		vname = extcolon(&p, '?', &we);
		if (*p == ':') {
		    wsrc = extcolon(&p, 0, &dummy);
		    if (*p == ':')
			wdst = extcolon(&p, 0, &dummy);
		    else
			wdst = wsrc;
		}
	    }
		
	    /*
	     * Locate the variable.
	     */

	    list = FindVar(type, dep, vname);

#ifdef NOTDEF
	    if (we) {
		char *p = wdst;
		int plen;

		if (list) {
		    p = wsrc;
		}
		i = vqi;
		plen = strlen(p);
		if (i + plen >= maxi) {
		    maxi = (i + plen) * 2;

		    if (ptr == Buf) {
			ptr = malloc(maxi);
			memmove(ptr, Buf, i);
		    } else {
			ptr = realloc(ptr, maxi);
		    }
		}
		memmove(ptr + i, p, plen);
		i += plen;
		++id;
		continue;
	    }
#endif

	    if (list == NULL && we != '?')
		fatal(&in->in_Node, "Variable(%s) not found\n", vname);

	    /*
	     * Wildcard transformation
	     */

	    for ((node= (list)?GetHead(list):NULL); node; node=GetNext(node)) {
		char *p = node->no_Name;
		char *dbuf = NULL;

		if (wsrc != NULL) {
		    if (WildConvert(node->no_Name, &dbuf, wsrc, wdst) < 0) {
			p = "";
		    } else {
			p = dbuf;
		    }
		}

		if (*p) {
		    /*
		     * replace buffer's end (@ i) with string @ vqi and commit.
		     * This means that we vectorize multi-entry variables:
		     *
		     * A=a b c
		     * B=d e f
		     *
		     * $(A)$(B) results in ad ae af bd be bf		REQUEUED
		     * $(A)$(B) results in a b cd e f			IN-PLACE
		     *
		     * if in is NULL, we are doing an in-place replacement  (e.g.
		     * for a shell command line)
		     * 
		     * if in is not NULL, we are doing a requeued replacement.
		     */
		    int plen = strlen(p);

		    if (in == NULL) {
			int l = vqi + plen + 1;

			if (vqi + l >= maxi) {
			    maxi = (vqi + l) * 2;
			    if (ptr == Buf) {
				ptr = malloc(maxi + 1);
				memmove(ptr, Buf, vqi);
			    } else {
				ptr = realloc(ptr, maxi + 1);
			    }
			}
			if (node != list->li_Node.no_Next)
			    ptr[vqi++] = ' ';
			memmove(ptr + vqi, p, plen);
			vqi = vqi + plen;
		    } else {
			char xbuf[1024];
			char *cpy = xbuf;
			Node *n2;
			int idlen = strlen(id + 1);
			int l = vqi + plen + idlen;

			if (l >= sizeof(xbuf)) {
			    cpy = malloc(l + 1);
			}
			memmove(cpy, ptr, vqi);
			memmove(cpy + vqi, p, plen);
			memmove(cpy + vqi + plen, id + 1, idlen);
			cpy[vqi+plen+idlen] = 0;

			n2 = MakeNode(cpy, sizeof(Node), 0);
			AddTail(&in->in_EList, n2);

			if (cpy != xbuf)
			    free(cpy);
		    }
		}
		if (dbuf)
		    free(dbuf);
	    }
	    if (in != NULL) {
		/*
		 * break out, because we have requeued the deepest
		 * variable expansion level.
		 */
		i = 0;
		break;
	    }
	    i = vqi;
	    ++id;
	} 

	if (*id == '`') {
	    if (bqi >= 0) {
		/*
		 * execute and replace, parse the result 
		 * as a string of tokens
		 */
		INode *tin;

		ptr[i] = 0;
		tin = MakeNode(ptr + bqi, sizeof(INode), 0);
		tin->in_Parent = CurINode;
		tin->in_Node.no_INode = tin;
		tin->in_Node.no_ILine = 0;
		InitList(&tin->in_EList);

		if ((tin->in_Fi = popen(ptr + bqi, "r")) != NULL) {
		    const char *s;

		    while ((s = getToken(tin, 1)) != NULL) {
			Node *node;

			if (*s == '\n')
			    continue;

			node = MakeNode(s, sizeof(Node), 0);
			AddTail(&in->in_EList, node);
		    }
		    pclose(tin->in_Fi);
		} else {
		    fatal(&in->in_Node, "popen('%s') failed\n", ptr + bqi);
		}
		i = 0;
		bqi = -1;
		++id;
		continue;
	    }
	    bqi = i + 1;
	    if (i != 0) {
		fatal(&in->in_Node, "I can't deal with embedded backticks!\n");
	    }
	    /* fall through */
	}
	if (i == maxi) {
	    if (ptr == Buf) {
		ptr = malloc(i * 2);
		memmove(ptr, Buf, i);
	    } else {
		ptr = realloc(ptr, i * 2);
	    }
	    maxi = i * 2 - 1;
	}
	ptr[i++] = *id;
	++id;
    }
    ptr[i] = 0;
    if (i && in) {
	Node *node = MakeNode(ptr, sizeof(Node), 0);
	AddTail(&in->in_EList, node);
    }
    if (in == NULL) {
	if (ptr != Buf)
	    LBuf = ptr;
	return(ptr);
    } else {
	if (ptr != Buf)
	    free(ptr);
	return(NULL);
    }
}

char *
extcolon(char **pp, char exdelim, char *pwe)
{
    char *p = *pp;
    char *r;
    int i;
    int quo = 0;

    *pwe = 0;

    if (*p == ':')
	++p;

    if (*p == '\"') {
	++p;
	quo = 1;
    }
    for (i = 0; p[i] && (quo || (p[i] != ':' && p[i] != exdelim)); ++i) {
	if (p[i] == '\"') {
	    quo = 0;
	    break;
	}
    }
    r = malloc(i + 1);
    memmove(r, p, i);
    r[i] = 0;

    if (p[i] == '\"')
	++i;

    if (exdelim && p[i] == exdelim) {
	*pwe = exdelim;
	++i;
    }
    *pp = p + i;

    return(r);
}

