-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
class FIXED_ARRAY2[E]
   -- 
   -- Implementation of COLLECTION[E] with frozen lower bounds :
   -- `lower1' and `lower2' are frozen to 0. Some memory is saved 
   -- and looping toward lower bounds runs a little bit faster.
   --
   
inherit COLLECTION2[E] redefine copy end;
   
creation make

feature {FIXED_ARRAY2}
   
   storage: FIXED_ARRAY[like item];

feature

   lower1, lower2: INTEGER is 0;

   upper1, upper2, count1, count2: INTEGER;

feature 
   
   make(size1, size2: INTEGER) is
	 -- Reset `count1' and `count2' using arguments as new
	 -- values. All elements are set to the default value of 
	 -- type E.
      require
	 size1 > 0;
	 size2 > 0
      do
	 count1 := size1;
	 count2 := size2;
	 upper1 := size1 - 1;
	 upper2 := size2 - 1;
	 !!storage.make(count);
      ensure
	 count1 = size1;
	 count2 = size2;
	 upper1 = size1 - 1;
	 upper2 = size2 - 1
      end;
   
feature 
   
   item(i1, i2: INTEGER): E is
      do
	 Result := storage.item(i1 * count2 + i2);
      end;
   
   put(x: like item; i1, i2: INTEGER) is
      do
	 storage.put(x,i1 * count2 + i2);	 
      end;
   
   copy(other: like Current) is
      local
	 i: INTEGER;
      do
	 make(other.count1,other.count2);
	 storage.copy(other.storage);
      end;
   
invariant

   upper1 > 0;

   upper2 > 0;

   count1 = upper1 + 1;

   count2 = upper2 + 1;

   storage.count = count;
   
end -- FIXED_ARRAY2[E]

