--          This file is part of SmallEiffel The GNU Eiffel Compiler.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
-- SmallEiffel is  free  software;  you can  redistribute it and/or modify it 
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later 
-- version. SmallEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License 
-- for  more  details.  You  should  have  received a copy of the GNU General 
-- Public  License  along  with  SmallEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class CALL_INFIX_MINUS
--   
--   Infix operator : "-".
--      

inherit CALL_INFIX;
   
creation make
   
feature 
   
   precedence: INTEGER is 7;
   
   left_brackets: BOOLEAN is false;

   operator: STRING is
      do
	 Result := us_minus;
      end;
   
   isa_dca_inline_argument: INTEGER is
      do
	 Result := target.isa_dca_inline_argument;
	 if Result = -1 then
	    Result := arg1.isa_dca_inline_argument;
	 elseif Result > 0 then
	    if arg1.isa_dca_inline_argument >= 0 then
	       Result := 0;
	    end;
	 end;
      end;

   dca_inline_argument(formal_arg_type: TYPE) is
      do
	 cpp.put_character('(');
	 target.dca_inline_argument(formal_arg_type)
	 cpp.put_character(')');
	 cpp.put_character('-');
	 cpp.put_character('(');
	 arg1.dca_inline_argument(formal_arg_type)
	 cpp.put_character(')');
      end;

   is_static: BOOLEAN is
      do
	 if result_type.is_integer then
	    if target.is_static and then arg1.is_static then
	       Result := true;
	       static_value_mem := target.static_value - arg1.static_value;
	    end;
	 end;
      end;

   compile_to_jvm is
      do
	 call_proc_call_c2jvm;
      end;
   
   jvm_branch_if_false: INTEGER is
      do
	 Result := jvm_standard_branch_if_false;
      end;

   jvm_branch_if_true: INTEGER is
      do
	 Result := jvm_standard_branch_if_true;
      end;
   
end -- CALL_INFIX_MINUS

