/*
-- ANSI C code generated by :
-- SmallEiffel The GNU Eiffel Compiler -- Release (- 0.80)      --
-- Copyright (C), 1994-98 - LORIA - UHP - CRIN - INRIA - FRANCE --
-- Dominique COLNET and Suzanne COLLIN -    colnet@loria.fr     --
--                 http://www.loria.fr/SmallEiffel              --
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (base.h) is automatically included in the header for all modes 
  of compilation : -boost, -no_check, -require_check, ...
  This file is also included in the header of any cecil file.
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
# define JMP_BUF    sigjmp_buf
# define SETJMP(x)  sigsetjmp( (x), 1)
# define LONGJMP    siglongjmp
#else
# define JMP_BUF    jmp_buf
# define SETJMP(x)  setjmp( (x) )
# define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define T2BITS (CHAR_BIT*sizeof(int))
#define T2MIN INT_MIN
#define T2MAX INT_MAX

/*
  Eiffel type CHARACTER is #3 :
*/
typedef char T3;
#define T3BITS CHAR_BIT
#define T3MIN (0)
#define T3MAX (255)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define T4BITS (CHAR_BIT*sizeof(float))
#define T4MIN (-(FLT_MAX))
#define T4MAX FLT_MAX

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define T5BITS (CHAR_BIT*sizeof(double))
#define T5MIN (-(DBL_MAX))
#define T5MAX DBL_MAX

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef int T6;
#define T6BITS (CHAR_BIT*sizeof(int))

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define T8BITS (CHAR_BIT*sizeof(void*))

/* --- Mangling Table Start ---
A*1  T571  R STD_ERROR 571
A*1  T504  R SMALL_EIFFEL 504
A 1  T1136 E NATIVE_ARRAY[STRING] 1136
A*1  T194  R FINDER 194
A*1  T474  R BOOLEAN_REF 474
A*1  T1806 R FIXED_ARRAY[INTEGER] 1806
A 1  T2    E INTEGER 2
A*1  T85   R ECHO 85
A*1  T1540 R DICTIONARY[STRING,STRING] 1540
A 1  T3    E CHARACTER 3
A*1  T1886 R FIXED_ARRAY[STRING] 1886
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A*1  T7    R STRING 7
A*1  T931  R ARRAY[STRING] 931
A*1  T878  R STD_OUTPUT 878
A 1  T8    E POINTER 8
A*1  T822  R PARSER_BUFFER 822
A 1  T6    E BOOLEAN 6
A*1  T500  R STD_FILE_READ 500
A 1  T673  E FILE_TOOLS 673
A 1  T2045 E NATIVE_ARRAY[INTEGER] 2045
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef void*T571;
typedef void*T504;
typedef void*T194;
typedef struct S474 T474;
typedef struct S1806 T1806;
typedef struct S85 T85;
typedef struct S1540 T1540;
typedef struct S1886 T1886;
typedef struct S7 T7;
typedef struct S931 T931;
typedef void*T878;
typedef struct S822 T822;
typedef struct S500 T500;
typedef int T673;

/*C Header Pass 2 :*/
typedef T0**T1136;
typedef T3*T9;
typedef T2*T2045;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
extern T571 M571;
extern T504 M504;
extern T194 M194;
struct S474{T6 _item;};
extern T474 M474;
struct S1806{T2045 _storage;T2 _capacity;T2 _upper;};
extern T1806 M1806;
struct S85{T6 _verbose;};
extern T85 M85;
struct S1540{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T1540 M1540;
struct S1886{T1136 _storage;T2 _capacity;T2 _upper;};
extern T1886 M1886;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S931{T1136 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T931 M931;
extern T878 M878;
struct S822{T0* _path;T2 _count;};
extern T822 M822;
struct S500{T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T500 M500;
extern T673 M673;
T7*se_ms(int c,char*e);
T7*e2s(char*e);
char*s2e(T7*s);
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

/*
  This file (boost.h) is automatically included when `run_control.boost' is
  true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void sigrsp(int sig);
T3 r3to_upper(T3 C);
T6 r3is_separator(T3 C);
T3 r3to_lower(T3 C);
T6 r3is_letter(T3 C);
T6 r3is_digit(T3 C);
T6 r6_ix_not(T6 C);
T1136 r1136realloc(T1136 C,T2 a1,T2 a2);
void r1136set_all_with(T1136 C,T0* a1,T2 a2);
T6 r1136equal_like(T0* a1,T0* a2);
void r1136copy_from(T1136 C,T1136 a1,T2 a2);
T2 r1136index_of(T1136 C,T0* a1,T2 a2);
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
T9 r9realloc(T9 C,T2 a1,T2 a2);
T2 r9fast_index_of(T9 C,T3 a1,T2 a2);
void r9copy_from(T9 C,T9 a1,T2 a2);
T2045 r2045realloc(T2045 C,T2 a1,T2 a2);
void r2045set_all_with(T2045 C,T2 a1,T2 a2);
void r2045copy_from(T2045 C,T2045 a1,T2 a2);
T6 r7has(T7* C,T3 a1);
T8 r7to_external(T7* C);
void r7set_last(T7* C,T3 a1);
void r7to_upper(T7* C);
T0* r7twin(T7* C);
void r7remove_last(T7* C,T2 a1);
void r7to_lower(T7* C);
T6 r7is_equal(T7* C,T0* a1);
T6 r7has_suffix(T7* C,T0* a1);
void r7prepend(T7* C,T0* a1);
T3 r7last(T7* C);
void r7make(T7* C,T2 a1);
void r7append(T7* C,T0* a1);
void r7extend(T7* C,T3 a1);
void r7copy(T7* C,T0* a1);
T2 r7hash_code(T7* C);
T2 r7index_of(T7* C,T3 a1);
void r1806add_last(T1806* C,T2 a1);
void r1806resize(T1806* C,T2 a1);
void r1806make(T1806* C,T2 a1);
void r1886with_capacity(T1886* C,T2 a1);
void r1886add_last(T1886* C,T0* a1);
void r1886resize(T1886* C,T2 a1);
void r1886make(T1886* C,T2 a1);
void r931add_last(T931* C,T0* a1);
T0* r931item(T931* C,T2 a1);
T2 r931count(T931* C);
void r931make(T931* C,T2 a1,T2 a2);
void r931clear(T931* C);
T2 r931index_of(T931* C,T0* a1);
void r1540with_capacity(T1540* C,T2 a1);
T6 r1540has(T1540* C,T0* a1);
void r1540expand(T1540* C);
void r1540resize_buckets(T1540* C,T2 a1);
T0* r1540at(T1540* C,T0* a1);
void r1540put(T1540* C,T0* a1,T0* a2);
void r571put_string(T571* C,T0* a1);
T0* r504find_path_for(T504* C,T0* a1);
extern int fBC266system_name;
extern T0*oBC266system_name;
T0* r504system_name(T504* C);
extern T0*oBC266tmp_file_read;
extern int fBC266small_eiffel_directory;
extern T0*oBC266small_eiffel_directory;
T0* r504small_eiffel_directory(T504* C);
T0* r504get_environment_variable(T504* C,T0* a1);
extern T0*oBC504parser_buffer_path;
extern T0*oBC504tmp_tail;
extern int fBC504rename_dictionary;
extern T0*oBC504rename_dictionary;
T0* r504rename_dictionary(T504* C);
extern int fBC504loading_path;
extern T0*oBC504loading_path;
T0* r504loading_path(T504* C);
extern T0*oBC266system_list;
T6 r504parser_buffer_for(T504* C,T0* a1);
void r504add_directory(T504* C,T0* a1,T0* a2);
extern T0*oBC266echo;
extern T0*oBC266parser_buffer;
extern T0*oBC266tmp_path;
void r504append_loading_path_in(T504* C,T0* a1);
T0* r194system_name(T194* C);
extern T0*oBC266help_file_name;
void r194print_help(T194* C,T0* a1);
extern T0*oBC1std_output;
T0* r194small_eiffel_directory(T194* C);
extern T673 oBC1file_tools;
T0* r194get_environment_variable(T194* C,T0* a1);
extern T0*oBC1std_error;
extern T0*oBC266small_eiffel;
T6 r194file_exists(T0* a1);
T0* r194argument(T2 a1);
void r194add_directory(T194* C,T0* a1,T0* a2);
void r194make(T194* C);
extern int fBC1command_arguments;
extern T0*oBC1command_arguments;
T0* r194command_arguments(void);
void r85sfr_connect(T85* C,T0* a1,T0* a2);
void r85w_put_string(T0* a1);
void r85put_string(T85* C,T0* a1);
void r85w_put_character(T3 a1);
extern T0*oBC1070tmp_file_read;
void r878put_string(T878* C,T0* a1);
void r878append_file(T878* C,T0* a1);
T2 r822read_file(T0* a1);
extern int fBC822buffer;
extern T9 oBC822buffer;
T9 r822buffer(void);
extern T0*oBC822text;
T0* r822next_line(T2 a1);
void r822load_file(T822* C,T0* a1);
void r500read_line(T500* C);
void r500read_line_in(T500* C,T0* a1);
void r500read_word(T500* C);
void r500skip_separators(T500* C);
extern T0*oBC869last_string;
void r500connect_to(T500* C,T0* a1);
T6 r500end_of_input(T500* C);
void r500disconnect(T500* C);
void r500read_character(T500* C);
extern T0*oBC673std_fr1;
T6 r673is_readable(T0* a1);
extern T194*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms1_194;
extern T7*ms2_194;
extern T7*ms2_266;
extern T7*ms36_266;
extern T7*ms3_266;
extern T7*ms10_504;
extern T7*ms142_2027;
extern T7*ms13_504;
extern T7*ms14_504;
extern T7*ms15_504;
extern T7*ms16_504;
extern T7*ms17_504;
extern T7*ms22_266;
extern T7*ms11_504;
extern T7*ms12_504;
extern T7*ms77_504;
extern T7*ms2_504;
extern T7*ms3_504;
extern T7*ms131_2027;
extern T7*ms3_85;
extern T7*ms17_266;
extern T7*ms132_2027;
extern T7*ms18_266;
extern T7*ms1_266;
extern T7*ms21_266;
extern T7*ms247_2027;
extern T7*ms19_266;
extern T7*ms20_266;
extern T7*ms10_266;
extern T7*ms11_266;
extern T7*ms12_266;
extern T7*ms13_266;
extern T7*ms14_266;
extern T7*ms15_266;
extern T7*ms16_266;
extern T7*ms4_504;
extern T7*ms5_504;
extern T7*ms78_504;
extern T7*ms124_2027;
extern T7*ms79_504;
extern T7*ms81_504;
extern T7*ms82_504;
extern T7*ms80_504;
extern T7*ms3_194;
void se_msi1(void);
void se_msi2(void);
void se_msi3(void);
void*se_ma931(int argc,...);

