/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Dick Porter <dick@cymru.net>
 *
 */

#include "orbit_types.h"
#include "corba_object.h"
#include "env.h"
#include "orb.h"

/* Deprecated - Section 4.2.1 */
CORBA_ImplementationDef *CORBA_Object_get_implementation(CORBA_Object obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

/* Section 4.2.1 */
CORBA_InterfaceDef *CORBA_Object_get_interface(CORBA_Object obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

/* Section 4.2.3 */
CORBA_boolean CORBA_Object_is_nil(CORBA_Object obj, CORBA_Environment *ev)
{
	if(obj==CORBA_OBJECT_NIL) {
		return(CORBA_TRUE);
	} else {
		return(CORBA_FALSE);
	}
}

/* Section 4.2.2 */
CORBA_Object CORBA_Object_duplicate(CORBA_Object obj, CORBA_Environment *ev)
{
	if(obj == CORBA_OBJECT_NIL)
		return CORBA_OBJECT_NIL;

	ORBIT_ROOT_OBJECT_REF(obj);

	return(obj);
}


/* Section 4.2.2 */
void CORBA_Object_release(CORBA_Object obj, CORBA_Environment *ev)
{
	if(obj != CORBA_OBJECT_NIL)
		ORBIT_ROOT_OBJECT_release(obj,ev);
}

/* Section 4.2.4 */
CORBA_boolean CORBA_Object_is_a(CORBA_Object obj, CORBA_char *logical_type_id, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(CORBA_FALSE);
}

/* Section 4.2.5 */
CORBA_boolean CORBA_Object_non_existant(CORBA_Object obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(CORBA_FALSE);
}

gboolean
g_CORBA_Object_equal(CORBA_Object obj1, CORBA_Object obj2)
{
	gboolean retval;
	CORBA_Environment ev;

	CORBA_exception_init(&ev);

	retval = (gboolean)CORBA_Object_is_equivalent(obj1, obj2, &ev);

	CORBA_exception_free(&ev);

	return retval;
}

/* Section 4.2.6 */
CORBA_boolean CORBA_Object_is_equivalent(CORBA_Object obj, CORBA_Object other_object, CORBA_Environment *ev)
{
	if(obj == CORBA_OBJECT_NIL
	   && other_object == CORBA_OBJECT_NIL)
		return CORBA_TRUE;

	if(obj == CORBA_OBJECT_NIL
	   || other_object == CORBA_OBJECT_NIL)
		goto ret_false;

	if(!obj->objinfo.iopinfo != !other_object->objinfo.iopinfo)
		goto ret_false;

	if(!obj->objinfo.orbitinfo != !other_object->objinfo.orbitinfo)
		goto ret_false;

	if(obj->objinfo.iopinfo) {
		TAG_INTERNET_IOP_info *ii1, *ii2;

		ii1 = obj->objinfo.iopinfo;
		ii2 = other_object->objinfo.iopinfo;

		if(ii1->port != ii2->port
		   || ii1->object_key._length != ii2->object_key._length)
			goto ret_false;

		if(strcmp(ii1->host, ii2->host) != 0)
			goto ret_false;

		if(memcmp(ii1->object_key._buffer,
			  ii2->object_key._buffer,
			  ii1->object_key._length) != 0)
			goto ret_false;

		return CORBA_TRUE;
	} else if(obj->objinfo.orbitinfo) {
		TAG_ORBIT_SPECIFIC_info *oi1, *oi2;

		oi1 = obj->objinfo.orbitinfo;
		oi2 = other_object->objinfo.orbitinfo;

		if(strcmp(oi1->unix_sock_path, oi2->unix_sock_path))
			goto ret_false;

		if(oi1->ipv6_port != oi2->ipv6_port)
			goto ret_false;

		return CORBA_TRUE;
	}

 ret_false:
	return CORBA_FALSE;
}

guint
g_CORBA_Object_hash(CORBA_Object obj)
{
	guint retval;
	CORBA_Environment ev;

	CORBA_exception_init(&ev);

	retval = (guint)CORBA_Object_hash(obj, UINT_MAX, &ev);

	CORBA_exception_free(&ev);

	return retval;
}


/* Section 4.2.6 */
CORBA_unsigned_long CORBA_Object_hash(CORBA_Object obj,
				      CORBA_unsigned_long maximum,
				      CORBA_Environment *ev)
{
	CORBA_unsigned_long retval = 0;
	char *tptr;

	g_assert(obj);

	tptr = obj->objinfo.obj_id;
	while(*tptr) {
		retval = (retval << 8) ^ *tptr;
		tptr++;
	}

	if(obj->objinfo.iopinfo) {
		retval ^= obj->objinfo.iopinfo->object_key._length;
		retval ^= !obj->objinfo.iopinfo->port;
	} else if(obj->objinfo.orbitinfo) {
		retval ^= g_str_hash(obj->objinfo.orbitinfo->unix_sock_path);
		retval ^= !obj->objinfo.orbitinfo->ipv6_port;
	} else {
		g_warning("Object of type %s doesn't seem to have any connection info!", obj->objinfo.obj_id);
	}

	return (retval % maximum);
}

/* Section 4.2.7 */
CORBA_Policy CORBA_Object_get_policy(CORBA_Object obj, CORBA_PolicyType policy_type, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}
