/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* By Elliot Lee. Copyright (c) 1998 Red Hat Software */

#include "allocators.h"
#include "dii.h"

/* These are the free-ers for specific types that have nested values
   in them. These functions only free the nested values, NOT 'mem' itself */
/* Not used */
#if 0
static void ORBit_free_any(CORBA_TypeCode tc, gpointer mem);
static void ORBit_free_TypeCode(CORBA_TypeCode tc, gpointer mem);
static void ORBit_free_objref(CORBA_TypeCode tc, gpointer mem);
static void ORBit_free_struct(CORBA_TypeCode tc, gpointer mem);
static void ORBit_free_union(CORBA_TypeCode tc, gpointer mem);
static void ORBit_free_sequence(CORBA_TypeCode tc, gpointer mem);
static void ORBit_free_array(CORBA_TypeCode tc, gpointer mem);
static void ORBit_free_except(CORBA_TypeCode tc, gpointer mem);
#endif

static gpointer ORBit_free_via_TypeCode(gpointer mem);

/* The memory chunk stuff */

#define ALLOCATOR_DEFINITION
#include "allocator-defs.h"
#undef ALLOCATOR_DEFINITION

void
ORBit_chunks_init(void)
{
#define ALLOCATOR_INITIALIZATION
#include "allocator-defs.h"
#undef ALLOCATOR_INTIALIZATION
}

gpointer
ORBit_chunk_alloc(GMemChunk *chunk,
		  PARAM_LOCK(chunk))
{
  gpointer retval;

  GET_LOCK(chunk);
  retval = g_mem_chunk_alloc(chunk);
  RELEASE_LOCK(chunk);

  return retval;
}

void
ORBit_chunk_free(GMemChunk *chunk,
		 PARAM_LOCK(chunk),
		 gpointer mem)
{
  GET_LOCK(chunk);
  g_mem_chunk_free(chunk, mem);
  RELEASE_LOCK(chunk);
}

/* end memory chunk routines */

/****************************************************************/

/************* begin funky memory alloc/free system */

/****** functions */

gpointer ORBit_alloc(size_t block_size,
		     ORBit_free_childvals freefunc,
		     gpointer func_data)
{
	ORBit_mem_info *block;

	block = g_malloc(block_size + sizeof(ORBit_mem_info));

#ifdef DEBUG
	block->magic = 0xdeadbeef;
#endif
	block->free = freefunc;
	block->func_data = func_data;

	return MEMINFO_TO_PTR(block);
}

/*
  ORBit_free
  ----------

  Frees a corba primitive type.

  mem = pointer to the memory block. (must have a preceeding pointer to a meminfo block)

  1)obtains a pointer to the preceeding meminfo structure
  2)Uses the meminfo structure to find the number of elements in the memory block
  3)iterates through the memory block, calling the free function for each item.
  
 */

void
ORBit_free(gpointer mem, CORBA_boolean free_strings)
{
	ORBit_mem_info *block;

	if(!mem)
		return;

	block = PTR_TO_MEMINFO(mem);

#ifdef DEBUG
	g_assert(block->magic == 0xdeadbeef);
#endif

	if(block->free) {
		if((gpointer)block->free == (gpointer)ORBit_free_via_TypeCode)
			block->free(mem, block->func_data, free_strings);
		else {
			int i;
			gpointer x;
			for(i = 0, x = mem; i < (gulong)block->func_data; i++)
				x = block->free(x, NULL, free_strings);
		}
	}
	g_free(block);
}

/******************************************************************/
/* These aren't currently used... */

static gpointer
ORBit_free_via_TypeCode(gpointer mem)
{
	return NULL;
}

#if 0
/*
  Free functions. 

  Each of these free a particular type of corba primitive. The
  ORBit_array_alloc function wires up one of these as appropriate.
  
 */

static void
ORBit_free_any(CORBA_TypeCode tc, gpointer mem)
{
	CORBA_any *anyval = mem;

#if 0
	ORBit_mem_info *valblock = PTR_TO_MEMINFO(anyval->_value);
#endif

	ORBit_free(anyval->_value);
}

static void
ORBit_free_TypeCode(CORBA_TypeCode tc, gpointer mem)
{
	int i;
	CORBA_TypeCode type = mem;

	g_warning("We're freeing a CORBA_TypeCode, which is probably VERY bad.");

	g_free(type->name);
	g_free(type->repo_id);
	for(i = 0; i < type->sub_parts; i++)
		g_free(type->subnames[i]);

	/* yes, this really does work, because ORBit_free knows how to
	   handle arrays properly */

	ORBit_free(type->sublabels);

#if 0
	/* XXX should we be freeing typecodes? */ 
	ORBit_free(type->subtypes);
	ORBit_free(type->discriminator);
#endif
}

static void
ORBit_free_objref(CORBA_TypeCode tc, gpointer mem)
{
	/* This is patently stupid. Look at the CORBA_Object_release() routine
	   for the right way to do it. */
	CORBA_Object obj = mem;
#if 0
	giop_connection_unref(obj->connection);
	ORBit_free(obj->object_key._buffer);
	ORBit_free(obj->obj_id);
#else
	g_error("NYI");
#endif
}

static void
ORBit_free_struct(CORBA_TypeCode tc, gpointer mem)
{
	int i;
	for(i = 0; i < tc->sub_parts; i++) {
		switch(tc->subtypes[i]->kind) {
		case CORBA_tk_any:
			mem = ALIGN_ADDRESS(mem, sizeof(long));
			ORBit_free_any(&TC_any, mem);
			mem += sizeof(CORBA_any);
			break;
		case CORBA_tk_TypeCode:
			g_warning("Not sure whether or not to free a TypeCode.");
			break;
		case CORBA_tk_Principal:
		case CORBA_tk_objref:
		case CORBA_tk_string:
		case CORBA_tk_wstring:
			mem = ALIGN_ADDRESS(mem, sizeof(gpointer));
			ORBit_free(*((gpointer *)mem));
			break;
		case CORBA_tk_union:
		case CORBA_tk_struct:
		case CORBA_tk_except:
			break;
		case CORBA_tk_fixed:
			break;
		default:
			g_error("Unsupported structure member kind %d",
				tc->subtypes[i]->kind);
		}
	}
}

static void
ORBit_free_union(CORBA_TypeCode tc, gpointer mem)
{
}

static void
ORBit_free_sequence(CORBA_TypeCode tc, gpointer mem)
{
}

static void
ORBit_free_array(CORBA_TypeCode tc, gpointer mem)
{
}

static void
ORBit_free_except(CORBA_TypeCode tc, gpointer mem)
{
}

#endif
