// This program tests the use of String_var type

#include "varTest.hh"
#include "iostream.h"

char*
__string_fn (const char* in, char*& inout, char*& out) {
  out = CORBA::string_dup(in);
  CORBA::string_free(inout);
  inout = CORBA::string_dup(in);
  char* result = CORBA::string_dup(in);
  return result;
}

char*
string_fn (const char* in, CORBA::String_INOUT_arg inout, CORBA::String_OUT_arg out) {
  return __string_fn(in,inout._data,out._data);
}

int
main (int argc, char**argv)
{
  {
    cerr << "String_var test: ";
    CORBA::String_var in    = (const char*) "a string";

    CORBA::String_var inout = in;

    CORBA::String_var out = in;
    // Current data should be deallocated by operator char*& () when 
    // this variable is used as the out argument of string_fn.


    CORBA::String_var result;

    result = string_fn(in,inout,out);

    if (strcmp((const char*)in,(const char*)inout) != 0 ||
	strcmp((const char*)in,(const char*)out) != 0 ||
	strcmp((const char*)in,(const char*)result) != 0)
      {
	cerr << "failed. Line no: " << __LINE__ << endl;
	return 1;
      }
    cerr << "PASSED." << endl;
    cerr << "Now cast to (char*) : ";
    char* p = (char*)in;
    cerr << p << endl;
  }
  return 0;
}
