// Usage:  client -i <stringified IOR>
//         client <COSNaming compound name (e.g. x/y/echo.obj)>

#include <iostream.h>
#include <echo.hh>
#include <common/common.h>

CORBA::BOA_ptr boa;

class Echo_i : public virtual _sk_Echo {
public:
  Echo_i() {}
  virtual ~Echo_i() {}
  virtual char * echoString(const char *mesg);
};

char *
Echo_i::echoString(const char *mesg) {
  char *p = CORBA::string_dup(mesg);
  return p;
}

int
main(int argc, char **argv)
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  CORBA::Object_var obj;

  switch (argc) {
  case 2:
    {
      try {
        CosNaming::Name use_name = string_to_name(argv[1]);
        obj = getObjectReference(orb,use_name);
      }
      catch (...) {
        obj = CORBA::Object::_nil(); 
	  }
      if (CORBA::is_nil(obj)) {
	    cerr << "Cannot resolve compound name to an object reference."
				  << endl;
	    return 1; 
      }
      break;
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      obj = orb->string_to_object(argv[2]);
      if (CORBA::is_nil(obj)) {
	    cerr << "Cannot convert stringified IOR to an object reference."
	          << endl;
	    return 1;
      }
      break;
    }
  default:
    cerr << "usage: client -i <stringified IOR>" << endl;
    cerr << "       client <COSNaming compound name (e.g. x/y/echo.obj)>"
	 << endl;
    return 1;
  }


  Echo_i *myobj = new Echo_i;
  myobj->_obj_is_ready(boa);

  {
    Echo_var myobjRef = myobj->_this();
    CORBA::String_var p = orb->object_to_string(myobjRef);
    cerr << "Created a locate Echo Object: " << (char*)p << endl;
  }

  boa->impl_is_ready(0,1);

  try {
    CORBA::ULong loopCount = 1;
    while (loopCount--) {
      {
	Echo_var e;
	e = Echo::_narrow(obj);
	if (CORBA::is_nil(e)) {
	  cerr << "Cannot invoke on a nil object reference." << endl;
	  return 1;
	}
	cerr << "Testing CORBA::Object::_non_existent() to a remote object..." <<endl;
	if (e->_non_existent()) {
	  cerr << "Object does not exist" << endl;
	}
	else {
	  cerr << "Object exists." << endl;
	}
      }

      {
	Echo_var e;
	e = Echo::_narrow(obj);
	if (CORBA::is_nil(e)) {
	  cerr << "Cannot invoke on a nil object reference." << endl;
	  return 1;
	}
	cerr << "Testing CORBA::Object::_is_a() to a remote object..." << endl;
	if (e->_is_a("IDL:Echo:1.0")) {
	  cerr << "Object is IDL:Echo:1.0" << endl;
	}
	else {
	  cerr << "Object is not IDL:Echo:1.0." << endl;
	}
	cerr << "Testing CORBA::Object::_is_a() to a remote object..." << endl;
	if (e->_is_a("IDL:omg.org/CORBA/Object:1.0")) {
	  cerr << "Object is IDL:omg.org/CORBA/Object:1.0" << endl;
	}
	else {
	  cerr << "Object is not IDL:omg.org/CORBA/Object:1.0." << endl;
	}
      }

      {
	Echo_var e;
	e = myobj->_this();
	if (CORBA::is_nil(e)) {
	  cerr << "Cannot invoke on a nil object reference." << endl;
	  return 1;
	}
	cerr << "Testing CORBA::Object::_non_existent() to a colocated object..." <<endl;
	if (e->_non_existent()) {
	  cerr << "Object does not exist" << endl;
	}
	else {
	  cerr << "Object exists." << endl;
	}
      }

      {
	Echo_var e;
	e = myobj->_this();
	if (CORBA::is_nil(e)) {
	  cerr << "Cannot invoke on a nil object reference." << endl;
	  return 1;
	}
	cerr << "Testing CORBA::Object::_is_a() to a colocated object..." << endl;
	if (e->_is_a("IDL:Echo:1.0")) {
	  cerr << "Object is IDL:Echo:1.0" << endl;
	}
	else {
	  cerr << "Object is not IDL:Echo:1.0." << endl;
	}
	cerr << "Testing CORBA::Object::_is_a() to a colocated object..." << endl;
	if (e->_is_a("IDL:omg.org/CORBA/Object:1.0")) {
	  cerr << "Object is IDL:omg.org/CORBA/Object:1.0" << endl;
	}
	else {
	  cerr << "Object is not IDL:omg.org/CORBA/Object:1.0." << endl;
	}
      }
    }
  }
  catch(CORBA::COMM_FAILURE&) {
    cerr << "Caught COMM_FAILURE. Exit" << endl;
  }
  myobj->_dispose();
  boa->impl_shutdown();
  return 0;
}

