/*
 *	Ohio Trollius
 *	(public domain software)
 *
 *	$Log:	tfclose.c,v $
 * Revision 6.1  96/11/24  00:35:51  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:06:26  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:17:31  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:45  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:51  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/05/10  16:36:45  raja
 * pre-release to 2.3
 * 
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <tstdio.h>

/*
 * external functions
 */
extern int		iomap_close();


int
tfclose(fp)
	TFILE *fp;
{
	int f;

	if(fp == NULL)
		return(EOF);		/* NULL file pointer file */
	f = fp->_flag;
	if((f & (_TIOREAD | _TIOWRT)) == 0)
		return(EOF);		/* file not open! */
	tfflush(fp);
	if(fp->_flag & _TIOMYBUF)	/* throw away non-standard buffer */
	{
		free(fp->_base);
	}
	fp->_base = NULL;
	fp->_ptr = NULL;
	fp->_bsiz = 0;
	fp->_flag = 0;			/* clear status */
	if(f & _TIODEV)			/* leave tty's alone */
		return(0);

	f = iomap_close(f, fp->_file);

	return(f ? EOF : 0);
}

/*
 *	fcloseall
 *
 *	Function:	- Close all streams.
 */

void
tfcloseall()

{
	int i, f;

	for(i=0; i<_TNFILE; ++i) {
		f = _tiob[i]._flag;
		if(f & (_TIOREAD | _TIOWRT))
			tfclose(&_tiob[i]);
	}
}
