/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	rbfstate.c,v $
 * Revision 6.1  96/11/24  00:25:52  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:04:56  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/16  01:51:49  gdburns
 * Remove user space buffer parameter.
 * 
 * Revision 5.2  94/08/22  14:13:27  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:03  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:12  gdburns
 * Ohio Release
 * 
 *	Function:	- gathers message status from a remote bufferd
 *	Accepts:	- target node ID
 *			- buffer status table
 *			- # of table entries
 *			- buffer parameter structure ptr
 *	Returns:	- number of replied descriptors or ERROR
 */

#include <unistd.h>

#include <bfreq.h>
#include <events.h>
#include <ksignal.h>
#include <net.h>
#include <terror.h>
#include <typical.h>

int
rbfstate(node, tbl, tblsize, parms)

int4			node;		/* target node ID */
int			tblsize;	/* buffer status table size */
struct bfstatus		tbl[];		/* buffer status table */
struct bfparms		*parms;		/* buffer parameters */

{
	struct nmsg	nhead;		/* network message desc. */
	struct bfreq	*request;	/* bufferd request */
	struct bfreply	*reply;		/* bufferd reply */
	int4		minsize;	/* # expected elements */
	int4		mask;		/* signal mask */
	int4		totsize;	/* total # replied descs */

	request = (struct bfreq *) nhead.nh_data;
	reply = (struct bfreply *) nhead.nh_data;

	request->bfq_src_node = (node == LOCAL) ? node : getnodeid();
	request->bfq_src_event = -getpid();
	request->bfq_req = BFQSTATE;
	request->bfq_maxtbl = tblsize;

	nhead.nh_node = node;
	nhead.nh_event = EVBUFFERD;
	nhead.nh_type = DLCTL;
	nhead.nh_flags = NOBUF;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	nhead.nh_event = -getpid();
	nhead.nh_type = 0;
	nhead.nh_flags = 0;

	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	if (reply->bfr_reply) {
		errno = reply->bfr_reply;
		ksigsetmask(mask);
		return(LAMERROR);
	}

	parms->bfp_maxspace = reply->bfr_maxspace;
	parms->bfp_nspace = reply->bfr_nspace;
	totsize = reply->bfr_nbuf;
	minsize = min(totsize, tblsize);
	nhead.nh_length = MAXNMSGLEN;
	nhead.nh_msg = (char *) tbl;

	while (minsize > 0) {
	
		if (nrecv(&nhead)) {
			ksigsetmask(mask);
			return(LAMERROR);
		}
			
		minsize -= nhead.nh_length / sizeof(struct bfstatus);
		nhead.nh_msg += nhead.nh_length;
	}

	ksigsetmask(mask);
	return(totsize);
}
