/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	rbflook.c,v $
 * Revision 6.1  96/11/24  00:25:49  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:04:44  gdburns
 * Ohio Release
 * 
 *	Function:	- receives a copy of a buffered network packet
 *	Accepts:	- server node
 *			- network message descriptor
 *			- sequence #
 *	Returns:	- 0 or ERROR
 */

#include <stdlib.h>
#include <unistd.h>

#include <bfreq.h>
#include <events.h>
#include <ksignal.h>
#include <net.h>
#include <terror.h>
#include <typical.h>

int
rbflook(node, pnh_look, seq)

int4			node;
struct nmsg		*pnh_look;
int4			seq;

{
	struct bfreq	*pbfq;		/* bufferd request */
	struct bfreply	*pbfr;		/* bufferd reply */
	struct nmsg	nhbf;		/* bufferd message */
	int4		mask;		/* signal mask */
/*
 * Send a query message to the buffer.
 */
	pbfq = (struct bfreq *) nhbf.nh_data;

	pbfq->bfq_req = BFQLOOK;
	pbfq->bfq_src_node = (node == LOCAL) ? node : getnodeid();
	pbfq->bfq_src_event = -getpid();
	pbfq->bfq_seq = seq;

	nhbf.nh_dl_event = EVBUFFERD;
	nhbf.nh_node = node;
	nhbf.nh_event = EVBUFFERD;
	nhbf.nh_type = DLCTL;
	nhbf.nh_flags = 0;
	nhbf.nh_length = 0;
	nhbf.nh_msg = 0;

	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhbf)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhbf.nh_event = -getpid();
	nhbf.nh_type = pnh_look->nh_type;
	nhbf.nh_length = 0;
	nhbf.nh_msg = 0;

	if (nrecv(&nhbf)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	pbfr = (struct bfreply *) nhbf.nh_data;

	if (pbfr->bfr_reply) {
		errno = pbfr->bfr_reply;
		ksigsetmask(mask);
		return(ERROR);
	}

	pnh_look->nh_type = pbfr->bfr_type;

	nhbf.nh_type = pnh_look->nh_type;
	nhbf.nh_length = pnh_look->nh_length;
	nhbf.nh_msg = pnh_look->nh_msg;

	if (nrecv(&nhbf)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	ksigsetmask(mask);

	pnh_look->nh_length = nhbf.nh_length;
	memcpy((char *) pnh_look->nh_data, (char *) nhbf.nh_data,
			NHDSIZE * sizeof(int4));
	return(0);
}
