/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: unpack.c,v 6.1 96/11/23 22:54:51 nevin Rel $
 *
 *	Function:	- unpack to data buffer
 *	Accepts:	- packed buffer
 *			- packed buffer size
 *			- ptr packed buffer position
 *			- data buffer
 *			- data count
 *			- data type
 *			- communicator
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Unpack(packbuf, packsize, ppackpos, buf, count, dtype, comm)

void			*packbuf;
int			packsize;
int			*ppackpos;
void			*buf;
int			count;
MPI_Datatype		dtype;
MPI_Comm		comm;

{
	int		size;
	char		*p;

	lam_initerr();
	lam_setfunc(BLKMPIUNPACK);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIUNPACK, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(comm,
			BLKMPIUNPACK, lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if (count < 0) {
		return(lam_errfunc(comm,
			BLKMPIUNPACK, lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if ((packsize < 0) || (ppackpos == 0)) {
		return(lam_errfunc(comm,
			BLKMPIUNPACK, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((*ppackpos < 0) || ((*ppackpos >= packsize) && (count > 0))) {
		return(lam_errfunc(comm,
			BLKMPIUNPACK, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((packsize > 0) && (packbuf == 0)) {
		return(lam_errfunc(comm,
			BLKMPIUNPACK, lam_mkerr(MPI_ERR_BUFFER, 0)));
	}
/*
 * Unpack the data.
 */
	p = ((char *) packbuf) + *ppackpos;
	size = packsize - *ppackpos;

	size = lam_unpack(p, size, (char *) buf, count, dtype);

	if (size < 0) {
		return(lam_errfunc(comm,
			BLKMPIUNPACK, lam_mkerr(MPI_ERR_TRUNCATE, 0)));
	}

	*ppackpos += size;

	lam_resetfunc(BLKMPIUNPACK);
	return(MPI_SUCCESS);
}
