/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: testsome.c,v 6.1 96/11/23 22:54:33 nevin Rel $
 *
 *	Function:	- check if at least one request completed
 *			- return info on all completed requests
 *	Accepts:	- # of requests
 *			- array of requests
 *			- output count (returned)
 *			- array of indices
 *			- array of status structures
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <mpitrace.h>
#include <rpisys.h>

/*
 * external functions
 */
extern void		lam_emptystat();
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern void		lam_tr_wrapend();
extern int		lam_tr_wrapstart();
extern int		lam_mkerr();


int
MPI_Testsome(count, reqs, outcount, indices, stats)

int			count;
MPI_Request		*reqs;
int			*outcount;
int			*indices;
MPI_Status		*stats;

{
	int		i;			/* favourite index */
	int		fl_done;		/* request done flag */
	int		fl_err;			/* error flag */
	int		err;			/* error code */
	int		fl_trace;		/* do tracing? */
	MPI_Status	*p;			/* ptr status */

	lam_initerr();
	lam_setfunc(BLKMPITESTSOME);
/*
 * Check the arguments.
 */
	if (count < 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTSOME,
				lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if ((count > 0) && ((reqs == 0) || (indices == 0) || (stats == 0))) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTSOME,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if (outcount == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTSOME,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Generate a start wrapper trace.
 */
	fl_trace = ((_kio.ki_rtf & RTF_TRON) == RTF_TRON);

	if (fl_trace) {
		lam_tr_wrapstart(BLKMPITESTSOME);
	}
/*
 * Initialize all status members.
 */
	for (i = 0, p = stats; i < count; ++i, ++p) {
		lam_emptystat(p);
	}
/*
 * Loop testing all requests.
 * Skip inactive requests.
 */
	*outcount = MPI_UNDEFINED;
	fl_err = 0;

	for (i = 0; i < count; ++i, ++reqs) {

		if ((*reqs == MPI_REQUEST_NULL) ||
			((*reqs)->rq_state == LAM_RQSINIT)) continue;

		if (*outcount == MPI_UNDEFINED) {
			*outcount = 0;
		}

		err = MPI_Test(reqs, &fl_done, stats);

		if ((err != MPI_SUCCESS) || fl_done) {

			++(*outcount);
			*indices++ = i;

			if (err != MPI_SUCCESS) {
				stats->MPI_ERROR = err;
				fl_err = 1;
			}

			++stats;
		}
	}
/*
 * Generate an end wrapper trace.
 */
	if (fl_trace) {
		lam_tr_wrapend(BLKMPITESTSOME);
	}

	lam_resetfunc(BLKMPITESTSOME);

	if (fl_err) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTSOME,
				lam_mkerr(MPI_ERR_IN_STATUS, 0)));
	}

	return(MPI_SUCCESS);
}
