/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: tcommit.c,v 6.1 96/11/23 22:54:24 nevin Rel $
 *
 *	Function:	- commit a datatype
 *	Accepts:	- ptr to datatype
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * external functions
 */
extern int		lam_tr_dtype();

int
MPI_Type_commit(dtype)

MPI_Datatype		*dtype;

{
	lam_initerr();
	lam_setfunc(BLKMPITCOMMIT);

	if (dtype == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITCOMMIT, lam_mkerr(MPI_ERR_ARG, 0)));
	}
	else if (*dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITCOMMIT, lam_mkerr(MPI_ERR_TYPE, 0)));
	}
	else {
		if (lam_tr_dtype(*dtype)) {
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPITCOMMIT,
					lam_mkerr(MPI_ERR_INTERN, errno)));
		}

		(*dtype)->dt_commit = 1;
	}

	lam_resetfunc(BLKMPITCOMMIT);
	return(MPI_SUCCESS);
}
