/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: rsend.c,v 6.1 96/11/23 22:53:57 nevin Rel $
 *
 *	Function:	- ready-mode send
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- tag
 *			- communicator
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

int
MPI_Rsend(buf, count, dtype, dest, tag, comm)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;

{
	int		err;

	lam_initerr();
	lam_setfunc(BLKMPIRSEND);

	err = lam_send(buf, count, dtype, dest, tag, comm, LAM_RQIRSEND);

	lam_resetfunc(BLKMPIRSEND);

	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIRSEND, err));

	return(MPI_SUCCESS);
}
