/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: lamfault.c,v 6.1 96/11/23 22:53:01 nevin Rel $
 *
 *	Function:	- LAM-MPI fault tolerance
 */

#include <all_list.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 *	lam_commfault
 *
 *	Function:	- invalidate communicators involving a dead node
 *	Accepts:	- dead node's id
 */
void
lam_commfault(node)

int			node;

{
	MPI_Comm	*comm;			/* communicator */
	struct _proc	**p;
	int		i;
	
	comm = al_top(lam_comms);

	for ( ; comm; comm = al_next(lam_comms, comm)) {
/*
 * There is nothing to do if the local group is already dead.
 */
		if ((*comm)->c_flags & LAM_CLDEAD) continue;
/*
 * Check the local group.
 */
		p = (*comm)->c_group->g_procs;
		
		for (i = (*comm)->c_group->g_nprocs; i > 0 ; i--, p++) {

			if ((*p)->p_gps.gps_node == node) {
				(*comm)->c_flags |= LAM_CLDEAD;
				break;
			}
		}
/*
 * If it's an intercommunicator and the remote group is not dead, then
 * check the remote group.
 */
		if (LAM_IS_INTER(*comm) && ! ((*comm)->c_flags & LAM_CRDEAD)) {
			
			p = (*comm)->c_rgroup->g_procs;

			for (i = (*comm)->c_rgroup->g_nprocs; i > 0 ;
					i--, p++) {

				if ((*p)->p_gps.gps_node == node) {
					(*comm)->c_flags |= LAM_CRDEAD;
					break;
				}
			}
		}
	}
}
