/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: infoset.c,v 6.1 96/11/22 13:34:59 nevin Rel $
 *
 *	Function:	- set info value associated with key
 *	Accepts:	- info (inout)
 *			- key
 *			- value
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>
#include <string.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Info_set(info, key, value)

MPI_Info		info;
char			*key;
char			*value;

{
	struct _info	new;			/* new info pair */
	struct _info	*old;			/* existing pair with key */
	int		key_len;		/* key length */
	int		val_len;		/* value length */
	char		*new_val;		/* storage for new value */
	
        lam_initerr();
	lam_setfunc(BLKMPIINFOSET);
/*
 * Check arguments.
 */
	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOSET,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	key_len = strlen(key);
	if (key_len == 0 || key_len > MPI_INFO_MAX_KEYLEN) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOSET,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}

	val_len = strlen(value);
	if (val_len > MPI_INFO_MAX_VALUELEN) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOSET,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Allocate storage for the new value.
 */
	if ((new_val = (char *) malloc(val_len + 1)) == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOSET,
					lam_mkerr(MPI_ERR_OTHER, 0)));
	}

	strcpy(new.info_key, key);
	strcpy(new_val, value);
/*
 * Check if key already appears in the info object.
 */
	old = al_find((LIST *) info, &new);

	if (old) {
/*
 * The key is already in the info object.  Replace the old value with the new.
 */
		free((char *) (old->info_value));
		old->info_value = new_val;
	} else {
/*
 * Add the key/value pair to the info object.
 */
		new.info_value = new_val;
		if (al_append((LIST *) info, &new) == 0) {
			return(lam_errfunc(MPI_COMM_WORLD,
				BLKMPIINFOSET, lam_mkerr(MPI_ERR_OTHER, 0)));
		}
	}

        lam_resetfunc(BLKMPIINFOSET);
	return(MPI_SUCCESS);
}
