/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: graphnbrcount.c,v 6.1 96/11/23 22:52:17 nevin Rel $
 *
 *	Function:	- get # neighbours for a process
 *	Accepts:	- communicator
 *			- rank
 *			- ptr # neighbours
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Graph_neighbors_count(comm, rank, pnbr)

MPI_Comm		comm;
int			rank;
int			*pnbr;

{
	lam_initerr();
	lam_setfunc(BLKMPIGRAPHNBRCOUNT);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGRAPHNBRCOUNT, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHNBRCOUNT, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (!LAM_IS_GRAPH(comm)) {
		return(lam_errfunc(comm, BLKMPIGRAPHNBRCOUNT,
				lam_mkerr(MPI_ERR_TOPOLOGY, 0)));
	}

	if ((rank < 0) || (rank >= comm->c_group->g_nprocs)) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHNBRCOUNT, lam_mkerr(MPI_ERR_RANK, 0)));
	}

	if (pnbr == 0) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHNBRCOUNT, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*pnbr = comm->c_topo_index[rank];
	if (rank > 0) {
		*pnbr -= comm->c_topo_index[rank - 1];
	}

	lam_resetfunc(BLKMPIGRAPHNBRCOUNT);
	return(MPI_SUCCESS);
}
